/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational.json;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import org.komodo.rest.Messages;
import org.komodo.rest.relational.AbstractKomodoContentAttribute;
import org.komodo.rest.relational.json.AbstractContentSerializer;
import org.komodo.rest.relational.json.KomodoJsonMarshaller;
import org.komodo.rest.relational.response.KomodoStorageAttributes;
import org.komodo.spi.repository.DocumentType;

public final class StorageAttributesSerializer
extends AbstractContentSerializer<KomodoStorageAttributes> {
    private static final Type STRING_MAP_TYPE = new /* Unavailable Anonymous Inner Class!! */.getType();

    public KomodoStorageAttributes read(JsonReader in) throws IOException {
        KomodoStorageAttributes storageAttr = new KomodoStorageAttributes();
        in.beginObject();
        block12: while (in.hasNext()) {
            String name = in.nextName();
            if (this.readContent(in, (AbstractKomodoContentAttribute)storageAttr, name) != null) continue;
            switch (name) {
                case "storageType": {
                    storageAttr.setStorageType(in.nextString());
                    break;
                }
                case "dataPath": {
                    storageAttr.setArtifactPath(in.nextString());
                    break;
                }
                case "parameters": {
                    Map parameters = (Map)KomodoJsonMarshaller.BUILDER.fromJson(in, Map.class);
                    for (Map.Entry parameter : parameters.entrySet()) {
                        storageAttr.setParameter((String)parameter.getKey(), (String)parameter.getValue());
                    }
                    continue block12;
                }
                case "documentType": {
                    String docTypeValue = in.nextString();
                    DocumentType docType = DocumentType.documentType((String)docTypeValue);
                    storageAttr.setDocumentType(docType);
                    break;
                }
                default: {
                    throw new IOException(Messages.getString((Enum)Messages.Error.UNEXPECTED_JSON_TOKEN, (Object[])new Object[]{name}));
                }
            }
        }
        in.endObject();
        return storageAttr;
    }

    public void write(JsonWriter out, KomodoStorageAttributes value) throws IOException {
        out.beginObject();
        out.name("storageType");
        out.value(value.getStorageType());
        out.name("dataPath");
        out.value(value.getArtifactPath());
        this.writeContent(out, (AbstractKomodoContentAttribute)value);
        String docType = value.getDocumentType();
        if (docType != null) {
            out.name("documentType");
            out.value(docType.toString());
        }
        if (!value.getParameters().isEmpty()) {
            out.name("parameters");
            KomodoJsonMarshaller.BUILDER.toJson((Object)value.getParameters(), STRING_MAP_TYPE, out);
        }
        out.endObject();
    }
}

