/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational.json;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.komodo.rest.RestBasicEntity;
import org.komodo.rest.relational.json.BasicEntitySerializer;
import org.komodo.rest.relational.json.KomodoJsonMarshaller;
import org.komodo.rest.relational.response.RestVdbDataRole;
import org.komodo.rest.relational.response.RestVdbPermission;
import org.komodo.utils.StringUtils;

public final class VdbDataRoleSerializer
extends BasicEntitySerializer<RestVdbDataRole> {
    protected boolean isComplete(RestVdbDataRole dataRole) {
        return super.isComplete((RestBasicEntity)dataRole) && !StringUtils.isBlank((String)dataRole.getName());
    }

    protected RestVdbDataRole createEntity() {
        return new RestVdbDataRole();
    }

    protected String readExtension(String name, RestVdbDataRole dataRole, JsonReader in) {
        if (RestVdbDataRole.PERMISSIONS_LABEL.equals(name)) {
            RestVdbPermission[] permissions = (RestVdbPermission[])KomodoJsonMarshaller.BUILDER.fromJson(in, RestVdbPermission[].class);
            dataRole.setPermissions(permissions);
            return Integer.toString(permissions.length);
        }
        return null;
    }

    protected void writeExtensions(JsonWriter out, RestVdbDataRole dataRole) throws IOException {
        RestVdbPermission[] permissions = dataRole.getPermissions();
        if (permissions.length != 0) {
            out.name(RestVdbDataRole.PERMISSIONS_LABEL);
            out.beginArray();
            for (RestVdbPermission permission : permissions) {
                KomodoJsonMarshaller.BUILDER.getAdapter(RestVdbPermission.class).write(out, (Object)permission);
            }
            out.endArray();
        }
    }
}

