/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.komodo.rest.KRestEntity;

@JsonSerialize
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class KomodoConnectionAttributes
implements KRestEntity {
    public static final String JNDI_LABEL = "jndiName";
    public static final String JDBC_LABEL = "jdbc";
    public static final String DRIVER_LABEL = "driverName";
    public static final String PARAMETERS_LABEL = "parameters";
    @JsonProperty(value="jndiName")
    private String jndi;
    @JsonProperty(value="jdbc")
    private boolean jdbc;
    @JsonProperty(value="driverName")
    private String driver;
    @JsonProperty(value="parameters")
    private Map<String, Object> parameters;

    @JsonIgnore
    public boolean supports(MediaType mediaType) {
        return MediaType.APPLICATION_JSON_TYPE.equals((Object)mediaType);
    }

    @JsonIgnore
    public Object getXml() {
        throw new UnsupportedOperationException();
    }

    public String getJndi() {
        return this.jndi;
    }

    public void setJndi(String Jndi) {
        this.jndi = Jndi;
    }

    public boolean isJdbc() {
        return this.jdbc;
    }

    public void setJdbc(boolean jdbc) {
        this.jdbc = jdbc;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String Driver2) {
        this.driver = Driver2;
    }

    public Map<String, Object> getParameters() {
        if (this.parameters == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.parameters);
    }

    public void setParameter(String name, Object value) {
        if (this.parameters == null) {
            this.parameters = new HashMap();
        }
        this.parameters.put(name, value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.driver == null ? 0 : this.driver.hashCode());
        result = 31 * result + (this.jndi == null ? 0 : this.jndi.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = 31 * result + (this.jdbc ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KomodoConnectionAttributes other = (KomodoConnectionAttributes)obj;
        if (this.driver == null ? other.driver != null : !this.driver.equals(other.driver)) {
            return false;
        }
        if (this.jndi == null ? other.jndi != null : !this.jndi.equals(other.jndi)) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
            return false;
        }
        return this.jdbc == other.jdbc;
    }

    public String toString() {
        return "KomodoConnectionAttributes [JndiId=" + this.jndi + ", jdbc=" + this.jdbc + ", Driver=" + this.driver + "]";
    }
}

