/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.komodo.rest.relational.request.KomodoPathAttribute;
import org.komodo.utils.ArgCheck;

@JsonSerialize
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class KomodoSearcherAttributes
extends KomodoPathAttribute {
    public static final String SEARCH_NAME_LABEL = "searchName";
    public static final String TYPE_LABEL = "type";
    public static final String PARENT_LABEL = "parent";
    public static final String ANCESTOR_LABEL = "ancestor";
    public static final String CONTAINS_LABEL = "contains";
    public static final String OBJECT_NAME_LABEL = "objectName";
    public static final String PARAMETERS_LABEL = "parameters";
    @JsonProperty(value="searchName")
    private String searchName;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="parent")
    private String parent;
    @JsonProperty(value="ancestor")
    private String ancestor;
    @JsonProperty(value="contains")
    private String contains;
    @JsonProperty(value="objectName")
    private String objectName;
    @JsonProperty(value="parameters")
    private Map<String, String> parameters;

    public KomodoSearcherAttributes() {
    }

    public KomodoSearcherAttributes(String name) {
        ArgCheck.isNotNull((Object)name);
        this.searchName = name;
    }

    public String getSearchName() {
        return this.searchName;
    }

    public void setSearchName(String searchName) {
        this.searchName = searchName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public String getAncestor() {
        return this.ancestor;
    }

    public void setAncestor(String ancestor) {
        this.ancestor = ancestor;
    }

    public String getContains() {
        return this.contains;
    }

    public void setContains(String contains) {
        this.contains = contains;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public Map<String, String> getParameters() {
        if (this.parameters == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.parameters);
    }

    public void setParameter(String name, String value) {
        if (this.parameters == null) {
            this.parameters = new HashMap();
        }
        this.parameters.put(name, value);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.ancestor == null ? 0 : this.ancestor.hashCode());
        result = 31 * result + (this.contains == null ? 0 : this.contains.hashCode());
        result = 31 * result + (this.objectName == null ? 0 : this.objectName.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + (this.searchName == null ? 0 : this.searchName.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KomodoSearcherAttributes other = (KomodoSearcherAttributes)obj;
        if (this.ancestor == null ? other.ancestor != null : !this.ancestor.equals(other.ancestor)) {
            return false;
        }
        if (this.contains == null ? other.contains != null : !this.contains.equals(other.contains)) {
            return false;
        }
        if (this.objectName == null ? other.objectName != null : !this.objectName.equals(other.objectName)) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
            return false;
        }
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        if (this.searchName == null ? other.searchName != null : !this.searchName.equals(other.searchName)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String toString() {
        return "KomodoSearcherAttributes [searchName=" + this.searchName + ", type=" + this.type + ", parent=" + this.parent + ", ancestor=" + this.ancestor + ", contains=" + this.contains + ", objectName=" + this.objectName + "]";
    }
}

