/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational.response;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.komodo.rest.relational.AbstractKomodoContentAttribute;
import org.komodo.spi.repository.DocumentType;

@JsonSerialize
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class KomodoStorageAttributes
extends AbstractKomodoContentAttribute {
    public static final String STORAGE_TYPE_LABEL = "storageType";
    public static final String ARTIFACT_PATH_LABEL = "dataPath";
    public static final String PARAMETERS_LABEL = "parameters";
    public static final String DOCUMENT_TYPE_LABEL = "documentType";
    @JsonProperty(value="storageType")
    private String storageType;
    @JsonProperty(value="dataPath")
    private String artifactPath;
    @JsonProperty(value="parameters")
    private Map<String, String> parameters;
    @JsonProperty(value="documentType")
    private String documentType;

    public String getStorageType() {
        return this.storageType;
    }

    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }

    public String getArtifactPath() {
        return this.artifactPath;
    }

    public void setArtifactPath(String artifactPath) {
        this.artifactPath = artifactPath;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    public void setDocumentType(DocumentType documentType) {
        this.documentType = documentType.toString();
    }

    public Map<String, String> getParameters() {
        if (this.parameters == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.parameters);
    }

    public Properties convertParameters() {
        Properties props = new Properties();
        if (this.parameters == null) {
            return props;
        }
        for (Map.Entry entry : this.parameters.entrySet()) {
            props.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return props;
    }

    public void setParameter(String name, String value) {
        if (this.parameters == null) {
            this.parameters = new HashMap();
        }
        this.parameters.put(name, value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.artifactPath == null ? 0 : this.artifactPath.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = 31 * result + (this.storageType == null ? 0 : this.storageType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KomodoStorageAttributes other = (KomodoStorageAttributes)obj;
        if (this.artifactPath == null ? other.artifactPath != null : !this.artifactPath.equals(other.artifactPath)) {
            return false;
        }
        if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
            return false;
        }
        return !(this.storageType == null ? other.storageType != null : !this.storageType.equals(other.storageType));
    }

    public String toString() {
        return "KomodoStorageAttributes [storageType=" + this.storageType + ", artifactPath=" + this.artifactPath + ", parameters=" + this.parameters + "]";
    }
}

