/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational.response;

import java.sql.Clob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.komodo.rest.KRestEntity;
import org.komodo.spi.query.QSRow;

public class RestQueryRow
implements KRestEntity {
    public static final String ROW_LABEL = "row";
    private List<String> values;

    public RestQueryRow() {
    }

    public RestQueryRow(QSRow qsRow) {
        if (qsRow == null) {
            this.values = Collections.emptyList();
        } else {
            this.values = new ArrayList();
            for (Object value : qsRow.getValues()) {
                String valueStr;
                block9: {
                    valueStr = "";
                    if (value != null) {
                        if (value instanceof Clob) {
                            Clob valueClob = (Clob)value;
                            try {
                                long clobLength = valueClob.length();
                                if (clobLength > 0L) {
                                    valueStr = valueClob.getSubString(1L, (int)clobLength);
                                    break block9;
                                }
                                valueStr = "";
                            }
                            catch (SQLException ex) {
                                valueStr = "";
                            }
                        } else {
                            valueStr = value.toString();
                        }
                    }
                }
                this.values.add(valueStr);
            }
        }
    }

    public Object getXml() {
        throw new UnsupportedOperationException();
    }

    public boolean supports(MediaType mediaType) {
        return MediaType.APPLICATION_JSON_TYPE.equals((Object)mediaType);
    }

    public String[] getValues() {
        return this.values.toArray(new String[0]);
    }

    public void setValues(Object[] values) {
        if (values == null || values.length == 0) {
            this.values = Collections.emptyList();
        }
        this.values = new ArrayList();
        for (Object value : values) {
            this.values.add(value.toString());
        }
    }
}

