/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational.response;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.komodo.rest.KRestEntity;
import org.komodo.rest.relational.response.RestStorageTypeDescriptor;
import org.komodo.spi.storage.StorageConnector;

public class RestStorageType
implements KRestEntity {
    public static final String NAME_LABEL = "name";
    public static final String DESCRIPTORS_LABEL = "descriptors";
    public static final String DESCRIPTION_LABEL = "description";
    private String name;
    private List<RestStorageTypeDescriptor> descriptors;
    private String description;

    public RestStorageType() {
        this.descriptors = Collections.emptyList();
    }

    public RestStorageType(String name, String description, Collection<StorageConnector.Descriptor> descriptors) {
        this.name = name;
        this.description = description;
        if (descriptors == null || descriptors.isEmpty()) {
            this.descriptors = Collections.emptyList();
        } else {
            this.descriptors = new ArrayList();
            for (StorageConnector.Descriptor descriptor : descriptors) {
                this.descriptors.add(new RestStorageTypeDescriptor(descriptor));
            }
        }
    }

    public Object getXml() {
        throw new UnsupportedOperationException();
    }

    public boolean supports(MediaType mediaType) {
        return MediaType.APPLICATION_JSON_TYPE.equals((Object)mediaType) || MediaType.APPLICATION_XML_TYPE.equals((Object)mediaType);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<RestStorageTypeDescriptor> getDescriptors() {
        return this.descriptors;
    }

    public void setDescriptors(RestStorageTypeDescriptor[] descriptors) {
        if (descriptors == null || descriptors.length == 0) {
            this.descriptors = Collections.emptyList();
        }
        this.descriptors = new ArrayList();
        for (RestStorageTypeDescriptor descriptor : descriptors) {
            this.descriptors.add(descriptor);
        }
    }
}

