/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational.response;

import java.net.URI;
import java.util.Properties;
import javax.ws.rs.core.MediaType;
import org.komodo.relational.vdb.Vdb;
import org.komodo.rest.KomodoService;
import org.komodo.rest.RestBasicEntity;
import org.komodo.rest.RestLink;
import org.komodo.rest.relational.KomodoRestUriBuilder;
import org.komodo.spi.KException;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;

public class RestVdb
extends RestBasicEntity {
    public static final String NAME_LABEL = KomodoService.protectPrefix((String)"vdb:name");
    public static final String DESCRIPTION_LABEL = KomodoService.protectPrefix((String)"vdb:description");
    public static final String FILE_PATH_LABEL = KomodoService.protectPrefix((String)"vdb:originalFile");
    public static final String PREVIEW_LABEL = KomodoService.protectPrefix((String)"vdb:preview");
    public static final String CONNECTION_TYPE_LABEL = KomodoService.protectPrefix((String)"vdb:connectionType");
    public static final String VERSION_LABEL = KomodoService.protectPrefix((String)"vdb:version");

    public RestVdb() {
    }

    public RestVdb(URI baseUri) throws KException {
        super(baseUri);
    }

    public RestVdb(URI baseUri, Vdb vdb, boolean exportXml, Repository.UnitOfWork uow) throws KException {
        super(baseUri, (KomodoObject)vdb, uow, false);
        this.setName(vdb.getName(uow));
        this.setDescription(vdb.getDescription(uow));
        this.setOriginalFilePath(vdb.getOriginalFilePath(uow));
        this.setPreview(vdb.isPreview(uow));
        this.setConnectionType(vdb.getConnectionType(uow));
        this.setVersion(vdb.getVersion(uow));
        this.addExecutionProperties(uow, (KomodoObject)vdb);
        if (exportXml) {
            byte[] xmlBytes = vdb.export(uow, new Properties());
            this.setXml(new String(xmlBytes));
        }
        Properties settings = this.getUriBuilder().createSettings(KomodoRestUriBuilder.SettingNames.VDB_NAME, this.getId());
        URI parentUri = this.getUriBuilder().vdbParentUri(vdb, uow);
        this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.VDB_PARENT_PATH, parentUri);
        this.addLink(new RestLink(RestLink.LinkType.SELF, this.getUriBuilder().vdbUri(RestLink.LinkType.SELF, settings)));
        this.addLink(new RestLink(RestLink.LinkType.PARENT, this.getUriBuilder().vdbUri(RestLink.LinkType.PARENT, settings)));
        this.createChildLink();
        this.addLink(new RestLink(RestLink.LinkType.IMPORTS, this.getUriBuilder().vdbUri(RestLink.LinkType.IMPORTS, settings)));
        this.addLink(new RestLink(RestLink.LinkType.MODELS, this.getUriBuilder().vdbUri(RestLink.LinkType.MODELS, settings)));
        this.addLink(new RestLink(RestLink.LinkType.TRANSLATORS, this.getUriBuilder().vdbUri(RestLink.LinkType.TRANSLATORS, settings)));
        this.addLink(new RestLink(RestLink.LinkType.DATA_ROLES, this.getUriBuilder().vdbUri(RestLink.LinkType.DATA_ROLES, settings)));
    }

    public boolean supports(MediaType mediaType) {
        if (MediaType.APPLICATION_JSON_TYPE.equals((Object)mediaType)) {
            return true;
        }
        return MediaType.APPLICATION_XML_TYPE.equals((Object)mediaType) && this.getXml() != null;
    }

    public String getName() {
        Object name = this.tuples.get(NAME_LABEL);
        return name != null ? name.toString() : null;
    }

    public void setName(String name) {
        this.tuples.put(NAME_LABEL, name);
    }

    public String getDescription() {
        Object description = this.tuples.get(DESCRIPTION_LABEL);
        return description != null ? description.toString() : null;
    }

    public void setDescription(String description) {
        this.tuples.put(DESCRIPTION_LABEL, description);
    }

    public String getOriginalFilePath() {
        Object path = this.tuples.get(FILE_PATH_LABEL);
        return path != null ? path.toString() : null;
    }

    public void setOriginalFilePath(String originalFilePath) {
        this.tuples.put(FILE_PATH_LABEL, originalFilePath);
    }

    public boolean isPreview() {
        Object preview = this.tuples.get(PREVIEW_LABEL);
        return preview != null ? Boolean.parseBoolean(preview.toString()) : false;
    }

    public void setPreview(boolean preview) {
        this.tuples.put(PREVIEW_LABEL, preview);
    }

    public String getConnectionType() {
        Object connectionType = this.tuples.get(CONNECTION_TYPE_LABEL);
        return connectionType != null ? connectionType.toString() : null;
    }

    public void setConnectionType(String connectionType) {
        this.tuples.put(CONNECTION_TYPE_LABEL, connectionType);
    }

    public int getVersion() {
        Object version = this.tuples.get(VERSION_LABEL);
        return version != null ? Integer.parseInt(version.toString()) : 1;
    }

    public void setVersion(int version) {
        this.tuples.put(VERSION_LABEL, version);
    }
}

