/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational.response;

import java.net.URI;
import java.util.Properties;
import org.komodo.relational.vdb.Condition;
import org.komodo.relational.vdb.DataRole;
import org.komodo.relational.vdb.Permission;
import org.komodo.relational.vdb.Vdb;
import org.komodo.rest.KomodoService;
import org.komodo.rest.RestBasicEntity;
import org.komodo.rest.RestLink;
import org.komodo.rest.relational.KomodoRestUriBuilder;
import org.komodo.spi.KException;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.ArgCheck;

public final class RestVdbCondition
extends RestBasicEntity {
    public static final String NAME_LABEL = KomodoService.protectPrefix((String)"vdb:condition");
    public static final String CONSTRAINT_LABEL = KomodoService.protectPrefix((String)"vdb:constraint");
    public static final RestVdbCondition[] NO_CONDITIONS = new RestVdbCondition[0];

    public RestVdbCondition() {
        this.setConstraint(true);
    }

    public RestVdbCondition(URI baseUri, Condition condition, Repository.UnitOfWork uow) throws KException {
        super(baseUri, (KomodoObject)condition, uow, false);
        this.setName(condition.getName(uow));
        this.setConstraint(condition.isConstraint(uow));
        Permission permission = (Permission)this.ancestor((KomodoObject)condition, Permission.class, uow);
        ArgCheck.isNotNull((Object)permission);
        String permName = permission.getName(uow);
        DataRole dataRole = (DataRole)this.ancestor((KomodoObject)permission, DataRole.class, uow);
        ArgCheck.isNotNull((Object)dataRole);
        String dataRoleName = dataRole.getName(uow);
        Vdb vdb = (Vdb)this.ancestor((KomodoObject)dataRole, Vdb.class, uow);
        ArgCheck.isNotNull((Object)vdb);
        String vdbName = vdb.getName(uow);
        Properties settings = this.getUriBuilder().createSettings(KomodoRestUriBuilder.SettingNames.VDB_NAME, vdbName);
        this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.VDB_PARENT_PATH, this.getUriBuilder().vdbParentUri(vdb, uow));
        this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.DATA_ROLE_ID, dataRoleName);
        this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.PERMISSION_ID, permName);
        this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.PERMISSION_CHILD_TYPE, RestLink.LinkType.CONDITIONS.uriName());
        this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.PERMISSION_CHILD_ID, this.getId());
        this.addLink(new RestLink(RestLink.LinkType.SELF, this.getUriBuilder().vdbPermissionChildUri(RestLink.LinkType.SELF, settings)));
        this.addLink(new RestLink(RestLink.LinkType.PARENT, this.getUriBuilder().vdbPermissionChildUri(RestLink.LinkType.PARENT, settings)));
        this.createChildLink();
    }

    public String getName() {
        Object name = this.tuples.get(NAME_LABEL);
        return name != null ? name.toString() : null;
    }

    public void setName(String newName) {
        this.tuples.put(NAME_LABEL, newName);
    }

    public boolean isConstraint() {
        Object constraint = this.tuples.get(CONSTRAINT_LABEL);
        return constraint != null ? Boolean.parseBoolean(constraint.toString()) : true;
    }

    public void setConstraint(boolean constraint) {
        this.tuples.put(CONSTRAINT_LABEL, constraint);
    }
}

