/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational.response;

import java.net.URI;
import java.util.Properties;
import org.komodo.relational.vdb.DataRole;
import org.komodo.relational.vdb.Permission;
import org.komodo.relational.vdb.Vdb;
import org.komodo.rest.KomodoService;
import org.komodo.rest.RestBasicEntity;
import org.komodo.rest.RestLink;
import org.komodo.rest.relational.KomodoRestUriBuilder;
import org.komodo.rest.relational.response.RestVdbPermission;
import org.komodo.spi.KException;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.ArgCheck;

public final class RestVdbDataRole
extends RestBasicEntity {
    public static final String NAME_LABEL = KomodoService.protectPrefix((String)"vdb:dataRole");
    public static final String DESCRIPTION_LABEL = KomodoService.protectPrefix((String)"vdb:description");
    public static final String ALLOW_CREATE_TEMP_TABLES_LABEL = KomodoService.protectPrefix((String)"vdb:allowCreateTemporaryTables");
    public static final String ANY_AUTHENTICATED_LABEL = KomodoService.protectPrefix((String)"vdb:anyAuthenticated");
    public static final String GRANT_ALL_LABEL = KomodoService.protectPrefix((String)"vdb:grantAll");
    public static final String MAPPED_ROLES_LABEL = KomodoService.protectPrefix((String)"vdb:mappedRoleNames");
    public static final String PERMISSIONS_LABEL = KomodoService.protectPrefix((String)"vdb:permissions");
    public static final RestVdbDataRole[] NO_DATA_ROLES = new RestVdbDataRole[0];
    private RestVdbPermission[] permissions = RestVdbPermission.NO_PERMISSIONS;

    public RestVdbDataRole() {
        this.setAllowCreateTempTables(false);
        this.setAnyAuthenticated(false);
        this.setGrantAll(false);
    }

    public RestVdbDataRole(URI baseUri, DataRole dataRole, Repository.UnitOfWork uow) throws KException {
        super(baseUri, (KomodoObject)dataRole, uow, false);
        Permission[] permissions;
        this.setName(dataRole.getName(uow));
        this.setDescription(dataRole.getDescription(uow));
        this.setAllowCreateTempTables(dataRole.isAllowCreateTempTables(uow));
        this.setAnyAuthenticated(dataRole.isAnyAuthenticated(uow));
        this.setGrantAll(dataRole.isGrantAll(uow));
        String[] mappedRoles = dataRole.getMappedRoles(uow, new String[0]);
        if (mappedRoles != null) {
            this.setMappedRoles(mappedRoles);
        }
        if ((permissions = dataRole.getPermissions(uow, new String[0])).length != 0) {
            RestVdbPermission[] restPermissions = new RestVdbPermission[permissions.length];
            int i = 0;
            for (Permission permission : permissions) {
                restPermissions[i++] = new RestVdbPermission(baseUri, permission, uow);
            }
            this.setPermissions(restPermissions);
        }
        Vdb vdb = (Vdb)this.ancestor((KomodoObject)dataRole, Vdb.class, uow);
        ArgCheck.isNotNull((Object)vdb);
        String vdbName = vdb.getName(uow);
        Properties settings = this.getUriBuilder().createSettings(KomodoRestUriBuilder.SettingNames.VDB_NAME, vdbName);
        this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.VDB_PARENT_PATH, this.getUriBuilder().vdbParentUri(vdb, uow));
        this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.DATA_ROLE_ID, this.getId());
        this.addLink(new RestLink(RestLink.LinkType.SELF, this.getUriBuilder().vdbDataRoleUri(RestLink.LinkType.SELF, settings)));
        this.addLink(new RestLink(RestLink.LinkType.PARENT, this.getUriBuilder().vdbDataRoleUri(RestLink.LinkType.PARENT, settings)));
        this.createChildLink();
        this.addLink(new RestLink(RestLink.LinkType.PERMISSIONS, this.getUriBuilder().vdbDataRoleUri(RestLink.LinkType.PERMISSIONS, settings)));
    }

    public String getDescription() {
        Object description = this.tuples.get(DESCRIPTION_LABEL);
        return description != null ? description.toString() : null;
    }

    public String[] getMappedRoles() {
        Object roles = this.tuples.get(MAPPED_ROLES_LABEL);
        if (roles == null) {
            return EMPTY_ARRAY;
        }
        if (roles instanceof String[]) {
            return (String[])roles;
        }
        Object[] roleArr = (Object[])roles;
        String[] roleStrings = new String[roleArr.length];
        for (int i = 0; i < roleArr.length; ++i) {
            roleStrings[i] = roleArr[i].toString();
        }
        return roleStrings;
    }

    public String getName() {
        Object name = this.tuples.get(NAME_LABEL);
        return name != null ? name.toString() : null;
    }

    public RestVdbPermission[] getPermissions() {
        return this.permissions;
    }

    public boolean isAllowCreateTempTables() {
        Object value = this.tuples.get(ALLOW_CREATE_TEMP_TABLES_LABEL);
        return value != null ? Boolean.parseBoolean(value.toString()) : false;
    }

    public boolean isAnyAuthenticated() {
        Object value = this.tuples.get(ANY_AUTHENTICATED_LABEL);
        return value != null ? Boolean.parseBoolean(value.toString()) : false;
    }

    public boolean isGrantAll() {
        Object value = this.tuples.get(GRANT_ALL_LABEL);
        return value != null ? Boolean.parseBoolean(value.toString()) : false;
    }

    public void setAllowCreateTempTables(boolean newAllowCreateTempTables) {
        this.tuples.put(ALLOW_CREATE_TEMP_TABLES_LABEL, newAllowCreateTempTables);
    }

    public void setAnyAuthenticated(boolean newAnyAuthenticated) {
        this.tuples.put(ANY_AUTHENTICATED_LABEL, newAnyAuthenticated);
    }

    public void setDescription(String newDescription) {
        this.tuples.put(DESCRIPTION_LABEL, newDescription);
    }

    public void setGrantAll(boolean newGrantAll) {
        this.tuples.put(GRANT_ALL_LABEL, newGrantAll);
    }

    public void setMappedRoles(String[] newMappedRoles) {
        this.tuples.put(MAPPED_ROLES_LABEL, newMappedRoles);
    }

    public void setName(String newName) {
        this.tuples.put(NAME_LABEL, newName);
    }

    public void setPermissions(RestVdbPermission[] newPermissions) {
        this.permissions = newPermissions == null ? RestVdbPermission.NO_PERMISSIONS : newPermissions;
    }
}

