/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational.response;

import java.net.URI;
import java.util.Properties;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.vdb.VdbImport;
import org.komodo.rest.KomodoService;
import org.komodo.rest.RestBasicEntity;
import org.komodo.rest.RestLink;
import org.komodo.rest.relational.KomodoRestUriBuilder;
import org.komodo.spi.KException;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.ArgCheck;

public final class RestVdbImport
extends RestBasicEntity {
    public static final String NAME_LABEL = KomodoService.protectPrefix((String)"vdb:importVdb");
    public static final String IMPORT_POLICIES_LABEL = KomodoService.protectPrefix((String)"vdb:importDataPolicies");
    public static final String VERSION_LABEL = KomodoService.protectPrefix((String)"vdb:version");
    public static final RestVdbImport[] NO_IMPORTS = new RestVdbImport[0];

    public RestVdbImport() {
        this.setVersion(1);
        this.setImportDataPolicies(true);
    }

    public RestVdbImport(URI baseUri, VdbImport vdbImport, Repository.UnitOfWork uow) throws KException {
        super(baseUri, (KomodoObject)vdbImport, uow, false);
        this.setName(vdbImport.getName(uow));
        this.setVersion(vdbImport.getVersion(uow));
        this.setImportDataPolicies(vdbImport.isImportDataPolicies(uow));
        Vdb vdb = (Vdb)this.ancestor((KomodoObject)vdbImport, Vdb.class, uow);
        ArgCheck.isNotNull((Object)vdb);
        String vdbName = vdb.getName(uow);
        Properties settings = this.getUriBuilder().createSettings(KomodoRestUriBuilder.SettingNames.VDB_NAME, vdbName);
        this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.VDB_PARENT_PATH, this.getUriBuilder().vdbParentUri(vdb, uow));
        this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.IMPORT_NAME, this.getId());
        this.addLink(new RestLink(RestLink.LinkType.SELF, this.getUriBuilder().vdbImportUri(RestLink.LinkType.SELF, settings)));
        this.addLink(new RestLink(RestLink.LinkType.PARENT, this.getUriBuilder().vdbImportUri(RestLink.LinkType.PARENT, settings)));
        this.createChildLink();
    }

    public String getName() {
        Object value = this.tuples.get(NAME_LABEL);
        return value != null ? value.toString() : null;
    }

    public void setName(String newName) {
        this.tuples.put(NAME_LABEL, newName);
    }

    public int getVersion() {
        Object value = this.tuples.get(VERSION_LABEL);
        return value != null ? Integer.parseInt(value.toString()) : 1;
    }

    public void setVersion(int newVersion) {
        this.tuples.put(VERSION_LABEL, newVersion);
    }

    public boolean isImportDataPolicies() {
        Object value = this.tuples.get(IMPORT_POLICIES_LABEL);
        return value != null ? Boolean.parseBoolean(value.toString()) : true;
    }

    public void setImportDataPolicies(boolean newImportDataPolicies) {
        this.tuples.put(IMPORT_POLICIES_LABEL, newImportDataPolicies);
    }
}

