/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational.response;

import java.net.URI;
import java.util.Properties;
import org.komodo.relational.vdb.DataRole;
import org.komodo.relational.vdb.Mask;
import org.komodo.relational.vdb.Permission;
import org.komodo.relational.vdb.Vdb;
import org.komodo.rest.KomodoService;
import org.komodo.rest.RestBasicEntity;
import org.komodo.rest.RestLink;
import org.komodo.rest.relational.KomodoRestUriBuilder;
import org.komodo.spi.KException;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.ArgCheck;

public final class RestVdbMask
extends RestBasicEntity {
    public static final String NAME_LABEL = KomodoService.protectPrefix((String)"vdb:mask");
    public static final String ORDER_LABEL = KomodoService.protectPrefix((String)"vdb:order");
    public static final RestVdbMask[] NO_MASKS = new RestVdbMask[0];

    public RestVdbMask() {
    }

    public RestVdbMask(URI baseUri, Mask mask, Repository.UnitOfWork uow) throws KException {
        super(baseUri, (KomodoObject)mask, uow, false);
        this.setName(mask.getName(uow));
        this.setOrder(mask.getOrder(uow));
        Permission permission = (Permission)this.ancestor((KomodoObject)mask, Permission.class, uow);
        ArgCheck.isNotNull((Object)permission);
        String permName = permission.getName(uow);
        DataRole dataRole = (DataRole)this.ancestor((KomodoObject)permission, DataRole.class, uow);
        ArgCheck.isNotNull((Object)dataRole);
        String dataRoleName = dataRole.getName(uow);
        Vdb vdb = (Vdb)this.ancestor((KomodoObject)dataRole, Vdb.class, uow);
        ArgCheck.isNotNull((Object)vdb);
        String vdbName = vdb.getName(uow);
        Properties settings = this.getUriBuilder().createSettings(KomodoRestUriBuilder.SettingNames.VDB_NAME, vdbName);
        this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.VDB_PARENT_PATH, this.getUriBuilder().vdbParentUri(vdb, uow));
        this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.DATA_ROLE_ID, dataRoleName);
        this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.PERMISSION_ID, permName);
        this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.PERMISSION_CHILD_TYPE, RestLink.LinkType.MASKS.uriName());
        this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.PERMISSION_CHILD_ID, this.getId());
        this.addLink(new RestLink(RestLink.LinkType.SELF, this.getUriBuilder().vdbPermissionChildUri(RestLink.LinkType.SELF, settings)));
        this.addLink(new RestLink(RestLink.LinkType.PARENT, this.getUriBuilder().vdbPermissionChildUri(RestLink.LinkType.PARENT, settings)));
        this.createChildLink();
    }

    public String getName() {
        Object value = this.tuples.get(NAME_LABEL);
        return value != null ? value.toString() : null;
    }

    public void setName(String newName) {
        this.tuples.put(NAME_LABEL, newName);
    }

    public String getOrder() {
        Object value = this.tuples.get(ORDER_LABEL);
        return value != null ? value.toString() : null;
    }

    public void setOrder(String order) {
        this.tuples.put(ORDER_LABEL, order);
    }
}

