/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational.response;

import java.net.URI;
import java.util.Properties;
import org.komodo.relational.model.Model;
import org.komodo.relational.vdb.Vdb;
import org.komodo.rest.KomodoService;
import org.komodo.rest.RestBasicEntity;
import org.komodo.rest.RestLink;
import org.komodo.rest.relational.KomodoRestUriBuilder;
import org.komodo.spi.KException;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.ArgCheck;

public final class RestVdbModel
extends RestBasicEntity {
    public static final String DESCRIPTION_LABEL = KomodoService.protectPrefix((String)"vdb:description");
    public static final String MODEL_TYPE_LABEL = KomodoService.protectPrefix((String)"mmcore:modelType");
    public static final String VISIBLE_LABEL = KomodoService.protectPrefix((String)"vdb:visible");
    public static final String METADATA_TYPE_LABEL = KomodoService.protectPrefix((String)"vdb:metadataType");

    public RestVdbModel() {
    }

    public RestVdbModel(URI baseUri, Model model, Repository.UnitOfWork uow) throws KException {
        super(baseUri, (KomodoObject)model, uow, false);
        this.setDescription(model.getDescription(uow));
        this.setModelType(model.getModelType(uow));
        this.setVisible(model.isVisible(uow));
        this.setMetadataType(model.getMetadataType(uow));
        this.addExecutionProperties(uow, (KomodoObject)model);
        Properties properties = new Properties();
        byte[] ddlBytes = model.export(uow, properties);
        String ddl = ddlBytes == null ? "" : new String(ddlBytes);
        this.setDdl(ddl);
        Vdb vdb = (Vdb)this.ancestor((KomodoObject)model, Vdb.class, uow);
        ArgCheck.isNotNull((Object)vdb);
        String vdbName = vdb.getName(uow);
        Properties settings = this.getUriBuilder().createSettings(KomodoRestUriBuilder.SettingNames.VDB_NAME, vdbName);
        this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.VDB_PARENT_PATH, this.getUriBuilder().vdbParentUri(vdb, uow));
        this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.MODEL_NAME, this.getId());
        this.addLink(new RestLink(RestLink.LinkType.SELF, this.getUriBuilder().vdbModelUri(RestLink.LinkType.SELF, settings)));
        this.addLink(new RestLink(RestLink.LinkType.PARENT, this.getUriBuilder().vdbModelUri(RestLink.LinkType.PARENT, settings)));
        this.createChildLink();
        this.addLink(new RestLink(RestLink.LinkType.SOURCES, this.getUriBuilder().vdbModelUri(RestLink.LinkType.SOURCES, settings)));
    }

    public String getDescription() {
        Object description = this.tuples.get(DESCRIPTION_LABEL);
        return description != null ? description.toString() : null;
    }

    public void setDescription(String description) {
        this.tuples.put(DESCRIPTION_LABEL, description);
    }

    public Model.Type getModelType() {
        Object type = this.tuples.get(MODEL_TYPE_LABEL);
        return type != null ? Model.Type.findType((String)type.toString()) : Model.Type.DEFAULT_VALUE;
    }

    public void setModelType(Model.Type type) {
        this.tuples.put(MODEL_TYPE_LABEL, type);
    }

    public boolean isVisible() {
        Object visible = this.tuples.get(VISIBLE_LABEL);
        return visible != null ? Boolean.parseBoolean(visible.toString()) : true;
    }

    public void setVisible(boolean visible) {
        this.tuples.put(VISIBLE_LABEL, visible);
    }

    public String getMetadataType() {
        Object type = this.tuples.get(METADATA_TYPE_LABEL);
        return type != null ? type.toString() : "DDL";
    }

    public void setMetadataType(String metadataType) {
        this.tuples.put(METADATA_TYPE_LABEL, metadataType);
    }

    public String getDdl() {
        Object ddl = this.tuples.get("keng__ddl");
        return ddl != null ? ddl.toString() : "";
    }

    public void setDdl(String ddl) {
        this.tuples.put("keng__ddl", ddl);
    }
}

