/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational.response;

import java.net.URI;
import java.util.Properties;
import org.komodo.relational.model.Model;
import org.komodo.relational.vdb.ModelSource;
import org.komodo.relational.vdb.Translator;
import org.komodo.relational.vdb.Vdb;
import org.komodo.rest.KomodoService;
import org.komodo.rest.RestBasicEntity;
import org.komodo.rest.RestLink;
import org.komodo.rest.relational.KomodoRestUriBuilder;
import org.komodo.spi.KException;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.ArgCheck;

public final class RestVdbModelSource
extends RestBasicEntity {
    public static final String JNDI_NAME_LABEL = KomodoService.protectPrefix((String)"vdb:sourceJndiName");
    public static final String TRANSLATOR_LABEL = KomodoService.protectPrefix((String)"vdb:sourceTranslator");

    public RestVdbModelSource() {
    }

    public RestVdbModelSource(URI baseUri, ModelSource source, Repository.UnitOfWork uow) throws KException {
        super(baseUri, (KomodoObject)source, uow, false);
        this.setJndiName(source.getJndiName(uow));
        String translatorName = source.getTranslatorName(uow);
        this.setTranslator(translatorName);
        Model model = (Model)this.ancestor((KomodoObject)source, Model.class, uow);
        ArgCheck.isNotNull((Object)model);
        String modelName = model.getName(uow);
        Vdb vdb = (Vdb)this.ancestor((KomodoObject)model, Vdb.class, uow);
        ArgCheck.isNotNull((Object)vdb);
        String vdbName = vdb.getName(uow);
        Properties settings = this.getUriBuilder().createSettings(KomodoRestUriBuilder.SettingNames.VDB_NAME, vdbName);
        this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.VDB_PARENT_PATH, this.getUriBuilder().vdbParentUri(vdb, uow));
        this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.MODEL_NAME, modelName);
        this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.TRANSLATOR_NAME, translatorName);
        this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.SOURCE_NAME, this.getId());
        this.addLink(new RestLink(RestLink.LinkType.SELF, this.getUriBuilder().vdbModelSourceUri(RestLink.LinkType.SELF, settings)));
        this.addLink(new RestLink(RestLink.LinkType.PARENT, this.getUriBuilder().vdbModelSourceUri(RestLink.LinkType.PARENT, settings)));
        this.createChildLink();
        Translator[] translators = vdb.getTranslators(uow, new String[]{translatorName});
        if (translators != null && translators.length == 1) {
            this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.TRANSLATOR_NAME, translatorName);
            this.addLink(new RestLink(RestLink.LinkType.REFERENCE, this.getUriBuilder().vdbModelSourceUri(RestLink.LinkType.REFERENCE, settings)));
        }
    }

    public String getJndiName() {
        Object jndi = this.tuples.get(JNDI_NAME_LABEL);
        return jndi != null ? jndi.toString() : null;
    }

    public void setJndiName(String jndiName) {
        this.tuples.put(JNDI_NAME_LABEL, jndiName);
    }

    public String getTranslator() {
        Object translator = this.tuples.get(TRANSLATOR_LABEL);
        return translator != null ? translator.toString() : null;
    }

    public void setTranslator(String translator) {
        this.tuples.put(TRANSLATOR_LABEL, translator);
    }
}

