/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational.response;

import java.net.URI;
import java.util.Properties;
import org.komodo.relational.model.Model;
import org.komodo.relational.model.Table;
import org.komodo.relational.vdb.Vdb;
import org.komodo.rest.RestBasicEntity;
import org.komodo.rest.RestLink;
import org.komodo.rest.relational.KomodoRestUriBuilder;
import org.komodo.spi.KException;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.ArgCheck;

public final class RestVdbModelTable
extends RestBasicEntity {
    public static final String CARDINALITY_LABEL = "Cardinality";

    public RestVdbModelTable() {
    }

    public RestVdbModelTable(URI baseUri, Table table, Repository.UnitOfWork uow) throws KException {
        super(baseUri, (KomodoObject)table, uow, false);
        this.setCardinality(table.getCardinality(uow));
        Model model = (Model)this.ancestor((KomodoObject)table, Model.class, uow);
        ArgCheck.isNotNull((Object)model);
        String modelName = model.getName(uow);
        Vdb vdb = (Vdb)this.ancestor((KomodoObject)model, Vdb.class, uow);
        ArgCheck.isNotNull((Object)vdb);
        String vdbName = vdb.getName(uow);
        Properties settings = this.getUriBuilder().createSettings(KomodoRestUriBuilder.SettingNames.VDB_NAME, vdbName);
        this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.VDB_PARENT_PATH, this.getUriBuilder().vdbParentUri(vdb, uow));
        this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.MODEL_NAME, modelName);
        this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.TABLE_NAME, this.getId());
        this.addLink(new RestLink(RestLink.LinkType.SELF, this.getUriBuilder().vdbModelTableUri(RestLink.LinkType.SELF, settings)));
        this.addLink(new RestLink(RestLink.LinkType.PARENT, this.getUriBuilder().vdbModelTableUri(RestLink.LinkType.PARENT, settings)));
        this.createChildLink();
    }

    public long getCardinality() {
        Object adminPort = this.tuples.get(CARDINALITY_LABEL);
        return adminPort != null ? Long.parseLong(adminPort.toString()) : 1L;
    }

    public void setCardinality(long cardinality) {
        this.tuples.put(CARDINALITY_LABEL, cardinality);
    }
}

