/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational.response;

import java.net.URI;
import java.util.Properties;
import org.komodo.relational.model.Column;
import org.komodo.relational.model.Model;
import org.komodo.relational.model.Table;
import org.komodo.relational.vdb.Vdb;
import org.komodo.rest.RestBasicEntity;
import org.komodo.rest.RestLink;
import org.komodo.rest.relational.KomodoRestUriBuilder;
import org.komodo.spi.KException;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.ArgCheck;

public final class RestVdbModelTableColumn
extends RestBasicEntity {
    public static final String DATATYPE_LABEL = "Datatype";

    public RestVdbModelTableColumn() {
    }

    public RestVdbModelTableColumn(URI baseUri, Column column, Repository.UnitOfWork uow) throws KException {
        super(baseUri, (KomodoObject)column, uow, false);
        this.setDatatypeName(column.getDatatypeName(uow));
        Table table = (Table)this.ancestor((KomodoObject)column, Table.class, uow);
        ArgCheck.isNotNull((Object)table);
        String tableName = table.getName(uow);
        Model model = (Model)this.ancestor((KomodoObject)table, Model.class, uow);
        ArgCheck.isNotNull((Object)model);
        String modelName = model.getName(uow);
        Vdb vdb = (Vdb)this.ancestor((KomodoObject)model, Vdb.class, uow);
        ArgCheck.isNotNull((Object)vdb);
        String vdbName = vdb.getName(uow);
        Properties settings = this.getUriBuilder().createSettings(KomodoRestUriBuilder.SettingNames.VDB_NAME, vdbName);
        this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.VDB_PARENT_PATH, this.getUriBuilder().vdbParentUri(vdb, uow));
        this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.MODEL_NAME, modelName);
        this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.TABLE_NAME, tableName);
        this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.COLUMN_NAME, this.getId());
        this.addLink(new RestLink(RestLink.LinkType.SELF, this.getUriBuilder().vdbModelTableColumnUri(RestLink.LinkType.SELF, settings)));
        this.addLink(new RestLink(RestLink.LinkType.PARENT, this.getUriBuilder().vdbModelTableColumnUri(RestLink.LinkType.PARENT, settings)));
        this.createChildLink();
    }

    public String getDatatypeName() {
        Object dataType = this.tuples.get(DATATYPE_LABEL);
        return dataType != null ? dataType.toString() : null;
    }

    public void setDatatypeName(String newDataType) {
        this.tuples.put(DATATYPE_LABEL, newDataType);
    }
}

