/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational.response;

import java.net.URI;
import java.util.Properties;
import org.komodo.relational.vdb.DataRole;
import org.komodo.relational.vdb.Permission;
import org.komodo.relational.vdb.Vdb;
import org.komodo.rest.KomodoService;
import org.komodo.rest.RestBasicEntity;
import org.komodo.rest.RestLink;
import org.komodo.rest.relational.KomodoRestUriBuilder;
import org.komodo.spi.KException;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.ArgCheck;

public final class RestVdbPermission
extends RestBasicEntity {
    public static final String NAME_LABEL = KomodoService.protectPrefix((String)"vdb:permission");
    public static final String ALLOW_ALTER_LABEL = KomodoService.protectPrefix((String)"vdb:allowAlter");
    public static final String ALLOW_CREATE_LABEL = KomodoService.protectPrefix((String)"vdb:allowCreate");
    public static final String ALLOW_DELETE_LABEL = KomodoService.protectPrefix((String)"vdb:allowDelete");
    public static final String ALLOW_EXECUTE_LABEL = KomodoService.protectPrefix((String)"vdb:allowExecute");
    public static final String ALLOW_LANGUAGE_LABEL = KomodoService.protectPrefix((String)"vdb:allowLanguage");
    public static final String ALLOW_READ_LABEL = KomodoService.protectPrefix((String)"vdb:allowRead");
    public static final String ALLOW_UPDATE_LABEL = KomodoService.protectPrefix((String)"vdb:allowUpdate");
    public static final RestVdbPermission[] NO_PERMISSIONS = new RestVdbPermission[0];

    public RestVdbPermission() {
        this.setAllowAlter(false);
        this.setAllowCreate(false);
        this.setAllowDelete(false);
        this.setAllowExecute(false);
        this.setAllowLanguage(false);
        this.setAllowRead(false);
        this.setAllowUpdate(false);
    }

    public RestVdbPermission(URI baseUri, Permission permission, Repository.UnitOfWork uow) throws KException {
        super(baseUri, (KomodoObject)permission, uow, false);
        this.setName(permission.getName(uow));
        this.setAllowAlter(permission.isAllowAlter(uow));
        this.setAllowCreate(permission.isAllowCreate(uow));
        this.setAllowDelete(permission.isAllowDelete(uow));
        this.setAllowExecute(permission.isAllowExecute(uow));
        this.setAllowLanguage(permission.isAllowLanguage(uow));
        this.setAllowRead(permission.isAllowRead(uow));
        this.setAllowUpdate(permission.isAllowUpdate(uow));
        DataRole dataRole = (DataRole)this.ancestor((KomodoObject)permission, DataRole.class, uow);
        ArgCheck.isNotNull((Object)dataRole);
        String dataRoleName = dataRole.getName(uow);
        Vdb vdb = (Vdb)this.ancestor((KomodoObject)dataRole, Vdb.class, uow);
        ArgCheck.isNotNull((Object)vdb);
        String vdbName = vdb.getName(uow);
        Properties settings = this.getUriBuilder().createSettings(KomodoRestUriBuilder.SettingNames.VDB_NAME, vdbName);
        this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.VDB_PARENT_PATH, this.getUriBuilder().vdbParentUri(vdb, uow));
        this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.DATA_ROLE_ID, dataRoleName);
        this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.PERMISSION_ID, this.getId());
        this.addLink(new RestLink(RestLink.LinkType.SELF, this.getUriBuilder().vdbPermissionUri(RestLink.LinkType.SELF, settings)));
        this.addLink(new RestLink(RestLink.LinkType.PARENT, this.getUriBuilder().vdbPermissionUri(RestLink.LinkType.PARENT, settings)));
        this.createChildLink();
        this.addLink(new RestLink(RestLink.LinkType.CONDITIONS, this.getUriBuilder().vdbPermissionUri(RestLink.LinkType.CONDITIONS, settings)));
        this.addLink(new RestLink(RestLink.LinkType.MASKS, this.getUriBuilder().vdbPermissionUri(RestLink.LinkType.MASKS, settings)));
    }

    public String getName() {
        Object name = this.tuples.get(NAME_LABEL);
        return name != null ? name.toString() : null;
    }

    public boolean isAllowAlter() {
        Object value = this.tuples.get(ALLOW_ALTER_LABEL);
        return value != null ? Boolean.parseBoolean(value.toString()) : false;
    }

    public boolean isAllowCreate() {
        Object value = this.tuples.get(ALLOW_CREATE_LABEL);
        return value != null ? Boolean.parseBoolean(value.toString()) : false;
    }

    public boolean isAllowDelete() {
        Object value = this.tuples.get(ALLOW_DELETE_LABEL);
        return value != null ? Boolean.parseBoolean(value.toString()) : false;
    }

    public boolean isAllowExecute() {
        Object value = this.tuples.get(ALLOW_EXECUTE_LABEL);
        return value != null ? Boolean.parseBoolean(value.toString()) : false;
    }

    public boolean isAllowLanguage() {
        Object value = this.tuples.get(ALLOW_LANGUAGE_LABEL);
        return value != null ? Boolean.parseBoolean(value.toString()) : false;
    }

    public boolean isAllowRead() {
        Object value = this.tuples.get(ALLOW_READ_LABEL);
        return value != null ? Boolean.parseBoolean(value.toString()) : false;
    }

    public boolean isAllowUpdate() {
        Object value = this.tuples.get(ALLOW_UPDATE_LABEL);
        return value != null ? Boolean.parseBoolean(value.toString()) : false;
    }

    public void setAllowAlter(boolean newAllowAlter) {
        this.tuples.put(ALLOW_ALTER_LABEL, newAllowAlter);
    }

    public void setAllowCreate(boolean newAllowCreate) {
        this.tuples.put(ALLOW_CREATE_LABEL, newAllowCreate);
    }

    public void setAllowDelete(boolean newAllowDelete) {
        this.tuples.put(ALLOW_DELETE_LABEL, newAllowDelete);
    }

    public void setAllowExecute(boolean newAllowExecute) {
        this.tuples.put(ALLOW_EXECUTE_LABEL, newAllowExecute);
    }

    public void setAllowLanguage(boolean newAllowLanguage) {
        this.tuples.put(ALLOW_LANGUAGE_LABEL, newAllowLanguage);
    }

    public void setAllowRead(boolean newAllowRead) {
        this.tuples.put(ALLOW_READ_LABEL, newAllowRead);
    }

    public void setAllowUpdate(boolean newAllowUpdate) {
        this.tuples.put(ALLOW_UPDATE_LABEL, newAllowUpdate);
    }

    public void setName(String newName) {
        this.tuples.put(NAME_LABEL, newName);
    }
}

