/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational.response;

import java.net.URI;
import java.util.Properties;
import org.komodo.relational.vdb.Translator;
import org.komodo.rest.KomodoService;
import org.komodo.rest.RestBasicEntity;
import org.komodo.rest.RestLink;
import org.komodo.rest.relational.KomodoRestUriBuilder;
import org.komodo.spi.KException;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;

public class RestVdbTranslator
extends RestBasicEntity {
    public static final String DESCRIPTION_LABEL = KomodoService.protectPrefix((String)"vdb:description");
    public static final String TYPE_LABEL = KomodoService.protectPrefix((String)"vdb:type");
    public static final RestVdbTranslator[] NO_TRANSLATORS = new RestVdbTranslator[0];

    public RestVdbTranslator() {
    }

    public RestVdbTranslator(URI baseUri) throws KException {
        super(baseUri);
    }

    public RestVdbTranslator(URI baseUri, Translator translator, Repository.UnitOfWork uow) throws KException {
        super(baseUri, (KomodoObject)translator, uow, false);
        this.setDescription(translator.getDescription(uow));
        this.setType(translator.getType(uow));
        this.addExecutionProperties(uow, (KomodoObject)translator);
        Properties settings = this.getUriBuilder().createSettings(KomodoRestUriBuilder.SettingNames.TRANSLATOR_NAME, this.getId());
        URI parentUri = this.getUriBuilder().vdbTranslatorParentUri(translator, uow);
        this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.PARENT_PATH, parentUri);
        KomodoObject parentObject = translator.getParent(uow);
        if (parentObject != null && "vdb:virtualDatabase".equals(parentObject.getPrimaryType(uow).getName())) {
            this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.ADD_TRANSLATORS_SEGMENT, "true");
        }
        this.addLink(new RestLink(RestLink.LinkType.SELF, this.getUriBuilder().vdbTranslatorUri(RestLink.LinkType.SELF, settings)));
        this.addLink(new RestLink(RestLink.LinkType.PARENT, this.getUriBuilder().vdbTranslatorUri(RestLink.LinkType.PARENT, settings)));
        this.createChildLink();
    }

    public String getDescription() {
        Object description = this.tuples.get(DESCRIPTION_LABEL);
        return description != null ? description.toString() : null;
    }

    public void setDescription(String newDescription) {
        this.tuples.put(DESCRIPTION_LABEL, newDescription);
    }

    public String getType() {
        Object type = this.tuples.get(TYPE_LABEL);
        return type != null ? type.toString() : null;
    }

    public void setType(String newType) {
        this.tuples.put(TYPE_LABEL, newType);
    }
}

