/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational.response.metadata;

import java.net.URI;
import java.util.Properties;
import org.komodo.relational.connection.Connection;
import org.komodo.rest.RestLink;
import org.komodo.rest.relational.KomodoRestUriBuilder;
import org.komodo.rest.relational.connection.RestConnection;
import org.komodo.spi.KException;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.ArgCheck;

public final class RestMetadataConnection
extends RestConnection {
    public static final RestMetadataConnection[] NO_CONNECTIONS = new RestMetadataConnection[0];

    public RestMetadataConnection() {
    }

    public RestMetadataConnection(URI baseUri, Connection connection, Repository.UnitOfWork uow) throws KException {
        super(baseUri);
        ArgCheck.isNotNull((Object)connection, (String)"connection");
        ArgCheck.isNotNull((Object)uow, (String)"uow");
        this.setId(connection.getName(uow));
        this.setkType(connection.getTypeIdentifier(uow));
        this.setHasChildren(connection.hasChildren(uow));
        this.setJndiName(connection.getJndiName(uow));
        this.setDriverName(connection.getDriverName(uow));
        this.setJdbc(connection.isJdbc(uow));
        this.addExecutionProperties(uow, (KomodoObject)connection);
        Properties settings = this.getUriBuilder().createSettings(KomodoRestUriBuilder.SettingNames.CONNECTION_NAME, this.getId());
        URI parentUri = this.getUriBuilder().mServerConnectionsUri();
        this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.PARENT_PATH, parentUri);
        this.addLink(new RestLink(RestLink.LinkType.SELF, this.getUriBuilder().connectionUri(RestLink.LinkType.SELF, settings)));
        this.addLink(new RestLink(RestLink.LinkType.PARENT, this.getUriBuilder().connectionUri(RestLink.LinkType.PARENT, settings)));
    }
}

