/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational.response.metadata;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.komodo.rest.AbstractKEntity;
import org.komodo.rest.RestLink;
import org.komodo.rest.relational.response.RestConnectionDriver;
import org.komodo.spi.KException;
import org.komodo.spi.metadata.MetadataInstance;
import org.komodo.spi.runtime.ConnectionDriver;
import org.komodo.spi.runtime.TeiidDataSource;
import org.komodo.spi.runtime.TeiidTranslator;
import org.komodo.spi.runtime.TeiidVdb;
import org.komodo.spi.runtime.version.MetadataVersion;

public final class RestMetadataStatus
extends AbstractKEntity {
    public static final String AVAILABLE_LABEL = "available";
    public static final String VERSION_LABEL = "version";
    public static final String DATA_SOURCE_SIZE_LABEL = "dataSourceSize";
    public static final String DATA_SOURCE_NAMES_LABEL = "dataSourceNames";
    public static final String DATA_SOURCE_DRIVER_SIZE_LABEL = "dataSourceDriverSize";
    public static final String DATA_SOURCE_DRIVERS_LABEL = "dataSourceDrivers";
    public static final String TRANSLATOR_SIZE_LABEL = "translatorSize";
    public static final String TRANSLATOR_NAMES_LABEL = "translatorNames";
    public static final String VDB_SIZE_LABEL = "vdbSize";
    public static final String VDB_NAMES_LABEL = "vdbNames";
    private List<RestConnectionDriver> sourceDrivers = new ArrayList();

    public RestMetadataStatus() {
    }

    public RestMetadataStatus(URI baseUri, MetadataInstance mServer) throws KException {
        super(baseUri);
        this.addLink(new RestLink(RestLink.LinkType.SELF, this.getUriBuilder().mServerStatusUri()));
        this.setVersion(mServer.getVersion());
        this.setAvailable(MetadataInstance.Condition.REACHABLE == mServer.getCondition());
        if (mServer != null) {
            Collection dataSources = mServer.getDataSources();
            this.setDataSourceSize(dataSources.size());
            this.setDataSourcesNames(dataSources);
            Collection dataSourceDrivers = mServer.getDataSourceDrivers();
            this.setDataSourceDriverSize(dataSourceDrivers.size());
            if (dataSourceDrivers == null || dataSourceDrivers.isEmpty()) {
                this.sourceDrivers = Collections.emptyList();
            } else {
                this.sourceDrivers = new ArrayList();
                for (ConnectionDriver driver : dataSourceDrivers) {
                    this.sourceDrivers.add(new RestConnectionDriver(driver));
                }
            }
            Collection translators = mServer.getTranslators();
            this.setTranslatorSize(translators.size());
            this.setTranslatorNames(translators);
            try {
                Collection vdbs = mServer.getVdbs();
                this.setVdbSize(vdbs.size());
                this.setVdbNames(vdbs);
            }
            catch (Exception e) {
                throw new KException((Throwable)e);
            }
        }
    }

    public String getVersion() {
        Object versionObj = this.tuples.get(VERSION_LABEL);
        return versionObj != null ? versionObj.toString() : null;
    }

    protected void setVersion(MetadataVersion version) {
        this.tuples.put(VERSION_LABEL, version.toString());
    }

    public boolean isAvailable() {
        Object hasServer = this.tuples.get(AVAILABLE_LABEL);
        return hasServer != null ? Boolean.parseBoolean(hasServer.toString()) : false;
    }

    protected void setAvailable(boolean hasServer) {
        this.tuples.put(AVAILABLE_LABEL, hasServer);
    }

    public int getDataSourceSize() {
        Object size = this.tuples.get(DATA_SOURCE_SIZE_LABEL);
        return size != null ? Integer.parseInt(size.toString()) : 0;
    }

    protected void setDataSourceSize(int size) {
        this.tuples.put(DATA_SOURCE_SIZE_LABEL, size);
    }

    public String[] getDataSourceNames() {
        Object names = this.tuples.get(DATA_SOURCE_NAMES_LABEL);
        return names != null ? (String[])names : EMPTY_ARRAY;
    }

    protected void setDataSourcesNames(Collection<TeiidDataSource> dataSources) {
        ArrayList<String> names = new ArrayList<String>(dataSources.size());
        for (TeiidDataSource source : dataSources) {
            names.add(source.getName());
        }
        this.tuples.put(DATA_SOURCE_NAMES_LABEL, names.toArray(new String[0]));
    }

    public int getDataSourceDriverSize() {
        Object size = this.tuples.get(DATA_SOURCE_DRIVER_SIZE_LABEL);
        return size != null ? Integer.parseInt(size.toString()) : 0;
    }

    protected void setDataSourceDriverSize(int size) {
        this.tuples.put(DATA_SOURCE_DRIVER_SIZE_LABEL, size);
    }

    public List<RestConnectionDriver> getDataSourceDrivers() {
        return this.sourceDrivers;
    }

    public void setDataSourceDrivers(RestConnectionDriver[] dataSourceDrivers) {
        if (dataSourceDrivers == null || dataSourceDrivers.length == 0) {
            this.sourceDrivers = Collections.emptyList();
        }
        this.sourceDrivers = new ArrayList();
        for (RestConnectionDriver driver : this.sourceDrivers) {
            this.sourceDrivers.add(driver);
        }
    }

    public int getTranslatorSize() {
        Object size = this.tuples.get(TRANSLATOR_SIZE_LABEL);
        return size != null ? Integer.parseInt(size.toString()) : 0;
    }

    protected void setTranslatorSize(int size) {
        this.tuples.put(TRANSLATOR_SIZE_LABEL, size);
    }

    public String[] getTranslatorNames() {
        Object names = this.tuples.get(TRANSLATOR_NAMES_LABEL);
        return names != null ? (String[])names : EMPTY_ARRAY;
    }

    protected void setTranslatorNames(Collection<TeiidTranslator> translators) {
        ArrayList<String> names = new ArrayList<String>(translators.size());
        for (TeiidTranslator tr : translators) {
            names.add(tr.getName());
        }
        this.tuples.put(TRANSLATOR_NAMES_LABEL, names.toArray(new String[0]));
    }

    public int getVdbSize() {
        Object size = this.tuples.get(VDB_SIZE_LABEL);
        return size != null ? Integer.parseInt(size.toString()) : 0;
    }

    protected void setVdbSize(int size) {
        this.tuples.put(VDB_SIZE_LABEL, size);
    }

    public String[] getVdbNames() {
        Object names = this.tuples.get(VDB_NAMES_LABEL);
        return names != null ? (String[])names : EMPTY_ARRAY;
    }

    protected void setVdbNames(Collection<TeiidVdb> vdbs) {
        ArrayList<String> names = new ArrayList<String>(vdbs.size());
        for (TeiidVdb vdb : vdbs) {
            names.add(vdb.getName());
        }
        this.tuples.put(VDB_NAMES_LABEL, names.toArray(new String[0]));
    }
}

