/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational.response.metadata;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.komodo.relational.template.Template;
import org.komodo.relational.template.TemplateEntry;
import org.komodo.rest.RestBasicEntity;
import org.komodo.rest.RestLink;
import org.komodo.rest.relational.KomodoRestUriBuilder;
import org.komodo.spi.KException;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.ArgCheck;

public final class RestMetadataTemplate
extends RestBasicEntity {
    public static final String IS_JDBC_LABEL = "isJdbc";
    public static final String ENTRIES_LABEL = "entries";
    public static final RestMetadataTemplate[] NO_TEMPLATES = new RestMetadataTemplate[0];
    private List<String> entries = Collections.emptyList();

    public RestMetadataTemplate() {
    }

    public RestMetadataTemplate(URI baseUri, Template template, Repository.UnitOfWork uow) throws KException {
        super(baseUri);
        ArgCheck.isNotNull((Object)template, (String)"template");
        ArgCheck.isNotNull((Object)uow, (String)"uow");
        this.setId(template.getName(uow));
        this.setkType(template.getTypeIdentifier(uow));
        this.setHasChildren(template.hasChildren(uow));
        this.setJdbc(template.isJdbc(uow));
        Properties settings = this.getUriBuilder().createSettings(KomodoRestUriBuilder.SettingNames.TEMPLATE_NAME, this.getId());
        URI parentUri = this.getUriBuilder().mServerTemplatesUri();
        this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.PARENT_PATH, parentUri);
        List templateEntries = template.getEntries(uow, new String[0]);
        if (templateEntries != null) {
            this.entries = new ArrayList();
            for (TemplateEntry entry : templateEntries) {
                this.entries.add(entry.getName(uow));
            }
        }
        this.addLink(new RestLink(RestLink.LinkType.SELF, this.getUriBuilder().templateUri(RestLink.LinkType.SELF, settings)));
        this.addLink(new RestLink(RestLink.LinkType.PARENT, this.getUriBuilder().templateUri(RestLink.LinkType.PARENT, settings)));
        this.addLink(new RestLink(RestLink.LinkType.TEMPLATE_ENTRIES, this.getUriBuilder().templateUri(RestLink.LinkType.TEMPLATE_ENTRIES, settings)));
    }

    public boolean isJdbc() {
        Object value = this.tuples.get(IS_JDBC_LABEL);
        return value != null ? Boolean.parseBoolean(value.toString()) : false;
    }

    public void setJdbc(boolean jdbc) {
        this.tuples.put(IS_JDBC_LABEL, jdbc);
    }

    public List<String> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public void setEntries(String[] entriesNames) {
        this.entries = entriesNames == null ? Collections.emptyList() : Arrays.asList(entriesNames);
    }
}

