/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational.response.metadata;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.komodo.relational.template.Template;
import org.komodo.relational.template.TemplateEntry;
import org.komodo.rest.RestBasicEntity;
import org.komodo.rest.RestLink;
import org.komodo.rest.relational.KomodoRestUriBuilder;
import org.komodo.spi.KException;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.ArgCheck;

public final class RestMetadataTemplateEntry
extends RestBasicEntity {
    public static final String REQUIRED_LABEL = "required";
    public static final String MODIFIABLE_LABEL = "modifiable";
    public static final String MASKED_LABEL = "masked";
    public static final String CONSTRAINED_ALLOWED_VALUES_LABEL = "constrainedToAllowedValues";
    public static final String ADVANCED_LABEL = "advanced";
    public static final String TYPE_CLASS_NAME_LABEL = "typeClassName";
    public static final String DISPLAY_NAME_LABEL = "displayName";
    public static final String DESCRIPTION_LABEL = "description";
    public static final String DEFAULT_VALUE_LABEL = "defaultValue";
    public static final String CATEGORY_LABEL = "category";
    public static final String ALLOWED_VALUES_LABEL = "allowedValues";
    public static final String CUSTOM_PROPERTIES_LABEL = "customProperties";
    public static final RestMetadataTemplateEntry[] NO_ENTRIES = new RestMetadataTemplateEntry[0];
    @JsonProperty(value="customProperties")
    private Map<String, String> customProperties;

    public RestMetadataTemplateEntry() {
    }

    public RestMetadataTemplateEntry(URI baseUri, TemplateEntry templateEntry, Repository.UnitOfWork uow) throws KException {
        super(baseUri);
        ArgCheck.isNotNull((Object)templateEntry, (String)"templateEntry");
        ArgCheck.isNotNull((Object)uow, (String)"uow");
        this.setId(templateEntry.getName(uow));
        this.setkType(templateEntry.getTypeIdentifier(uow));
        this.setHasChildren(templateEntry.hasChildren(uow));
        this.setAllowedValues(templateEntry.getAllowedValues(uow));
        this.setCategory(templateEntry.getCategory(uow));
        this.setCustomProperties(templateEntry.getCustomProperties(uow));
        this.setDefaultValue(templateEntry.getDefaultValue(uow));
        this.setDescription(templateEntry.getDescription(uow));
        this.setDisplayName(templateEntry.getDisplayName(uow));
        this.setTypeClassName(templateEntry.getTypeClassName(uow));
        this.setAdvanced(templateEntry.isAdvanced(uow));
        this.setConstrainedToAllowedValues(templateEntry.isConstrainedToAllowedValues(uow));
        this.setMasked(templateEntry.isMasked(uow));
        this.setModifiable(templateEntry.isModifiable(uow));
        this.setRequired(templateEntry.isRequired(uow));
        Template template = (Template)this.ancestor((KomodoObject)templateEntry, Template.class, uow);
        ArgCheck.isNotNull((Object)template);
        String templateName = template.getName(uow);
        Properties settings = this.getUriBuilder().createSettings(KomodoRestUriBuilder.SettingNames.TEMPLATE_NAME, templateName);
        this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.TEMPLATE_NAME, templateName);
        this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.TEMPLATE_ENTRY_NAME, this.getId());
        this.addLink(new RestLink(RestLink.LinkType.SELF, this.getUriBuilder().templateEntryUri(RestLink.LinkType.SELF, settings)));
        this.addLink(new RestLink(RestLink.LinkType.PARENT, this.getUriBuilder().templateEntryUri(RestLink.LinkType.PARENT, settings)));
    }

    public boolean isRequired() {
        Object value = this.tuples.get(REQUIRED_LABEL);
        return value != null ? Boolean.parseBoolean(value.toString()) : false;
    }

    public void setRequired(boolean required) {
        this.tuples.put(REQUIRED_LABEL, required);
    }

    public boolean isModifiable() {
        Object value = this.tuples.get(MODIFIABLE_LABEL);
        return value != null ? Boolean.parseBoolean(value.toString()) : false;
    }

    public void setModifiable(boolean modifiable) {
        this.tuples.put(MODIFIABLE_LABEL, modifiable);
    }

    public boolean isMasked() {
        Object value = this.tuples.get(MASKED_LABEL);
        return value != null ? Boolean.parseBoolean(value.toString()) : false;
    }

    public void setMasked(boolean masked) {
        this.tuples.put(MASKED_LABEL, masked);
    }

    public boolean isConstrainedToAllowedValues() {
        Object value = this.tuples.get(CONSTRAINED_ALLOWED_VALUES_LABEL);
        return value != null ? Boolean.parseBoolean(value.toString()) : false;
    }

    public void setConstrainedToAllowedValues(boolean constrainedToAllowedValues) {
        this.tuples.put(CONSTRAINED_ALLOWED_VALUES_LABEL, constrainedToAllowedValues);
    }

    public boolean isAdvanced() {
        Object value = this.tuples.get(ADVANCED_LABEL);
        return value != null ? Boolean.parseBoolean(value.toString()) : false;
    }

    public void setAdvanced(boolean advanced) {
        this.tuples.put(ADVANCED_LABEL, advanced);
    }

    public String getTypeClassName() {
        Object value = this.tuples.get(TYPE_CLASS_NAME_LABEL);
        return value != null ? value.toString() : null;
    }

    public void setTypeClassName(String typeClassName) {
        this.tuples.put(TYPE_CLASS_NAME_LABEL, typeClassName);
    }

    public String getDisplayName() {
        Object value = this.tuples.get(DISPLAY_NAME_LABEL);
        return value != null ? value.toString() : null;
    }

    public void setDisplayName(String displayName) {
        this.tuples.put(DISPLAY_NAME_LABEL, displayName);
    }

    public String getDescription() {
        Object value = this.tuples.get(DESCRIPTION_LABEL);
        return value != null ? value.toString() : null;
    }

    public void setDescription(String description) {
        this.tuples.put(DESCRIPTION_LABEL, description);
    }

    public Object getDefaultValue() {
        Object value = this.tuples.get(DEFAULT_VALUE_LABEL);
        return value != null ? value : null;
    }

    public void setDefaultValue(Object defaultValue) {
        this.tuples.put(DEFAULT_VALUE_LABEL, defaultValue);
    }

    public Map<String, String> getCustomProperties() {
        if (this.customProperties == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.customProperties);
    }

    public void setCustomProperties(Properties customProperties) {
        if (this.customProperties == null) {
            this.customProperties = new HashMap();
        }
        if (customProperties != null) {
            for (Object keyObj : customProperties.keySet()) {
                String key = keyObj.toString();
                this.customProperties.put(key, customProperties.getProperty(key));
            }
        }
    }

    public String getCategory() {
        Object value = this.tuples.get(CATEGORY_LABEL);
        return value != null ? value.toString() : null;
    }

    public void setCategory(String category) {
        this.tuples.put(CATEGORY_LABEL, category);
    }

    public Object[] getAllowedValues() {
        Object[] values = (Object[])this.tuples.get(ALLOWED_VALUES_LABEL);
        return values != null ? values : null;
    }

    public <T> void setAllowedValues(Collection<T> allowedValues) {
        if (allowedValues == null || allowedValues.isEmpty()) {
            return;
        }
        this.tuples.put(ALLOWED_VALUES_LABEL, allowedValues.toArray(new Object[0]));
    }
}

