/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational.response.metadata;

import java.net.URI;
import java.util.Properties;
import org.komodo.relational.vdb.Vdb;
import org.komodo.rest.RestLink;
import org.komodo.rest.relational.KomodoRestUriBuilder;
import org.komodo.rest.relational.response.RestVdb;
import org.komodo.spi.KException;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;

public final class RestMetadataVdb
extends RestVdb {
    public RestMetadataVdb() {
    }

    public RestMetadataVdb(URI baseUri, Vdb vdb, Repository.UnitOfWork uow, boolean exportXml) throws KException {
        super(baseUri);
        this.setId(vdb.getName(uow));
        this.setkType(vdb.getTypeIdentifier(uow));
        this.setHasChildren(vdb.hasChildren(uow));
        this.setName(vdb.getName(uow));
        this.setDescription(vdb.getDescription(uow));
        this.setPreview(vdb.isPreview(uow));
        this.setConnectionType(vdb.getConnectionType(uow));
        this.setVersion(vdb.getVersion(uow));
        this.addExecutionProperties(uow, (KomodoObject)vdb);
        if (exportXml) {
            byte[] xmlBytes = vdb.export(uow, new Properties());
            this.setXml(new String(xmlBytes));
        }
        Properties settings = this.getUriBuilder().createSettings(KomodoRestUriBuilder.SettingNames.VDB_NAME, this.getId());
        URI parentUri = this.getUriBuilder().mServerVdbsUri();
        this.getUriBuilder().addSetting(settings, KomodoRestUriBuilder.SettingNames.VDB_PARENT_PATH, parentUri);
        this.addLink(new RestLink(RestLink.LinkType.SELF, this.getUriBuilder().vdbUri(RestLink.LinkType.SELF, settings)));
        this.addLink(new RestLink(RestLink.LinkType.PARENT, this.getUriBuilder().vdbUri(RestLink.LinkType.PARENT, settings)));
        this.addLink(new RestLink(RestLink.LinkType.IMPORTS, this.getUriBuilder().vdbUri(RestLink.LinkType.IMPORTS, settings)));
        this.addLink(new RestLink(RestLink.LinkType.MODELS, this.getUriBuilder().vdbUri(RestLink.LinkType.MODELS, settings)));
        this.addLink(new RestLink(RestLink.LinkType.TRANSLATORS, this.getUriBuilder().vdbUri(RestLink.LinkType.TRANSLATORS, settings)));
        this.addLink(new RestLink(RestLink.LinkType.DATA_ROLES, this.getUriBuilder().vdbUri(RestLink.LinkType.DATA_ROLES, settings)));
    }
}

