/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.relational.response.metadata;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.komodo.rest.KRestEntity;
import org.komodo.spi.runtime.TeiidVdb;

@JsonSerialize
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RestMetadataVdbStatusVdb
implements KRestEntity {
    public static final String VDB_STATUS_NAME = "name";
    public static final String VDB_STATUS_DEPLOYED_NAME = "deployedName";
    public static final String VDB_STATUS_VERSION = "version";
    public static final String VDB_STATUS_ACTIVE = "active";
    public static final String VDB_STATUS_LOADING = "loading";
    public static final String VDB_STATUS_FAILED = "failed";
    public static final String VDB_STATUS_ERROR = "errors";
    private String name;
    private String deployedName;
    private String version;
    private boolean active;
    private boolean failed;
    private boolean loading;
    private List<String> errors;

    public RestMetadataVdbStatusVdb() {
    }

    public RestMetadataVdbStatusVdb(TeiidVdb vdb) {
        this.name = vdb.getName();
        this.deployedName = vdb.getDeployedName();
        this.version = vdb.getVersion();
        this.active = vdb.isActive();
        this.failed = vdb.hasFailed();
        this.loading = vdb.isLoading();
        this.errors = vdb.getValidityErrors();
    }

    public boolean supports(MediaType mediaType) {
        return MediaType.APPLICATION_JSON_TYPE.equals((Object)mediaType);
    }

    public Object getXml() {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDeployedName() {
        return this.deployedName;
    }

    public void setDeployedName(String deployedName) {
        this.deployedName = deployedName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void setFailed(boolean failed) {
        this.failed = failed;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void setLoading(boolean loading) {
        this.loading = loading;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.active ? 1231 : 1237);
        result = 31 * result + (this.deployedName == null ? 0 : this.deployedName.hashCode());
        result = 31 * result + (this.errors == null ? 0 : this.errors.hashCode());
        result = 31 * result + (this.failed ? 1231 : 1237);
        result = 31 * result + (this.loading ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RestMetadataVdbStatusVdb other = (RestMetadataVdbStatusVdb)obj;
        if (this.active != other.active) {
            return false;
        }
        if (this.deployedName == null ? other.deployedName != null : !this.deployedName.equals(other.deployedName)) {
            return false;
        }
        if (this.errors == null ? other.errors != null : !this.errors.equals(other.errors)) {
            return false;
        }
        if (this.failed != other.failed) {
            return false;
        }
        if (this.loading != other.loading) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.version == other.version;
    }

    public String toString() {
        return "RestTeiidVdbStatusProps [name=" + this.name + ", deployedName=" + this.deployedName + ", version=" + this.version + ", active=" + this.active + ", failed=" + this.failed + ", loading=" + this.loading + ", errors=" + this.errors + "]";
    }
}

