/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.schema.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.sun.xml.xsom.XSAnnotation;
import com.sun.xml.xsom.XSAttGroupDecl;
import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSAttributeUse;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSContentType;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSFacet;
import com.sun.xml.xsom.XSIdentityConstraint;
import com.sun.xml.xsom.XSModelGroup;
import com.sun.xml.xsom.XSModelGroupDecl;
import com.sun.xml.xsom.XSNotation;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSRestrictionSimpleType;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSTerm;
import com.sun.xml.xsom.XSType;
import com.sun.xml.xsom.XSWildcard;
import com.sun.xml.xsom.XSXPath;
import com.sun.xml.xsom.parser.AnnotationParserFactory;
import com.sun.xml.xsom.parser.XSOMParser;
import com.sun.xml.xsom.visitor.XSVisitor;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.xml.parsers.SAXParserFactory;
import org.komodo.rest.json.JsonConstants;
import org.komodo.rest.schema.json.TeiidXsdReader;
import org.komodo.rest.schema.json.XsdAnnotationFactory;
import org.komodo.spi.repository.KomodoType;
import org.komodo.spi.utils.KeyInValueMap;
import org.komodo.utils.StringUtils;

public class TeiidXsdReader
implements XSVisitor,
JsonConstants {
    private static final String SCHEMA = "schema-";
    private static final String TEIID_VDB_XSD = "teiid-vdb.xsd";
    private static final String SUGGESTED = "suggested";
    private static final String XSD_PROPERTY = "property";
    private ObjectMapper mapper;
    private ObjectNode rootNode;
    private ObjectNode parentCtx;
    private ObjectNode schemaCtx;
    private static KeyInValueMap<String, AliasMapper> ALIAS_CACHE = new KeyInValueMap((KeyInValueMap.KeyFromValueAdapter)new AliasMapperAdapter(null));

    private String toLowerCamelCase(String value) {
        StringBuffer sb = new StringBuffer();
        String[] values = value.split("-");
        for (int i = 0; i < values.length; ++i) {
            String s = values[i];
            if (i == 0) {
                sb.append(s.toLowerCase());
                continue;
            }
            sb.append(Character.toUpperCase(s.charAt(0)));
            if (s.length() <= 1) continue;
            sb.append(s.substring(1, s.length()).toLowerCase());
        }
        return sb.toString();
    }

    private String convertPropertyName(String xsdName) {
        if (xsdName == null) {
            return xsdName;
        }
        xsdName = this.toLowerCamelCase(xsdName);
        JsonNode parentIdNode = this.parentCtx.get("keng__id");
        if (parentIdNode == null) {
            return xsdName;
        }
        String id = parentIdNode.asText();
        AliasMapper aliasMapper = (AliasMapper)ALIAS_CACHE.get((Object)id);
        if (aliasMapper == null) {
            return xsdName;
        }
        return aliasMapper.getKName(xsdName);
    }

    public void wildcard(XSWildcard wc) {
    }

    public void modelGroupDecl(XSModelGroupDecl decl) {
    }

    public void empty(XSContentType empty) {
    }

    public void annotation(XSAnnotation ann) {
        if (ann == null) {
            return;
        }
        Object annoObj = ann.getAnnotation();
        if (annoObj == null) {
            return;
        }
        String description = annoObj.toString();
        description = description.replaceAll("[\\s]+", " ");
        this.parentCtx.put("keng__description", description);
    }

    public void attGroupDecl(XSAttGroupDecl decl) {
    }

    public void facet(XSFacet facet) {
    }

    public void notation(XSNotation notation) {
    }

    public void identityConstraint(XSIdentityConstraint decl) {
    }

    public void xpath(XSXPath xp) {
    }

    private String checkSuggestedPrefix(String name) {
        if (name.startsWith(SUGGESTED)) {
            name = name.substring(SUGGESTED.length()).toLowerCase();
        }
        return name;
    }

    public void attributeDecl(XSAttributeDecl decl) {
        ObjectNode parent = this.parentCtx;
        ObjectNode propertiesCtx = this.parentCtx.with("keng__properties");
        String attributeName = this.convertPropertyName(decl.getName());
        attributeName = this.checkSuggestedPrefix(attributeName);
        ObjectNode attrNode = propertiesCtx.with(attributeName);
        if (decl.getDefaultValue() != null) {
            attrNode.put("keng__defaultValue", decl.getDefaultValue().value);
        }
        this.parentCtx = attrNode;
        decl.getType().visit((XSVisitor)this);
        this.parentCtx = attrNode;
        this.annotation(decl.getAnnotation());
        this.parentCtx = parent;
    }

    public void attributeUse(XSAttributeUse use) {
        XSAttributeDecl attributeDecl = use.getDecl();
        attributeDecl.visit((XSVisitor)this);
        ObjectNode propertiesCtx = this.parentCtx.with("keng__properties");
        String name = this.convertPropertyName(attributeDecl.getName());
        name = this.checkSuggestedPrefix(name);
        ObjectNode attrNode = propertiesCtx.with(name);
        attrNode.put("keng__required", Boolean.toString(use.isRequired()));
    }

    public void simpleType(XSSimpleType simpleType) {
        if (simpleType.isRestriction()) {
            XSRestrictionSimpleType restriction = simpleType.asRestriction();
            this.parentCtx.put("keng__type", restriction.getPrimitiveType().getName());
            for (XSFacet facet : restriction.getDeclaredFacets()) {
                if (!facet.getName().equals("enumeration")) continue;
                ArrayNode values = this.parentCtx.withArray("keng__values");
                if (values.size() == 0) {
                    values.add(facet.getValue().toString());
                    continue;
                }
                ArrayList<String> valList = new ArrayList<String>();
                valList.add(facet.getValue().toString());
                Iterator iterator = values.elements();
                while (iterator.hasNext()) {
                    String value = ((JsonNode)iterator.next()).asText();
                    valList.add(value);
                }
                values.removeAll();
                Collections.sort(valList);
                for (String value : valList) {
                    values.add(value);
                }
            }
        } else {
            this.parentCtx.put("keng__type", simpleType.getName());
        }
    }

    public void modelGroup(XSModelGroup group) {
        XSParticle[] particles = group.getChildren();
        if (particles.length == 0) {
            return;
        }
        ObjectNode parent = this.parentCtx;
        for (XSParticle p : particles) {
            this.parentCtx = parent;
            p.visit((XSVisitor)this);
        }
        this.parentCtx = parent;
    }

    public void particle(XSParticle particle) {
        XSTerm term = particle.getTerm();
        term.visit((XSVisitor)this);
        this.parentCtx.put("keng__required", Boolean.toString(particle.getMinOccurs().compareTo(BigInteger.ZERO) > 0));
        this.parentCtx.put("keng__repeatable", Boolean.toString(particle.isRepeated()));
        if (particle.isRepeated()) {
            this.parentCtx.put("keng__limit", particle.getMaxOccurs().toString());
        }
    }

    public void complexType(XSComplexType complexType) {
        Iterator attrUses = complexType.getAttributeUses().iterator();
        while (attrUses.hasNext()) {
            ((XSAttributeUse)attrUses.next()).visit((XSVisitor)this);
        }
        complexType.getContentType().visit((XSVisitor)this);
    }

    public void elementDecl(XSElementDecl decl) {
        ObjectNode parent = this.parentCtx;
        XSType type = decl.getType();
        String typeName = type.getName();
        if (type.isLocal() || typeName == null) {
            typeName = decl.getName();
        }
        typeName = this.toLowerCamelCase(typeName);
        ObjectNode elementNode = null;
        if (type.getBaseType().getName().equals(XSD_PROPERTY)) {
            ObjectNode propertiesCtx = this.parentCtx.with("keng__properties");
            this.parentCtx = elementNode = propertiesCtx.with(XSD_PROPERTY);
        } else if (type.isComplexType()) {
            elementNode = this.parentCtx.objectNode();
            this.schemaCtx.set(typeName, (JsonNode)elementNode);
            this.parentCtx = elementNode;
            elementNode.put("keng__id", this.toLowerCamelCase(decl.getName()));
            KomodoType kType = KomodoType.getKomodoType((String)typeName);
            elementNode.put("keng__kType", kType.getType());
            if (parent != this.schemaCtx) {
                ArrayNode children = parent.withArray("keng__children");
                children.add(typeName);
            }
        } else if (type.isSimpleType()) {
            ObjectNode propertiesCtx = this.parentCtx.with("keng__properties");
            String name = this.convertPropertyName(decl.getName());
            this.parentCtx = elementNode = propertiesCtx.with(name);
        }
        this.annotation(decl.getAnnotation());
        decl.getType().visit((XSVisitor)this);
        if (decl.getDefaultValue() != null) {
            elementNode.put("keng__defaultValue", decl.getDefaultValue().value);
        }
    }

    public void schema(XSSchema schema) {
        if (schema.getElementDecls().size() == 0) {
            return;
        }
        this.schemaCtx = this.parentCtx.objectNode();
        Iterator iterator = schema.iterateElementDecls();
        while (iterator.hasNext()) {
            XSElementDecl element = (XSElementDecl)iterator.next();
            this.parentCtx = this.schemaCtx;
            element.visit((XSVisitor)this);
        }
        this.parentCtx = this.schemaCtx;
    }

    private String writeNode(JsonNode node) throws JsonProcessingException {
        return this.getMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)node);
    }

    private ObjectMapper getMapper() {
        if (this.mapper == null) {
            this.mapper = new ObjectMapper();
            this.mapper.enable(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY});
            this.mapper.enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);
        }
        return this.mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String read() throws Exception {
        XSOMParser parser = new XSOMParser(SAXParserFactory.newInstance());
        parser.setAnnotationParser((AnnotationParserFactory)new XsdAnnotationFactory());
        InputStream stream = this.getClass().getResourceAsStream(TEIID_VDB_XSD);
        if (stream == null) {
            throw new FileNotFoundException();
        }
        try {
            parser.parse(stream);
            XSSchemaSet schemaSet = parser.getResult();
            Collection schemas = schemaSet.getSchemas();
            this.rootNode = this.getMapper().createObjectNode();
            Iterator iterator = schemas.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                XSSchema schema = (XSSchema)iterator.next();
                this.parentCtx = this.rootNode;
                schema.visit((XSVisitor)this);
                if (this.parentCtx != this.rootNode) {
                    this.rootNode.set(SCHEMA + i, (JsonNode)this.parentCtx);
                }
                ++i;
            }
            String string = this.writeNode((JsonNode)this.rootNode);
            return string;
        }
        finally {
            stream.close();
        }
    }

    private String schemaByKType(JsonNode node, KomodoType kType) throws Exception {
        String kValue;
        KomodoType nodeKType;
        if (node == null) {
            throw new IllegalStateException("Programming error. read() should be called prior to this method");
        }
        JsonNode jsonNode = node.get("keng__kType");
        if (jsonNode != null && kType.equals((Object)(nodeKType = KomodoType.getKomodoType((String)(kValue = jsonNode.asText()))))) {
            return this.writeNode(node);
        }
        Iterator elements = node.elements();
        while (elements.hasNext()) {
            JsonNode element = (JsonNode)elements.next();
            String schema = this.schemaByKType(element, kType);
            if ("".equals(schema)) continue;
            return schema;
        }
        return "";
    }

    public String schemaByKType(KomodoType kType) throws Exception {
        if (this.rootNode == null) {
            this.read();
        }
        return this.schemaByKType((JsonNode)this.rootNode, kType);
    }

    public static void main(String[] args) throws Exception {
        TeiidXsdReader reader = new TeiidXsdReader();
        System.out.println(reader.read());
        System.out.println();
        System.out.println();
        System.out.println(reader.schemaByKType(KomodoType.MODEL));
        System.out.println();
        System.out.println();
        System.out.println(reader.schemaByKType(KomodoType.VDB_DATA_ROLE));
        Object[] values = new String[]{KomodoType.VDB.getType(), KomodoType.VDB_IMPORT.getType(), KomodoType.VDB_TRANSLATOR.getType(), KomodoType.MODEL.getType(), KomodoType.VDB_MODEL_SOURCE.getType(), KomodoType.VDB_DATA_ROLE.getType(), KomodoType.VDB_PERMISSION.getType(), KomodoType.VDB_CONDITION.getType(), KomodoType.VDB_MASK.getType()};
        System.out.println(StringUtils.toCommaSeparatedList((Object[])values));
    }

    static {
        AliasMapper vdbMapper = new AliasMapper("vdb");
        vdbMapper.add("name", Namespaces.VDB);
        vdbMapper.add("description", Namespaces.VDB);
        vdbMapper.add("version", Namespaces.VDB);
        vdbMapper.add("connectionType", Namespaces.VDB);
        ALIAS_CACHE.add((Object)vdbMapper);
        AliasMapper modelMapper = new AliasMapper("model");
        modelMapper.add("description", Namespaces.VDB);
        modelMapper.add("visible", Namespaces.VDB);
        modelMapper.add("path", Namespaces.VDB, "pathInVdb");
        modelMapper.add("type", Namespaces.MMCORE, "modelType");
        ALIAS_CACHE.add((Object)modelMapper);
        AliasMapper sourceMapper = new AliasMapper("source");
        sourceMapper.add("translatorName", Namespaces.VDB, "sourceTranslator");
        sourceMapper.add("connectionJndiName", Namespaces.VDB, "sourceJndiName");
        ALIAS_CACHE.add((Object)sourceMapper);
        AliasMapper translatorMapper = new AliasMapper("translator");
        translatorMapper.add("description", Namespaces.VDB);
        translatorMapper.add("type", Namespaces.VDB);
        ALIAS_CACHE.add((Object)translatorMapper);
        AliasMapper dataRoleMapper = new AliasMapper("dataRole");
        dataRoleMapper.add("description", Namespaces.VDB);
        dataRoleMapper.add("anyAuthenticated", Namespaces.VDB);
        dataRoleMapper.add("allowCreateTemporaryTables", Namespaces.VDB);
        dataRoleMapper.add("grantAll", Namespaces.VDB);
        dataRoleMapper.add("mappedRoleName", Namespaces.VDB, "mappedRolesNames");
        ALIAS_CACHE.add((Object)dataRoleMapper);
        AliasMapper permissionMapper = new AliasMapper("permission");
        permissionMapper.add("resourceName", Namespaces.VDB);
        permissionMapper.add("allowCreate", Namespaces.VDB);
        permissionMapper.add("allowRead", Namespaces.VDB);
        permissionMapper.add("allowUpdate", Namespaces.VDB);
        permissionMapper.add("allowDelete", Namespaces.VDB);
        permissionMapper.add("allowExecute", Namespaces.VDB);
        permissionMapper.add("allowAlter", Namespaces.VDB);
        permissionMapper.add("allowLanguage", Namespaces.VDB);
        permissionMapper.add("allowExecute", Namespaces.VDB);
        ALIAS_CACHE.add((Object)permissionMapper);
        AliasMapper conditionMapper = new AliasMapper("condition");
        conditionMapper.add("constraint", Namespaces.VDB);
        ALIAS_CACHE.add((Object)conditionMapper);
        AliasMapper maskMapper = new AliasMapper("mask");
        maskMapper.add("order", Namespaces.VDB);
        ALIAS_CACHE.add((Object)maskMapper);
        AliasMapper entryMapper = new AliasMapper("entry");
        entryMapper.add("description", Namespaces.VDB);
        entryMapper.add("path", Namespaces.VDB);
        ALIAS_CACHE.add((Object)entryMapper);
        AliasMapper importVdbMapper = new AliasMapper("importVdb");
        importVdbMapper.add("version", Namespaces.VDB);
        importVdbMapper.add("importDataPolicies", Namespaces.VDB);
        ALIAS_CACHE.add((Object)importVdbMapper);
    }
}

