/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.service;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.komodo.core.KEngine;
import org.komodo.core.repository.ObjectImpl;
import org.komodo.relational.connection.Connection;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.rest.KRestEntity;
import org.komodo.rest.KomodoRestException;
import org.komodo.rest.KomodoService;
import org.komodo.rest.relational.KomodoProperties;
import org.komodo.rest.relational.RelationalMessages;
import org.komodo.rest.relational.connection.RestConnection;
import org.komodo.rest.relational.json.KomodoJsonMarshaller;
import org.komodo.rest.relational.request.KomodoConnectionAttributes;
import org.komodo.rest.relational.response.KomodoStatusObject;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.StringUtils;

@Path(value="workspace/connections")
@Api(tags={"connections"})
public final class KomodoConnectionService
extends KomodoService {
    private static final int ALL_AVAILABLE = -1;

    public KomodoConnectionService(KEngine engine) throws WebApplicationException {
        super(engine);
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Return the collection of connections", response=RestConnection[].class)
    @ApiResponses(value={@ApiResponse(code=403, message="An error has occurred.")})
    public Response getConnections(@Context HttpHeaders headers, @Context UriInfo uriInfo) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            String searchPattern = (String)uriInfo.getQueryParameters().getFirst((Object)"pattern");
            uow = this.createTransaction(principal, "getConnections", true);
            Connection[] connections = null;
            if (StringUtils.isBlank((String)searchPattern)) {
                connections = this.getWorkspaceManager(uow).findConnections(uow);
                LOGGER.debug("getConnections:found '{0}' Connections", new Object[]{connections.length});
            } else {
                String[] connectionPaths = this.getWorkspaceManager(uow).findByType(uow, "dv:connection", null, searchPattern, false);
                if (connectionPaths.length == 0) {
                    connections = Connection.NO_CONNECTIONS;
                } else {
                    connections = new Connection[connectionPaths.length];
                    int i = 0;
                    for (String path : connectionPaths) {
                        connections[i++] = (Connection)this.getWorkspaceManager(uow).resolve(uow, (Object)new ObjectImpl(this.getWorkspaceManager(uow).getRepository(), path, 0), Connection.class);
                    }
                    LOGGER.debug("getConnections:found '{0}' Connections using pattern '{1}'", new Object[]{connections.length, searchPattern});
                }
            }
            int start = 0;
            String qparam = (String)uriInfo.getQueryParameters().getFirst((Object)"start");
            if (qparam != null) {
                try {
                    start = Integer.parseInt(qparam);
                    if (start < 0) {
                        start = 0;
                    }
                }
                catch (Exception e) {
                    start = 0;
                }
            }
            int size = -1;
            String qparam2 = (String)uriInfo.getQueryParameters().getFirst((Object)"size");
            if (qparam2 != null) {
                try {
                    size = Integer.parseInt(qparam2);
                    if (size <= 0) {
                        size = -1;
                    }
                }
                catch (Exception e) {
                    size = -1;
                }
            }
            ArrayList<RestConnection> entities = new ArrayList<RestConnection>();
            int i = 0;
            KomodoProperties properties = new KomodoProperties();
            for (Connection connection : connections) {
                if (start == 0 || i >= start) {
                    if (size != -1 && entities.size() >= size) break;
                    RestConnection entity = (RestConnection)this.entityFactory.create((KomodoObject)connection, uriInfo.getBaseUri(), uow, properties);
                    entities.add(entity);
                    LOGGER.debug("getConnections:Connection '{0}' entity was constructed", new Object[]{connection.getName(uow)});
                }
                ++i;
            }
            return this.commit(uow, mediaTypes, entities);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.CONNECTION_SERVICE_GET_CONNECTIONS_ERROR, new Object[0]);
        }
    }

    @GET
    @Path(value="{connectionName}")
    @Produces(value={"application/json", "application/xml"})
    @ApiOperation(value="Find connection by name", response=RestConnection.class)
    @ApiResponses(value={@ApiResponse(code=404, message="No Connection could be found with name"), @ApiResponse(code=406, message="Only JSON or XML is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response getConnection(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the connection", required=true) @PathParam(value="connectionName") String connectionName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "getConnection", true);
            Connection connection = this.findConnection(uow, connectionName);
            if (connection == null) {
                return this.commitNoConnectionFound(uow, mediaTypes, connectionName);
            }
            KomodoProperties properties = new KomodoProperties();
            RestConnection restConnection = (RestConnection)this.entityFactory.create((KomodoObject)connection, uriInfo.getBaseUri(), uow, properties);
            LOGGER.debug("getConnection:Connection '{0}' entity was constructed", new Object[]{connection.getName(uow)});
            return this.commit(uow, mediaTypes, (KRestEntity)restConnection);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.CONNECTION_SERVICE_GET_CONNECTION_ERROR, new Object[]{connectionName});
        }
    }

    @POST
    @Path(value="/{connectionName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a connection in the workspace")
    @ApiResponses(value={@ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response createConnection(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the connection", required=true) @PathParam(value="connectionName") String connectionName, @ApiParam(value="JSON of the properties of the new connection:<br><pre>{<br>&nbsp;driverName: \"name of the driver, eg. mysql\",<br>&nbsp;jndiName: \"the jndi name of the connection\",<br>&nbsp;jdbc: \"true if jdbc, otherwise false\"<br>&nbsp;parameters: {<br>&nbsp;&nbsp;property1...n: \"key/value pairs of properties applicable to connection<br>&nbsp;}<br>}</pre>", required=true) String connectionJson) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        if (StringUtils.isBlank((String)connectionName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.CONNECTION_SERVICE_CREATE_MISSING_NAME, new Object[0]);
        }
        RestConnection restConnection = new RestConnection();
        restConnection.setId(connectionName);
        try {
            KomodoConnectionAttributes rcAttr = (KomodoConnectionAttributes)KomodoJsonMarshaller.unmarshall((String)connectionJson, KomodoConnectionAttributes.class);
            restConnection.setDriverName(rcAttr.getDriver());
            restConnection.setJndiName(rcAttr.getJndi());
            restConnection.setJdbc(rcAttr.isJdbc());
            for (Map.Entry entry : rcAttr.getParameters().entrySet()) {
                restConnection.addProperty((String)entry.getKey(), entry.getValue());
            }
        }
        catch (Exception ex) {
            throw new KomodoRestException((Throwable)ex);
        }
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "createConnection", false);
            if (this.getWorkspaceManager(uow).hasChild(uow, connectionName)) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.CONNECTION_SERVICE_CREATE_ALREADY_EXISTS, new Object[0]);
            }
            return this.doAddConnection(uow, uriInfo.getBaseUri(), mediaTypes, restConnection);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.CONNECTION_SERVICE_CREATE_CONNECTION_ERROR, new Object[]{connectionName});
        }
    }

    @POST
    @Path(value="/clone/{connectionName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Clone a connection in the workspace")
    @ApiResponses(value={@ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response cloneConnection(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the connection", required=true) @PathParam(value="connectionName") String connectionName, @ApiParam(value="The new name of the connection", required=true) String newConnectionName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        if (StringUtils.isBlank((String)connectionName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.CONNECTION_SERVICE_CLONE_MISSING_NAME, new Object[0]);
        }
        if (StringUtils.isBlank((String)newConnectionName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.CONNECTION_SERVICE_CLONE_MISSING_NEW_NAME, new Object[0]);
        }
        boolean namesMatch = connectionName.equals(newConnectionName);
        if (namesMatch) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.CONNECTION_SERVICE_CLONE_SAME_NAME_ERROR, new Object[]{newConnectionName});
        }
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "cloneConnection", false);
            if (this.getWorkspaceManager(uow).hasChild(uow, newConnectionName)) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.CONNECTION_SERVICE_CLONE_ALREADY_EXISTS, new Object[0]);
            }
            KomodoObject kobject = this.getWorkspaceManager(uow).getChild(uow, connectionName, "dv:connection");
            Connection oldConnection = (Connection)this.getWorkspaceManager(uow).resolve(uow, (Object)kobject, Connection.class);
            RestConnection oldEntity = (RestConnection)this.entityFactory.create((KomodoObject)oldConnection, uriInfo.getBaseUri(), uow);
            Connection connection = this.getWorkspaceManager(uow).createConnection(uow, null, newConnectionName);
            this.setProperties(uow, connection, oldEntity);
            RestConnection entity = (RestConnection)this.entityFactory.create((KomodoObject)connection, uriInfo.getBaseUri(), uow);
            Response response = this.commit(uow, mediaTypes, (KRestEntity)entity);
            return response;
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.CONNECTION_SERVICE_CLONE_CONNECTION_ERROR, new Object[0]);
        }
    }

    @PUT
    @Path(value="/{connectionName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Update a connection in the workspace")
    @ApiResponses(value={@ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response updateConnection(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the connection", required=true) @PathParam(value="connectionName") String connectionName, @ApiParam(value="JSON of the properties of the connection:<br><pre>{<br>&nbsp;driverName: \"name of the driver, eg. mysql\",<br>&nbsp;jndiName: \"the jndi name of the connection\",<br>&nbsp;jdbc: \"true if jdbc, otherwise false\"<br>&nbsp;parameters: {<br>&nbsp;&nbsp;property1...n: \"key/value pairs of properties applicable to connection<br>&nbsp;}<br>}</pre>", required=true) String connectionJson) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        if (StringUtils.isBlank((String)connectionName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.CONNECTION_SERVICE_UPDATE_MISSING_NAME, new Object[0]);
        }
        RestConnection restConnection = new RestConnection();
        restConnection.setId(connectionName);
        try {
            KomodoConnectionAttributes rcAttr = (KomodoConnectionAttributes)KomodoJsonMarshaller.unmarshall((String)connectionJson, KomodoConnectionAttributes.class);
            restConnection.setDriverName(rcAttr.getDriver());
            restConnection.setJndiName(rcAttr.getJndi());
            restConnection.setJdbc(rcAttr.isJdbc());
            for (Map.Entry entry : rcAttr.getParameters().entrySet()) {
                restConnection.addProperty((String)entry.getKey(), entry.getValue());
            }
        }
        catch (Exception ex) {
            throw new KomodoRestException((Throwable)ex);
        }
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "updateConnection", false);
            boolean exists = this.getWorkspaceManager(uow).hasChild(uow, connectionName);
            if (!exists) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.CONNECTION_SERVICE_UPDATE_SOURCE_DNE, new Object[0]);
            }
            KomodoObject kobject = this.getWorkspaceManager(uow).getChild(uow, connectionName, "dv:connection");
            this.getWorkspaceManager(uow).delete(uow, new KomodoObject[]{kobject});
            Response response = this.doAddConnection(uow, uriInfo.getBaseUri(), mediaTypes, restConnection);
            LOGGER.debug("updateConnection: connection '{0}' entity was updated", new Object[]{connectionName});
            return response;
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.CONNECTION_SERVICE_UPDATE_CONNECTION_ERROR, new Object[0]);
        }
    }

    private Response doAddConnection(Repository.UnitOfWork uow, URI baseUri, List<MediaType> mediaTypes, RestConnection restConnection) throws KomodoRestException {
        assert (!uow.isRollbackOnly());
        assert (uow.getState() == Repository.UnitOfWork.State.NOT_STARTED);
        assert (restConnection != null);
        String connectionName = restConnection.getId();
        try {
            Connection connection = this.getWorkspaceManager(uow).createConnection(uow, null, connectionName);
            this.setProperties(uow, connection, restConnection);
            RestConnection entity = (RestConnection)this.entityFactory.create((KomodoObject)connection, baseUri, uow);
            Response response = this.commit(uow, mediaTypes, (KRestEntity)entity);
            return response;
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            throw new KomodoRestException(RelationalMessages.getString((Enum)RelationalMessages.Error.CONNECTION_SERVICE_CREATE_CONNECTION_ERROR, (Object[])new Object[]{connectionName}), (Throwable)e);
        }
    }

    @DELETE
    @Path(value="{connectionName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete a connection from the workspace")
    @ApiResponses(value={@ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response deleteConnection(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the connection", required=true) @PathParam(value="connectionName") String connectionName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "removeConnectionFromWorkspace", false);
            Repository repo = this.kengine.getDefaultRepository();
            WorkspaceManager mgr = WorkspaceManager.getInstance((Repository)repo, (Repository.UnitOfWork)uow);
            KomodoObject connection = mgr.getChild(uow, connectionName, "dv:connection");
            if (connection == null) {
                return Response.noContent().build();
            }
            mgr.delete(uow, new KomodoObject[]{connection});
            KomodoStatusObject kso = new KomodoStatusObject("Delete Status");
            if (mgr.hasChild(uow, connectionName)) {
                kso.addAttribute(connectionName, "Deletion failure");
            } else {
                kso.addAttribute(connectionName, "Successfully deleted");
            }
            return this.commit(uow, mediaTypes, (KRestEntity)kso);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.CONNECTION_SERVICE_DELETE_CONNECTION_ERROR, new Object[0]);
        }
    }

    @GET
    @Path(value="nameValidation/{connectionName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Returns an error message if the Connection name is invalid")
    @ApiResponses(value={@ApiResponse(code=400, message="The URI cannot contain encoded slashes or backslashes."), @ApiResponse(code=403, message="An unexpected error has occurred."), @ApiResponse(code=500, message="The Connection name cannot be empty.")})
    public Response validateConnectionName(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="The Connection name being checked", required=true) @PathParam(value="connectionName") String connectionName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        String errorMsg = VALIDATOR.checkValidName(connectionName);
        if (errorMsg != null) {
            return Response.ok().entity((Object)errorMsg).build();
        }
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "validateConnectionName", true);
            Connection connection = this.findConnection(uow, connectionName);
            if (connection == null) {
                Vdb ds = this.findVdb(uow, connectionName);
                if (ds == null) {
                    return Response.ok().build();
                }
                return Response.ok().entity((Object)RelationalMessages.getString((Enum)RelationalMessages.Error.VDB_DATA_SOURCE_NAME_EXISTS, (Object[])new Object[0])).build();
            }
            return Response.ok().entity((Object)RelationalMessages.getString((Enum)RelationalMessages.Error.CONNECTION_SERVICE_NAME_EXISTS, (Object[])new Object[0])).build();
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(headers.getAcceptableMediaTypes(), (Throwable)e, RelationalMessages.Error.CONNECTION_SERVICE_NAME_VALIDATION_ERROR, new Object[0]);
        }
    }
}

