/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.service;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.komodo.core.KEngine;
import org.komodo.core.repository.ObjectImpl;
import org.komodo.core.repository.SynchronousCallback;
import org.komodo.relational.ViewBuilderCriteriaPredicate;
import org.komodo.relational.ViewDdlBuilder;
import org.komodo.relational.connection.Connection;
import org.komodo.relational.dataservice.Dataservice;
import org.komodo.relational.model.Column;
import org.komodo.relational.model.ForeignKey;
import org.komodo.relational.model.Model;
import org.komodo.relational.model.PrimaryKey;
import org.komodo.relational.model.Table;
import org.komodo.relational.model.View;
import org.komodo.relational.resource.Driver;
import org.komodo.relational.vdb.ModelSource;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.rest.KRestEntity;
import org.komodo.rest.KomodoRestException;
import org.komodo.rest.KomodoService;
import org.komodo.rest.Messages;
import org.komodo.rest.relational.KomodoProperties;
import org.komodo.rest.relational.RelationalMessages;
import org.komodo.rest.relational.connection.RestConnection;
import org.komodo.rest.relational.dataservice.RestDataservice;
import org.komodo.rest.relational.json.KomodoJsonMarshaller;
import org.komodo.rest.relational.request.KomodoDataserviceUpdateAttributes;
import org.komodo.rest.relational.response.KomodoStatusObject;
import org.komodo.rest.relational.response.RestConnectionDriver;
import org.komodo.rest.relational.response.RestDataserviceViewInfo;
import org.komodo.rest.relational.response.RestVdb;
import org.komodo.spi.KException;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;
import org.komodo.spi.runtime.ConnectionDriver;
import org.komodo.utils.StringNameValidator;
import org.komodo.utils.StringUtils;

@Path(value="workspace/dataservices")
@Api(tags={"dataservices"})
public final class KomodoDataserviceService
extends KomodoService {
    private static final int ALL_AVAILABLE = -1;
    private static final String SERVICE_VDB_SUFFIX = "VDB";
    private static final String SERVICE_VDB_VIEW_MODEL = "views";
    private static final String SERVICE_VDB_VIEW_SUFFIX = "View";
    private static final String LH_TABLE_ALIAS = "A";
    private static final String LH_TABLE_ALIAS_DOT = "A.";
    private static final String RH_TABLE_ALIAS = "B";
    private static final String RH_TABLE_ALIAS_DOT = "B.";
    private static final String INNER_JOIN = "INNER JOIN";
    private static final String LEFT_OUTER_JOIN = "LEFT OUTER JOIN";
    private static final String RIGHT_OUTER_JOIN = "RIGHT OUTER JOIN";
    private static final String FULL_OUTER_JOIN = "FULL OUTER JOIN";
    private static final String OR = "OR";
    private static final String AND = "AND";
    private static final String EQ = "=";
    private static final String NE = "<>";
    private static final String LT = "<";
    private static final String GT = ">";
    private static final String LE = "<=";
    private static final String GE = ">=";
    private static final StringNameValidator VALIDATOR = new StringNameValidator();

    public KomodoDataserviceService(KEngine engine) throws WebApplicationException {
        super(engine);
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Return the collection of data services", response=RestDataservice[].class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="pattern", value="A regex expression used when searching. If not present, all objects are returned.", required=false, dataType="string", paramType="query"), @ApiImplicitParam(name="size", value="The number of objects to return. If not present, all objects are returned", required=false, dataType="integer", paramType="query"), @ApiImplicitParam(name="start", value="Index of the first dataservice to return", required=false, dataType="integer", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=403, message="An error has occurred.")})
    public Response getDataservices(@Context HttpHeaders headers, @Context UriInfo uriInfo) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            String searchPattern = (String)uriInfo.getQueryParameters().getFirst((Object)"pattern");
            uow = this.createTransaction(principal, "getDataservices", true);
            Dataservice[] dataServices = null;
            if (StringUtils.isBlank((String)searchPattern)) {
                dataServices = this.getWorkspaceManager(uow).findDataservices(uow);
                LOGGER.debug("getDataservices:found '{0}' Dataservices", new Object[]{dataServices.length});
            } else {
                String[] dataservicePaths = this.getWorkspaceManager(uow).findByType(uow, "dv:dataService", null, searchPattern, false);
                if (dataservicePaths.length == 0) {
                    dataServices = Dataservice.NO_DATASERVICES;
                } else {
                    dataServices = new Dataservice[dataservicePaths.length];
                    int i = 0;
                    for (String path : dataservicePaths) {
                        dataServices[i++] = (Dataservice)this.getWorkspaceManager(uow).resolve(uow, (Object)new ObjectImpl(this.getWorkspaceManager(uow).getRepository(), path, 0), Dataservice.class);
                    }
                    LOGGER.debug("getDataservices:found '{0}' DataServices using pattern '{1}'", new Object[]{dataServices.length, searchPattern});
                }
            }
            int start = 0;
            String qparam = (String)uriInfo.getQueryParameters().getFirst((Object)"start");
            if (qparam != null) {
                try {
                    start = Integer.parseInt(qparam);
                    if (start < 0) {
                        start = 0;
                    }
                }
                catch (Exception e) {
                    start = 0;
                }
            }
            int size = -1;
            String qparam2 = (String)uriInfo.getQueryParameters().getFirst((Object)"size");
            if (qparam2 != null) {
                try {
                    size = Integer.parseInt(qparam2);
                    if (size <= 0) {
                        size = -1;
                    }
                }
                catch (Exception e) {
                    size = -1;
                }
            }
            ArrayList<RestDataservice> entities = new ArrayList<RestDataservice>();
            int i = 0;
            KomodoProperties properties = new KomodoProperties();
            for (Dataservice dataService : dataServices) {
                if (start == 0 || i >= start) {
                    if (size != -1 && entities.size() >= size) break;
                    RestDataservice entity = (RestDataservice)this.entityFactory.create((KomodoObject)dataService, uriInfo.getBaseUri(), uow, properties);
                    entities.add(entity);
                    LOGGER.debug("getDataservices:Dataservice '{0}' entity was constructed", new Object[]{dataService.getName(uow)});
                }
                ++i;
            }
            return this.commit(uow, mediaTypes, entities);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.DATASERVICE_SERVICE_GET_DATASERVICES_ERROR, new Object[0]);
        }
    }

    @GET
    @Path(value="{dataserviceName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find dataservice by name", response=RestDataservice.class)
    @ApiResponses(value={@ApiResponse(code=404, message="No Dataservice could be found with name"), @ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response getDataservice(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Id of the dataservice to be fetched, ie. the value of the 'keng__id' property", required=true) @PathParam(value="dataserviceName") String dataserviceName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "getDataservice", true);
            Dataservice dataservice = this.findDataservice(uow, dataserviceName);
            if (dataservice == null) {
                return this.commitNoDataserviceFound(uow, mediaTypes, dataserviceName);
            }
            KomodoProperties properties = new KomodoProperties();
            RestDataservice restDataservice = (RestDataservice)this.entityFactory.create((KomodoObject)dataservice, uriInfo.getBaseUri(), uow, properties);
            LOGGER.debug("getDataservice:Dataservice '{0}' entity was constructed", new Object[]{dataservice.getName(uow)});
            return this.commit(uow, mediaTypes, (KRestEntity)restDataservice);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.DATASERVICE_SERVICE_GET_DATASERVICE_ERROR, new Object[]{dataserviceName});
        }
    }

    @POST
    @Path(value="/{dataserviceName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a dataservice in the workspace", consumes="application/json")
    @ApiResponses(value={@ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response createDataservice(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the data service", required=true) @PathParam(value="dataserviceName") String dataserviceName, @ApiParam(value="JSON of the properties of the new data service:<br><pre>{<br>&nbsp;keng\\_\\_id: \"id of the data service\",<br>&nbsp;<pre-cmt class=\"json-comment\">(identical to dataserviceName parameter)</pre-cmt><br><br>&nbsp;tko__description: \"the description\"<br>}</pre>", required=true) String dataserviceJson) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        if (StringUtils.isBlank((String)dataserviceName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_CREATE_MISSING_NAME, new Object[0]);
        }
        RestDataservice restDataservice = (RestDataservice)KomodoJsonMarshaller.unmarshall((String)dataserviceJson, RestDataservice.class);
        String jsonDataserviceName = restDataservice.getId();
        if (StringUtils.isBlank((String)jsonDataserviceName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_JSON_MISSING_NAME, new Object[0]);
        }
        boolean namesMatch = dataserviceName.equals(jsonDataserviceName);
        if (!namesMatch) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_SERVICE_NAME_ERROR, new Object[]{dataserviceName, jsonDataserviceName});
        }
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "createDataservice", false);
            if (this.getWorkspaceManager(uow).hasChild(uow, dataserviceName)) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_CREATE_ALREADY_EXISTS, new Object[0]);
            }
            return this.doAddDataservice(uow, uriInfo.getBaseUri(), mediaTypes, restDataservice);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.DATASERVICE_SERVICE_CREATE_DATASERVICE_ERROR, new Object[]{dataserviceName});
        }
    }

    @POST
    @Path(value="/clone/{dataserviceName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Clone a dataservice in the workspace")
    @ApiResponses(value={@ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response cloneDataservice(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the data service", required=true) @PathParam(value="dataserviceName") String dataserviceName, @ApiParam(value="Name of the cloned data service", required=true) String newDataserviceName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        if (StringUtils.isBlank((String)dataserviceName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_CLONE_MISSING_NAME, new Object[0]);
        }
        if (StringUtils.isBlank((String)newDataserviceName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_CLONE_MISSING_NEW_NAME, new Object[0]);
        }
        boolean namesMatch = dataserviceName.equals(newDataserviceName);
        if (namesMatch) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_CLONE_SAME_NAME_ERROR, new Object[]{newDataserviceName});
        }
        Repository.UnitOfWork uow1 = null;
        Repository.UnitOfWork uow2 = null;
        try {
            Model[] sourceModels;
            uow1 = this.createTransaction(principal, "cloneDataservice", false);
            if (this.getWorkspaceManager(uow1).hasChild(uow1, newDataserviceName)) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_CLONE_ALREADY_EXISTS, new Object[0]);
            }
            KomodoObject kobject = this.getWorkspaceManager(uow1).getChild(uow1, dataserviceName, "dv:dataService");
            Dataservice srcDataservice = (Dataservice)this.getWorkspaceManager(uow1).resolve(uow1, (Object)kobject, Dataservice.class);
            String srcDescription = srcDataservice.getDescription(uow1);
            Vdb srcServiceVdb = srcDataservice.getServiceVdb(uow1);
            Dataservice newDataservice = this.getWorkspaceManager(uow1).createDataservice(uow1, null, newDataserviceName);
            newDataservice.setDescription(uow1, srcDescription);
            newDataservice.setServiceVdb(uow1, null);
            String tgtServiceVdbName = newDataserviceName + SERVICE_VDB_SUFFIX;
            if (this.getWorkspaceManager(uow1).hasChild(uow1, tgtServiceVdbName, "vdb:virtualDatabase")) {
                KomodoObject svcVdbObj = this.getWorkspaceManager(uow1).getChild(uow1, tgtServiceVdbName, "vdb:virtualDatabase");
                svcVdbObj.remove(uow1);
            }
            Vdb tgtServiceVdbObj = this.getWorkspaceManager(uow1).createVdb(uow1, null, tgtServiceVdbName, tgtServiceVdbName);
            tgtServiceVdbObj.setProperty(uow1, "dsbOwner", new Object[]{uow1.getUserName()});
            Vdb tgtServiceVdb = (Vdb)Vdb.RESOLVER.resolve(uow1, (KomodoObject)tgtServiceVdbObj);
            for (Model sourceModel : sourceModels = srcServiceVdb.getModels(uow1, new String[0])) {
                if (sourceModel.getModelType(uow1) == Model.Type.VIRTUAL) {
                    Model viewModel = tgtServiceVdb.addModel(uow1, SERVICE_VDB_VIEW_MODEL);
                    viewModel.setModelType(uow1, Model.Type.VIRTUAL);
                    byte[] ddlBytes = sourceModel.export(uow1, new Properties());
                    String viewDdl = new String(ddlBytes);
                    String srcViewName = dataserviceName + SERVICE_VDB_VIEW_SUFFIX;
                    String tgtViewName = newDataserviceName + SERVICE_VDB_VIEW_SUFFIX;
                    viewDdl = viewDdl.replaceFirst(srcViewName, tgtViewName);
                    viewModel.setModelDefinition(uow1, viewDdl);
                    continue;
                }
                if (sourceModel.getModelType(uow1) != Model.Type.PHYSICAL) continue;
                String modelName = sourceModel.getName(uow1);
                Model targetModel = tgtServiceVdb.addModel(uow1, modelName);
                targetModel.setModelType(uow1, Model.Type.PHYSICAL);
                Properties exportProps = new Properties();
                byte[] bytes = sourceModel.export(uow1, exportProps);
                String sourceDdl = new String(bytes);
                targetModel.setModelDefinition(uow1, sourceDdl);
                ModelSource[] srcModelSources = sourceModel.getSources(uow1, new String[0]);
                ModelSource srcModelSource = srcModelSources[0];
                if (srcModelSource == null) continue;
                ModelSource tgtModelSource = targetModel.addSource(uow1, srcModelSource.getName(uow1));
                tgtModelSource.setJndiName(uow1, srcModelSource.getJndiName(uow1));
                tgtModelSource.setTranslatorName(uow1, srcModelSource.getTranslatorName(uow1));
            }
            SynchronousCallback callback = (SynchronousCallback)uow1.getCallback();
            uow1.commit();
            if (!callback.await(30L, TimeUnit.SECONDS)) {
                String errorMessage = Messages.getString((Enum)Messages.Error.COMMIT_TIMEOUT, (Object[])new Object[]{uow1.getName(), 30, TimeUnit.SECONDS});
                Object responseEntity = this.createErrorResponseEntity(mediaTypes, errorMessage);
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity(responseEntity).build();
            }
            uow2 = this.createTransaction(principal, "cloneDataservice", false);
            newDataservice.setServiceVdb(uow2, tgtServiceVdb);
            RestDataservice entity = (RestDataservice)this.entityFactory.create((KomodoObject)newDataservice, uriInfo.getBaseUri(), uow2);
            Response response = this.commit(uow2, mediaTypes, (KRestEntity)entity);
            return response;
        }
        catch (Exception e) {
            if (uow1 != null && uow1.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow1.rollback();
            }
            if (uow2 != null && uow2.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow2.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.DATASERVICE_SERVICE_CLONE_DATASERVICE_ERROR, new Object[0]);
        }
    }

    @POST
    @Path(value="/ServiceVdbForSingleTable")
    @Produces(value={"application/json"})
    @ApiOperation(value="Sets the data service's service vdb")
    @ApiResponses(value={@ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response setServiceVdbForSingleTable(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="JSON specifying the service vdb:<br><pre>{<br>&nbsp;dataserviceName: \"name of the data service\",<br>&nbsp;tablePath: \"/path/to/table\",<br>&nbsp;modelSourcePath: \"/path/to/modelSource\",<br>&nbsp;columnNames: {name1, name2, ...} [OPTIONAL],<br>&nbsp;viewDdl: \"DDL for the service view\" [OPTIONAL]<br>}</pre>", required=true) String dataserviceUpdateAttributes) throws KomodoRestException {
        String absTablePath;
        KomodoDataserviceUpdateAttributes attr;
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        try {
            attr = (KomodoDataserviceUpdateAttributes)KomodoJsonMarshaller.unmarshall((String)dataserviceUpdateAttributes, KomodoDataserviceUpdateAttributes.class);
            Response response = this.checkDataserviceUpdateAttributesSingleTableView(attr, mediaTypes);
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                return response;
            }
        }
        catch (Exception ex) {
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)ex, RelationalMessages.Error.DATASERVICE_SERVICE_REQUEST_PARSING_ERROR, new Object[0]);
        }
        String dataserviceName = attr.getDataserviceName();
        if (StringUtils.isBlank((String)dataserviceName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_SET_SERVICE_MISSING_NAME, new Object[0]);
        }
        String serviceVdbName = dataserviceName + SERVICE_VDB_SUFFIX;
        String viewDdl = attr.getViewDdl();
        boolean viewDdlSupplied = false;
        if (!StringUtils.isBlank((String)viewDdl)) {
            viewDdlSupplied = true;
        }
        if (StringUtils.isBlank((String)(absTablePath = attr.getTablePath()))) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_SET_SERVICE_MISSING_TABLEPATH, new Object[]{dataserviceName});
        }
        String absServiceModelSourcePath = attr.getModelSourcePath();
        if (StringUtils.isBlank((String)absServiceModelSourcePath)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_SET_SERVICE_MISSING_MODELSOURCE_PATH, new Object[]{dataserviceName});
        }
        List columnNames = attr.getColumnNames();
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "setDataserviceServiceVDB", false);
            WorkspaceManager wkspMgr = this.getWorkspaceManager(uow);
            boolean exists = wkspMgr.hasChild(uow, dataserviceName);
            if (!exists) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_SERVICE_DNE, new Object[0]);
            }
            KomodoObject kobject = wkspMgr.getChild(uow, dataserviceName, "dv:dataService");
            Dataservice dataservice = (Dataservice)wkspMgr.resolve(uow, (Object)kobject, Dataservice.class);
            List tableObjs = wkspMgr.getRepository().searchByPath(uow, absTablePath);
            if (tableObjs.isEmpty() || !Table.RESOLVER.resolvable(uow, (KomodoObject)tableObjs.get(0))) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_SOURCE_TABLE_DNE, new Object[]{absTablePath});
            }
            Table sourceTable = (Table)Table.RESOLVER.resolve(uow, (KomodoObject)tableObjs.get(0));
            List modelObjs = wkspMgr.getRepository().searchByPath(uow, absServiceModelSourcePath);
            if (modelObjs.isEmpty() || !ModelSource.RESOLVER.resolvable(uow, (KomodoObject)modelObjs.get(0))) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_MODEL_SOURCE_DNE, new Object[]{absServiceModelSourcePath});
            }
            ModelSource svcModelSource = (ModelSource)ModelSource.RESOLVER.resolve(uow, (KomodoObject)modelObjs.get(0));
            dataservice.setServiceVdb(uow, null);
            if (wkspMgr.hasChild(uow, serviceVdbName, "vdb:virtualDatabase")) {
                KomodoObject svcVdbObj = wkspMgr.getChild(uow, serviceVdbName, "vdb:virtualDatabase");
                svcVdbObj.remove(uow);
            }
            Vdb vdbObj = wkspMgr.createVdb(uow, null, serviceVdbName, serviceVdbName);
            vdbObj.setProperty(uow, "dsbOwner", new Object[]{uow.getUserName()});
            Vdb serviceVdb = (Vdb)Vdb.RESOLVER.resolve(uow, (KomodoObject)vdbObj);
            Model viewModel = serviceVdb.addModel(uow, SERVICE_VDB_VIEW_MODEL);
            viewModel.setModelType(uow, Model.Type.VIRTUAL);
            if (!viewDdlSupplied) {
                viewDdl = ViewDdlBuilder.getODataViewDdl((Repository.UnitOfWork)uow, (String)(dataserviceName + SERVICE_VDB_VIEW_SUFFIX), (Table)sourceTable, (List)columnNames);
            }
            viewModel.setModelDefinition(uow, viewDdl);
            String physicalModelName = svcModelSource.getParent(uow).getParent(uow).getName(uow);
            String physicalModelSourceName = svcModelSource.getParent(uow).getName(uow);
            Model sourceModel = serviceVdb.addModel(uow, physicalModelName);
            sourceModel.setModelType(uow, Model.Type.PHYSICAL);
            Properties exportProps = new Properties();
            exportProps.put("excludeTableConstraints", (Object)true);
            byte[] bytes = sourceTable.export(uow, exportProps);
            String tableString = new String(bytes);
            sourceModel.setModelDefinition(uow, tableString);
            ModelSource modelSource = sourceModel.addSource(uow, physicalModelSourceName);
            modelSource.setJndiName(uow, svcModelSource.getJndiName(uow));
            modelSource.setTranslatorName(uow, svcModelSource.getTranslatorName(uow));
            dataservice.setServiceVdb(uow, serviceVdb);
            KomodoStatusObject kso = new KomodoStatusObject("Update DataService Status");
            kso.addAttribute(dataserviceName, "Successfully updated");
            return this.commit(uow, mediaTypes, (KRestEntity)kso);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.DATASERVICE_SERVICE_SET_SERVICE_ERROR, new Object[0]);
        }
    }

    @POST
    @Path(value="/ServiceViewDdlForSingleTable")
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets generated View DDL using parameters provided in the request body")
    @ApiResponses(value={@ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response getServiceViewDdlForSingleTable(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="JSON parameters:<br><pre>{<br>&nbsp;dataserviceName: \"name of the data service\",<br>&nbsp;tablePath: \"/path/to/table\",<br>&nbsp;modelSourcePath: \"/path/to/modelSource\",<br>&nbsp;columnNames: {name1, name2, ...} [OPTIONAL],<br>&nbsp;viewDdl: \"DDL for the service view\" [OPTIONAL]<br>}</pre>", required=true) String dataserviceUpdateAttributes) throws KomodoRestException {
        KomodoDataserviceUpdateAttributes attr;
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        try {
            attr = (KomodoDataserviceUpdateAttributes)KomodoJsonMarshaller.unmarshall((String)dataserviceUpdateAttributes, KomodoDataserviceUpdateAttributes.class);
            Response response = this.checkDataserviceUpdateAttributesGetSingleTableDdl(attr, mediaTypes);
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                return response;
            }
        }
        catch (Exception ex) {
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)ex, RelationalMessages.Error.DATASERVICE_SERVICE_REQUEST_PARSING_ERROR, new Object[0]);
        }
        String dataserviceName = attr.getDataserviceName();
        if (StringUtils.isBlank((String)dataserviceName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_SET_SERVICE_MISSING_NAME, new Object[0]);
        }
        String absTablePath = attr.getTablePath();
        if (StringUtils.isBlank((String)absTablePath)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_SET_SERVICE_MISSING_TABLEPATH, new Object[]{dataserviceName});
        }
        List columnNames = attr.getColumnNames();
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "getDataserviceServiceVDB", true);
            WorkspaceManager wkspMgr = this.getWorkspaceManager(uow);
            List tableObjs = wkspMgr.getRepository().searchByPath(uow, absTablePath);
            if (tableObjs.isEmpty() || !Table.RESOLVER.resolvable(uow, (KomodoObject)tableObjs.get(0))) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_SOURCE_TABLE_DNE, new Object[]{absTablePath});
            }
            Table sourceTable = (Table)Table.RESOLVER.resolve(uow, (KomodoObject)tableObjs.get(0));
            String viewDdl = ViewDdlBuilder.getODataViewDdl((Repository.UnitOfWork)uow, (String)(dataserviceName + SERVICE_VDB_VIEW_SUFFIX), (Table)sourceTable, (List)columnNames);
            RestDataserviceViewInfo viewInfo = new RestDataserviceViewInfo();
            viewInfo.setInfoType("DDL");
            viewInfo.setViewDdl(viewDdl);
            return this.commit(uow, mediaTypes, (KRestEntity)viewInfo);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.DATASERVICE_SERVICE_SET_SERVICE_ERROR, new Object[0]);
        }
    }

    @POST
    @Path(value="/ServiceVdbForJoinTables")
    @Produces(value={"application/json"})
    @ApiOperation(value="Sets the dataservice vdb using parameters provided in the request body")
    @ApiResponses(value={@ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response setServiceVdbForTwoTables(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="JSON parameters:<br><pre>{<br>&nbsp;dataserviceName: \"name of the data service\",<br>&nbsp;tablePath: \"/path/to/table\",<br>&nbsp;rhTablePath: \"/path/to/table\",<br>&nbsp;modelSourcePath: \"/path/to/modelSource\",<br>&nbsp;rhModelSourcePath: \"/path/to/modelSource\",<br>&nbsp;columnNames: {name1, name2, ...} [OPTIONAL],<br>&nbsp;rhColumnNames: {name1, name2, ...} [OPTIONAL],<br>&nbsp;viewDdl: \"DDL for the service view\" [OPTIONAL],<br>&nbsp;joinType: \"Type of join\",<br>&nbsp;criteriaPredicates: []<br>}</pre>", required=true) String dataserviceUpdateAttributes) throws KomodoRestException {
        KomodoDataserviceUpdateAttributes attr;
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        try {
            attr = (KomodoDataserviceUpdateAttributes)KomodoJsonMarshaller.unmarshall((String)dataserviceUpdateAttributes, KomodoDataserviceUpdateAttributes.class);
            Response response = this.checkDataserviceUpdateAttributesJoinView(attr, mediaTypes);
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                return response;
            }
        }
        catch (Exception ex) {
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)ex, RelationalMessages.Error.DATASERVICE_SERVICE_REQUEST_PARSING_ERROR, new Object[0]);
        }
        String dataserviceName = attr.getDataserviceName();
        if (StringUtils.isBlank((String)dataserviceName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_SET_SERVICE_MISSING_NAME, new Object[0]);
        }
        String serviceVdbName = dataserviceName + SERVICE_VDB_SUFFIX;
        String absLhTablePath = attr.getTablePath();
        String absRhTablePath = attr.getRhTablePath();
        if (StringUtils.isBlank((String)absLhTablePath) || StringUtils.isBlank((String)absRhTablePath)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_SET_SERVICE_MISSING_TABLEPATH, new Object[]{dataserviceName});
        }
        String absLhModelSourcePath = attr.getModelSourcePath();
        String absRhModelSourcePath = attr.getRhModelSourcePath();
        if (StringUtils.isBlank((String)absLhModelSourcePath) || StringUtils.isBlank((String)absRhModelSourcePath)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_SET_SERVICE_MISSING_MODELSOURCE_PATH, new Object[]{dataserviceName});
        }
        boolean sameLeftAndRightModel = absLhModelSourcePath.trim().equals(absRhModelSourcePath.trim());
        String viewDdl = attr.getViewDdl();
        boolean viewDdlSupplied = false;
        if (!StringUtils.isBlank((String)viewDdl)) {
            viewDdlSupplied = true;
        }
        String joinType = attr.getJoinType();
        if (!viewDdlSupplied && StringUtils.isBlank((String)joinType)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_SET_SERVICE_MISSING_JOIN_TYPE, new Object[]{dataserviceName});
        }
        List predicateMaps = attr.getCriteriaPredicates();
        ArrayList<ViewBuilderCriteriaPredicate> criteriaPredicates = new ArrayList<ViewBuilderCriteriaPredicate>(predicateMaps.size());
        for (Map predicateMap : predicateMaps) {
            criteriaPredicates.add(new ViewBuilderCriteriaPredicate(predicateMap));
        }
        List lhColumnNames = attr.getColumnNames();
        List rhColumnNames = attr.getRhColumnNames();
        Repository.UnitOfWork uow = null;
        try {
            ModelSource lhModelSource;
            uow = this.createTransaction(principal, "setDataserviceServiceVDB", false);
            WorkspaceManager wkspMgr = this.getWorkspaceManager(uow);
            boolean exists = wkspMgr.hasChild(uow, dataserviceName);
            if (!exists) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_SERVICE_DNE, new Object[0]);
            }
            KomodoObject kobject = wkspMgr.getChild(uow, dataserviceName, "dv:dataService");
            Dataservice dataservice = (Dataservice)wkspMgr.resolve(uow, (Object)kobject, Dataservice.class);
            List tableObjs = wkspMgr.getRepository().searchByPath(uow, absLhTablePath);
            if (tableObjs.isEmpty() || !Table.RESOLVER.resolvable(uow, (KomodoObject)tableObjs.get(0))) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_SOURCE_TABLE_DNE, new Object[]{absLhTablePath});
            }
            Table lhSourceTable = (Table)Table.RESOLVER.resolve(uow, (KomodoObject)tableObjs.get(0));
            tableObjs = wkspMgr.getRepository().searchByPath(uow, absRhTablePath);
            if (tableObjs.isEmpty() || !Table.RESOLVER.resolvable(uow, (KomodoObject)tableObjs.get(0))) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_SOURCE_TABLE_DNE, new Object[]{absRhTablePath});
            }
            Table rhSourceTable = (Table)Table.RESOLVER.resolve(uow, (KomodoObject)tableObjs.get(0));
            List modelObjs = wkspMgr.getRepository().searchByPath(uow, absLhModelSourcePath);
            if (modelObjs.isEmpty() || !ModelSource.RESOLVER.resolvable(uow, (KomodoObject)modelObjs.get(0))) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_MODEL_SOURCE_DNE, new Object[]{absLhModelSourcePath});
            }
            ModelSource rhModelSource = lhModelSource = (ModelSource)ModelSource.RESOLVER.resolve(uow, (KomodoObject)modelObjs.get(0));
            if (!sameLeftAndRightModel) {
                modelObjs = wkspMgr.getRepository().searchByPath(uow, absRhModelSourcePath);
                if (modelObjs.isEmpty() || !ModelSource.RESOLVER.resolvable(uow, (KomodoObject)modelObjs.get(0))) {
                    return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_MODEL_SOURCE_DNE, new Object[]{absRhModelSourcePath});
                }
                rhModelSource = (ModelSource)ModelSource.RESOLVER.resolve(uow, (KomodoObject)modelObjs.get(0));
            }
            dataservice.setServiceVdb(uow, null);
            if (wkspMgr.hasChild(uow, serviceVdbName, "vdb:virtualDatabase")) {
                KomodoObject svcVdbObj = wkspMgr.getChild(uow, serviceVdbName, "vdb:virtualDatabase");
                svcVdbObj.remove(uow);
            }
            Vdb vdbObj = wkspMgr.createVdb(uow, null, serviceVdbName, serviceVdbName);
            vdbObj.setProperty(uow, "dsbOwner", new Object[]{uow.getUserName()});
            Vdb serviceVdb = (Vdb)Vdb.RESOLVER.resolve(uow, (KomodoObject)vdbObj);
            Model viewModel = serviceVdb.addModel(uow, SERVICE_VDB_VIEW_MODEL);
            viewModel.setModelType(uow, Model.Type.VIRTUAL);
            if (!viewDdlSupplied) {
                viewDdl = ViewDdlBuilder.getODataViewJoinDdl((Repository.UnitOfWork)uow, (String)(dataserviceName + SERVICE_VDB_VIEW_SUFFIX), (Table)lhSourceTable, (String)LH_TABLE_ALIAS, (List)lhColumnNames, (Table)rhSourceTable, (String)RH_TABLE_ALIAS, (List)rhColumnNames, (String)joinType, criteriaPredicates);
            }
            viewModel.setModelDefinition(uow, viewDdl);
            String lhPhysicalModelName = lhModelSource.getParent(uow).getParent(uow).getName(uow);
            String lhPhysicalModelSourceName = lhModelSource.getParent(uow).getName(uow);
            Model lhPhysicalModel = serviceVdb.addModel(uow, lhPhysicalModelName);
            lhPhysicalModel.setModelType(uow, Model.Type.PHYSICAL);
            Properties exportProps = new Properties();
            exportProps.put("excludeTableConstraints", (Object)true);
            byte[] bytes = lhSourceTable.export(uow, exportProps);
            String lhTableDdl = new String(bytes);
            bytes = rhSourceTable.export(uow, exportProps);
            String rhTableDdl = new String(bytes);
            if (sameLeftAndRightModel) {
                lhPhysicalModel.setModelDefinition(uow, lhTableDdl + rhTableDdl);
            } else {
                lhPhysicalModel.setModelDefinition(uow, lhTableDdl);
            }
            ModelSource lhPhysicalModelSource = lhPhysicalModel.addSource(uow, lhPhysicalModelSourceName);
            lhPhysicalModelSource.setJndiName(uow, lhModelSource.getJndiName(uow));
            lhPhysicalModelSource.setTranslatorName(uow, lhModelSource.getTranslatorName(uow));
            if (!sameLeftAndRightModel) {
                String rhPhysicalModelName = rhModelSource.getParent(uow).getParent(uow).getName(uow);
                String rhPhysicalModelSourceName = rhModelSource.getParent(uow).getName(uow);
                Model rhPhysicalModel = serviceVdb.addModel(uow, rhPhysicalModelName);
                rhPhysicalModel.setModelType(uow, Model.Type.PHYSICAL);
                rhPhysicalModel.setModelDefinition(uow, rhTableDdl);
                ModelSource rhPhysicalModelSource = rhPhysicalModel.addSource(uow, rhPhysicalModelSourceName);
                rhPhysicalModelSource.setJndiName(uow, rhModelSource.getJndiName(uow));
                rhPhysicalModelSource.setTranslatorName(uow, rhModelSource.getTranslatorName(uow));
            }
            dataservice.setServiceVdb(uow, serviceVdb);
            KomodoStatusObject kso = new KomodoStatusObject("Update DataService Status");
            kso.addAttribute(dataserviceName, "Successfully updated");
            return this.commit(uow, mediaTypes, (KRestEntity)kso);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.DATASERVICE_SERVICE_SET_SERVICE_ERROR, new Object[0]);
        }
    }

    @POST
    @Path(value="/ServiceViewDdlForJoinTables")
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets generated View DDL using parameters provided in the request body")
    @ApiResponses(value={@ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response getServiceViewDdlForTwoTables(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="JSON parameters:<br><pre>{<br>&nbsp;dataserviceName: \"name of the data service\",<br>&nbsp;tablePath: \"/path/to/table\",<br>&nbsp;rhTablePath: \"/path/to/table\",<br>&nbsp;columnNames: {name1, name2, ...} [OPTIONAL],<br>&nbsp;rhColumnNames: {name1, name2, ...} [OPTIONAL],<br>&nbsp;joinType: \"Type of join\",<br>&nbsp;criteriaPredicates: []<br>}</pre>", required=true) String dataserviceUpdateAttributes) throws KomodoRestException {
        KomodoDataserviceUpdateAttributes attr;
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        try {
            attr = (KomodoDataserviceUpdateAttributes)KomodoJsonMarshaller.unmarshall((String)dataserviceUpdateAttributes, KomodoDataserviceUpdateAttributes.class);
            Response response = this.checkDataserviceUpdateAttributesGetJoinDdl(attr, mediaTypes);
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                return response;
            }
        }
        catch (Exception ex) {
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)ex, RelationalMessages.Error.DATASERVICE_SERVICE_REQUEST_PARSING_ERROR, new Object[0]);
        }
        String dataserviceName = attr.getDataserviceName();
        if (StringUtils.isBlank((String)dataserviceName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_SET_SERVICE_MISSING_NAME, new Object[0]);
        }
        String absLhTablePath = attr.getTablePath();
        String absRhTablePath = attr.getRhTablePath();
        if (StringUtils.isBlank((String)absLhTablePath) || StringUtils.isBlank((String)absRhTablePath)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_SET_SERVICE_MISSING_TABLEPATH, new Object[]{dataserviceName});
        }
        String joinType = attr.getJoinType();
        if (StringUtils.isBlank((String)joinType)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_SET_SERVICE_MISSING_JOIN_TYPE, new Object[]{dataserviceName});
        }
        List predicateMaps = attr.getCriteriaPredicates();
        ArrayList<ViewBuilderCriteriaPredicate> criteriaPredicates = new ArrayList<ViewBuilderCriteriaPredicate>(predicateMaps.size());
        for (Map predicateMap : predicateMaps) {
            criteriaPredicates.add(new ViewBuilderCriteriaPredicate(predicateMap));
        }
        List lhColumnNames = attr.getColumnNames();
        List rhColumnNames = attr.getRhColumnNames();
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "getViewDdl", true);
            WorkspaceManager wkspMgr = this.getWorkspaceManager(uow);
            List tableObjs = wkspMgr.getRepository().searchByPath(uow, absLhTablePath);
            if (tableObjs.isEmpty() || !Table.RESOLVER.resolvable(uow, (KomodoObject)tableObjs.get(0))) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_SOURCE_TABLE_DNE, new Object[]{absLhTablePath});
            }
            Table lhSourceTable = (Table)Table.RESOLVER.resolve(uow, (KomodoObject)tableObjs.get(0));
            tableObjs = wkspMgr.getRepository().searchByPath(uow, absRhTablePath);
            if (tableObjs.isEmpty() || !Table.RESOLVER.resolvable(uow, (KomodoObject)tableObjs.get(0))) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_SOURCE_TABLE_DNE, new Object[]{absRhTablePath});
            }
            Table rhSourceTable = (Table)Table.RESOLVER.resolve(uow, (KomodoObject)tableObjs.get(0));
            String viewDdl = ViewDdlBuilder.getODataViewJoinDdl((Repository.UnitOfWork)uow, (String)(dataserviceName + SERVICE_VDB_VIEW_SUFFIX), (Table)lhSourceTable, (String)LH_TABLE_ALIAS, (List)lhColumnNames, (Table)rhSourceTable, (String)RH_TABLE_ALIAS, (List)rhColumnNames, (String)joinType, criteriaPredicates);
            RestDataserviceViewInfo viewInfo = new RestDataserviceViewInfo();
            viewInfo.setInfoType("DDL");
            viewInfo.setViewDdl(viewDdl);
            return this.commit(uow, mediaTypes, (KRestEntity)viewInfo);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.DATASERVICE_SERVICE_SET_SERVICE_ERROR, new Object[0]);
        }
    }

    @POST
    @Path(value="/CriteriaForJoinTables")
    @Produces(value={"application/json"})
    @ApiOperation(value="Generates join criteria using table parameters provided in the request body")
    @ApiResponses(value={@ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response getJoinCriteriaForTables(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="JSON parameters:<br><pre>{<br>&nbsp;tablePath: \"/path/to/table\",<br>&nbsp;rhTablePath: \"/path/to/table\",<br>}</pre>", required=true) String dataserviceUpdateAttributes) throws KomodoRestException {
        KomodoDataserviceUpdateAttributes attr;
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        try {
            attr = (KomodoDataserviceUpdateAttributes)KomodoJsonMarshaller.unmarshall((String)dataserviceUpdateAttributes, KomodoDataserviceUpdateAttributes.class);
            Response response = this.checkDataserviceUpdateAttributesGetJoinCriteria(attr, mediaTypes);
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                return response;
            }
        }
        catch (Exception ex) {
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)ex, RelationalMessages.Error.DATASERVICE_SERVICE_REQUEST_PARSING_ERROR, new Object[0]);
        }
        String absLhTablePath = attr.getTablePath();
        String absRhTablePath = attr.getRhTablePath();
        if (StringUtils.isBlank((String)absLhTablePath) || StringUtils.isBlank((String)absRhTablePath)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_GET_JOIN_MISSING_TABLEPATH, new Object[0]);
        }
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "getJoinCriteria", true);
            WorkspaceManager wkspMgr = this.getWorkspaceManager(uow);
            List tableObjs = wkspMgr.getRepository().searchByPath(uow, absLhTablePath);
            if (tableObjs.isEmpty() || !Table.RESOLVER.resolvable(uow, (KomodoObject)tableObjs.get(0))) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_SOURCE_TABLE_DNE, new Object[]{absLhTablePath});
            }
            Table lhSourceTable = (Table)Table.RESOLVER.resolve(uow, (KomodoObject)tableObjs.get(0));
            tableObjs = wkspMgr.getRepository().searchByPath(uow, absRhTablePath);
            if (tableObjs.isEmpty() || !Table.RESOLVER.resolvable(uow, (KomodoObject)tableObjs.get(0))) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_SOURCE_TABLE_DNE, new Object[]{absRhTablePath});
            }
            Table rhSourceTable = (Table)Table.RESOLVER.resolve(uow, (KomodoObject)tableObjs.get(0));
            RestDataserviceViewInfo viewInfo = this.buildJoinCriteria(uow, lhSourceTable, rhSourceTable);
            return this.commit(uow, mediaTypes, (KRestEntity)viewInfo);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.DATASERVICE_SERVICE_SET_SERVICE_ERROR, new Object[0]);
        }
    }

    @PUT
    @Path(value="/{dataserviceName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Update a dataservice in the workspace")
    @ApiResponses(value={@ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response updateDataservice(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the data service to be updated", required=true) @PathParam(value="dataserviceName") String dataserviceName, @ApiParam(value="JSON of the data service properties to update:<br><pre>{<br>&nbsp;keng\\_\\_id: \"id of the data service\",<br>&nbsp;<pre-cmt class=\"json-comment\">(identical to dataserviceName parameter)</pre-cmt><br><br>&nbsp;tko__description: \"the description\"<br>}</pre>", required=true) String dataserviceJson) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        if (StringUtils.isBlank((String)dataserviceName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_UPDATE_MISSING_NAME, new Object[0]);
        }
        RestDataservice restDataservice = (RestDataservice)KomodoJsonMarshaller.unmarshall((String)dataserviceJson, RestDataservice.class);
        String jsonDataserviceName = restDataservice.getId();
        if (StringUtils.isBlank((String)jsonDataserviceName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_JSON_MISSING_NAME, new Object[0]);
        }
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "updateDataservice", false);
            boolean exists = this.getWorkspaceManager(uow).hasChild(uow, dataserviceName);
            if (!exists) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_SERVICE_DNE, new Object[0]);
            }
            KomodoObject kobject = this.getWorkspaceManager(uow).getChild(uow, dataserviceName, "dv:dataService");
            Dataservice dataservice = (Dataservice)this.getWorkspaceManager(uow).resolve(uow, (Object)kobject, Dataservice.class);
            this.setProperties(uow, dataservice, restDataservice);
            boolean namesMatch = dataserviceName.equals(jsonDataserviceName);
            if (!namesMatch) {
                dataservice.rename(uow, jsonDataserviceName);
            }
            KomodoProperties properties = new KomodoProperties();
            RestDataservice entity = (RestDataservice)this.entityFactory.create((KomodoObject)dataservice, uriInfo.getBaseUri(), uow, properties);
            LOGGER.debug("updateDataservice: dataservice '{0}' entity was updated", new Object[]{dataservice.getName(uow)});
            Response response = this.commit(uow, headers.getAcceptableMediaTypes(), (KRestEntity)entity);
            return response;
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.DATASERVICE_SERVICE_UPDATE_DATASERVICE_ERROR, new Object[0]);
        }
    }

    private Response doAddDataservice(Repository.UnitOfWork uow, URI baseUri, List<MediaType> mediaTypes, RestDataservice restDataservice) throws KomodoRestException {
        assert (!uow.isRollbackOnly());
        assert (uow.getState() == Repository.UnitOfWork.State.NOT_STARTED);
        assert (restDataservice != null);
        String dataserviceName = restDataservice.getId();
        try {
            Dataservice dataservice = this.getWorkspaceManager(uow).createDataservice(uow, null, dataserviceName);
            this.setProperties(uow, dataservice, restDataservice);
            RestDataservice entity = (RestDataservice)this.entityFactory.create((KomodoObject)dataservice, baseUri, uow);
            Response response = this.commit(uow, mediaTypes, (KRestEntity)entity);
            return response;
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            throw new KomodoRestException(RelationalMessages.getString((Enum)RelationalMessages.Error.DATASERVICE_SERVICE_CREATE_DATASERVICE_ERROR, (Object[])new Object[]{dataserviceName}), (Throwable)e);
        }
    }

    private void setProperties(Repository.UnitOfWork uow, Dataservice dataService, RestDataservice restDataService) throws KException {
        String oldDescription;
        String newDescription = restDataService.getDescription();
        if (!StringUtils.equals((String)newDescription, (String)(oldDescription = dataService.getDescription(uow)))) {
            dataService.setDescription(uow, newDescription);
        }
    }

    @DELETE
    @Path(value="{dataserviceName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete a dataservice from the workspace")
    @ApiResponses(value={@ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response deleteDataservice(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the data service to be deleted", required=true) @PathParam(value="dataserviceName") String dataserviceName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "removeDataserviceFromWorkspace", false);
            WorkspaceManager wkspMgr = this.getWorkspaceManager(uow);
            boolean exists = wkspMgr.hasChild(uow, dataserviceName);
            if (!exists) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_SERVICE_DNE, new Object[0]);
            }
            KomodoObject dsKobject = wkspMgr.getChild(uow, dataserviceName, "dv:dataService");
            Dataservice dataservice = (Dataservice)wkspMgr.resolve(uow, (Object)dsKobject, Dataservice.class);
            Vdb serviceVdb = dataservice.getServiceVdb(uow);
            if (serviceVdb != null) {
                wkspMgr.delete(uow, new KomodoObject[]{serviceVdb});
            }
            wkspMgr.delete(uow, new KomodoObject[]{dataservice});
            KomodoStatusObject kso = new KomodoStatusObject("Delete Status");
            kso.addAttribute(dataserviceName, "Successfully deleted");
            return this.commit(uow, mediaTypes, (KRestEntity)kso);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.DATASERVICE_SERVICE_DELETE_DATASERVICE_ERROR, new Object[0]);
        }
    }

    private Response checkDataserviceUpdateAttributesSingleTableView(KomodoDataserviceUpdateAttributes attr, List<MediaType> mediaTypes) throws Exception {
        if (attr == null || attr.getDataserviceName() == null || attr.getTablePath() == null || attr.getModelSourcePath() == null) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_MISSING_PARAMETER_ERROR, new Object[0]);
        }
        return Response.ok().build();
    }

    private Response checkDataserviceUpdateAttributesGetSingleTableDdl(KomodoDataserviceUpdateAttributes attr, List<MediaType> mediaTypes) throws Exception {
        if (attr == null || attr.getDataserviceName() == null || attr.getTablePath() == null) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_MISSING_PARAMETER_ERROR, new Object[0]);
        }
        return Response.ok().build();
    }

    private Response checkDataserviceUpdateAttributesJoinView(KomodoDataserviceUpdateAttributes attr, List<MediaType> mediaTypes) throws Exception {
        if (attr == null || attr.getDataserviceName() == null || attr.getModelSourcePath() == null || attr.getRhModelSourcePath() == null || attr.getTablePath() == null || attr.getRhTablePath() == null) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_MISSING_PARAMETER_ERROR, new Object[0]);
        }
        if ((attr.getJoinType() == null || attr.getCriteriaPredicates() == null) && attr.getViewDdl() == null) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_MISSING_PARAMETER_ERROR, new Object[0]);
        }
        return Response.ok().build();
    }

    private Response checkDataserviceUpdateAttributesGetJoinDdl(KomodoDataserviceUpdateAttributes attr, List<MediaType> mediaTypes) throws Exception {
        if (attr == null || attr.getDataserviceName() == null || attr.getJoinType() == null || attr.getTablePath() == null || attr.getRhTablePath() == null) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_MISSING_PARAMETER_ERROR, new Object[0]);
        }
        return Response.ok().build();
    }

    private Response checkDataserviceUpdateAttributesGetJoinCriteria(KomodoDataserviceUpdateAttributes attr, List<MediaType> mediaTypes) throws Exception {
        if (attr == null || attr.getTablePath() == null || attr.getRhTablePath() == null) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.DATASERVICE_SERVICE_MISSING_PARAMETER_ERROR, new Object[0]);
        }
        return Response.ok().build();
    }

    @GET
    @Path(value="{dataserviceName}/connections")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find a dataservice's connections ", response=RestDataservice.class)
    @ApiResponses(value={@ApiResponse(code=404, message="No Dataservice could be found with name"), @ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response getConnections(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the data service containing the required connections", required=true) @PathParam(value="dataserviceName") String dataserviceName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "getDataservice", true);
            Dataservice dataservice = this.findDataservice(uow, dataserviceName);
            if (dataservice == null) {
                return this.commitNoDataserviceFound(uow, mediaTypes, dataserviceName);
            }
            Connection[] connections = dataservice.getConnections(uow, new String[0]);
            ArrayList<RestConnection> restConnections = new ArrayList<RestConnection>(connections.length);
            for (Connection connection : connections) {
                RestConnection entity = (RestConnection)this.entityFactory.create((KomodoObject)connection, uriInfo.getBaseUri(), uow);
                restConnections.add(entity);
                LOGGER.debug("getConnections:Connections from Dataservice '{0}' entity was constructed", new Object[]{dataserviceName});
            }
            return this.commit(uow, mediaTypes, restConnections);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.DATASERVICE_SERVICE_GET_CONNECTIONS_ERROR, new Object[]{dataserviceName});
        }
    }

    @GET
    @Path(value="{dataserviceName}/drivers")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find a dataservice's drivers ", response=RestConnectionDriver.class)
    @ApiResponses(value={@ApiResponse(code=404, message="No Dataservice could be found with name"), @ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response getDrivers(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the data service containing the required drivers", required=true) @PathParam(value="dataserviceName") String dataserviceName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "getDataservice", true);
            Dataservice dataservice = this.findDataservice(uow, dataserviceName);
            if (dataservice == null) {
                return this.commitNoDataserviceFound(uow, mediaTypes, dataserviceName);
            }
            Driver[] drivers = dataservice.getDrivers(uow, new String[0]);
            ArrayList<RestConnectionDriver> restDrivers = new ArrayList<RestConnectionDriver>(drivers.length);
            for (Driver driver : drivers) {
                ConnectionDriver aDriver = new ConnectionDriver(driver.getName(uow));
                RestConnectionDriver entity = new RestConnectionDriver(aDriver);
                restDrivers.add(entity);
                LOGGER.debug("getDrivers:Drivers from Dataservice '{0}' entity was constructed", new Object[]{dataserviceName});
            }
            return this.commit(uow, mediaTypes, restDrivers);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.DATASERVICE_SERVICE_GET_DRIVERS_ERROR, new Object[]{dataserviceName});
        }
    }

    @GET
    @Path(value="{dataserviceName}/sourceVdbMatches")
    @Produces(value={"application/json", "application/xml"})
    @ApiOperation(value="Find workspace source VDB matches for a Dataservice", response=RestVdb[].class)
    @ApiResponses(value={@ApiResponse(code=404, message="No dataservice could be found with name"), @ApiResponse(code=406, message="Only JSON or XML is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response getSourceVdbsForDataService(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the data service containing the required source vdbs", required=true) @PathParam(value="dataserviceName") String dataserviceName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            Model[] models;
            uow = this.createTransaction(principal, "getSourceVdbsForDataservice", true);
            Dataservice dataservice = this.findDataservice(uow, dataserviceName);
            if (dataservice == null) {
                return this.commitNoDataserviceFound(uow, mediaTypes, dataserviceName);
            }
            Vdb serviceVdb = dataservice.getServiceVdb(uow);
            ArrayList<String> sourceVdbNames = new ArrayList<String>();
            for (Model model : models = serviceVdb.getModels(uow, new String[0])) {
                if (model.getModelType(uow) != Model.Type.PHYSICAL) continue;
                sourceVdbNames.add(model.getName(uow));
            }
            ArrayList<Object> sourceVdbs = new ArrayList<Object>();
            if (!sourceVdbNames.isEmpty()) {
                WorkspaceManager wsMgr = this.getWorkspaceManager(uow);
                Vdb[] wsVdbs = wsMgr.findVdbs(uow);
                for (Vdb wsVdb : wsVdbs) {
                    if (!sourceVdbNames.contains(wsVdb.getName(uow))) continue;
                    sourceVdbs.add(wsVdb);
                }
            }
            ArrayList<RestVdb> entities = new ArrayList<RestVdb>();
            KomodoProperties properties = new KomodoProperties();
            properties.addProperty("vdb-export-xml", (Object)false);
            for (Vdb vdb : sourceVdbs) {
                RestVdb entity = (RestVdb)this.entityFactory.create((KomodoObject)vdb, uriInfo.getBaseUri(), uow, properties);
                entities.add(entity);
            }
            return this.commit(uow, mediaTypes, entities);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.DATASERVICE_SERVICE_FIND_SOURCE_VDB_ERROR, new Object[]{dataserviceName});
        }
    }

    @GET
    @Path(value="{dataserviceName}/serviceViewInfo")
    @Produces(value={"application/json"})
    @ApiOperation(value="retrieve the service view information for a dataservice")
    @ApiResponses(value={@ApiResponse(code=404, message="No dataservice could be found with name"), @ApiResponse(code=406, message="Only JSON or XML is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response getServiceViewInfoForDataService(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the required data service", required=true) @PathParam(value="dataserviceName") String dataserviceName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            boolean bl;
            uow = this.createTransaction(principal, "getServiceViewInfoForDataService", true);
            Dataservice dataservice = this.findDataservice(uow, dataserviceName);
            if (dataservice == null) {
                return this.commitNoDataserviceFound(uow, mediaTypes, dataserviceName);
            }
            String viewSql = null;
            String viewDdl = null;
            Vdb serviceVdb = dataservice.getServiceVdb(uow);
            Model[] models = serviceVdb.getModels(uow, new String[0]);
            ArrayList<Table> srcTables = new ArrayList<Table>();
            for (Model model : models) {
                Table[] tables;
                if (model.getModelType(uow) == Model.Type.VIRTUAL) {
                    View[] views = model.getViews(uow, new String[0]);
                    viewSql = views[0].getQueryExpression(uow);
                    byte[] byArray = model.export(uow, new Properties());
                    if (byArray == null) {
                        viewDdl = "";
                        continue;
                    }
                    viewDdl = new String(byArray);
                    continue;
                }
                if (model.getModelType(uow) != Model.Type.PHYSICAL) continue;
                for (Table table : tables = model.getTables(uow, new String[0])) {
                    srcTables.add(table);
                }
            }
            ArrayList<RestDataserviceViewInfo> viewInfos = new ArrayList<RestDataserviceViewInfo>();
            Map tableColumnMap = this.getTableColumnNameMap(viewSql);
            Set sqlTables = tableColumnMap.keySet();
            String leftSqlTableName = "";
            String rightSqlTableName = "";
            boolean bl2 = false;
            boolean rightSqlTableAliased = false;
            for (String sqlTable : sqlTables) {
                int aliasIndx;
                if (sqlTable.endsWith(" AS A")) {
                    aliasIndx = sqlTable.indexOf(" AS A");
                    leftSqlTableName = sqlTable.substring(0, aliasIndx);
                    bl = true;
                    continue;
                }
                if (sqlTable.endsWith(" AS B")) {
                    aliasIndx = sqlTable.indexOf(" AS B");
                    rightSqlTableName = sqlTable.substring(0, aliasIndx);
                    rightSqlTableAliased = true;
                    continue;
                }
                leftSqlTableName = sqlTable;
            }
            int nTable = 0;
            boolean hasUnmatchedTable = false;
            Table lhTable = null;
            Table rhTable = null;
            for (Table srcTable : srcTables) {
                List colsForTable;
                RestDataserviceViewInfo viewInfo = new RestDataserviceViewInfo();
                String tblName = srcTable.getName(uow);
                String tblSrc = srcTable.getParent(uow).getName(uow);
                String qualifiedTblName = tblSrc + "." + srcTable.getName(uow);
                if (qualifiedTblName.equals(leftSqlTableName)) {
                    viewInfo.setInfoType("LHTABLE");
                    lhTable = srcTable;
                } else if (qualifiedTblName.equals(rightSqlTableName)) {
                    viewInfo.setInfoType("RHTABLE");
                    rhTable = srcTable;
                } else if (nTable == 0) {
                    viewInfo.setInfoType("LHTABLE");
                    lhTable = srcTable;
                    hasUnmatchedTable = true;
                } else if (nTable == 1) {
                    viewInfo.setInfoType("RHTABLE");
                    rhTable = srcTable;
                    hasUnmatchedTable = true;
                }
                viewInfo.setSourceVdbName(tblSrc);
                viewInfo.setTableName(tblName);
                String mapKey = qualifiedTblName;
                if (viewInfo.getInfoType() != null) {
                    if (viewInfo.getInfoType().equals("LHTABLE") && bl) {
                        mapKey = mapKey + " " + "AS" + " " + LH_TABLE_ALIAS;
                    } else if (viewInfo.getInfoType().equals("RHTABLE") && rightSqlTableAliased) {
                        mapKey = mapKey + " " + "AS" + " " + RH_TABLE_ALIAS;
                    }
                }
                if ((colsForTable = (List)tableColumnMap.get(mapKey)) != null && !colsForTable.isEmpty()) {
                    viewInfo.setColumnNames((Collection)colsForTable);
                }
                viewInfos.add(viewInfo);
                ++nTable;
            }
            RestDataserviceViewInfo criteriaInfo = this.getCriteriaInfo(viewSql);
            if (viewInfos.size() == 2 && criteriaInfo != null) {
                viewInfos.add(criteriaInfo);
            }
            RestDataserviceViewInfo viewInfo = new RestDataserviceViewInfo();
            viewInfo.setInfoType("DDL");
            viewInfo.setViewDdl(viewDdl);
            if (srcTables.isEmpty() || tableColumnMap.isEmpty()) {
                viewInfo.setViewEditable(false);
            } else if (srcTables.size() != tableColumnMap.size()) {
                viewInfo.setViewEditable(false);
            } else if (tableColumnMap.size() == 2 && criteriaInfo == null) {
                viewInfo.setViewEditable(false);
            } else if (this.columnOrderingChanged(uow, lhTable, rhTable, viewDdl)) {
                viewInfo.setViewEditable(false);
            } else if (hasUnmatchedTable) {
                viewInfo.setViewEditable(false);
            } else {
                viewInfo.setViewEditable(true);
            }
            viewInfos.add(viewInfo);
            return this.commit(uow, mediaTypes, viewInfos);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.DATASERVICE_SERVICE_FIND_VIEW_INFO_ERROR, new Object[]{dataserviceName});
        }
    }

    private Map<String, List<String>> getTableColumnNameMap(String viewSql) {
        HashMap<String, List<String>> tableColumnMap = new HashMap<String, List<String>>();
        ArrayList<String> colNames = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)viewSql)) {
            List cols = this.getColumnNamesFromSQL(viewSql);
            for (String cName : cols) {
                if (cName.startsWith("ROW_NUMBER()")) continue;
                colNames.add(cName);
            }
            String fromStr = "";
            int fromStartIndex = viewSql.indexOf("FROM ");
            if (fromStartIndex > -1) {
                fromStr = viewSql.substring(fromStartIndex + "FROM ".length());
            }
            if (fromStr.contains(INNER_JOIN) || fromStr.contains(LEFT_OUTER_JOIN) || fromStr.contains(RIGHT_OUTER_JOIN) || fromStr.contains(FULL_OUTER_JOIN)) {
                int indxStart = 0;
                int indxEnd = fromStr.indexOf("AS A");
                String lhTable = null;
                if (indxEnd > -1) {
                    lhTable = fromStr.substring(indxStart, indxEnd).trim();
                }
                indxStart = fromStr.indexOf("JOIN ");
                indxEnd = fromStr.indexOf("AS B");
                String rhTable = null;
                if (indxStart > -1 && indxEnd > -1) {
                    rhTable = fromStr.substring(indxStart + "JOIN ".length(), indxEnd).trim();
                }
                ArrayList<String> lhCols = new ArrayList<String>();
                ArrayList<String> rhCols = new ArrayList<String>();
                for (String colName : colNames) {
                    if (colName.startsWith(LH_TABLE_ALIAS_DOT)) {
                        lhCols.add(colName.substring(LH_TABLE_ALIAS_DOT.length()));
                        continue;
                    }
                    if (!colName.startsWith(RH_TABLE_ALIAS_DOT)) continue;
                    rhCols.add(colName.substring(RH_TABLE_ALIAS_DOT.length()));
                }
                if (!StringUtils.isBlank((String)lhTable) && !StringUtils.isBlank((String)rhTable)) {
                    tableColumnMap.put(lhTable + " " + "AS" + " " + LH_TABLE_ALIAS, lhCols);
                    tableColumnMap.put(rhTable + " " + "AS" + " " + RH_TABLE_ALIAS, rhCols);
                }
            } else {
                String tableName = fromStr.trim();
                if (!StringUtils.isBlank((String)tableName)) {
                    tableColumnMap.put(tableName, colNames);
                }
            }
        }
        return tableColumnMap;
    }

    private boolean columnOrderingChanged(Repository.UnitOfWork uow, Table lhTable, Table rhTable, String viewSql) throws KException {
        Column[] columns;
        boolean isDifferent = false;
        ArrayList<String> tableColNameOrdered = new ArrayList<String>();
        for (Column column : columns = lhTable.getColumns(uow, new String[0])) {
            tableColNameOrdered.add(LH_TABLE_ALIAS_DOT + column.getName(uow));
        }
        if (rhTable != null) {
            for (Column column : columns = rhTable.getColumns(uow, new String[0])) {
                tableColNameOrdered.add(RH_TABLE_ALIAS_DOT + column.getName(uow));
            }
        }
        ArrayList<String> sqlColNames = new ArrayList<String>();
        List cols = this.getColumnNamesFromSQL(viewSql);
        for (String cName : cols) {
            if (cName.startsWith("ROW_NUMBER()")) continue;
            if (!cName.startsWith(LH_TABLE_ALIAS_DOT) && !cName.startsWith(RH_TABLE_ALIAS_DOT)) {
                sqlColNames.add(LH_TABLE_ALIAS_DOT + cName);
                continue;
            }
            sqlColNames.add(cName);
        }
        Iterator tcIter = tableColNameOrdered.iterator();
        while (tcIter.hasNext()) {
            String tcName = (String)tcIter.next();
            if (sqlColNames.contains(tcName)) continue;
            tcIter.remove();
        }
        if (sqlColNames.size() != tableColNameOrdered.size()) {
            isDifferent = true;
        } else {
            for (int i = 0; i < sqlColNames.size(); ++i) {
                if (((String)sqlColNames.get(i)).equalsIgnoreCase((String)tableColNameOrdered.get(i))) continue;
                isDifferent = true;
                break;
            }
        }
        return isDifferent;
    }

    private List<String> getColumnNamesFromSQL(String sql) {
        ArrayList<String> columnNames = new ArrayList<String>();
        int startIndex = sql.indexOf("SELECT") + "SELECT".length();
        int endIndex = sql.indexOf("FROM ");
        String columnsStr = "";
        String[] cols = new String[]{};
        if (startIndex > -1 && endIndex > startIndex) {
            columnsStr = sql.substring(startIndex, endIndex);
        }
        if (!columnsStr.trim().isEmpty()) {
            cols = columnsStr.split(",");
        }
        for (String col : cols) {
            columnNames.add(col.trim());
        }
        return columnNames;
    }

    private RestDataserviceViewInfo buildJoinCriteria(Repository.UnitOfWork uow, Table lhTable, Table rhTable) throws KException {
        PrimaryKey pk = lhTable.getPrimaryKey(uow);
        ForeignKey fk = null;
        if (pk != null) {
            fk = this.findFkMatch(uow, pk, rhTable);
        }
        if (fk == null && (pk = rhTable.getPrimaryKey(uow)) != null) {
            fk = this.findFkMatch(uow, pk, lhTable);
        }
        RestDataserviceViewInfo criteriaInfo = new RestDataserviceViewInfo();
        criteriaInfo.setInfoType("CRITERIA");
        if (pk != null && fk != null) {
            ArrayList<ViewBuilderCriteriaPredicate> predicates = new ArrayList<ViewBuilderCriteriaPredicate>();
            Column[] pkColumns = pk.getColumns(uow);
            Column[] fkColumns = fk.getColumns(uow);
            for (int i = 0; i < pkColumns.length; ++i) {
                ViewBuilderCriteriaPredicate predicate = new ViewBuilderCriteriaPredicate();
                predicate.setOperator(EQ);
                predicate.setCombineKeyword(AND);
                predicate.setLhColumn(pkColumns[i].getName(uow));
                predicate.setRhColumn(fkColumns[i].getName(uow));
                predicates.add(predicate);
            }
            criteriaInfo.setCriteriaPredicates(predicates);
        } else {
            criteriaInfo.setCriteriaPredicates(Collections.emptyList());
        }
        return criteriaInfo;
    }

    private ForeignKey findFkMatch(Repository.UnitOfWork uow, PrimaryKey pk, Table table) throws KException {
        ForeignKey[] fks;
        Table pkTable = pk.getTable(uow);
        ForeignKey matchingFK = null;
        Column[] pkColumns = pk.getColumns(uow);
        List<Column> pkColumnList = Arrays.asList(pkColumns);
        for (ForeignKey fk : fks = table.getForeignKeys(uow, new String[0])) {
            Column[] fkRefColumns;
            Table fkTableRef = fk.getReferencesTable(uow);
            if (fkTableRef == null || !fkTableRef.equals(pkTable) || (fkRefColumns = fk.getReferencesColumns(uow)).length != pkColumns.length) continue;
            boolean columnsMatch = true;
            for (Column fkRefColumn : fkRefColumns) {
                if (pkColumnList.contains(fkRefColumn)) continue;
                columnsMatch = false;
                break;
            }
            if (!columnsMatch) continue;
            matchingFK = fk;
            break;
        }
        return matchingFK;
    }

    private RestDataserviceViewInfo getCriteriaInfo(String viewSql) {
        if (!this.hasJoin(viewSql)) {
            return null;
        }
        RestDataserviceViewInfo criteriaInfo = new RestDataserviceViewInfo();
        criteriaInfo.setInfoType("CRITERIA");
        if (!StringUtils.isEmpty((String)viewSql)) {
            if (viewSql.indexOf(INNER_JOIN) != -1) {
                criteriaInfo.setJoinType("INNER");
            } else if (viewSql.indexOf(LEFT_OUTER_JOIN) != -1) {
                criteriaInfo.setJoinType("LEFT_OUTER");
            } else if (viewSql.indexOf(RIGHT_OUTER_JOIN) != -1) {
                criteriaInfo.setJoinType("RIGHT_OUTER");
            } else if (viewSql.indexOf(FULL_OUTER_JOIN) != -1) {
                criteriaInfo.setJoinType("FULL_OUTER");
            }
            String asRhAliasOn = "AS B ON";
            int startIndex = viewSql.indexOf(asRhAliasOn);
            String criteriaStr = "";
            if (startIndex > -1) {
                criteriaStr = viewSql.substring(startIndex + asRhAliasOn.length());
            }
            ArrayList<ViewBuilderCriteriaPredicate> predicates = new ArrayList<ViewBuilderCriteriaPredicate>();
            if (!StringUtils.isEmpty((String)criteriaStr)) {
                while (!StringUtils.isEmpty((String)criteriaStr)) {
                    ViewBuilderCriteriaPredicate predicate;
                    String predicateStr;
                    int orIndex = criteriaStr.indexOf(" OR ");
                    int andIndex = criteriaStr.indexOf(" AND ");
                    if (orIndex == -1 && andIndex == -1) {
                        ViewBuilderCriteriaPredicate predicate2 = this.parsePredicate(criteriaStr, AND);
                        if (predicate2.isComplete()) {
                            predicates.add(predicate2);
                        }
                        criteriaStr = "";
                        continue;
                    }
                    if (orIndex > -1 && andIndex == -1) {
                        predicateStr = criteriaStr.substring(0, orIndex);
                        predicate = this.parsePredicate(predicateStr, OR);
                        if (predicate.isComplete()) {
                            predicates.add(predicate);
                        }
                        criteriaStr = criteriaStr.substring(orIndex + " OR ".length());
                        continue;
                    }
                    if (orIndex == -1 && andIndex > -1) {
                        predicateStr = criteriaStr.substring(0, andIndex);
                        predicate = this.parsePredicate(predicateStr, AND);
                        if (predicate.isComplete()) {
                            predicates.add(predicate);
                        }
                        criteriaStr = criteriaStr.substring(andIndex + " AND ".length());
                        continue;
                    }
                    if (orIndex < andIndex) {
                        predicateStr = criteriaStr.substring(0, orIndex);
                        predicate = this.parsePredicate(predicateStr, OR);
                        if (predicate.isComplete()) {
                            predicates.add(predicate);
                        }
                        criteriaStr = criteriaStr.substring(orIndex + " OR ".length());
                        continue;
                    }
                    predicateStr = criteriaStr.substring(0, andIndex);
                    predicate = this.parsePredicate(predicateStr, AND);
                    if (predicate.isComplete()) {
                        predicates.add(predicate);
                    }
                    criteriaStr = criteriaStr.substring(andIndex + " AND ".length());
                }
                criteriaInfo.setCriteriaPredicates(predicates);
            }
            if (predicates.size() == 0) {
                criteriaInfo = null;
            } else {
                for (ViewBuilderCriteriaPredicate predicate : predicates) {
                    if (predicate.isComplete()) continue;
                    criteriaInfo = null;
                    break;
                }
            }
        }
        return criteriaInfo;
    }

    private ViewBuilderCriteriaPredicate parsePredicate(String predicateStr, String combineKeyword) {
        ViewBuilderCriteriaPredicate predicate = new ViewBuilderCriteriaPredicate();
        predicate.setCombineKeyword(combineKeyword);
        String[] criteriaCols = null;
        if (predicateStr.indexOf(" = ") > -1) {
            predicate.setOperator(EQ);
            criteriaCols = predicateStr.split(EQ);
        } else if (predicateStr.indexOf(" < ") > -1) {
            predicate.setOperator(LT);
            criteriaCols = predicateStr.split(LT);
        } else if (predicateStr.indexOf(" > ") > -1) {
            predicate.setOperator(GT);
            criteriaCols = predicateStr.split(GT);
        } else if (predicateStr.indexOf(" <> ") > -1) {
            predicate.setOperator(NE);
            criteriaCols = predicateStr.split(NE);
        } else if (predicateStr.indexOf(" <= ") > -1) {
            predicate.setOperator(LE);
            criteriaCols = predicateStr.split(LE);
        } else if (predicateStr.indexOf(" >= ") > -1) {
            predicate.setOperator(GE);
            criteriaCols = predicateStr.split(GE);
        }
        if (criteriaCols != null) {
            for (int i = 0; i < criteriaCols.length; ++i) {
                String cCol = criteriaCols[i].trim();
                if (StringUtils.isBlank((String)cCol)) continue;
                if (cCol.startsWith(LH_TABLE_ALIAS_DOT)) {
                    predicate.setLhColumn(cCol.substring(LH_TABLE_ALIAS_DOT.length()));
                    continue;
                }
                if (!cCol.startsWith(RH_TABLE_ALIAS_DOT)) continue;
                predicate.setRhColumn(cCol.substring(RH_TABLE_ALIAS_DOT.length()));
            }
        }
        return predicate;
    }

    private boolean hasJoin(String viewDdl) {
        return !StringUtils.isEmpty((String)viewDdl) && (viewDdl.indexOf(INNER_JOIN) != -1 || viewDdl.indexOf(LEFT_OUTER_JOIN) != -1 || viewDdl.indexOf(RIGHT_OUTER_JOIN) != -1 || viewDdl.indexOf(FULL_OUTER_JOIN) != -1);
    }

    @GET
    @Path(value="nameValidation/{dataserviceName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Returns an error message if the data service name is invalid")
    @ApiResponses(value={@ApiResponse(code=400, message="The URI cannot contain encoded slashes or backslashes."), @ApiResponse(code=403, message="An unexpected error has occurred."), @ApiResponse(code=500, message="The dataservice name cannot be empty.")})
    public Response validateDataserviceName(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="The dataservice name being checked", required=true) @PathParam(value="dataserviceName") String dataserviceName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        String errorMsg = VALIDATOR.checkValidName(dataserviceName);
        if (errorMsg != null) {
            Response response = Response.ok().entity((Object)errorMsg).build();
            return response;
        }
        Repository.UnitOfWork uow = null;
        try {
            Vdb vdb;
            uow = this.createTransaction(principal, "validateDataserviceName", true);
            Dataservice service = this.findDataservice(uow, dataserviceName);
            if (service == null && (vdb = this.findVdb(uow, dataserviceName)) == null) {
                return Response.ok().build();
            }
            return Response.ok().entity((Object)RelationalMessages.getString((Enum)RelationalMessages.Error.DATASERVICE_SERVICE_NAME_EXISTS, (Object[])new Object[0])).build();
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(headers.getAcceptableMediaTypes(), (Throwable)e, RelationalMessages.Error.DATASERVICE_SERVICE_NAME_VALIDATION_ERROR, new Object[0]);
        }
    }
}

