/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.service;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.komodo.core.KEngine;
import org.komodo.core.repository.ObjectImpl;
import org.komodo.relational.resource.Driver;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.rest.KomodoRestException;
import org.komodo.rest.KomodoService;
import org.komodo.rest.relational.RelationalMessages;
import org.komodo.rest.relational.response.RestConnectionDriver;
import org.komodo.spi.repository.Repository;
import org.komodo.spi.runtime.ConnectionDriver;
import org.komodo.utils.StringUtils;

@Path(value="workspace/drivers")
@Api(tags={"drivers"})
public final class KomodoDriverService
extends KomodoService {
    private static final int ALL_AVAILABLE = -1;

    public KomodoDriverService(KEngine engine) throws WebApplicationException {
        super(engine);
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Return the collection of installed drivers", response=RestConnectionDriver[].class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="pattern", value="A regex expression used when searching. If not present, all objects are returned.", required=false, dataType="string", paramType="query"), @ApiImplicitParam(name="size", value="The number of objects to return. If not present, all objects are returned", required=false, dataType="integer", paramType="query"), @ApiImplicitParam(name="start", value="Index of the first dataservice to return", required=false, dataType="integer", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=403, message="An error has occurred.")})
    public Response getDrivers(@Context HttpHeaders headers, @Context UriInfo uriInfo) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            String searchPattern = (String)uriInfo.getQueryParameters().getFirst((Object)"pattern");
            uow = this.createTransaction(principal, "getDrivers", true);
            Driver[] drivers = null;
            WorkspaceManager wsMgr = this.getWorkspaceManager(uow);
            if (StringUtils.isBlank((String)searchPattern)) {
                drivers = wsMgr.findDrivers(uow);
                LOGGER.debug("getDrivers:found '{0}' Drivers", new Object[]{drivers.length});
            } else {
                String[] driverPaths = wsMgr.findByType(uow, "dv:driverFile", null, searchPattern, false);
                if (driverPaths.length == 0) {
                    drivers = Driver.NO_DRIVERS;
                } else {
                    drivers = new Driver[driverPaths.length];
                    int i = 0;
                    for (String path : driverPaths) {
                        drivers[i++] = (Driver)wsMgr.resolve(uow, (Object)new ObjectImpl(wsMgr.getRepository(), path, 0), Driver.class);
                    }
                    LOGGER.debug("getDrivers:found '{0}' Drivers using pattern '{1}'", new Object[]{drivers.length, searchPattern});
                }
            }
            int start = 0;
            String qparam = (String)uriInfo.getQueryParameters().getFirst((Object)"start");
            if (qparam != null) {
                try {
                    start = Integer.parseInt(qparam);
                    if (start < 0) {
                        start = 0;
                    }
                }
                catch (Exception e) {
                    start = 0;
                }
            }
            int size = -1;
            String qparam2 = (String)uriInfo.getQueryParameters().getFirst((Object)"size");
            if (qparam2 != null) {
                try {
                    size = Integer.parseInt(qparam2);
                    if (size <= 0) {
                        size = -1;
                    }
                }
                catch (Exception e) {
                    size = -1;
                }
            }
            ArrayList<RestConnectionDriver> entities = new ArrayList<RestConnectionDriver>();
            int i = 0;
            for (Driver driver : drivers) {
                if (start == 0 || i >= start) {
                    if (size != -1 && entities.size() >= size) break;
                    ConnectionDriver aDriver = new ConnectionDriver(driver.getName(uow));
                    RestConnectionDriver entity = new RestConnectionDriver(aDriver);
                    entities.add(entity);
                    LOGGER.debug("getDrivers:Driver '{0}' entity was constructed", new Object[]{driver.getName(uow)});
                }
                ++i;
            }
            return this.commit(uow, mediaTypes, entities);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.DRIVER_SERVICE_GET_DRIVERS_ERROR, new Object[0]);
        }
    }
}

