/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.service;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.komodo.core.KEngine;
import org.komodo.importer.ImportMessages;
import org.komodo.importer.ImportOptions;
import org.komodo.osgi.PluginService;
import org.komodo.rest.KRestEntity;
import org.komodo.rest.KomodoRestException;
import org.komodo.rest.KomodoService;
import org.komodo.rest.relational.RelationalMessages;
import org.komodo.rest.relational.json.KomodoJsonMarshaller;
import org.komodo.rest.relational.response.ImportExportStatus;
import org.komodo.rest.relational.response.KomodoStorageAttributes;
import org.komodo.rest.relational.response.RestStorageType;
import org.komodo.spi.repository.DocumentType;
import org.komodo.spi.repository.Exportable;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;
import org.komodo.spi.storage.StorageConnector;
import org.komodo.spi.storage.StorageReference;
import org.komodo.spi.storage.StorageService;
import org.komodo.utils.FileUtils;
import org.komodo.utils.KLog;
import org.komodo.utils.StringUtils;

@Path(value="importexport")
@Api(tags={"importexport"})
public class KomodoImportExportService
extends KomodoService {
    public KomodoImportExportService(KEngine engine) throws WebApplicationException {
        super(engine);
    }

    private Response checkStorageAttributes(KomodoStorageAttributes sta, List<MediaType> mediaTypes) throws Exception {
        Map parameters = sta.getParameters();
        if (sta == null || sta.getStorageType() == null && sta.getArtifactPath() == null && parameters == null) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.IMPORT_EXPORT_SERVICE_NO_PARAMETERS_ERROR, new Object[0]);
        }
        Set supportedTypes = PluginService.getInstance().getSupportedStorageTypes();
        if (!supportedTypes.contains(sta.getStorageType())) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.IMPORT_EXPORT_SERVICE_UNSUPPORTED_TYPE_ERROR, new Object[0]);
        }
        StorageService storageService = PluginService.getInstance().getStorageService(sta.getStorageType());
        for (StorageConnector.Descriptor descriptor : storageService.getDescriptors()) {
            if (!descriptor.isRequired() || "file-path-property".equals(descriptor.getName()) || parameters.containsKey(descriptor.getName())) continue;
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.IMPORT_EXPORT_SERVICE_MISSING_PARAMETER_ERROR, new Object[]{descriptor.getName()});
        }
        for (StorageConnector.Descriptor descriptor : storageService.getDescriptors()) {
            if (!descriptor.isEncoded() || !parameters.containsKey(descriptor.getName())) continue;
            String value = (String)parameters.get(descriptor.getName());
            value = new String(this.decode(value));
            sta.setParameter(descriptor.getName(), value);
        }
        return Response.ok().build();
    }

    @POST
    @Path(value="export")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Exports an artifact using parameters provided in the request body", response=ImportExportStatus.class)
    @ApiResponses(value={@ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response exportArtifact(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="JSON of the possible storage attributes:<br><pre>{<br>&nbsp;storageType: \"Either 'file' or 'git'\",<br>&nbsp;dataPath: \"Path of the object to be exported\",<br>&nbsp;documentType: \"Expected destination export file type\"<br>&nbsp;<pre-cmt class=\"json-comment\">(Used to help determine the expected file type, eg. zip, xml, directory)</pre-cmt><br>&nbsp;parameters: {<br>&nbsp;&nbsp;files-home-path-property: \"Path to the parent directory of the export files\",<br>&nbsp;&nbsp;file-path-property: \"Relative path, inc. name, of the destination exported file\",<br>&nbsp;&nbsp;<pre-cmt class=\"json-comment\">(Optional if documentType specified)</pre-cmt><br>&nbsp;&nbsp;downloadable-path-property: \"Should a file be downloadable once exported\",<br>&nbsp;&nbsp;useTabs: \"Should tabs be used in exporting xml\",<br>&nbsp;&nbsp;excludeTableConstraints: \"Should table constraints be excluded when exporting DDL\",<br>&nbsp;&nbsp;<pre-cmt class=\"json-comment\">(Further parameters are specific to storage type. see /importexport/availableStorageType REST link)</pre-cmt><br>&nbsp;}<br>}</pre>", required=true) String storageAttributes) throws KomodoRestException {
        KomodoStorageAttributes sta;
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        try {
            sta = (KomodoStorageAttributes)KomodoJsonMarshaller.unmarshall((String)storageAttributes, KomodoStorageAttributes.class);
            Response response = this.checkStorageAttributes(sta, mediaTypes);
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                return response;
            }
        }
        catch (Exception ex) {
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)ex, RelationalMessages.Error.IMPORT_EXPORT_SERVICE_REQUEST_PARSING_ERROR, new Object[0]);
        }
        ImportExportStatus status = new ImportExportStatus();
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "exportFromWorkspace", true);
            Repository repo = this.kengine.getDefaultRepository();
            String artifactPath = sta.getArtifactPath();
            KomodoObject kObject = repo.getFromWorkspace(uow, artifactPath);
            if (kObject == null) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.IMPORT_EXPORT_SERVICE_NO_ARTIFACT_ERROR, new Object[]{artifactPath});
            }
            Exportable artifact = (Exportable)this.getWorkspaceManager(uow).resolve(uow, (Object)kObject, Exportable.class);
            if (artifact == null) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.IMPORT_EXPORT_SERVICE_ARTIFACT_NOT_EXPORTABLE_ERROR, new Object[]{artifactPath});
            }
            DocumentType documentType = artifact.getDocumentType(uow);
            Properties parameters = sta.convertParameters();
            if (!parameters.containsKey("file-path-property")) {
                String fileName = documentType.fileName(artifact.getName(uow));
                parameters.setProperty("file-path-property", fileName);
            }
            status.setName(artifact.getName(uow));
            status.setType(documentType.toString());
            String downloadable = this.getWorkspaceManager(uow).exportArtifact(uow, artifact, sta.getStorageType(), parameters);
            status.setDownloadable(downloadable != null);
            this.applyContent(status, downloadable);
            status.setSuccess(true);
            return this.commit(uow, mediaTypes, (KRestEntity)status);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            return this.createErrorResponse(Response.Status.FORBIDDEN, mediaTypes, (Throwable)e, RelationalMessages.Error.IMPORT_EXPORT_SERVICE_EXPORT_ERROR, new Object[]{sta.getArtifactPath(), sta.getStorageType()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyContent(ImportExportStatus status, String downloadable) throws Exception {
        if (downloadable == null) {
            return;
        }
        try (FileInputStream stream = null;){
            File downloadableFile = new File(downloadable);
            stream = new FileInputStream(downloadableFile);
            status.setDownloadableSize(downloadableFile.length());
            byte[] content = new byte[(int)downloadableFile.length()];
            stream.read(content);
            String encContent = this.encode(content);
            status.setContent(encContent);
            KLog.getLogger().debug("Encrypted content of " + downloadableFile.getAbsolutePath() + ": " + encContent + " SIZE: " + downloadableFile.length(), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="import")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Imports an artifact using parameters provided in the request body", response=ImportExportStatus.class)
    @ApiResponses(value={@ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response importArtifact(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="JSON of the possible storage attributes:<br><pre>{<br>&nbsp;storageType: \"Either 'file' or 'git'\",<br>&nbsp;content: \"Base64-encoded byte data of the file to import\",<br>&nbsp;<pre-cmt class=\"json-comment\">(If defined then this overrides 'files-home' & 'file-path' properties)</pre-cmt><br>&nbsp;dataPath: \"Destination object path\",<br>&nbsp;<pre-cmt class=\"json-comment\">(If not specified then located under the workspace)</pre-cmt><br>&nbsp;documentType: \"Type of the file being imported\"<br>&nbsp;<pre-cmt class=\"json-comment\">(Required for content type, eg. zip, xml, directory)</pre-cmt><br>&nbsp;parameters: {<br>&nbsp;&nbsp;files-home-path-property: \"Path to the parent location of the file to import\",<br>&nbsp;&nbsp;file-path-property: \"Relative path, inc. name, of the file to import\"<br>&nbsp;&nbsp;<pre-cmt class=\"json-comment\">(Further parameters are specific to storage type. see /importexport/availableStorageType REST link)</pre-cmt><br>&nbsp;}<br>}</pre>", required=true) String storageAttributes) throws KomodoRestException {
        KomodoStorageAttributes sta;
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        try {
            sta = (KomodoStorageAttributes)KomodoJsonMarshaller.unmarshall((String)storageAttributes, KomodoStorageAttributes.class);
            Response response = this.checkStorageAttributes(sta, mediaTypes);
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                return response;
            }
        }
        catch (Exception ex) {
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)ex, RelationalMessages.Error.IMPORT_EXPORT_SERVICE_REQUEST_PARSING_ERROR, new Object[0]);
        }
        File cttFile = null;
        ImportExportStatus status = new ImportExportStatus();
        Repository.UnitOfWork uow = null;
        try {
            Properties parameters;
            String tempDir;
            if (sta.getContent() != null) {
                byte[] content = this.decode(sta.getContent());
                tempDir = FileUtils.tempDirectory();
                String fileName = content.hashCode() + "." + sta.getDocumentType();
                cttFile = new File(tempDir, fileName);
                FileUtils.write((byte[])content, (File)cttFile);
                sta.setParameter("files-home-path-property", tempDir);
                sta.setParameter("file-path-property", fileName);
            }
            if (!(parameters = sta.convertParameters()).containsKey("file-path-property")) {
                tempDir = this.createErrorResponse(Response.Status.FORBIDDEN, mediaTypes, RelationalMessages.Error.IMPORT_EXPORT_SERVICE_NO_FILE_PATH_ERROR, new Object[0]);
                return tempDir;
            }
            Repository repo = this.kengine.getDefaultRepository();
            uow = this.createTransaction(principal, "importToWorkspace", false);
            KomodoObject importTarget = repo.komodoWorkspace(uow);
            String artifactPath = sta.getArtifactPath();
            if (!StringUtils.isEmpty((String)artifactPath) && (importTarget = repo.getFromWorkspace(uow, artifactPath)) == null) {
                Response response = this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.IMPORT_EXPORT_SERVICE_NO_ARTIFACT_ERROR, new Object[]{artifactPath});
                return response;
            }
            StorageReference storageRef = new StorageReference(sta.getStorageType(), parameters, new DocumentType(sta.getDocumentType()));
            ImportOptions importOptions = new ImportOptions();
            if (parameters.containsKey("import-overwrite-property")) {
                String importOverwrite = parameters.getProperty("import-overwrite-property");
                if (importOverwrite.equals(ImportOptions.ExistingNodeOptions.RETURN.name())) {
                    importOptions.setOption(ImportOptions.OptionKeys.HANDLE_EXISTING, (Object)ImportOptions.ExistingNodeOptions.RETURN);
                } else if (importOverwrite.equals(ImportOptions.ExistingNodeOptions.CREATE_NEW.name())) {
                    importOptions.setOption(ImportOptions.OptionKeys.HANDLE_EXISTING, (Object)ImportOptions.ExistingNodeOptions.CREATE_NEW);
                } else {
                    importOptions.setOption(ImportOptions.OptionKeys.HANDLE_EXISTING, (Object)ImportOptions.ExistingNodeOptions.OVERWRITE);
                }
            } else {
                importOptions.setOption(ImportOptions.OptionKeys.HANDLE_EXISTING, (Object)ImportOptions.ExistingNodeOptions.OVERWRITE);
            }
            ImportMessages messages = this.getWorkspaceManager(uow).importArtifact(uow, importTarget, storageRef, importOptions);
            if (messages.hasError()) {
                Response response = this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.IMPORT_EXPORT_SERVICE_IMPORT_ARTIFACT_ERROR, new Object[]{messages.errorMessagesToString()});
                return response;
            }
            status.setSuccess(true);
            status.setName(storageRef.getRelativeRef());
            status.setMessage(RelationalMessages.getString((Enum)RelationalMessages.Info.IMPORT_EXPORT_SERVICE_IMPORT_SUCCESS_MESSAGE, (Object[])new Object[]{importOptions.getOption(ImportOptions.OptionKeys.NAME)}));
            if (sta.getDocumentType().equals(DocumentType.JAR.toString())) {
                String driverName = storageRef.getParameters().getProperty("driverName");
                if (StringUtils.isBlank((String)driverName)) {
                    driverName = "defaultDriver";
                }
                status.setName(driverName);
            }
            status.setType(sta.getDocumentType().toString());
            Response response = this.commit(uow, mediaTypes, (KRestEntity)status);
            return response;
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            Response response = this.createErrorResponse(Response.Status.FORBIDDEN, mediaTypes, (Throwable)e, RelationalMessages.Error.IMPORT_EXPORT_SERVICE_IMPORT_ERROR, new Object[]{sta.getStorageType()});
            return response;
        }
        finally {
            if (cttFile != null) {
                cttFile.delete();
            }
        }
    }

    @GET
    @Path(value="availableStorageTypes")
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns the collection of available storage types used for import/export", response=RestStorageType[].class)
    @ApiResponses(value={@ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response storageTypes(@Context HttpHeaders headers, @Context UriInfo uriInfo) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        try {
            PluginService pluginService = PluginService.getInstance();
            Set storageTypes = pluginService.getSupportedStorageTypes();
            if (storageTypes == null || storageTypes.isEmpty()) {
                return Response.noContent().build();
            }
            ArrayList<RestStorageType> restStorageTypes = new ArrayList<RestStorageType>(storageTypes.size());
            for (String storageType : storageTypes) {
                StorageService storageService = pluginService.getStorageService(storageType);
                String description = storageService.getDescription();
                Set descriptors = storageService.getDescriptors();
                RestStorageType type = new RestStorageType(storageType, description, (Collection)descriptors);
                restStorageTypes.add(type);
            }
            Repository.UnitOfWork uow = this.createTransaction(principal, "getStorageTypes", true);
            return this.commit(uow, mediaTypes, restStorageTypes);
        }
        catch (Exception e) {
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.IMPORT_EXPORT_SERVICE_STORAGE_TYPES_ERROR, new Object[0]);
        }
    }
}

