/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.service;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.komodo.core.KEngine;
import org.komodo.importer.ImportMessages;
import org.komodo.importer.ImportOptions;
import org.komodo.relational.DeployStatus;
import org.komodo.relational.dataservice.Dataservice;
import org.komodo.relational.importer.vdb.VdbImporter;
import org.komodo.relational.model.Model;
import org.komodo.relational.resource.Driver;
import org.komodo.relational.vdb.ModelSource;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.rest.CallbackTimeoutException;
import org.komodo.rest.KRestEntity;
import org.komodo.rest.KomodoRestException;
import org.komodo.rest.KomodoService;
import org.komodo.rest.relational.KomodoProperties;
import org.komodo.rest.relational.RelationalMessages;
import org.komodo.rest.relational.connection.RestConnection;
import org.komodo.rest.relational.connection.RestConnectionJdbcInfo;
import org.komodo.rest.relational.json.KomodoJsonMarshaller;
import org.komodo.rest.relational.request.KomodoDataSourceJdbcTableAttributes;
import org.komodo.rest.relational.request.KomodoFileAttributes;
import org.komodo.rest.relational.request.KomodoPathAttribute;
import org.komodo.rest.relational.request.KomodoQueryAttribute;
import org.komodo.rest.relational.request.KomodoVdbUpdateAttributes;
import org.komodo.rest.relational.response.KomodoStatusObject;
import org.komodo.rest.relational.response.RestConnectionDriver;
import org.komodo.rest.relational.response.RestQueryResult;
import org.komodo.rest.relational.response.RestVdb;
import org.komodo.rest.relational.response.RestVdbTranslator;
import org.komodo.rest.relational.response.metadata.RestMetadataConnection;
import org.komodo.rest.relational.response.metadata.RestMetadataDataSourceJdbcCatalogSchemaInfo;
import org.komodo.rest.relational.response.metadata.RestMetadataStatus;
import org.komodo.rest.relational.response.metadata.RestMetadataTemplate;
import org.komodo.rest.relational.response.metadata.RestMetadataTemplateEntry;
import org.komodo.rest.relational.response.metadata.RestMetadataVdb;
import org.komodo.rest.relational.response.metadata.RestMetadataVdbStatus;
import org.komodo.rest.relational.response.metadata.RestMetadataVdbTranslator;
import org.komodo.rest.service.KomodoMetadataService;
import org.komodo.spi.KException;
import org.komodo.spi.metadata.MetadataInstance;
import org.komodo.spi.query.QSResult;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;
import org.komodo.spi.runtime.ConnectionDriver;
import org.komodo.spi.runtime.TeiidDataSource;
import org.komodo.spi.runtime.TeiidTranslator;
import org.komodo.spi.runtime.TeiidVdb;
import org.komodo.utils.ArgCheck;
import org.komodo.utils.FileUtils;
import org.komodo.utils.ModelType;
import org.komodo.utils.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Path(value="metadata")
@Api(tags={"metadata"})
public class KomodoMetadataService
extends KomodoService {
    private static final String TABLE_NAME = "TABLE_NAME";
    private static final String CATALOG = "Catalog";
    private static final String SCHEMA = "Schema";
    private InitialContext initialContext;
    private static final String DRIVER_TRANSLATOR_MAPPING_FILE = "driverTranslatorMappings.xml";
    private static final String URLCONTENT_TRANSLATOR_MAPPING_FILE = "urlContentTranslatorMappings.xml";
    private static final String ELEM_TRANSLATOR = "translator";
    private static final String ATTR_DRIVER = "driver";
    private static final String ATTR_URLCONTENT = "urlcontent";
    private static final String UNKNOWN_TRANSLATOR = "unknown";
    private static final int DEPLOYMENT_WAIT_TIME = 10000;
    private static final String[] PRIORITY_TEMPLATE_NAMES = new String[]{"connection-url", "user-name", "password", "port"};
    private Map<String, String> driverTranslatorMap = new HashMap();
    private Map<String, String> urlContentTranslatorMap = new HashMap();

    public KomodoMetadataService(KEngine engine) throws WebApplicationException {
        super(engine);
        this.loadDriverTranslatorMap();
        this.loadUrlContentTranslatorMap();
    }

    private synchronized MetadataInstance getMetadataInstance() throws KException {
        return this.kengine.getMetadataInstance();
    }

    private String getSchema(Repository.UnitOfWork uow, String vdbName, String modelName) throws Exception {
        MetadataInstance mServer = this.getMetadataInstance();
        return mServer.getSchema(vdbName, "1", modelName);
    }

    private Response createTimeoutResponse(List<MediaType> mediaTypes) {
        Object responseEntity = this.createErrorResponseEntity(mediaTypes, RelationalMessages.getString((Enum)RelationalMessages.Error.VDB_SAMPLE_IMPORT_TIMEOUT, (Object[])new Object[0]));
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity(responseEntity).build();
    }

    private Response checkFileAttributes(KomodoFileAttributes kfa, List<MediaType> mediaTypes) throws Exception {
        if (kfa == null || kfa.getName() == null && kfa.getContent() == null) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.METADATA_SERVICE_FILE_ATTRIB_NO_PARAMETERS, new Object[0]);
        }
        if (kfa.getName() == null) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.METADATA_SERVICE_FILE_ATTRIB_NO_NAME, new Object[0]);
        }
        if (kfa.getContent() == null) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.METADATA_SERVICE_FILE_ATTRIB_NO_CONTENT, new Object[0]);
        }
        return Response.ok().build();
    }

    private boolean hasDriver(String driverName) throws Exception {
        boolean hasDriver = false;
        try {
            Collection drivers = this.getMetadataInstance().getDataSourceDrivers();
            for (ConnectionDriver driver : drivers) {
                if (!driver.getName().startsWith(driverName)) continue;
                hasDriver = true;
                break;
            }
            return hasDriver;
        }
        catch (KException ex) {
            this.kengine.getErrorHandler().error((Throwable)ex);
            throw ex;
        }
    }

    private boolean hasDynamicVdb(String vdbName) throws Exception {
        boolean hasVdb = false;
        try {
            Collection vdbs = this.getMetadataInstance().getVdbs();
            for (TeiidVdb vdb : vdbs) {
                if (!vdb.getName().startsWith(vdbName)) continue;
                hasVdb = true;
                break;
            }
            return hasVdb;
        }
        catch (KException ex) {
            this.kengine.getErrorHandler().error((Throwable)ex);
            throw ex;
        }
    }

    private boolean hasDataSource(String dataSourceName) throws Exception {
        boolean hasDataSource = false;
        try {
            Collection datasources = this.getMetadataInstance().getDataSources();
            for (TeiidDataSource datasource : datasources) {
                if (!datasource.getName().startsWith(dataSourceName)) continue;
                hasDataSource = true;
                break;
            }
            return hasDataSource;
        }
        catch (KException ex) {
            this.kengine.getErrorHandler().error((Throwable)ex);
            throw ex;
        }
    }

    @GET
    @Path(value="status")
    @Produces(value={"application/json"})
    @ApiOperation(value="Display the status of the metadata instance", response=RestMetadataStatus.class)
    @ApiResponses(value={@ApiResponse(code=403, message="An error has occurred.")})
    public Response status(@javax.ws.rs.core.Context HttpHeaders headers, @javax.ws.rs.core.Context UriInfo uriInfo) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        try {
            MetadataInstance mServer = this.getMetadataInstance();
            RestMetadataStatus status = new RestMetadataStatus(uriInfo.getBaseUri(), mServer);
            return this.commit(mediaTypes, (KRestEntity)status);
        }
        catch (Throwable e) {
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, e, RelationalMessages.Error.METADATA_SERVICE_STATUS_ERROR, new Object[0]);
        }
    }

    @GET
    @Path(value="status/vdbs")
    @Produces(value={"application/json"})
    @ApiOperation(value="Display the status of the vdbs of the metadata instance", response=RestMetadataVdbStatus.class)
    @ApiResponses(value={@ApiResponse(code=403, message="An error has occurred.")})
    public Response vdbs(@javax.ws.rs.core.Context HttpHeaders headers, @javax.ws.rs.core.Context UriInfo uriInfo) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        try {
            RestMetadataVdbStatus status = new RestMetadataVdbStatus(uriInfo.getBaseUri(), this.getMetadataInstance());
            return this.commit(mediaTypes, (KRestEntity)status);
        }
        catch (Throwable e) {
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, e, RelationalMessages.Error.METADATA_SERVICE_VDBS_STATUS_ERROR, new Object[0]);
        }
    }

    @GET
    @Path(value="vdbs")
    @Produces(value={"application/json"})
    @ApiOperation(value="Display the collection of vdbs", response=RestVdb[].class)
    @ApiResponses(value={@ApiResponse(code=403, message="An error has occurred.")})
    public Response getVdbs(@javax.ws.rs.core.Context HttpHeaders headers, @javax.ws.rs.core.Context UriInfo uriInfo) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "convertVdbs", true);
            Collection vdbs = this.getMetadataInstance().getVdbs();
            LOGGER.debug("getVdbs:found '{0}' VDBs", new Object[]{vdbs.size()});
            ArrayList<RestMetadataVdb> entities = new ArrayList<RestMetadataVdb>();
            Repository repo = this.kengine.getDefaultRepository();
            for (TeiidVdb vdb : vdbs) {
                RestMetadataVdb entity = this.entityFactory.createMetadataVdb(uow, repo, vdb, uriInfo.getBaseUri());
                entities.add(entity);
                LOGGER.debug("getVdbs:VDB '{0}' entity was constructed", new Object[]{vdb.getName()});
            }
            return this.commit(uow, mediaTypes, entities);
        }
        catch (CallbackTimeoutException ex) {
            return this.createTimeoutResponse(mediaTypes);
        }
        catch (Throwable e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, e, RelationalMessages.Error.METADATA_SERVICE_GET_VDBS_ERROR, new Object[0]);
        }
    }

    @GET
    @Path(value="vdbs/{vdbName}")
    @Produces(value={"application/json", "application/xml"})
    @ApiOperation(value="Find vdb by name", response=RestMetadataVdb.class)
    @ApiResponses(value={@ApiResponse(code=404, message="No vdb could be found with name"), @ApiResponse(code=406, message="Only JSON or XML is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response getVdb(@javax.ws.rs.core.Context HttpHeaders headers, @javax.ws.rs.core.Context UriInfo uriInfo, @ApiParam(value="Id of the vdb to be fetched", required=true) @PathParam(value="vdbName") String vdbName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "getVdb-" + vdbName, true);
            TeiidVdb vdb = this.getMetadataInstance().getVdb(vdbName);
            if (vdb == null) {
                return this.commitNoVdbFound(uow, mediaTypes, vdbName);
            }
            Repository repo = this.kengine.getDefaultRepository();
            KomodoProperties properties = new KomodoProperties();
            properties.addProperty("vdb-export-xml", (Object)mediaTypes.contains(MediaType.APPLICATION_XML_TYPE));
            RestMetadataVdb entity = this.entityFactory.createMetadataVdb(uow, repo, vdb, uriInfo.getBaseUri());
            LOGGER.debug("getVdb:VDB '{0}' entity was constructed", new Object[]{vdb.getName()});
            return this.commit(uow, mediaTypes, (KRestEntity)entity);
        }
        catch (CallbackTimeoutException ex) {
            return this.createTimeoutResponse(mediaTypes);
        }
        catch (Throwable e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, e, RelationalMessages.Error.VDB_SERVICE_GET_VDB_ERROR, new Object[]{vdbName});
        }
    }

    @POST
    @Path(value="vdbs/VdbsFromTeiid")
    @Produces(value={"application/json"})
    @ApiOperation(value="Copy VDBs from the server into the workspace")
    @ApiResponses(value={@ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response copyVdbsIntoRepo(@javax.ws.rs.core.Context HttpHeaders headers, @javax.ws.rs.core.Context UriInfo uriInfo) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "vdbsFromTeiid", false);
            Collection serverVdbs = this.getMetadataInstance().getVdbs();
            boolean importError = false;
            if (serverVdbs.size() > 0) {
                WorkspaceManager mgr = this.getWorkspaceManager(uow);
                Vdb[] workspaceVdbs = mgr.findVdbs(uow);
                ArrayList<String> workspaceVdbNames = new ArrayList<String>(workspaceVdbs.length);
                for (Vdb workspaceVdb : workspaceVdbs) {
                    if (workspaceVdb.hasProperty(uow, "dsbServiceSource")) {
                        String owner = workspaceVdb.getProperty(uow, "dsbServiceSource").getStringValue(uow);
                        if (!uow.getUserName().equals(owner)) {
                            mgr.delete(uow, new KomodoObject[]{workspaceVdb});
                            continue;
                        }
                        workspaceVdbNames.add(workspaceVdb.getName(uow));
                        continue;
                    }
                    workspaceVdbNames.add(workspaceVdb.getName(uow));
                }
                Repository repo = this.kengine.getDefaultRepository();
                for (TeiidVdb serverVdb : serverVdbs) {
                    if (workspaceVdbNames.contains(serverVdb.getName())) continue;
                    String vdbXml = serverVdb.export();
                    ByteArrayInputStream vdbStream = new ByteArrayInputStream(vdbXml.getBytes());
                    VdbImporter importer = new VdbImporter(repo);
                    ImportOptions options = new ImportOptions();
                    ImportMessages importMessages = new ImportMessages();
                    importer.importVdb(uow, (InputStream)vdbStream, repo.komodoWorkspace(uow), options, importMessages);
                    if (!importMessages.hasError()) continue;
                    LOGGER.debug("importVDB for '{0}' failed", new Object[]{serverVdb.getName()});
                    importError = true;
                }
            }
            String title = RelationalMessages.getString((Enum)RelationalMessages.Info.VDB_TO_REPO_STATUS_TITLE, (Object[])new Object[0]);
            KomodoStatusObject status = new KomodoStatusObject(title);
            if (!importError) {
                status.addAttribute("copyVdbsToRepo", RelationalMessages.getString((Enum)RelationalMessages.Info.VDB_TO_REPO_SUCCESS, (Object[])new Object[0]));
            } else {
                status.addAttribute("copyVdbsToRepo", RelationalMessages.getString((Enum)RelationalMessages.Error.VDB_TO_REPO_IMPORT_ERROR, (Object[])new Object[0]));
            }
            return this.commit(uow, mediaTypes, (KRestEntity)status);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.VDB_TO_REPO_IMPORT_ERROR, new Object[0]);
        }
    }

    @PUT
    @Path(value="vdbs/VdbsFromTeiid")
    @Produces(value={"application/json"})
    @ApiOperation(value="Update workspace VDBs with teiid status")
    @ApiResponses(value={@ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response updateWorkspaceVdbsFromTeiid(@javax.ws.rs.core.Context HttpHeaders headers, @javax.ws.rs.core.Context UriInfo uriInfo) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        Repository.UnitOfWork uow = null;
        try {
            Vdb[] workspaceVdbs;
            uow = this.createTransaction(principal, "vdbUpdateFromTeiid", false);
            Collection teiidVdbs = this.getMetadataInstance().getVdbs();
            WorkspaceManager wsMgr = this.getWorkspaceManager(uow);
            for (Vdb wkspVdb : workspaceVdbs = wsMgr.findVdbs(uow)) {
                this.updateVdbProperties(uow, wkspVdb, teiidVdbs);
            }
            String title = RelationalMessages.getString((Enum)RelationalMessages.Info.VDB_TO_REPO_STATUS_TITLE, (Object[])new Object[0]);
            KomodoStatusObject status = new KomodoStatusObject(title);
            status.addAttribute("success", "true");
            return this.commit(uow, mediaTypes, (KRestEntity)status);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.VDB_TO_REPO_IMPORT_ERROR, new Object[0]);
        }
    }

    private void updateVdbProperties(Repository.UnitOfWork uow, Vdb workspaceVdb, Collection<TeiidVdb> teiidVdbs) throws KException {
        TeiidVdb serverVdbMatch = null;
        String wkspVdbName = workspaceVdb.getName(uow);
        for (TeiidVdb teiidVdb : teiidVdbs) {
            if (!teiidVdb.getName().equals(wkspVdbName)) continue;
            serverVdbMatch = teiidVdb;
            break;
        }
        String status = RelationalMessages.getString((Enum)RelationalMessages.Info.VDB_STATUS_NEW, (Object[])new Object[0]);
        String statusMessage = RelationalMessages.getString((Enum)RelationalMessages.Info.VDB_STATUS_MSG_NEW, (Object[])new Object[0]);
        if (serverVdbMatch != null) {
            List errors = serverVdbMatch.getValidityErrors();
            if (errors != null && errors.size() > 0) {
                status = RelationalMessages.getString((Enum)RelationalMessages.Info.VDB_STATUS_ERROR, (Object[])new Object[0]);
                statusMessage = (String)errors.get(0);
            } else if (serverVdbMatch.hasFailed()) {
                status = RelationalMessages.getString((Enum)RelationalMessages.Info.VDB_STATUS_ERROR, (Object[])new Object[0]);
                statusMessage = RelationalMessages.getString((Enum)RelationalMessages.Info.VDB_STATUS_MSG_UNKNOWN, (Object[])new Object[0]);
            } else if (serverVdbMatch.isActive()) {
                status = RelationalMessages.getString((Enum)RelationalMessages.Info.VDB_STATUS_ACTIVE, (Object[])new Object[0]);
                statusMessage = RelationalMessages.getString((Enum)RelationalMessages.Info.VDB_STATUS_MSG_ACTIVE, (Object[])new Object[0]);
            } else if (serverVdbMatch.isLoading()) {
                status = RelationalMessages.getString((Enum)RelationalMessages.Info.VDB_STATUS_LOADING, (Object[])new Object[0]);
                statusMessage = RelationalMessages.getString((Enum)RelationalMessages.Info.VDB_STATUS_MSG_LOADING, (Object[])new Object[0]);
            } else {
                status = RelationalMessages.getString((Enum)RelationalMessages.Info.VDB_STATUS_UNKNOWN, (Object[])new Object[0]);
                statusMessage = RelationalMessages.getString((Enum)RelationalMessages.Info.VDB_STATUS_MSG_UNKNOWN, (Object[])new Object[0]);
            }
        }
        if (workspaceVdb.hasProperty(uow, "dsbServiceSource")) {
            Model[] models;
            for (Model model : models = workspaceVdb.getModels(uow, new String[0])) {
                ModelSource[] modelSources;
                ModelSource[] modelSourceArray;
                int n;
                int n2;
                if (!model.getModelType(uow).equals((Object)ModelType.Type.PHYSICAL) || (n2 = 0) >= (n = (modelSourceArray = (modelSources = model.getSources(uow, new String[0]))).length)) continue;
                ModelSource modelSource = modelSourceArray[n2];
                workspaceVdb.setProperty(uow, "dsbSourceConnection", new Object[]{modelSource.getName(uow)});
                workspaceVdb.setProperty(uow, "dsbSourceTranslator", new Object[]{modelSource.getTranslatorName(uow)});
            }
        }
        workspaceVdb.setProperty(uow, "dsbMetadataStatus", new Object[]{status});
        workspaceVdb.setProperty(uow, "dsbMetadataStatusMessage", new Object[]{statusMessage});
    }

    @POST
    @Path(value="vdbs/ModelFromTeiidDdl")
    @Produces(value={"application/json"})
    @ApiOperation(value="Creates or updates a workspace vdb model using teiid model ddl")
    @ApiResponses(value={@ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response updateModelFromDdl(@javax.ws.rs.core.Context HttpHeaders headers, @javax.ws.rs.core.Context UriInfo uriInfo, @ApiParam(value="JSON of update attributes:<br><pre>{<br>&nbsp;vdbName: \"The destination workspace vdb name\",<br>&nbsp;modelName: \"The destination model name\",<br>&nbsp;teiidVdb: \"The source teiid vdb name\",<br>&nbsp;teiidModel: \"The source teiid model name containing required ddl\"<br>&nbsp;}<br>}</pre>", required=true) String vdbUpdateAttributes) throws KomodoRestException {
        KomodoVdbUpdateAttributes attr;
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        try {
            attr = (KomodoVdbUpdateAttributes)KomodoJsonMarshaller.unmarshall((String)vdbUpdateAttributes, KomodoVdbUpdateAttributes.class);
            Response response = this.checkVdbUpdateAttributes(attr, mediaTypes);
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                return response;
            }
        }
        catch (Exception ex) {
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)ex, RelationalMessages.Error.METADATA_SERVICE_UPDATE_REQUEST_PARSING_ERROR, new Object[0]);
        }
        String vdbName = attr.getVdbName();
        if (StringUtils.isBlank((String)vdbName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.METADATA_SERVICE_UPDATE_MISSING_VDBNAME, new Object[0]);
        }
        String modelName = attr.getModelName();
        if (StringUtils.isBlank((String)modelName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.METADATA_SERVICE_UPDATE_MISSING_MODELNAME, new Object[0]);
        }
        String teiidVdbName = attr.getTeiidVdbName();
        if (StringUtils.isBlank((String)teiidVdbName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.METADATA_SERVICE_UPDATE_MISSING_METADATA_VDBNAME, new Object[0]);
        }
        String teiidModelName = attr.getTeiidModelName();
        if (StringUtils.isBlank((String)teiidModelName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.METADATA_SERVICE_UPDATE_MISSING_METADATA_MODELNAME, new Object[0]);
        }
        Repository.UnitOfWork uow = null;
        try {
            String modelDdl;
            uow = this.createTransaction(principal, "updateVdb", false);
            try {
                modelDdl = this.getSchema(uow, teiidVdbName, teiidModelName);
            }
            catch (Exception ex) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.METADATA_SERVICE_UPDATE_DDL_FETCH_ERROR, new Object[]{teiidVdbName, teiidModelName});
            }
            if (StringUtils.isBlank((String)modelDdl)) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.METADATA_SERVICE_UPDATE_DDL_DNE, new Object[0]);
            }
            WorkspaceManager wkspMgr = this.getWorkspaceManager(uow);
            Vdb vdb = null;
            if (!wkspMgr.hasChild(uow, vdbName)) {
                vdb = wkspMgr.createVdb(uow, null, vdbName, vdbName);
            } else {
                KomodoObject kobject = wkspMgr.getChild(uow, vdbName, "vdb:virtualDatabase");
                vdb = (Vdb)wkspMgr.resolve(uow, (Object)kobject, Vdb.class);
            }
            Model[] models = vdb.getModels(uow, new String[]{modelName});
            Model modelToUpdate = null;
            if (models.length > 0) {
                modelToUpdate = models[0];
            }
            if (modelToUpdate == null) {
                modelToUpdate = vdb.addModel(uow, modelName);
            }
            modelToUpdate.setModelDefinition(uow, modelDdl);
            KomodoStatusObject kso = new KomodoStatusObject("Update Vdb Status");
            kso.addAttribute(vdbName, "Successfully updated");
            return this.commit(uow, mediaTypes, (KRestEntity)kso);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.METADATA_SERVICE_UPDATE_ERROR, new Object[0]);
        }
    }

    private Response checkVdbUpdateAttributes(KomodoVdbUpdateAttributes attr, List<MediaType> mediaTypes) throws Exception {
        if (attr == null || attr.getVdbName() == null || attr.getModelName() == null || attr.getVdbName() == null || attr.getModelName() == null) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.METADATA_SERVICE_UPDATE_MISSING_PARAMETER_ERROR, new Object[0]);
        }
        return Response.ok().build();
    }

    private Response checkJdbcTableAttributes(KomodoDataSourceJdbcTableAttributes attr, List<MediaType> mediaTypes) throws Exception {
        if (attr == null || attr.getDataSourceName() == null || attr.getCatalogFilter() == null || attr.getSchemaFilter() == null || attr.getTableFilter() == null) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.METADATA_SERVICE_UPDATE_MISSING_PARAMETER_ERROR, new Object[0]);
        }
        return Response.ok().build();
    }

    @DELETE
    @Path(value="vdbs/{vdbName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Removes a Vdb from the teiid server")
    @ApiResponses(value={@ApiResponse(code=403, message="An error has occurred.")})
    public Response removeVdb(@javax.ws.rs.core.Context HttpHeaders headers, @javax.ws.rs.core.Context UriInfo uriInfo, @ApiParam(value="Name of the VDB to be removed", required=true) @PathParam(value="vdbName") String vdbName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "unDeployTeiidDriver", false);
            this.getMetadataInstance().undeployDynamicVdb(vdbName);
            Thread.sleep(10000L);
            String title = RelationalMessages.getString((Enum)RelationalMessages.Info.VDB_DEPLOYMENT_STATUS_TITLE, (Object[])new Object[0]);
            KomodoStatusObject status = new KomodoStatusObject(title);
            if (!this.hasDynamicVdb(vdbName)) {
                status.addAttribute(vdbName, RelationalMessages.getString((Enum)RelationalMessages.Info.VDB_SUCCESSFULLY_UNDEPLOYED, (Object[])new Object[0]));
            } else {
                status.addAttribute(vdbName, RelationalMessages.getString((Enum)RelationalMessages.Info.VDB_UNDEPLOYMENT_REQUEST_SENT, (Object[])new Object[0]));
            }
            return this.commit(uow, mediaTypes, (KRestEntity)status);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.METADATA_SERVICE_UNDEPLOY_VDB_ERROR, new Object[]{vdbName});
        }
    }

    @DELETE
    @Path(value="connections/{connectionName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Removes a Connection from the teiid server")
    @ApiResponses(value={@ApiResponse(code=403, message="An error has occurred.")})
    public Response removeConnection(@javax.ws.rs.core.Context HttpHeaders headers, @javax.ws.rs.core.Context UriInfo uriInfo, @ApiParam(value="Name of the connection to be removed", required=true) @PathParam(value="connectionName") String connectionName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        Repository.UnitOfWork uow = null;
        String title = RelationalMessages.getString((Enum)RelationalMessages.Info.CONNECTION_DEPLOYMENT_STATUS_TITLE, (Object[])new Object[0]);
        KomodoStatusObject status = new KomodoStatusObject(title);
        try {
            uow = this.createTransaction(principal, "removeConnection", false);
            if (!this.getMetadataInstance().dataSourceExists(connectionName)) {
                status.addAttribute(connectionName, RelationalMessages.getString((Enum)RelationalMessages.Error.METADATA_SERVICE_NO_CONNECTION_FOUND, (Object[])new Object[]{connectionName}));
                return this.commit(uow, mediaTypes, (KRestEntity)status);
            }
            this.getMetadataInstance().deleteDataSource(connectionName);
            Thread.sleep(10000L);
            if (!this.hasDataSource(connectionName)) {
                status.addAttribute(connectionName, RelationalMessages.getString((Enum)RelationalMessages.Info.CONNECTION_SUCCESSFULLY_UNDEPLOYED, (Object[])new Object[]{connectionName}));
            } else {
                status.addAttribute(connectionName, RelationalMessages.getString((Enum)RelationalMessages.Info.CONNECTION_UNDEPLOYMENT_REQUEST_SENT, (Object[])new Object[]{connectionName}));
            }
            return this.commit(uow, mediaTypes, (KRestEntity)status);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.METADATA_SERVICE_UNDEPLOY_CONNECTION_ERROR, new Object[]{connectionName});
        }
    }

    @GET
    @Path(value="vdbs/{vdbName}/Models/{modelName}/schema")
    @Produces(value={"application/json", "application/xml"})
    @ApiOperation(value="Get schema for a VDB Model")
    @ApiResponses(value={@ApiResponse(code=404, message="No vdb could be found with name"), @ApiResponse(code=404, message="No model could be found with name"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response getVdbModelSchema(@javax.ws.rs.core.Context HttpHeaders headers, @javax.ws.rs.core.Context UriInfo uriInfo, @ApiParam(value="Name of the vdb", required=true) @PathParam(value="vdbName") String vdbName, @ApiParam(value="Name of the model", required=true) @PathParam(value="modelName") String modelName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "getModelSchema", true);
            String schema = this.getSchema(uow, vdbName, modelName);
            KomodoStatusObject kso = new KomodoStatusObject("VdbModelSchema");
            kso.addAttribute("schema", schema);
            return this.commit(uow, mediaTypes, (KRestEntity)kso);
        }
        catch (CallbackTimeoutException ex) {
            return this.createTimeoutResponse(mediaTypes);
        }
        catch (Throwable e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, e, RelationalMessages.Error.VDB_SERVICE_GET_VDB_ERROR, new Object[]{vdbName});
        }
    }

    @GET
    @Path(value="VdbTranslators")
    @Produces(value={"application/json"})
    @ApiOperation(value="Display the collection of translators", response=RestVdbTranslator[].class)
    @ApiResponses(value={@ApiResponse(code=403, message="An error has occurred.")})
    public Response getTranslators(@javax.ws.rs.core.Context HttpHeaders headers, @javax.ws.rs.core.Context UriInfo uriInfo) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            Repository repo = this.kengine.getDefaultRepository();
            uow = this.createTransaction(principal, "getTranslators", true);
            Collection translators = this.getMetadataInstance().getTranslators();
            LOGGER.debug("getTranslators:found '{0}' Translators", new Object[]{translators.size()});
            ArrayList<RestMetadataVdbTranslator> entities = new ArrayList<RestMetadataVdbTranslator>();
            for (TeiidTranslator translator : translators) {
                RestMetadataVdbTranslator entity = this.entityFactory.createMetadataTranslator(uow, repo, translator, uriInfo.getBaseUri());
                entities.add(entity);
                LOGGER.debug("getTranslators:Translator '{0}' entity was constructed", new Object[]{translator.getName()});
            }
            return this.commit(uow, mediaTypes, entities);
        }
        catch (CallbackTimeoutException ex) {
            return this.createTimeoutResponse(mediaTypes);
        }
        catch (Throwable e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, e, RelationalMessages.Error.METADATA_SERVICE_GET_TRANSLATORS_ERROR, new Object[0]);
        }
    }

    @GET
    @Path(value="connections")
    @Produces(value={"application/json"})
    @ApiOperation(value="Display the collection of connections", response=RestConnection[].class)
    @ApiResponses(value={@ApiResponse(code=403, message="An error has occurred.")})
    public Response getConnections(@javax.ws.rs.core.Context HttpHeaders headers, @javax.ws.rs.core.Context UriInfo uriInfo) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            Repository repo = this.kengine.getDefaultRepository();
            uow = this.createTransaction(principal, "getConnections", true);
            Collection dataSources = this.getMetadataInstance().getDataSources();
            LOGGER.debug("getConnections:found '{0}' DataSources", new Object[]{dataSources.size()});
            ArrayList<RestMetadataConnection> entities = new ArrayList<RestMetadataConnection>();
            for (TeiidDataSource dataSource : dataSources) {
                RestMetadataConnection entity = this.entityFactory.createMetadataDataSource(uow, repo, dataSource, uriInfo.getBaseUri());
                entities.add(entity);
                LOGGER.debug("getConnections:Data Source '{0}' entity was constructed", new Object[]{dataSource.getName()});
            }
            return this.commit(uow, mediaTypes, entities);
        }
        catch (CallbackTimeoutException ex) {
            return this.createTimeoutResponse(mediaTypes);
        }
        catch (Throwable e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, e, RelationalMessages.Error.METADATA_SERVICE_GET_DATA_SOURCES_ERROR, new Object[0]);
        }
    }

    @GET
    @Path(value="connections/{connectionName}")
    @Produces(value={"application/json", "application/xml"})
    @ApiOperation(value="Find connection by name", response=RestConnection.class)
    @ApiResponses(value={@ApiResponse(code=404, message="No connection could be found with name"), @ApiResponse(code=406, message="Only JSON or XML is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response getConnection(@javax.ws.rs.core.Context HttpHeaders headers, @javax.ws.rs.core.Context UriInfo uriInfo, @ApiParam(value="Name of the connection", required=true) @PathParam(value="connectionName") String connectionName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            Repository repo = this.kengine.getDefaultRepository();
            uow = this.createTransaction(principal, "getConnection-" + connectionName, true);
            TeiidDataSource dataSource = this.getMetadataInstance().getDataSource(connectionName);
            if (dataSource == null) {
                return this.commitNoConnectionFound(uow, mediaTypes, connectionName);
            }
            RestMetadataConnection restDataSource = this.entityFactory.createMetadataDataSource(uow, repo, dataSource, uriInfo.getBaseUri());
            LOGGER.debug("getConnection:Datasource '{0}' entity was constructed", new Object[]{dataSource.getName()});
            return this.commit(uow, mediaTypes, (KRestEntity)restDataSource);
        }
        catch (CallbackTimeoutException ex) {
            return this.createTimeoutResponse(mediaTypes);
        }
        catch (Throwable e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, e, RelationalMessages.Error.METADATA_SERVICE_GET_DATA_SOURCE_ERROR, new Object[]{connectionName});
        }
    }

    @GET
    @Path(value="connections/{connectionName}/TranslatorDefault")
    @Produces(value={"application/json", "application/xml"})
    @ApiOperation(value="Get the default translator recommended for a connection")
    @ApiResponses(value={@ApiResponse(code=404, message="No Connection could be found with name"), @ApiResponse(code=406, message="Only JSON or XML is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response getConnectionDefaultTranslator(@javax.ws.rs.core.Context HttpHeaders headers, @javax.ws.rs.core.Context UriInfo uriInfo, @ApiParam(value="Id of the connection", required=true) @PathParam(value="connectionName") String connectionName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "getConnectionDefaultTranslator-" + connectionName, true);
            TeiidDataSource dataSource = this.getMetadataInstance().getDataSource(connectionName);
            if (dataSource == null) {
                return this.commitNoConnectionFound(uow, mediaTypes, connectionName);
            }
            String driverName = dataSource.getType();
            String translatorName = (String)this.driverTranslatorMap.get(driverName);
            if (translatorName == null) {
                String connectionUrl = dataSource.getPropertyValue("connection-url");
                if (connectionUrl == null || connectionUrl.isEmpty()) {
                    translatorName = UNKNOWN_TRANSLATOR;
                } else {
                    for (String contentKey : this.urlContentTranslatorMap.keySet()) {
                        if (!connectionUrl.contains(contentKey)) continue;
                        translatorName = (String)this.urlContentTranslatorMap.get(contentKey);
                        break;
                    }
                    if (translatorName == null) {
                        translatorName = UNKNOWN_TRANSLATOR;
                    }
                }
            }
            KomodoStatusObject kso = new KomodoStatusObject();
            kso.addAttribute("Translator", translatorName);
            return this.commit(uow, mediaTypes, (KRestEntity)kso);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.METADATA_SERVICE_GET_DATA_SOURCE_TRANSLATOR_ERROR, new Object[]{connectionName});
        }
    }

    @POST
    @Path(value="connections/connectionsFromTeiid")
    @Produces(value={"application/json"})
    @ApiOperation(value="Copy Connections from the server into the workspace")
    @ApiResponses(value={@ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response copyConnectionsIntoRepo(@javax.ws.rs.core.Context HttpHeaders headers, @javax.ws.rs.core.Context UriInfo uriInfo) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        Repository.UnitOfWork uow = null;
        try {
            Repository repo = this.kengine.getDefaultRepository();
            uow = this.createTransaction(principal, "connectionsFromTeiid", false);
            Collection teiidConns = this.getMetadataInstance().getDataSources();
            WorkspaceManager mgr = this.getWorkspaceManager(uow);
            org.komodo.relational.connection.Connection[] workspaceConns = mgr.findConnections(uow);
            ArrayList<String> workspaceConnNames = new ArrayList<String>(workspaceConns.length);
            String title = RelationalMessages.getString((Enum)RelationalMessages.Info.CONNECTION_TO_REPO_STATUS_TITLE, (Object[])new Object[0]);
            KomodoStatusObject status = new KomodoStatusObject(title);
            for (org.komodo.relational.connection.Connection workspaceConn : workspaceConns) {
                if (workspaceConn.hasProperty(uow, "dsbServiceSource")) {
                    String owner = workspaceConn.getProperty(uow, "dsbServiceSource").getStringValue(uow);
                    if (!uow.getUserName().equals(owner)) {
                        mgr.delete(uow, new KomodoObject[]{workspaceConn});
                        continue;
                    }
                }
                workspaceConnNames.add(workspaceConn.getName(uow));
            }
            for (TeiidDataSource teiidConn : teiidConns) {
                String name = teiidConn.getName();
                if (workspaceConnNames.contains(name)) continue;
                org.komodo.relational.connection.Connection connection = this.getWorkspaceManager(uow).createConnection(uow, null, name);
                RestMetadataConnection teiidConnEntity = this.entityFactory.createMetadataDataSource(uow, repo, teiidConn, uriInfo.getBaseUri());
                this.setProperties(uow, connection, (RestConnection)teiidConnEntity);
            }
            status.addAttribute("copyConnsToRepo", RelationalMessages.getString((Enum)RelationalMessages.Info.CONNECTION_TO_REPO_SUCCESS, (Object[])new Object[0]));
            return this.commit(uow, mediaTypes, (KRestEntity)status);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.CONNECTION_TO_REPO_IMPORT_ERROR, new Object[0]);
        }
    }

    @GET
    @Path(value="drivers")
    @Produces(value={"application/json"})
    @ApiOperation(value="Display the collection of drivers available in teiid", response=RestConnectionDriver[].class)
    @ApiResponses(value={@ApiResponse(code=403, message="An error has occurred.")})
    public Response getDrivers(@javax.ws.rs.core.Context HttpHeaders headers, @javax.ws.rs.core.Context UriInfo uriInfo) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "getDrivers", true);
            Collection drivers = this.getMetadataInstance().getDataSourceDrivers();
            LOGGER.debug("getDrivers:found '{0}' Drivers", new Object[]{drivers.size()});
            ArrayList<RestConnectionDriver> entities = new ArrayList<RestConnectionDriver>();
            for (ConnectionDriver driver : drivers) {
                RestConnectionDriver entity = new RestConnectionDriver();
                entity.setName(driver.getName());
                entities.add(entity);
                LOGGER.debug("getDrivers:Driver '{0}' entity was constructed", new Object[]{driver.getName()});
            }
            return this.commit(uow, mediaTypes, entities);
        }
        catch (CallbackTimeoutException ex) {
            return this.createTimeoutResponse(mediaTypes);
        }
        catch (Throwable e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, e, RelationalMessages.Error.METADATA_SERVICE_GET_DRIVERS_ERROR, new Object[0]);
        }
    }

    @POST
    @Path(value="driver")
    @Produces(value={"application/json"})
    @ApiOperation(value="Add a driver to the teiid server")
    @ApiResponses(value={@ApiResponse(code=403, message="An error has occurred.")})
    public Response addDriver(@javax.ws.rs.core.Context HttpHeaders headers, @javax.ws.rs.core.Context UriInfo uriInfo, @ApiParam(value="JSON of the properties of the driver to add:<br><pre>{<br>&nbsp;name: \"name of the driver\",<br>&nbsp;content: \"Base64-encoded byte data of the,<br>&nbsp;driver file\"<br>}</pre>", required=true) String driverAttributes) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        Repository.UnitOfWork uow = null;
        String driverName = null;
        byte[] driverContent = null;
        try {
            Repository repo = this.kengine.getDefaultRepository();
            uow = this.createTransaction(principal, "deployTeiidDriver", false);
            if (driverAttributes.contains("path")) {
                try {
                    KomodoPathAttribute kpa = (KomodoPathAttribute)KomodoJsonMarshaller.unmarshall((String)driverAttributes, KomodoPathAttribute.class);
                    if (kpa.getPath() == null) {
                        return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.METADATA_SERVICE_DRIVER_MISSING_PATH, new Object[0]);
                    }
                    List results = repo.searchByPath(uow, kpa.getPath());
                    if (results.size() == 0) {
                        return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.METADATA_SERVICE_NO_DRIVER_FOUND_IN_WKSP, new Object[]{kpa.getPath()});
                    }
                    Driver driver = (Driver)this.getWorkspaceManager(uow).resolve(uow, results.get(0), Driver.class);
                    if (driver == null) {
                        return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.METADATA_SERVICE_NO_DRIVER_FOUND_IN_WKSP, new Object[]{kpa.getPath()});
                    }
                    driverName = driver.getName(uow);
                    driverContent = FileUtils.streamToByteArray((InputStream)driver.getContent(uow));
                }
                catch (Exception ex) {
                    return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)ex, RelationalMessages.Error.METADATA_SERVICE_REQUEST_PARSING_ERROR, new Object[0]);
                }
            }
            try {
                KomodoFileAttributes kfa = (KomodoFileAttributes)KomodoJsonMarshaller.unmarshall((String)driverAttributes, KomodoFileAttributes.class);
                Response response = this.checkFileAttributes(kfa, mediaTypes);
                if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                    return response;
                }
                driverName = kfa.getName();
                driverContent = this.decode(kfa.getContent());
            }
            catch (Exception ex) {
                return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)ex, RelationalMessages.Error.METADATA_SERVICE_REQUEST_PARSING_ERROR, new Object[0]);
            }
            if (driverName == null || driverContent == null) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.METADATA_SERVICE_DRIVER_ATTRIBUTES_MISSING, new Object[0]);
            }
            String tempDir = FileUtils.tempDirectory();
            String fileName = driverContent.hashCode() + "." + driverName;
            File driverFile = new File(tempDir, fileName);
            FileUtils.write((byte[])driverContent, (File)driverFile);
            this.getMetadataInstance().deployDataSourceDriver(driverName, driverFile);
            Thread.sleep(10000L);
            String title = RelationalMessages.getString((Enum)RelationalMessages.Info.DRIVER_DEPLOYMENT_STATUS_TITLE, (Object[])new Object[0]);
            KomodoStatusObject status = new KomodoStatusObject(title);
            status.addAttribute("deploymentSuccess", Boolean.FALSE.toString());
            if (this.hasDriver(driverName)) {
                status.addAttribute("deploymentSuccess", Boolean.TRUE.toString());
                status.addAttribute(driverName, RelationalMessages.getString((Enum)RelationalMessages.Info.DRIVER_SUCCESSFULLY_DEPLOYED, (Object[])new Object[0]));
            } else {
                status.addAttribute(driverName, RelationalMessages.getString((Enum)RelationalMessages.Info.DRIVER_SUCCESSFULLY_UPLOADED, (Object[])new Object[0]));
            }
            return this.commit(uow, mediaTypes, (KRestEntity)status);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponse(Response.Status.FORBIDDEN, mediaTypes, (Throwable)e, RelationalMessages.Error.METADATA_SERVICE_DEPLOY_DRIVER_ERROR, new Object[]{driverName});
        }
    }

    @DELETE
    @Path(value="driver/{driverName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Removes a driver from the teiid server")
    @ApiResponses(value={@ApiResponse(code=403, message="An error has occurred.")})
    public Response removeDriver(@javax.ws.rs.core.Context HttpHeaders headers, @javax.ws.rs.core.Context UriInfo uriInfo, @ApiParam(value="Name of the driver to be removed", required=true) @PathParam(value="driverName") String driverName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "unDeployTeiidDriver", false);
            this.getMetadataInstance().undeployDataSourceDriver(driverName);
            Thread.sleep(10000L);
            String title = RelationalMessages.getString((Enum)RelationalMessages.Info.DRIVER_DEPLOYMENT_STATUS_TITLE, (Object[])new Object[0]);
            KomodoStatusObject status = new KomodoStatusObject(title);
            if (!this.hasDriver(driverName)) {
                status.addAttribute(driverName, RelationalMessages.getString((Enum)RelationalMessages.Info.DRIVER_SUCCESSFULLY_UNDEPLOYED, (Object[])new Object[0]));
            } else {
                status.addAttribute(driverName, RelationalMessages.getString((Enum)RelationalMessages.Info.DRIVER_UNDEPLOYMENT_REQUEST_SENT, (Object[])new Object[0]));
            }
            return this.commit(uow, mediaTypes, (KRestEntity)status);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.METADATA_SERVICE_UNDEPLOY_DRIVER_ERROR, new Object[]{driverName});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="dataservice/{dataserviceName}/deployableStatus")
    @Produces(value={"application/json", "application/xml"})
    @ApiOperation(value="Get deployable status for a dataservice", response=KomodoStatusObject.class)
    @ApiResponses(value={@ApiResponse(code=404, message="No Dataservice could be found with name"), @ApiResponse(code=406, message="Only JSON or XML is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response getDataserviceDeployableStatus(@javax.ws.rs.core.Context HttpHeaders headers, @javax.ws.rs.core.Context UriInfo uriInfo, @ApiParam(value="Id of the data service", required=true) @PathParam(value="dataserviceName") String dataserviceName) throws KomodoRestException {
        Response response;
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        Connection connection = null;
        try {
            uow = this.createTransaction(principal, "getDeployableStatus", true);
            Dataservice dataservice = this.findDataservice(uow, dataserviceName);
            if (dataservice == null) {
                Response response2 = this.commitNoDataserviceFound(uow, mediaTypes, dataserviceName);
                return response2;
            }
            Vdb serviceVdb = dataservice.getServiceVdb(uow);
            String serviceVdbName = serviceVdb.getName(uow);
            TeiidVdb serverVdb = this.getMetadataInstance().getVdb(serviceVdbName);
            String deployableStatusMessage = "OK";
            if (serverVdb != null) {
                String serverVdbOwner = serverVdb.getPropertyValue("dsbOwner");
                if (serverVdbOwner != null) {
                    if (!serverVdbOwner.equals(uow.getUserName())) {
                        deployableStatusMessage = RelationalMessages.getString((Enum)RelationalMessages.Info.VDB_ALREADY_DEPLOYED_OWNER, (Object[])new Object[]{serviceVdbName, serverVdbOwner});
                    }
                } else {
                    deployableStatusMessage = RelationalMessages.getString((Enum)RelationalMessages.Info.VDB_ALREADY_DEPLOYED, (Object[])new Object[]{serviceVdbName});
                }
            }
            String title = RelationalMessages.getString((Enum)RelationalMessages.Info.DATA_SERVICE_DEPLOYABLE_STATUS_TITLE, (Object[])new Object[0]);
            KomodoStatusObject status = new KomodoStatusObject(title);
            status.addAttribute("deployableStatus", deployableStatusMessage);
            response = this.commit(uow, mediaTypes, (KRestEntity)status);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            Response response3 = this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.METADATA_SERVICE_GET_DATA_SERVICE_DEPLOYABLE_ERROR, new Object[]{dataserviceName});
            return response3;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return response;
    }

    @POST
    @Path(value="dataservice")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Deploy the data service to the teiid server")
    @ApiResponses(value={@ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response addDataservice(@javax.ws.rs.core.Context HttpHeaders headers, @javax.ws.rs.core.Context UriInfo uriInfo, @ApiParam(value="JSON of the properties of the data service:<br><pre>{<br>&nbsp;path: \"location of the data service in the workspace\"<br>}</pre>", required=true) String pathAttribute) throws KomodoRestException {
        KomodoPathAttribute kpa;
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        try {
            kpa = (KomodoPathAttribute)KomodoJsonMarshaller.unmarshall((String)pathAttribute, KomodoPathAttribute.class);
            if (kpa.getPath() == null) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.METADATA_SERVICE_DATA_SERVICE_MISSING_PATH, new Object[0]);
            }
        }
        catch (Exception ex) {
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)ex, RelationalMessages.Error.METADATA_SERVICE_REQUEST_PARSING_ERROR, new Object[0]);
        }
        Repository.UnitOfWork uow = null;
        try {
            Repository repo = this.kengine.getDefaultRepository();
            uow = this.createTransaction(principal, "deployTeiidDataservice", false);
            List dataServices = repo.searchByPath(uow, kpa.getPath());
            if (dataServices.size() == 0) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.METADATA_SERVICE_NO_DATA_SERVICE_FOUND, new Object[]{StringUtils.getLastToken((String)kpa.getPath(), (String)"/")});
            }
            Dataservice dataService = (Dataservice)this.getWorkspaceManager(uow).resolve(uow, dataServices.get(0), Dataservice.class);
            if (dataService == null) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.METADATA_SERVICE_NO_DATA_SERVICE_FOUND, new Object[]{StringUtils.getLastToken((String)kpa.getPath(), (String)"/")});
            }
            DeployStatus deployStatus = dataService.deploy(uow);
            Thread.sleep(10000L);
            String title = RelationalMessages.getString((Enum)RelationalMessages.Info.DATA_SERVICE_DEPLOYMENT_STATUS_TITLE, (Object[])new Object[0]);
            KomodoStatusObject status = new KomodoStatusObject(title);
            List progressMessages = deployStatus.getProgressMessages();
            for (int i = 0; i < progressMessages.size(); ++i) {
                status.addAttribute("ProgressMessage" + (i + 1), (String)progressMessages.get(i));
            }
            if (deployStatus.ok()) {
                status.addAttribute("deploymentSuccess", Boolean.TRUE.toString());
                status.addAttribute(dataService.getName(uow), RelationalMessages.getString((Enum)RelationalMessages.Info.DATA_SERVICE_SUCCESSFULLY_DEPLOYED, (Object[])new Object[0]));
            } else {
                status.addAttribute("deploymentSuccess", Boolean.FALSE.toString());
                List errorMessages = deployStatus.getErrorMessages();
                for (int i = 0; i < errorMessages.size(); ++i) {
                    status.addAttribute("ErrorMessage" + (i + 1), (String)errorMessages.get(i));
                }
                status.addAttribute(dataService.getName(uow), RelationalMessages.getString((Enum)RelationalMessages.Info.DATA_SERVICE_DEPLOYED_WITH_ERRORS, (Object[])new Object[0]));
            }
            return this.commit(uow, mediaTypes, (KRestEntity)status);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponse(Response.Status.FORBIDDEN, mediaTypes, (Throwable)e, RelationalMessages.Error.METADATA_SERVICE_DEPLOY_DATA_SERVICE_ERROR, new Object[0]);
        }
    }

    @POST
    @Path(value="connection")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Deploy the connection to the teiid server")
    @ApiResponses(value={@ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response addConnection(@javax.ws.rs.core.Context HttpHeaders headers, @javax.ws.rs.core.Context UriInfo uriInfo, @ApiParam(value="JSON of the properties of the connection:<br><pre>{<br>&nbsp;path: \"location of the connection in the workspace\"<br>}</pre>", required=true) String pathAttribute) throws KomodoRestException {
        KomodoPathAttribute kpa;
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        try {
            kpa = (KomodoPathAttribute)KomodoJsonMarshaller.unmarshall((String)pathAttribute, KomodoPathAttribute.class);
            if (kpa.getPath() == null) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.METADATA_SERVICE_CONNECTION_MISSING_PATH, new Object[0]);
            }
        }
        catch (Exception ex) {
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)ex, RelationalMessages.Error.METADATA_SERVICE_REQUEST_PARSING_ERROR, new Object[0]);
        }
        Repository.UnitOfWork uow = null;
        try {
            Repository repo = this.kengine.getDefaultRepository();
            uow = this.createTransaction(principal, "deployTeiidConnection", false);
            List connections = repo.searchByPath(uow, kpa.getPath());
            if (connections.size() == 0) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.METADATA_SERVICE_NO_CONNECTION_FOUND, new Object[0]);
            }
            org.komodo.relational.connection.Connection connection = (org.komodo.relational.connection.Connection)this.getWorkspaceManager(uow).resolve(uow, connections.get(0), org.komodo.relational.connection.Connection.class);
            if (connection == null) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.METADATA_SERVICE_NO_CONNECTION_FOUND, new Object[0]);
            }
            DeployStatus deployStatus = connection.deploy(uow);
            Thread.sleep(10000L);
            String title = RelationalMessages.getString((Enum)RelationalMessages.Info.CONNECTION_DEPLOYMENT_STATUS_TITLE, (Object[])new Object[0]);
            KomodoStatusObject status = new KomodoStatusObject(title);
            List progressMessages = deployStatus.getProgressMessages();
            for (int i = 0; i < progressMessages.size(); ++i) {
                status.addAttribute("ProgressMessage" + (i + 1), (String)progressMessages.get(i));
            }
            if (deployStatus.ok()) {
                status.addAttribute("deploymentSuccess", Boolean.TRUE.toString());
                status.addAttribute(connection.getName(uow), RelationalMessages.getString((Enum)RelationalMessages.Info.CONNECTION_SUCCESSFULLY_DEPLOYED, (Object[])new Object[0]));
            } else {
                status.addAttribute("deploymentSuccess", Boolean.FALSE.toString());
                List errorMessages = deployStatus.getErrorMessages();
                for (int i = 0; i < errorMessages.size(); ++i) {
                    status.addAttribute("ErrorMessage" + (i + 1), (String)errorMessages.get(i));
                }
                status.addAttribute(connection.getName(uow), RelationalMessages.getString((Enum)RelationalMessages.Info.CONNECTION_DEPLOYED_WITH_ERRORS, (Object[])new Object[0]));
            }
            return this.commit(uow, mediaTypes, (KRestEntity)status);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponse(Response.Status.FORBIDDEN, mediaTypes, (Throwable)e, RelationalMessages.Error.METADATA_SERVICE_DEPLOY_CONNECTION_ERROR, new Object[]{kpa.getPath()});
        }
    }

    @POST
    @Path(value="vdb")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Deploy the Vdb to the metadata server")
    @ApiResponses(value={@ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response addVdb(@javax.ws.rs.core.Context HttpHeaders headers, @javax.ws.rs.core.Context UriInfo uriInfo, @ApiParam(value="JSON of the properties of the vdb:<br><pre>{<br>&nbsp;path: \"location of the data service in the workspace\"<br>}</pre>", required=true) String pathAttribute) throws KomodoRestException {
        KomodoPathAttribute kpa;
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        try {
            kpa = (KomodoPathAttribute)KomodoJsonMarshaller.unmarshall((String)pathAttribute, KomodoPathAttribute.class);
            if (kpa.getPath() == null) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.METADATA_SERVICE_VDB_MISSING_PATH, new Object[0]);
            }
        }
        catch (Exception ex) {
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)ex, RelationalMessages.Error.METADATA_SERVICE_REQUEST_PARSING_ERROR, new Object[0]);
        }
        Repository.UnitOfWork uow = null;
        try {
            Repository repo = this.kengine.getDefaultRepository();
            uow = this.createTransaction(principal, "deployVdb", false);
            List vdbs = repo.searchByPath(uow, kpa.getPath());
            if (vdbs.size() == 0) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.METADATA_SERVICE_NO_VDB_FOUND, new Object[0]);
            }
            Vdb vdb = (Vdb)this.getWorkspaceManager(uow).resolve(uow, vdbs.get(0), Vdb.class);
            if (vdb == null) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.METADATA_SERVICE_NO_VDB_FOUND, new Object[0]);
            }
            DeployStatus deployStatus = vdb.deploy(uow);
            Thread.sleep(10000L);
            String title = RelationalMessages.getString((Enum)RelationalMessages.Info.VDB_DEPLOYMENT_STATUS_TITLE, (Object[])new Object[0]);
            KomodoStatusObject status = new KomodoStatusObject(title);
            List progressMessages = deployStatus.getProgressMessages();
            for (int i = 0; i < progressMessages.size(); ++i) {
                status.addAttribute("ProgressMessage" + (i + 1), (String)progressMessages.get(i));
            }
            if (deployStatus.ok()) {
                status.addAttribute("deploymentSuccess", Boolean.TRUE.toString());
                status.addAttribute(vdb.getName(uow), RelationalMessages.getString((Enum)RelationalMessages.Info.VDB_SUCCESSFULLY_DEPLOYED, (Object[])new Object[0]));
            } else {
                status.addAttribute("deploymentSuccess", Boolean.FALSE.toString());
                List errorMessages = deployStatus.getErrorMessages();
                for (int i = 0; i < errorMessages.size(); ++i) {
                    status.addAttribute("ErrorMessage" + (i + 1), (String)errorMessages.get(i));
                }
                status.addAttribute(vdb.getName(uow), RelationalMessages.getString((Enum)RelationalMessages.Info.VDB_DEPLOYED_WITH_ERRORS, (Object[])new Object[0]));
            }
            return this.commit(uow, mediaTypes, (KRestEntity)status);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponse(Response.Status.FORBIDDEN, mediaTypes, (Throwable)e, RelationalMessages.Error.METADATA_SERVICE_DEPLOY_VDB_ERROR, new Object[0]);
        }
    }

    private String extractServiceVdbName(Repository.UnitOfWork uow, WorkspaceManager mgr, String dsPath) throws KException {
        Repository repo = this.kengine.getDefaultRepository();
        KomodoObject dsObject = repo.getFromWorkspace(uow, dsPath);
        if (dsObject == null) {
            return null;
        }
        Dataservice dService = (Dataservice)mgr.resolve(uow, (Object)dsObject, Dataservice.class);
        if (dService == null) {
            return null;
        }
        Vdb vdb = dService.getServiceVdb(uow);
        if (vdb == null) {
            return null;
        }
        return vdb.getVdbName(uow);
    }

    @POST
    @Path(value="query")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Pass a query to the teiid server")
    @ApiResponses(value={@ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response query(@javax.ws.rs.core.Context HttpHeaders headers, @javax.ws.rs.core.Context UriInfo uriInfo, @ApiParam(value="JSON of the properties of the query:<br><pre>{<br>&nbsp;query: \"SQL formatted query to interrogate the target\",<br>&nbsp;target: \"The name of the target to be queried\"<br>&nbsp;<pre-cmt class=\"json-comment\">(The target can be a vdb or data service. If the latter &nbsp;then the name of the service vdb is extracted and &nbsp;replaces the data service)</pre-cmt>,<br>&nbsp;limit: Add a limit on number of results to be returned,<br>&nbsp;offset: The index of the result to begin the results with<br>}</pre>", required=true) String queryAttribute) throws KomodoRestException {
        KomodoQueryAttribute kqa;
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        try {
            kqa = (KomodoQueryAttribute)KomodoJsonMarshaller.unmarshall((String)queryAttribute, KomodoQueryAttribute.class);
            if (kqa.getQuery() == null) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.METADATA_SERVICE_QUERY_MISSING_QUERY, new Object[0]);
            }
            if (kqa.getTarget() == null) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.METADATA_SERVICE_QUERY_MISSING_TARGET, new Object[0]);
            }
        }
        catch (Exception ex) {
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)ex, RelationalMessages.Error.METADATA_SERVICE_REQUEST_PARSING_ERROR, new Object[0]);
        }
        Repository.UnitOfWork uow = null;
        try {
            TeiidVdb vdb;
            uow = this.createTransaction(principal, "queryTeiidservice", true);
            WorkspaceManager mgr = this.getWorkspaceManager(uow);
            String target = kqa.getTarget();
            String query = kqa.getQuery();
            String vdbName = this.extractServiceVdbName(uow, mgr, target);
            if (vdbName == null) {
                vdbName = target;
            }
            if ((vdb = this.getMetadataInstance().getVdb(vdbName)) == null) {
                return this.createErrorResponse(Response.Status.FORBIDDEN, mediaTypes, RelationalMessages.Error.METADATA_SERVICE_QUERY_TARGET_NOT_DEPLOYED, new Object[0]);
            }
            LOGGER.debug("Establishing query service for query {0} on vdb {1}", new Object[]{query, vdbName});
            QSResult result = this.getMetadataInstance().query(vdbName, query, kqa.getOffset(), kqa.getLimit());
            RestQueryResult restResult = new RestQueryResult(result);
            return this.commit(uow, mediaTypes, (KRestEntity)restResult);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponse(Response.Status.FORBIDDEN, mediaTypes, RelationalMessages.Error.METADATA_SERVICE_QUERY_ERROR, new Object[]{e.getLocalizedMessage()});
        }
    }

    private boolean isJdbc(TeiidDataSource dataSource) {
        return dataSource.getPropertyValue("bob") != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @POST
    @Path(value="connections/Tables")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get table names for a jdbc connection")
    @ApiResponses(value={@ApiResponse(code=404, message="No Connection could be found with name"), @ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response getConnectionJdbcTables(@javax.ws.rs.core.Context HttpHeaders headers, @javax.ws.rs.core.Context UriInfo uriInfo, @ApiParam(value="JSON of the properties of the data source jdbc tables:<br><pre>{<br>&nbsp;dataSourceName: \"data source name\",<br>&nbsp;catalogFilter: \"catalog filter\",<br>&nbsp;schemaFilter: \"schema filter\",<br>&nbsp;tableFilter: \"table filter\",<br>}</pre>", required=true) String jdbcTableAttributes) throws KomodoRestException {
        KomodoDataSourceJdbcTableAttributes attr;
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        Connection connection = null;
        try {
            attr = (KomodoDataSourceJdbcTableAttributes)KomodoJsonMarshaller.unmarshall((String)jdbcTableAttributes, KomodoDataSourceJdbcTableAttributes.class);
            Response response = this.checkJdbcTableAttributes(attr, mediaTypes);
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                return response;
            }
        }
        catch (Exception ex) {
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)ex, RelationalMessages.Error.METADATA_SERVICE_UPDATE_REQUEST_PARSING_ERROR, new Object[0]);
        }
        try {
            uow = this.createTransaction(principal, "getConnectionJdbcTables", true);
            TeiidDataSource dataSource = this.getMetadataInstance().getDataSource(attr.getDataSourceName());
            if (dataSource == null) {
                Response response = this.commitNoConnectionFound(uow, mediaTypes, attr.getDataSourceName());
                return response;
            }
            boolean isJdbc = this.isJdbc(dataSource);
            if (!isJdbc) {
                Response response = this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.METADATA_SERVICE_GET_DATA_SOURCE_NOT_JDBC_ERROR, new Object[0]);
                return response;
            }
            try {
                connection = this.getJdbcConnection(dataSource.getJndiName());
            }
            catch (Exception ex) {
                Response response = this.createErrorResponseWithForbidden(mediaTypes, (Throwable)ex, RelationalMessages.Error.METADATA_SERVICE_GET_DATA_SOURCE_CONNECTION_ERROR, new Object[0]);
                try {
                    if (connection == null) return response;
                    connection.close();
                    return response;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                return response;
            }
            KomodoStatusObject kso = new KomodoStatusObject();
            try {
                String catFilter = attr.getCatalogFilter().isEmpty() ? null : attr.getCatalogFilter();
                String schemaFilter = attr.getSchemaFilter().isEmpty() ? null : attr.getSchemaFilter();
                String tableFilter = attr.getTableFilter();
                List tableNames = this.getTableNames(connection, catFilter, schemaFilter, tableFilter);
                for (int i = 0; i < tableNames.size(); ++i) {
                    kso.addAttribute("Table" + (i + 1), (String)tableNames.get(i));
                }
            }
            catch (Exception ex) {
                Response response = this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.METADATA_SERVICE_GET_DATA_SOURCE_TABLE_FETCH_ERROR, new Object[0]);
                try {
                    if (connection == null) return response;
                    connection.close();
                    return response;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                return response;
            }
            Response response = this.commit(uow, mediaTypes, (KRestEntity)kso);
            return response;
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            Response response = this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.METADATA_SERVICE_GET_DATA_SOURCE_TABLES_ERROR, new Object[0]);
            return response;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="connections/{connectionName}/JdbcCatalogSchema")
    @Produces(value={"application/json", "application/xml"})
    @ApiOperation(value="Get catalog and schema info for a jdbc connection", response=RestMetadataDataSourceJdbcCatalogSchemaInfo[].class)
    @ApiResponses(value={@ApiResponse(code=404, message="No Connection could be found with name"), @ApiResponse(code=406, message="Only JSON or XML is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response getDatasourceJdbcCatalogSchemaInfo(@javax.ws.rs.core.Context HttpHeaders headers, @javax.ws.rs.core.Context UriInfo uriInfo, @ApiParam(value="Id of the connection", required=true) @PathParam(value="connectionName") String connectionName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        Connection connection = null;
        try {
            uow = this.createTransaction(principal, "getConnectionJdbcTables", true);
            TeiidDataSource dataSource = this.getMetadataInstance().getDataSource(connectionName);
            if (dataSource == null) {
                Response response = this.commitNoConnectionFound(uow, mediaTypes, connectionName);
                return response;
            }
            if (!this.isJdbc(dataSource)) {
                Response response = this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.METADATA_SERVICE_GET_DATA_SOURCE_NOT_JDBC_ERROR, new Object[0]);
                return response;
            }
            try {
                connection = this.getJdbcConnection(dataSource.getJndiName());
            }
            catch (Exception ex) {
                Response response = this.createErrorResponseWithForbidden(mediaTypes, (Throwable)ex, RelationalMessages.Error.METADATA_SERVICE_GET_DATA_SOURCE_CONNECTION_ERROR, new Object[0]);
                try {
                    if (connection == null) return response;
                    connection.close();
                    return response;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                return response;
            }
            List entities = this.generateCatalogSchemaInfos(connection);
            Response response = this.commit(uow, mediaTypes, entities);
            return response;
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            Response response = this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.METADATA_SERVICE_GET_DATA_SOURCE_CATALOG_SCHEMA_ERROR, new Object[0]);
            return response;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private List<RestMetadataDataSourceJdbcCatalogSchemaInfo> generateCatalogSchemaInfos(Connection connection) throws KException {
        ArrayList<RestMetadataDataSourceJdbcCatalogSchemaInfo> infos;
        block17: {
            ArgCheck.isNotNull((Object)connection, (String)"connection");
            infos = new ArrayList<RestMetadataDataSourceJdbcCatalogSchemaInfo>();
            try {
                boolean supportsSchemas;
                DatabaseMetaData metaData = connection.getMetaData();
                boolean supportsCatalogs = metaData.supportsCatalogsInTableDefinitions() || metaData.supportsCatalogsInProcedureCalls() || metaData.supportsCatalogsInDataManipulation();
                boolean bl = supportsSchemas = metaData.supportsSchemasInTableDefinitions() || metaData.supportsSchemasInDataManipulation();
                if (supportsCatalogs && supportsSchemas) {
                    ResultSet rs = connection.getMetaData().getCatalogs();
                    ArrayList<String> allCats = new ArrayList<String>();
                    while (rs.next()) {
                        String catalog = rs.getString(1);
                        allCats.add(catalog);
                    }
                    rs.close();
                    Collections.sort(allCats, String.CASE_INSENSITIVE_ORDER);
                    HashMap catalogSchemaMap = new HashMap();
                    for (String string : allCats) {
                        ResultSet rs2;
                        try {
                            rs2 = connection.getMetaData().getSchemas(string, null);
                        }
                        catch (Exception ex) {
                            if (allCats.size() != 1) continue;
                            try {
                                rs2 = connection.getMetaData().getSchemas();
                            }
                            catch (Exception ex1) {
                                continue;
                            }
                        }
                        ArrayList<String> schemaList = new ArrayList<String>();
                        while (rs2.next()) {
                            String schemaName = rs2.getString(1);
                            schemaList.add(schemaName);
                        }
                        Collections.sort(schemaList, String.CASE_INSENSITIVE_ORDER);
                        catalogSchemaMap.put(string, schemaList);
                        rs2.close();
                    }
                    ArrayList catNames = new ArrayList(catalogSchemaMap.keySet());
                    Collections.sort(catNames, String.CASE_INSENSITIVE_ORDER);
                    for (String catName : catNames) {
                        RestMetadataDataSourceJdbcCatalogSchemaInfo info = new RestMetadataDataSourceJdbcCatalogSchemaInfo();
                        info.setItemName(catName);
                        info.setItemType(CATALOG);
                        info.setCatalogSchemaNames((Collection)catalogSchemaMap.get(catName));
                        infos.add(info);
                    }
                    break block17;
                }
                if (supportsCatalogs && !supportsSchemas) {
                    ResultSet resultSet = connection.getMetaData().getCatalogs();
                    ArrayList<String> allCats = new ArrayList<String>();
                    while (resultSet.next()) {
                        String catalog = resultSet.getString(1);
                        allCats.add(catalog);
                    }
                    resultSet.close();
                    Collections.sort(allCats, String.CASE_INSENSITIVE_ORDER);
                    for (String cat : allCats) {
                        RestMetadataDataSourceJdbcCatalogSchemaInfo restMetadataDataSourceJdbcCatalogSchemaInfo = new RestMetadataDataSourceJdbcCatalogSchemaInfo();
                        restMetadataDataSourceJdbcCatalogSchemaInfo.setItemName(cat);
                        restMetadataDataSourceJdbcCatalogSchemaInfo.setItemType(CATALOG);
                        infos.add(restMetadataDataSourceJdbcCatalogSchemaInfo);
                    }
                    break block17;
                }
                if (supportsSchemas && !supportsCatalogs) {
                    ResultSet resultSet = connection.getMetaData().getSchemas();
                    ArrayList<String> allSchemas = new ArrayList<String>();
                    while (resultSet.next()) {
                        String schema = resultSet.getString(1);
                        allSchemas.add(schema);
                    }
                    resultSet.close();
                    Collections.sort(allSchemas, String.CASE_INSENSITIVE_ORDER);
                    for (String sch : allSchemas) {
                        RestMetadataDataSourceJdbcCatalogSchemaInfo restMetadataDataSourceJdbcCatalogSchemaInfo = new RestMetadataDataSourceJdbcCatalogSchemaInfo();
                        restMetadataDataSourceJdbcCatalogSchemaInfo.setItemName(sch);
                        restMetadataDataSourceJdbcCatalogSchemaInfo.setItemType(SCHEMA);
                        infos.add(restMetadataDataSourceJdbcCatalogSchemaInfo);
                    }
                    break block17;
                }
                throw new Exception(RelationalMessages.getString((Enum)RelationalMessages.Error.METADATA_SERVICE_GET_DATA_SOURCE_UNRECOGNISED_JDBC_SOURCE, (Object[])new Object[0]));
            }
            catch (Exception e) {
                throw new KException((Throwable)e);
            }
        }
        return infos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="connections/{connectionName}/JdbcInfo")
    @Produces(value={"application/json", "application/xml"})
    @ApiOperation(value="Get info for a jdbc source", response=RestConnectionJdbcInfo.class)
    @ApiResponses(value={@ApiResponse(code=404, message="No Connection could be found with name"), @ApiResponse(code=406, message="Only JSON or XML is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response getConnectionJdbcInfo(@javax.ws.rs.core.Context HttpHeaders headers, @javax.ws.rs.core.Context UriInfo uriInfo, @ApiParam(value="Id of the connection", required=true) @PathParam(value="connectionName") String connectionName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        Connection connection = null;
        try {
            uow = this.createTransaction(principal, "getConnectionJdbcTables", true);
            TeiidDataSource dataSource = this.getMetadataInstance().getDataSource(connectionName);
            if (dataSource == null) {
                Response response = this.commitNoConnectionFound(uow, mediaTypes, connectionName);
                return response;
            }
            if (!this.isJdbc(dataSource)) {
                Response response = this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.METADATA_SERVICE_GET_DATA_SOURCE_NOT_JDBC_ERROR, new Object[0]);
                return response;
            }
            try {
                connection = this.getJdbcConnection(dataSource.getJndiName());
            }
            catch (Exception ex) {
                Response response = this.createErrorResponseWithForbidden(mediaTypes, (Throwable)ex, RelationalMessages.Error.METADATA_SERVICE_GET_DATA_SOURCE_CONNECTION_ERROR, new Object[0]);
                try {
                    if (connection == null) return response;
                    connection.close();
                    return response;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                return response;
            }
            RestConnectionJdbcInfo info = new RestConnectionJdbcInfo();
            try {
                this.populateJdbcInfo(connection, info);
            }
            catch (Exception ex) {
                Response response = this.createErrorResponseWithForbidden(mediaTypes, (Throwable)ex, RelationalMessages.Error.METADATA_SERVICE_GET_DATA_SOURCE_JDBC_INFO_FAILURE, new Object[0]);
                try {
                    if (connection == null) return response;
                    connection.close();
                    return response;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                return response;
            }
            Response response = this.commit(uow, mediaTypes, (KRestEntity)info);
            return response;
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            Response response = this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.METADATA_SERVICE_GET_DATA_SOURCE_JDBC_INFO_FAILURE, new Object[0]);
            return response;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private void populateJdbcInfo(Connection connection, RestConnectionJdbcInfo jdbcInfo) throws KException {
        ArgCheck.isNotNull((Object)connection, (String)"connection");
        ArgCheck.isNotNull((Object)jdbcInfo, (String)"jdbcInfo");
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            String productName = metaData.getDatabaseProductName();
            String productVersion = metaData.getDatabaseProductVersion();
            String driverName = metaData.getDriverName();
            int majorVersion = metaData.getDriverMajorVersion();
            int minorVersion = metaData.getDriverMinorVersion();
            String url = metaData.getURL();
            boolean readonly = metaData.isReadOnly();
            String userName = metaData.getUserName();
            boolean supportsCatalogs = metaData.supportsCatalogsInTableDefinitions() || metaData.supportsCatalogsInProcedureCalls() || metaData.supportsCatalogsInDataManipulation();
            boolean supportsSchemas = metaData.supportsSchemasInTableDefinitions() || metaData.supportsSchemasInDataManipulation();
            jdbcInfo.setProductName(productName);
            jdbcInfo.setProductVersion(productVersion);
            jdbcInfo.setDriverUrl(url);
            jdbcInfo.setReadonly(readonly);
            jdbcInfo.setDriverName(driverName);
            jdbcInfo.setDriverMajorVersion(majorVersion);
            jdbcInfo.setDriverMinorVersion(minorVersion);
            jdbcInfo.setUsername(userName);
            jdbcInfo.setSupportsCatalogs(supportsCatalogs);
            jdbcInfo.setSupportsSchemas(supportsSchemas);
        }
        catch (Exception e) {
            throw new KException((Throwable)e);
        }
    }

    private List<String> getTableNames(Connection connection, String catalogName, String schemaName, String tableFilter) throws KException {
        ArgCheck.isNotNull((Object)connection, (String)"connection");
        ArrayList<String> tableNameList = new ArrayList<String>();
        try {
            ResultSet resultSet = connection.getMetaData().getTables(catalogName, schemaName, tableFilter, new String[]{"DOCUMENT", "TABLE", "VIEW"});
            int columnCount = resultSet.getMetaData().getColumnCount();
            while (resultSet.next()) {
                String tableName = null;
                for (int i = 1; i <= columnCount; ++i) {
                    String colName = resultSet.getMetaData().getColumnName(i);
                    String value = resultSet.getString(i);
                    if (colName.equalsIgnoreCase(TABLE_NAME)) {
                        tableName = value;
                    }
                    if (tableName != null) break;
                }
                tableNameList.add(tableName);
            }
            resultSet.close();
        }
        catch (Exception e) {
            throw new KException((Throwable)e);
        }
        return tableNameList;
    }

    private boolean isDataSource(String className) {
        if (className == null) {
            return false;
        }
        return className.endsWith("DataSource");
    }

    private Connection getJdbcConnection(String jndiName) throws KException {
        String jdbcContext = jndiName.substring(0, jndiName.lastIndexOf(47) + 1);
        if (this.initialContext == null) {
            try {
                this.initialContext = new InitialContext();
            }
            catch (Exception e) {
                throw new KException((Throwable)e);
            }
        }
        DataSource jdbcDataSource = null;
        NamingEnumeration<NameClassPair> ne = null;
        try {
            Context theJdbcContext = (Context)this.initialContext.lookup(jdbcContext);
            ne = theJdbcContext.list("");
        }
        catch (NamingException e1) {
            throw new KException((Throwable)e1);
        }
        while (ne != null && ne.hasMoreElements()) {
            String jdbcObjectName;
            NameClassPair o = (NameClassPair)ne.nextElement();
            String className = o.getClassName();
            if (!this.isDataSource(className) || !(jdbcObjectName = jdbcContext + o.getName()).equals(jndiName)) continue;
            try {
                Object jdbcObject = this.initialContext.lookup(jdbcContext + o.getName());
                if (jdbcObject == null || !(jdbcObject instanceof DataSource)) continue;
                jdbcDataSource = (DataSource)jdbcObject;
                break;
            }
            catch (NamingException e1) {
                throw new KException((Throwable)e1);
            }
        }
        if (jdbcDataSource == null) {
            throw new KException(RelationalMessages.getString((Enum)RelationalMessages.Error.METADATA_SERVICE_GET_DATA_SOURCE_INSTANTIATION_FAILURE, (Object[])new Object[0]));
        }
        try {
            return jdbcDataSource.getConnection();
        }
        catch (SQLException ex) {
            throw new KException((Throwable)ex);
        }
    }

    private void loadDriverTranslatorMap() {
        Document doc;
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(DRIVER_TRANSLATOR_MAPPING_FILE);
        if (inputStream == null) {
            LOGGER.error(RelationalMessages.getString((Enum)RelationalMessages.Error.METADATA_SERVICE_DEFAULT_TRANSLATOR_MAPPINGS_NOT_FOUND_ERROR, (Object[])new Object[0]), new Object[0]);
            return;
        }
        this.driverTranslatorMap.clear();
        try {
            String mappingXml = FileUtils.streamToString((InputStream)inputStream);
            doc = FileUtils.createDocument((String)mappingXml);
        }
        catch (Exception ex) {
            LOGGER.error(RelationalMessages.getString((Enum)RelationalMessages.Error.METADATA_SERVICE_LOAD_DEFAULT_TRANSLATOR_MAPPINGS_ERROR, (Object[])new Object[]{ex.getLocalizedMessage()}), new Object[0]);
            return;
        }
        Node mappingsNode = doc.getChildNodes().item(0);
        if (mappingsNode.getNodeType() != 1) {
            return;
        }
        NodeList translatorNodes = ((Element)mappingsNode).getElementsByTagName(ELEM_TRANSLATOR);
        for (int i = 0; i < translatorNodes.getLength(); ++i) {
            Node translatorNode = translatorNodes.item(i);
            String driver = translatorNode.getAttributes().getNamedItem(ATTR_DRIVER).getTextContent();
            String translator = translatorNode.getTextContent();
            this.driverTranslatorMap.put(driver, translator);
        }
    }

    private void loadUrlContentTranslatorMap() {
        Document doc;
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(URLCONTENT_TRANSLATOR_MAPPING_FILE);
        if (inputStream == null) {
            LOGGER.error(RelationalMessages.getString((Enum)RelationalMessages.Error.METADATA_SERVICE_DEFAULT_TRANSLATOR_MAPPINGS_NOT_FOUND_ERROR, (Object[])new Object[0]), new Object[0]);
            return;
        }
        this.urlContentTranslatorMap.clear();
        try {
            String mappingXml = FileUtils.streamToString((InputStream)inputStream);
            doc = FileUtils.createDocument((String)mappingXml);
        }
        catch (Exception ex) {
            LOGGER.error(RelationalMessages.getString((Enum)RelationalMessages.Error.METADATA_SERVICE_LOAD_DEFAULT_TRANSLATOR_MAPPINGS_ERROR, (Object[])new Object[]{ex.getLocalizedMessage()}), new Object[0]);
            return;
        }
        Node mappingsNode = doc.getChildNodes().item(0);
        if (mappingsNode.getNodeType() != 1) {
            return;
        }
        NodeList translatorNodes = ((Element)mappingsNode).getElementsByTagName(ELEM_TRANSLATOR);
        for (int i = 0; i < translatorNodes.getLength(); ++i) {
            Node translatorNode = translatorNodes.item(i);
            String urlContent = translatorNode.getAttributes().getNamedItem(ATTR_URLCONTENT).getTextContent();
            String translator = translatorNode.getTextContent();
            this.urlContentTranslatorMap.put(urlContent, translator);
        }
    }

    @GET
    @Path(value="templates")
    @Produces(value={"application/json"})
    @ApiOperation(value="Display the collection of templates", response=RestMetadataTemplate[].class)
    @ApiResponses(value={@ApiResponse(code=403, message="An error has occurred.")})
    public Response getConnectionTemplates(@javax.ws.rs.core.Context HttpHeaders headers, @javax.ws.rs.core.Context UriInfo uriInfo) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            Repository repo = this.kengine.getDefaultRepository();
            uow = this.createTransaction(principal, "getTemplates", true);
            Set templateNames = this.getMetadataInstance().getDataSourceTemplateNames();
            LOGGER.debug("getTemplates:found '{0}' Templates", new Object[]{templateNames.size()});
            ArrayList<RestMetadataTemplate> entities = new ArrayList<RestMetadataTemplate>();
            for (String template : templateNames) {
                Collection propertyDefns = this.getMetadataInstance().getTemplatePropertyDefns(template);
                RestMetadataTemplate entity = this.entityFactory.createMetadataTemplate(uow, repo, template, propertyDefns, uriInfo.getBaseUri());
                entities.add(entity);
                LOGGER.debug("getTemplates:Template '{0}' entity was constructed", new Object[]{template});
            }
            return this.commit(uow, mediaTypes, entities);
        }
        catch (CallbackTimeoutException ex) {
            return this.createTimeoutResponse(mediaTypes);
        }
        catch (Throwable e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, e, RelationalMessages.Error.METADATA_SERVICE_GET_TEMPLATES_ERROR, new Object[0]);
        }
    }

    @GET
    @Path(value="templates/{templateName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find connection template by name", response=RestMetadataTemplate.class)
    @ApiResponses(value={@ApiResponse(code=404, message="No template could be found with name"), @ApiResponse(code=406, message="Only JSON returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response getConnectionTemplate(@javax.ws.rs.core.Context HttpHeaders headers, @javax.ws.rs.core.Context UriInfo uriInfo, @ApiParam(value="Name of the template", required=true) @PathParam(value="templateName") String templateName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            Repository repo = this.kengine.getDefaultRepository();
            uow = this.createTransaction(principal, "getTemplates", true);
            Set templateNames = this.getMetadataInstance().getDataSourceTemplateNames();
            if (templateNames == null || templateNames.isEmpty()) {
                return this.commitNoTemplateFound(uow, mediaTypes, templateName);
            }
            if (!templateNames.contains(templateName)) {
                return this.commitNoTemplateFound(uow, mediaTypes, templateName);
            }
            Collection propertyDefns = this.getMetadataInstance().getTemplatePropertyDefns(templateName);
            RestMetadataTemplate restTemplate = this.entityFactory.createMetadataTemplate(uow, repo, templateName, propertyDefns, uriInfo.getBaseUri());
            LOGGER.debug("getConnectionTemplate:Template '{0}' entity was constructed", new Object[]{templateName});
            return this.commit(uow, mediaTypes, (KRestEntity)restTemplate);
        }
        catch (CallbackTimeoutException ex) {
            return this.createTimeoutResponse(mediaTypes);
        }
        catch (Throwable e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, e, RelationalMessages.Error.METADATA_SERVICE_GET_TEMPLATE_ERROR, new Object[0]);
        }
    }

    @GET
    @Path(value="templates/{templateName}/entries")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find the template entries of the named template", response=RestMetadataTemplateEntry[].class)
    @ApiResponses(value={@ApiResponse(code=404, message="No template could be found with name"), @ApiResponse(code=406, message="Only JSON returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response getConnectionTemplateEntries(@javax.ws.rs.core.Context HttpHeaders headers, @javax.ws.rs.core.Context UriInfo uriInfo, @ApiParam(value="Name of the template", required=true) @PathParam(value="templateName") String templateName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            Repository repo = this.kengine.getDefaultRepository();
            uow = this.createTransaction(principal, "getTemplateEntries", true);
            Set templateNames = this.getMetadataInstance().getDataSourceTemplateNames();
            if (templateNames == null || templateNames.isEmpty()) {
                return this.commitNoTemplateFound(uow, mediaTypes, templateName);
            }
            if (!templateNames.contains(templateName)) {
                return this.commitNoTemplateFound(uow, mediaTypes, templateName);
            }
            ArrayList propertyDefns = new ArrayList();
            propertyDefns.addAll(this.getMetadataInstance().getTemplatePropertyDefns(templateName));
            Collections.sort(propertyDefns, new TeiidPropertyDefinitionComparator(null));
            List<String> priorityNames = Arrays.asList(PRIORITY_TEMPLATE_NAMES);
            List entities = this.entityFactory.createMetadataTemplateEntry(uow, repo, propertyDefns, uriInfo.getBaseUri());
            for (RestMetadataTemplateEntry entity : entities) {
                if (!priorityNames.contains(entity.getId())) continue;
                entity.setRequired(true);
            }
            return this.commit(uow, mediaTypes, entities);
        }
        catch (CallbackTimeoutException ex) {
            return this.createTimeoutResponse(mediaTypes);
        }
        catch (Throwable e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, e, RelationalMessages.Error.METADATA_SERVICE_GET_TEMPLATE_ENTRIES_ERROR, new Object[0]);
        }
    }

    static /* synthetic */ String[] access$000() {
        return PRIORITY_TEMPLATE_NAMES;
    }
}

