/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.service;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.komodo.core.KEngine;
import org.komodo.core.internal.repository.search.Clause;
import org.komodo.core.internal.repository.search.ComparisonOperator;
import org.komodo.core.internal.repository.search.ContainsClause;
import org.komodo.core.internal.repository.search.ObjectSearcher;
import org.komodo.core.repository.KomodoTypeRegistry;
import org.komodo.core.repository.RepositoryTools;
import org.komodo.rest.KRestEntity;
import org.komodo.rest.KomodoRestException;
import org.komodo.rest.KomodoService;
import org.komodo.rest.RestBasicEntity;
import org.komodo.rest.relational.RelationalMessages;
import org.komodo.rest.relational.json.KomodoJsonMarshaller;
import org.komodo.rest.relational.request.KomodoSearcherAttributes;
import org.komodo.rest.relational.response.KomodoSavedSearcher;
import org.komodo.rest.relational.response.KomodoStatusObject;
import org.komodo.spi.KException;
import org.komodo.spi.query.LogicalOperator;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.KomodoType;
import org.komodo.spi.repository.Repository;

@Path(value="workspace/search")
@Api(tags={"search"})
public final class KomodoSearchService
extends KomodoService {
    public KomodoSearchService(KEngine engine) throws WebApplicationException {
        super(engine);
    }

    private String convertType(String type) {
        if (type == null) {
            return "nt:unstructured";
        }
        KomodoType kType = KomodoType.getKomodoType((String)type);
        if (kType == null || KomodoType.UNKNOWN.equals((Object)kType)) {
            return type;
        }
        KomodoTypeRegistry.TypeIdentifier identifier = KomodoTypeRegistry.getInstance().getIdentifier(kType);
        String lexiconType = identifier.getLexiconType();
        if (lexiconType != null) {
            return lexiconType;
        }
        return "nt:unstructured";
    }

    private ObjectSearcher createObjectSearcher(String type, String parent, String ancestor, String path, String contains, String name) throws KException {
        Repository repo = this.kengine.getDefaultRepository();
        String ALIAS = "nt";
        ObjectSearcher os = new ObjectSearcher(repo);
        os.setFromType(this.convertType(type), "nt");
        LogicalOperator operator = null;
        if (parent != null) {
            os.addWhereParentClause(null, "nt", parent, true);
            operator = LogicalOperator.AND;
        }
        if (ancestor != null) {
            os.addWhereParentClause(null, "nt", ancestor, false);
            operator = LogicalOperator.AND;
        }
        if (path != null) {
            os.addWherePathClause(operator, "nt", path);
            operator = LogicalOperator.AND;
        }
        if (contains != null) {
            ContainsClause clause1 = new ContainsClause(operator, "nt", "*", Repository.KeywordCriteria.ANY, new String[]{"*" + contains + "*"});
            os.addWhereClause((Clause)clause1);
            operator = LogicalOperator.AND;
        }
        if (name != null) {
            os.addWhereCompareClause(operator, "nt", "mode:localName", ComparisonOperator.LIKE, name);
            operator = LogicalOperator.AND;
        }
        return os;
    }

    private Response checkSearchAttributes(String searchName, String type, String path, String parent, String ancestor, String contains, String objectName, List<MediaType> mediaTypes) {
        if (searchName == null && type == null && path == null && parent == null && ancestor == null && contains == null && objectName == null) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.SEARCH_SERVICE_NO_PARAMETERS_ERROR, new Object[0]);
        }
        if (parent != null && ancestor != null) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.SEARCH_SERVICE_PARENT_ANCESTOR_EXCLUSIVE_ERROR, new Object[0]);
        }
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Search the workspace using criteria", response=RestBasicEntity[].class)
    @ApiResponses(value={@ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response searchWorkspace(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Execute a search already saved in the repository", required=false) @QueryParam(value="searchName") String searchName, @ApiParam(value="Type of object to search for", required=false) @QueryParam(value="type") String type, @ApiParam(value="The data path of the parent object", required=false) @QueryParam(value="parent") String parent, @ApiParam(value="The data path of the ancestor object", required=false) @QueryParam(value="ancestor") String ancestor, @ApiParam(value="The data path of a specific object", required=false) @QueryParam(value="path") String path, @ApiParam(value="Search term for object with a property that contains value", required=false) @QueryParam(value="contains") String contains, @ApiParam(value="The name of an object. Can use '%' as wildcards for broadening searches", required=false) @QueryParam(value="objectName") String objectName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        Response response = this.checkSearchAttributes(searchName, type, path, parent, ancestor, contains, objectName, mediaTypes);
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            return response;
        }
        Repository.UnitOfWork uow = null;
        try {
            ObjectSearcher os;
            Repository repo = this.kengine.getDefaultRepository();
            uow = this.createTransaction(principal, "objectFromWorkspace", true);
            if (searchName != null) {
                os = new ObjectSearcher(repo);
                os.read(uow, searchName);
            } else {
                os = this.createObjectSearcher(type, parent, ancestor, path, contains, objectName);
            }
            List searchObjects = os.searchObjects(uow);
            ArrayList<RestBasicEntity> entities = new ArrayList<RestBasicEntity>();
            for (KomodoObject kObject : searchObjects) {
                RestBasicEntity entity = this.entityFactory.create(kObject, uriInfo.getBaseUri(), uow);
                if (entity == null) continue;
                entities.add(entity);
            }
            return this.commit(uow, mediaTypes, entities);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.SEARCH_SERVICE_GET_SEARCH_ERROR, new Object[0]);
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Advanced search of the workspace where the criteria is encapsulated in the request body", response=RestBasicEntity[].class)
    @ApiResponses(value={@ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response searchWorkspace(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="JSON of the possible search attributes:<br><pre>{<br>&nbsp;searchName: \"If specified, use the saved search of this name\",<br>&nbsp;type: \"The type of object to search for (FROM type)\",<br>&nbsp;parent: \"Limits search to directly beneath this object path\",<br>&nbsp;ancestor: \"Limits search to descendents of this object path\",<br>&nbsp;<pre-cmt class=\"json-comment\">(parent and ancestor are mutually exclusive)</pre-cmt><br>&nbsp;path: \"Specifies path of the target object,<br>&nbsp;contain: \"Value that result properties will contain\",<br>&nbsp;objectName: \"Value that result names will match\",<br>&nbsp;<pre-cmt class=\"json-comment\">(Can be a wildcard using '%' symbol)</pre-cmt><br>&nbsp;Search parameters can be added to above keys,<br>&nbsp;by specifying them in braces {param1}.,<br>&nbsp;Values of parameters can be included using,<br>&nbsp;key:value properties.<br>&nbsp;}<br>}</pre>", required=true) String searchAttributes) throws KomodoRestException {
        KomodoSearcherAttributes sa;
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        try {
            sa = (KomodoSearcherAttributes)KomodoJsonMarshaller.unmarshall((String)searchAttributes, KomodoSearcherAttributes.class);
            Response response = this.checkSearchAttributes(sa.getSearchName(), sa.getType(), sa.getPath(), sa.getParent(), sa.getAncestor(), sa.getContains(), sa.getObjectName(), mediaTypes);
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                return response;
            }
        }
        catch (Exception ex) {
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)ex, RelationalMessages.Error.SEARCH_SERVICE_REQUEST_PARSING_ERROR, new Object[0]);
        }
        Repository.UnitOfWork uow = null;
        try {
            ObjectSearcher os;
            Repository repo = this.kengine.getDefaultRepository();
            uow = this.createTransaction(principal, "objectFromWorkspace", true);
            if (sa.getSearchName() != null) {
                os = new ObjectSearcher(repo);
                os.read(uow, sa.getSearchName());
            } else {
                os = this.createObjectSearcher(sa.getType(), sa.getParent(), sa.getAncestor(), sa.getPath(), sa.getContains(), sa.getObjectName());
            }
            for (Map.Entry parameter : sa.getParameters().entrySet()) {
                String value = (String)parameter.getValue();
                value = this.convertType(value);
                os.setParameterValue((String)parameter.getKey(), value);
            }
            System.out.println(RepositoryTools.traverse((Repository.UnitOfWork)uow, (KomodoObject)repo.komodoWorkspace(uow)));
            List searchObjects = os.searchObjects(uow);
            ArrayList<RestBasicEntity> entities = new ArrayList<RestBasicEntity>();
            for (KomodoObject kObject : searchObjects) {
                RestBasicEntity entity = this.entityFactory.create(kObject, uriInfo.getBaseUri(), uow);
                if (entity == null) continue;
                entities.add(entity);
            }
            return this.commit(uow, mediaTypes, entities);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponse(Response.Status.FORBIDDEN, mediaTypes, (Throwable)e, RelationalMessages.Error.SEARCH_SERVICE_GET_SEARCH_ERROR, new Object[0]);
        }
    }

    @GET
    @Path(value="savedSearches")
    @Produces(value={"application/json"})
    @ApiOperation(value="Fetch saved searches from the workspace", response=RestBasicEntity[].class)
    @ApiResponses(value={@ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response getSavedSearches(@Context HttpHeaders headers, @Context UriInfo uriInfo) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        Repository.UnitOfWork uow = null;
        try {
            Repository repo = this.kengine.getDefaultRepository();
            uow = this.createTransaction(principal, "searchesFromWorkspace", true);
            String searchesGroupPath = repo.komodoSearches(uow).getAbsolutePath();
            KomodoObject searchesGroup = repo.getFromWorkspace(uow, searchesGroupPath);
            ArrayList<KomodoSavedSearcher> entities = new ArrayList<KomodoSavedSearcher>();
            if (searchesGroup != null) {
                KomodoObject[] searches;
                for (KomodoObject kObject : searches = searchesGroup.getChildrenOfType(uow, "tko:search", new String[0])) {
                    String name = kObject.getName(uow);
                    try {
                        ObjectSearcher os = new ObjectSearcher(repo);
                        os.read(uow, name);
                        KomodoSavedSearcher kso = new KomodoSavedSearcher();
                        kso.setName(name);
                        kso.setQuery(os.toString());
                        kso.setParameters(os.getParameters());
                        entities.add(kso);
                    }
                    catch (KException kException) {
                        // empty catch block
                    }
                }
            }
            return this.commit(uow, mediaTypes, entities);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.SEARCH_SERVICE_WKSP_SEARCHES_ERROR, new Object[0]);
        }
    }

    @POST
    @Path(value="savedSearches")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Save a search to the workspace")
    @ApiResponses(value={@ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response saveSearch(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="JSON of the search attributes:<br><pre>{<br>&nbsp;searchName: \"The name to save the search to\",<br>&nbsp;type: \"The type of object to search for (FROM type)\",<br>&nbsp;parent: \"Limits search to directly beneath this object path\",<br>&nbsp;ancestor: \"Limits search to descendents of this object path\",<br>&nbsp;<pre-cmt class=\"json-comment\">(parent and ancestor are mutually exclusive)</pre-cmt><br>&nbsp;path: \"Specifies path of the target object,<br>&nbsp;contain: \"Value that result properties will contain\",<br>&nbsp;objectName: \"Value that result names will match\",<br>&nbsp;<pre-cmt class=\"json-comment\">(Can be a wildcard using '%' symbol)</pre-cmt><br>&nbsp;Search parameters can be added to above keys<br>&nbsp;by specifying them in braces {param1}.<br>&nbsp;}<br>}</pre>", required=true) String searchAttributes) throws KomodoRestException {
        ObjectSearcher os;
        KomodoSearcherAttributes sa;
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        try {
            sa = (KomodoSearcherAttributes)KomodoJsonMarshaller.unmarshall((String)searchAttributes, KomodoSearcherAttributes.class);
            os = this.createObjectSearcher(sa.getType(), sa.getParent(), sa.getAncestor(), sa.getPath(), sa.getContains(), sa.getObjectName());
        }
        catch (Exception ex) {
            throw new KomodoRestException((Throwable)ex);
        }
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "writeSearchToWorkspace", false);
            os.write(uow, sa.getSearchName());
            return this.commit(uow, mediaTypes, (KRestEntity)sa);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.SEARCH_SERVICE_SAVE_SEARCH_ERROR, new Object[0]);
        }
    }

    @DELETE
    @Path(value="savedSearches/{searchName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete a search from the workspace")
    @ApiResponses(value={@ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response deleteSavedSearch(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the saved search to be deleted", required=true) @PathParam(value="searchName") String searchName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            Repository repo = this.kengine.getDefaultRepository();
            uow = this.createTransaction(principal, "removeSearchFromWorkspace", false);
            String searchesGroupPath = repo.komodoSearches(uow).getAbsolutePath();
            KomodoObject searchesGroup = repo.getFromWorkspace(uow, searchesGroupPath);
            if (searchesGroup == null) {
                return Response.noContent().build();
            }
            KomodoObject search = searchesGroup.getChild(uow, searchName);
            if (search == null) {
                return Response.noContent().build();
            }
            search.remove(uow);
            KomodoStatusObject kso = new KomodoStatusObject("Delete Status");
            kso.addAttribute(searchName, "Successfully deleted");
            return this.commit(uow, mediaTypes, (KRestEntity)kso);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.SEARCH_SERVICE_DELETE_SEARCH_ERROR, new Object[0]);
        }
    }
}

