/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.service;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.komodo.core.KEngine;
import org.komodo.core.repository.SynchronousCallback;
import org.komodo.importer.ImportMessages;
import org.komodo.importer.ImportOptions;
import org.komodo.relational.importer.vdb.VdbImporter;
import org.komodo.relational.vdb.Vdb;
import org.komodo.rest.KRestEntity;
import org.komodo.rest.KomodoRestException;
import org.komodo.rest.KomodoRestV1Application;
import org.komodo.rest.KomodoService;
import org.komodo.rest.relational.RelationalMessages;
import org.komodo.rest.relational.json.KomodoJsonMarshaller;
import org.komodo.rest.relational.response.KomodoStatusObject;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.KomodoType;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="service")
@Api(tags={"service"})
public final class KomodoUtilService
extends KomodoService {
    private static final String REPO_WKSP_LABEL = "Repository Workspace";
    private static final String REPO_CONFIG_LABEL = "Repository Configuration";
    private static final String REPO_VDB_TOTAL = "Repository Vdb Total";
    static final String APP_NAME = "App Name";
    static final String APP_TITLE = "App Title";
    static final String APP_DESCRIPTION = "App Description";
    static final String APP_VERSION = "App Version";
    public static final String[] SAMPLES = new String[]{"parts_dynamic-vdb.xml", "portfolio-vdb.xml", "teiid-vdb-all-elements.xml", "tweet-example-vdb.xml", "northwind.xml", "financials.xml"};

    public KomodoUtilService(KEngine engine) throws WebApplicationException {
        super(engine);
    }

    @GET
    @Path(value="about")
    @ApiOperation(value="Display status of this rest service", response=String.class)
    @ApiResponses(value={@ApiResponse(code=403, message="An error has occurred.")})
    public Response about(@Context HttpHeaders headers, @Context UriInfo uriInfo) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        KomodoStatusObject repoStatus = new KomodoStatusObject();
        repoStatus.addAttribute("App Name", KomodoRestV1Application.V1Constants.App.name());
        repoStatus.addAttribute("App Title", KomodoRestV1Application.V1Constants.App.title());
        repoStatus.addAttribute("App Description", KomodoRestV1Application.V1Constants.App.description());
        repoStatus.addAttribute("App Version", KomodoRestV1Application.V1Constants.App.version());
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            Repository repo = this.kengine.getDefaultRepository();
            Repository.Id id = repo.getId();
            repoStatus.addAttribute("Repository Workspace", id.getWorkspaceName());
            repoStatus.addAttribute("Repository Configuration", id.getConfiguration().toString());
            uow = this.systemTx("getVdbs", true);
            Vdb[] vdbs = this.getWorkspaceManager(uow).findVdbs(uow);
            repoStatus.addAttribute("Repository Vdb Total", Integer.toString(vdbs.length));
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            String errorMsg = e.getLocalizedMessage() != null ? e.getLocalizedMessage() : e.getClass().getSimpleName();
            errorMsg = RelationalMessages.getString((Enum)RelationalMessages.Error.VDB_SERVICE_GET_VDBS_ERROR, (Object[])new Object[]{errorMsg});
            repoStatus.addAttribute("Repository Vdb Total", errorMsg);
        }
        try {
            return this.commit(uow, mediaTypes, (KRestEntity)repoStatus);
        }
        catch (Exception ex) {
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)ex, RelationalMessages.Error.VDB_SERVICE_GET_VDBS_ERROR, new Object[0]);
        }
    }

    public static InputStream getVdbSample(String sampleName) {
        String sampleFilePath = "sample" + File.separator + sampleName;
        InputStream fileStream = KomodoUtilService.class.getResourceAsStream(sampleFilePath);
        if (fileStream == null) {
            LOGGER.error(RelationalMessages.getString((Enum)RelationalMessages.Error.VDB_SAMPLE_CONTENT_FAILURE, (Object[])new Object[]{sampleName}), new Object[0]);
        } else {
            LOGGER.info(RelationalMessages.getString((Enum)RelationalMessages.Error.VDB_SAMPLE_CONTENT_SUCCESS, (Object[])new Object[]{sampleName}), new Object[0]);
        }
        return fileStream;
    }

    @POST
    @Path(value="samples")
    @Produces(value={"application/json"})
    @ApiOperation(value="Import sample data into VdbBuilder and display the status of the operation", response=KomodoStatusObject.class)
    @ApiResponses(value={@ApiResponse(code=403, message="An error has occurred.")})
    public Response importSampleData(@Context HttpHeaders headers, @Context UriInfo uriInfo) {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        KomodoStatusObject status = new KomodoStatusObject("Sample Vdb Import");
        for (String sampleName : SAMPLES) {
            InputStream sampleStream = KomodoUtilService.getVdbSample((String)sampleName);
            if (sampleStream == null) {
                status.addAttribute(sampleName, RelationalMessages.getString((Enum)RelationalMessages.Error.VDB_SAMPLE_CONTENT_FAILURE, (Object[])new Object[]{sampleName}));
                continue;
            }
            Repository.UnitOfWork uow = null;
            try {
                SynchronousCallback callback = new SynchronousCallback();
                uow = this.createTransaction(principal, "Import vdb " + sampleName, false, (Repository.UnitOfWorkListener)callback);
                String msg = null;
                ImportOptions importOptions = new ImportOptions();
                importOptions.setOption(ImportOptions.OptionKeys.HANDLE_EXISTING, (Object)ImportOptions.ExistingNodeOptions.RETURN);
                ImportMessages importMessages = new ImportMessages();
                Repository repo = this.kengine.getDefaultRepository();
                KomodoObject workspace = repo.komodoWorkspace(uow);
                VdbImporter importer = new VdbImporter(repo);
                importer.importVdb(uow, sampleStream, workspace, importOptions, importMessages);
                uow.commit();
                List errorMsgs = importMessages.getErrorMessages();
                if (errorMsgs.isEmpty()) {
                    msg = RelationalMessages.getString((Enum)RelationalMessages.Error.VDB_SAMPLE_IMPORT_SUCCESS, (Object[])new Object[]{sampleName});
                } else if (((String)errorMsgs.iterator().next()).contains("node already exists")) {
                    msg = RelationalMessages.getString((Enum)RelationalMessages.Error.VDB_SAMPLE_IMPORT_VDB_EXISTS, (Object[])new Object[]{sampleName});
                } else {
                    String errMsg = StringUtils.toCommaSeparatedList((Object[])errorMsgs.toArray());
                    msg = RelationalMessages.getString((Enum)RelationalMessages.Error.VDB_SAMPLE_IMPORT_ERRORS, (Object[])new Object[]{sampleName, errMsg});
                }
                if (callback.await(3L, TimeUnit.MINUTES)) {
                    status.addAttribute(sampleName, msg);
                    continue;
                }
                status.addAttribute(sampleName, RelationalMessages.getString((Enum)RelationalMessages.Error.VDB_SAMPLE_IMPORT_TIMEOUT, (Object[])new Object[]{sampleName, msg}));
            }
            catch (Exception e) {
                if (uow != null && uow.getState() != Repository.UnitOfWork.State.COMMITTED) {
                    uow.rollback();
                }
                status.addAttribute(sampleName, RelationalMessages.getString((Enum)RelationalMessages.Error.VDB_SERVICE_LOAD_SAMPLE_ERROR, (Object[])new Object[]{sampleName, e}));
            }
        }
        Response.ResponseBuilder builder = Response.ok((Object)KomodoJsonMarshaller.marshall((KRestEntity)status, (boolean)true), (String)"application/json");
        return builder.build();
    }

    @GET
    @Path(value="schema")
    @Produces(value={"application/json"})
    @ApiOperation(value="Display the schema structure of the teiid vdb", response=String.class)
    @ApiResponses(value={@ApiResponse(code=404, message="If ktype is not a recognised type"), @ApiResponse(code=404, message="If ktype is recognised but not associated with a teiid schema element"), @ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response getSchema(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Type of schema element to be returned", allowableValues="Vdb, VdbImport, Connection,VdbTranslator, Model, VdbModelSource, VdbDataRole, VdbPermission, VdbCondition, VdbMask", required=false, allowMultiple=false) @QueryParam(value="ktype") String ktype) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        try {
            String schema = null;
            if (ktype == null) {
                schema = KomodoJsonMarshaller.teiidElementSchema(null);
                return Response.ok().entity((Object)schema).build();
            }
            KomodoType komodoType = KomodoType.getKomodoType((String)ktype);
            if (komodoType == null) {
                return this.createErrorResponse(Response.Status.NOT_FOUND, mediaTypes, RelationalMessages.Error.SCHEMA_SERVICE_GET_SCHEMA_UNKNOWN_KTYPE, new Object[]{ktype});
            }
            schema = KomodoJsonMarshaller.teiidElementSchema((KomodoType)komodoType);
            if ("".equals(schema)) {
                return this.createErrorResponse(Response.Status.NOT_FOUND, mediaTypes, RelationalMessages.Error.SCHEMA_SERVICE_GET_SCHEMA_NOT_FOUND, new Object[]{ktype});
            }
            return Response.ok().entity((Object)schema).build();
        }
        catch (Exception e) {
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.SCHEMA_SERVICE_GET_SCHEMA_ERROR, new Object[0]);
        }
    }

    @GET
    @Path(value="validate/{validateValue}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Returns an error message if the value is invalid")
    @ApiResponses(value={@ApiResponse(code=400, message="The URI cannot contain encoded slashes or backslashes."), @ApiResponse(code=403, message="An unexpected error has occurred."), @ApiResponse(code=500, message="The value cannot be empty.")})
    public Response validateValue(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="The value being checked", required=true) @PathParam(value="validateValue") String validateValue) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        String errorMsg = VALIDATOR.checkValidName(validateValue);
        if (errorMsg != null) {
            return Response.ok().entity((Object)errorMsg).build();
        }
        return Response.ok().build();
    }
}

