/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.service;

import com.google.common.base.Objects;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.komodo.core.KEngine;
import org.komodo.core.repository.ObjectImpl;
import org.komodo.importer.ImportMessages;
import org.komodo.importer.ImportOptions;
import org.komodo.relational.connection.Connection;
import org.komodo.relational.importer.vdb.VdbImporter;
import org.komodo.relational.model.Column;
import org.komodo.relational.model.Model;
import org.komodo.relational.model.Table;
import org.komodo.relational.vdb.Condition;
import org.komodo.relational.vdb.DataRole;
import org.komodo.relational.vdb.Mask;
import org.komodo.relational.vdb.ModelSource;
import org.komodo.relational.vdb.Permission;
import org.komodo.relational.vdb.Translator;
import org.komodo.relational.vdb.Vdb;
import org.komodo.relational.vdb.VdbImport;
import org.komodo.relational.workspace.WorkspaceManager;
import org.komodo.rest.KRestEntity;
import org.komodo.rest.KomodoRestException;
import org.komodo.rest.KomodoService;
import org.komodo.rest.Messages;
import org.komodo.rest.RestBasicEntity;
import org.komodo.rest.RestProperty;
import org.komodo.rest.relational.KomodoProperties;
import org.komodo.rest.relational.RelationalMessages;
import org.komodo.rest.relational.json.KomodoJsonMarshaller;
import org.komodo.rest.relational.response.KomodoStatusObject;
import org.komodo.rest.relational.response.RestVdb;
import org.komodo.rest.relational.response.RestVdbCondition;
import org.komodo.rest.relational.response.RestVdbDataRole;
import org.komodo.rest.relational.response.RestVdbImport;
import org.komodo.rest.relational.response.RestVdbMask;
import org.komodo.rest.relational.response.RestVdbModel;
import org.komodo.rest.relational.response.RestVdbModelSource;
import org.komodo.rest.relational.response.RestVdbModelTable;
import org.komodo.rest.relational.response.RestVdbModelTableColumn;
import org.komodo.rest.relational.response.RestVdbPermission;
import org.komodo.rest.relational.response.RestVdbTranslator;
import org.komodo.spi.KException;
import org.komodo.spi.repository.KomodoObject;
import org.komodo.spi.repository.Repository;
import org.komodo.utils.StringNameValidator;
import org.komodo.utils.StringUtils;

@Path(value="workspace/vdbs")
@Api(tags={"vdbs"})
public final class KomodoVdbService
extends KomodoService {
    private static final int ALL_AVAILABLE = -1;
    private static final String VDB_PATH_DEFAULT = "defaultPath";
    private static final StringNameValidator VALIDATOR = new StringNameValidator();

    public KomodoVdbService(KEngine engine) throws WebApplicationException {
        super(engine);
    }

    @POST
    @Path(value="/{vdbName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a vdb in the workspace")
    @ApiResponses(value={@ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response createVdb(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the Vdb to be created", required=true) @PathParam(value="vdbName") String vdbName, @ApiParam(value="JSON of the properties of the Vdb to add:<br><pre>{<br>&nbsp;keng\\_\\_id: \"name of the Vdb\",<br>&nbsp;vdb\\_\\_name: \"name of the Vdb\",<br>&nbsp;keng\\_\\_dataPath: \"path of Vdb to create\",<br>&nbsp;<pre-cmt class=\"json-comment\">(eg keng\\_\\_dataPath: \"tko:komodo\\tko:workspace\\\\{username\\}\\\\{vdbName\\}\")</pre-cmt><br>&nbsp;vdb\\_\\_originalFile: \"original file location\",<br>&nbsp;<pre-cmt class=\"json-comment\">(same value as keng\\_\\_dataPath)</pre-cmt><br>&nbsp;keng\\_\\_kType: \"Vdb\"<br>}</pre>", required=true) String vdbJson) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        if (StringUtils.isBlank((String)vdbName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_CREATE_MISSING_VDB_NAME, new Object[0]);
        }
        RestVdb restVdb = (RestVdb)KomodoJsonMarshaller.unmarshall((String)vdbJson, RestVdb.class);
        String jsonVdbName = restVdb.getId();
        if (StringUtils.isBlank((String)jsonVdbName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_MISSING_JSON_VDB_NAME, new Object[0]);
        }
        boolean namesMatch = vdbName.equals(jsonVdbName);
        if (!namesMatch) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_VDB_NAME_DONT_MATCH_ERROR, new Object[]{vdbName, jsonVdbName});
        }
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "createVdb", false);
            if (this.getWorkspaceManager(uow).hasChild(uow, vdbName)) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_VDB_ALREADY_EXISTS, new Object[]{vdbName});
            }
            return this.doAddVdb(uow, uriInfo.getBaseUri(), mediaTypes, restVdb);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.VDB_SERVICE_CREATE_VDB_ERROR, new Object[]{vdbName});
        }
    }

    private Response doAddVdb(Repository.UnitOfWork uow, URI baseUri, List<MediaType> mediaTypes, RestVdb restVdb) throws KomodoRestException {
        assert (!uow.isRollbackOnly());
        assert (uow.getState() == Repository.UnitOfWork.State.NOT_STARTED);
        assert (restVdb != null);
        String vdbName = restVdb.getId();
        try {
            Vdb vdb = this.getWorkspaceManager(uow).createVdb(uow, null, vdbName, restVdb.getOriginalFilePath());
            this.setProperties(uow, vdb, restVdb);
            RestVdb entity = (RestVdb)this.entityFactory.create((KomodoObject)vdb, baseUri, uow);
            Response response = this.commit(uow, mediaTypes, (KRestEntity)entity);
            return response;
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            throw new KomodoRestException(RelationalMessages.getString((Enum)RelationalMessages.Error.VDB_SERVICE_CREATE_VDB_ERROR, (Object[])new Object[]{vdbName}), (Throwable)e);
        }
    }

    @PUT
    @Path(value="/{vdbName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Update a vdb in the workspace")
    @ApiResponses(value={@ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response updateVdb(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the Vdb to be updated", required=true) @PathParam(value="vdbName") String vdbName, @ApiParam(value="JSON of the properties of the Vdb to update:<br><pre>{<br>&nbsp;keng\\_\\_id: \"name of the Vdb\",<br>&nbsp;vdb\\_\\_name: \"name of the Vdb\",<br>&nbsp;keng\\_\\_dataPath: \"path of Vdb to update\",<br>&nbsp;<pre-cmt class=\"json-comment\">(eg keng\\_\\_dataPath: \"tko:komodo\\tko:workspace\\\\{username\\}\\\\{vdbName\\}\")</pre-cmt><br>&nbsp;vdb\\_\\_originalFile: \"original file location\",<br>&nbsp;<pre-cmt class=\"json-comment\">(same value as keng\\_\\_dataPath)</pre-cmt><br>&nbsp;keng\\_\\_kType: \"Vdb\"<br>}</pre>", required=true) String vdbJson) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        if (StringUtils.isBlank((String)vdbName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_UPDATE_MISSING_VDB_NAME, new Object[0]);
        }
        RestVdb restVdb = (RestVdb)KomodoJsonMarshaller.unmarshall((String)vdbJson, RestVdb.class);
        String jsonVdbName = restVdb.getId();
        if (StringUtils.isBlank((String)jsonVdbName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_MISSING_JSON_VDB_NAME, new Object[0]);
        }
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "updateVdb", false);
            WorkspaceManager wMgr = this.getWorkspaceManager(uow);
            boolean exists = wMgr.hasChild(uow, vdbName);
            if (!exists) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_UPDATE_VDB_DNE, new Object[0]);
            }
            KomodoObject kobject = wMgr.getChild(uow, vdbName, "vdb:virtualDatabase");
            Vdb vdb = (Vdb)wMgr.resolve(uow, (Object)kobject, Vdb.class);
            this.setProperties(uow, vdb, restVdb);
            boolean namesMatch = vdbName.equals(jsonVdbName);
            if (!namesMatch) {
                vdb.rename(uow, jsonVdbName);
            }
            KomodoProperties properties = new KomodoProperties();
            RestVdb entity = (RestVdb)this.entityFactory.create((KomodoObject)vdb, uriInfo.getBaseUri(), uow, properties);
            LOGGER.debug("updateVdb: vdb '{0}' entity was updated", new Object[]{vdb.getName(uow)});
            Response response = this.commit(uow, headers.getAcceptableMediaTypes(), (KRestEntity)entity);
            return response;
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.VDB_SERVICE_UPDATE_VDB_ERROR, new Object[0]);
        }
    }

    @POST
    @Path(value="/clone/{vdbName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Clone a VDB in the workspace")
    @ApiResponses(value={@ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response cloneVdb(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the Vdb to be cloned", required=true) @PathParam(value="vdbName") String vdbName, @ApiParam(value="name of the new Vdb", required=true) String newVdbName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        if (StringUtils.isBlank((String)vdbName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_CLONE_MISSING_NAME, new Object[0]);
        }
        if (StringUtils.isBlank((String)newVdbName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_CLONE_MISSING_NEW_NAME, new Object[0]);
        }
        boolean namesMatch = vdbName.equals(newVdbName);
        if (namesMatch) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_CLONE_SAME_NAME_ERROR, new Object[]{newVdbName});
        }
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "cloneVdb", false);
            WorkspaceManager wMgr = this.getWorkspaceManager(uow);
            if (wMgr.hasChild(uow, newVdbName)) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_CLONE_ALREADY_EXISTS, new Object[0]);
            }
            KomodoObject kobject = wMgr.getChild(uow, vdbName, "vdb:virtualDatabase");
            Vdb oldVdb = (Vdb)wMgr.resolve(uow, (Object)kobject, Vdb.class);
            oldVdb.setVdbName(uow, newVdbName);
            boolean oldHadDeploymentProperty = oldVdb.hasProperty(uow, "deployment-name");
            if (oldHadDeploymentProperty) {
                oldVdb.setProperty(uow, "deployment-name", new Object[]{newVdbName + "-vdb.xml"});
            }
            byte[] vdbXml = oldVdb.export(uow, null);
            ByteArrayInputStream vdbStream = new ByteArrayInputStream(vdbXml);
            oldVdb.setVdbName(uow, vdbName);
            if (oldHadDeploymentProperty) {
                oldVdb.setProperty(uow, "deployment-name", new Object[]{vdbName + "-vdb.xml"});
            }
            Repository repo = this.kengine.getDefaultRepository();
            VdbImporter importer = new VdbImporter(repo);
            ImportOptions importOptions = new ImportOptions();
            importOptions.setOption(ImportOptions.OptionKeys.NAME, (Object)newVdbName);
            ImportMessages importMessages = new ImportMessages();
            importer.importVdb(uow, (InputStream)vdbStream, repo.komodoWorkspace(uow), importOptions, importMessages);
            if (importMessages.hasError()) {
                LOGGER.debug("cloneVDB for '{0}' failed", new Object[]{newVdbName});
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_CLONE_VDB_ERROR, new Object[]{vdbName});
            }
            KomodoObject kobject2 = wMgr.getChild(uow, newVdbName, "vdb:virtualDatabase");
            Vdb vdb = (Vdb)wMgr.resolve(uow, (Object)kobject2, Vdb.class);
            RestVdb entity = (RestVdb)this.entityFactory.create((KomodoObject)vdb, uriInfo.getBaseUri(), uow);
            Response response = this.commit(uow, mediaTypes, (KRestEntity)entity);
            return response;
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.VDB_SERVICE_CLONE_VDB_ERROR, new Object[]{vdbName});
        }
    }

    private void setProperties(Repository.UnitOfWork uow, Vdb vdb, RestVdb restVdb) throws KException {
        String newDescription = restVdb.getDescription();
        String newConnType = restVdb.getConnectionType();
        String newOrigFilePath = restVdb.getOriginalFilePath();
        int newVersion = restVdb.getVersion();
        List newProperties = restVdb.getProperties();
        String oldDescription = vdb.getDescription(uow);
        String oldConnType = vdb.getConnectionType(uow);
        String oldOrigFilePath = vdb.getOriginalFilePath(uow);
        int oldVersion = vdb.getVersion(uow);
        if (!StringUtils.equals((String)newDescription, (String)oldDescription)) {
            vdb.setDescription(uow, newDescription);
        }
        if (!StringUtils.equals((String)newConnType, (String)oldConnType)) {
            vdb.setConnectionType(uow, newConnType);
        }
        if (!StringUtils.equals((String)newOrigFilePath, (String)oldOrigFilePath)) {
            String origFilePath = newOrigFilePath == null ? VDB_PATH_DEFAULT : newOrigFilePath;
            vdb.setOriginalFilePath(uow, origFilePath);
        }
        if (newVersion != oldVersion) {
            vdb.setVersion(uow, newVersion);
        }
        for (RestProperty newProp : newProperties) {
            vdb.setProperty(uow, newProp.getName(), new Object[]{newProp.getValue()});
        }
    }

    private void setProperties(Repository.UnitOfWork uow, Model model, RestVdbModel restVdbModel) throws KException {
        String newDdl;
        String newMetadataType;
        Model.Type newModelType;
        String newDescription = restVdbModel.getDescription();
        boolean newIsVisible = restVdbModel.isVisible();
        List newProperties = restVdbModel.getProperties();
        String oldDescription = model.getDescription(uow);
        boolean oldIsVisible = model.isVisible(uow);
        if (!StringUtils.equals((String)newDescription, (String)oldDescription)) {
            model.setDescription(uow, newDescription);
        }
        if (newIsVisible != oldIsVisible) {
            model.setVisible(uow, newIsVisible);
        }
        if (!Objects.equal((Object)(newModelType = restVdbModel.getModelType()), (Object)model.getModelType(uow))) {
            model.setModelType(uow, newModelType);
        }
        if (!Objects.equal((Object)(newMetadataType = restVdbModel.getMetadataType()), (Object)model.getMetadataType(uow))) {
            model.setMetadataType(uow, newMetadataType);
        }
        if (!Objects.equal((Object)(newDdl = restVdbModel.getDdl()), (Object)model.getModelDefinition(uow))) {
            model.setModelDefinition(uow, newDdl);
        }
        for (RestProperty newProp : newProperties) {
            model.setProperty(uow, newProp.getName(), new Object[]{newProp.getValue()});
        }
    }

    private void setProperties(Repository.UnitOfWork uow, ModelSource modelSource, RestVdbModelSource restVdbModelSource) throws KException {
        String newTranslator = restVdbModelSource.getTranslator();
        String newJndi = restVdbModelSource.getJndiName();
        List newProperties = restVdbModelSource.getProperties();
        String oldTranslator = modelSource.getTranslatorName(uow);
        String oldJndi = modelSource.getJndiName(uow);
        if (!StringUtils.equals((String)newTranslator, (String)oldTranslator)) {
            modelSource.setTranslatorName(uow, newTranslator);
        }
        if (!StringUtils.equals((String)newJndi, (String)oldJndi)) {
            modelSource.setJndiName(uow, newJndi);
        }
        for (RestProperty newProp : newProperties) {
            modelSource.setProperty(uow, newProp.getName(), new Object[]{newProp.getValue()});
        }
    }

    private Model findModel(Repository.UnitOfWork uow, List<MediaType> mediaTypes, String modelName, Vdb vdb) throws KException {
        if (!vdb.hasChild(uow, modelName, "vdb:declarativeModel")) {
            return null;
        }
        KomodoObject kModel = vdb.getChild(uow, modelName, "vdb:declarativeModel");
        Model model = (Model)this.getWorkspaceManager(uow).resolve(uow, (Object)kModel, Model.class);
        LOGGER.debug("Model '{0}' was found", new Object[]{modelName});
        return model;
    }

    private Table findTable(Repository.UnitOfWork uow, List<MediaType> mediaTypes, String tableName, Model model) throws KException {
        Table[] tables = model.getTables(uow, new String[]{tableName});
        if (tables.length == 0) {
            return null;
        }
        LOGGER.debug("Table '{0}' was found", new Object[]{tableName});
        return tables[0];
    }

    private DataRole findDataRole(Repository.UnitOfWork uow, List<MediaType> mediaTypes, String dataRoleId, Vdb vdb) throws KException {
        DataRole[] dataRoles = vdb.getDataRoles(uow, new String[0]);
        if (dataRoles == null || dataRoles.length == 0) {
            return null;
        }
        DataRole dataRole = null;
        for (DataRole drole : dataRoles) {
            if (!dataRoleId.equals(drole.getName(uow))) continue;
            dataRole = drole;
            break;
        }
        return dataRole;
    }

    private Permission findPermission(Repository.UnitOfWork uow, List<MediaType> mediaTypes, String permissionId, DataRole dataRole, Vdb vdb) throws KException {
        Permission[] permissions = dataRole.getPermissions(uow, new String[0]);
        if (permissions == null || permissions.length == 0) {
            return null;
        }
        Permission permission = null;
        for (Permission perm : permissions) {
            if (!permissionId.equals(perm.getName(uow))) continue;
            permission = perm;
            break;
        }
        return permission;
    }

    @DELETE
    @Path(value="{vdbName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete a vdb from the workspace")
    @ApiResponses(value={@ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response deleteVdb(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the Vdb to be removed", required=true) @PathParam(value="vdbName") String vdbName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        if (StringUtils.isBlank((String)vdbName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_DELETE_MISSING_VDB_NAME, new Object[0]);
        }
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "removeVdbFromWorkspace", false);
            WorkspaceManager mgr = this.getWorkspaceManager(uow);
            KomodoObject vdb = mgr.getChild(uow, vdbName, "vdb:virtualDatabase");
            if (vdb == null) {
                return Response.noContent().build();
            }
            mgr.delete(uow, new KomodoObject[]{vdb});
            KomodoStatusObject kso = new KomodoStatusObject("Delete Status");
            kso.addAttribute(vdbName, "Successfully deleted");
            return this.commit(uow, mediaTypes, (KRestEntity)kso);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.VDB_SERVICE_DELETE_VDB_ERROR, new Object[0]);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Display the collection of vdbs", response=RestVdb[].class)
    @ApiResponses(value={@ApiResponse(code=403, message="An error has occurred.")})
    public Response getVdbs(@Context HttpHeaders headers, @Context UriInfo uriInfo) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            String searchPattern = (String)uriInfo.getQueryParameters().getFirst((Object)"pattern");
            uow = this.createTransaction(principal, "getVdbs", true);
            Vdb[] vdbs = null;
            WorkspaceManager wsMgr = this.getWorkspaceManager(uow);
            if (StringUtils.isBlank((String)searchPattern)) {
                vdbs = wsMgr.findVdbs(uow);
                LOGGER.debug("getVdbs:found '{0}' VDBs", new Object[]{vdbs.length});
            } else {
                String[] vdbPaths = wsMgr.findByType(uow, "vdb:virtualDatabase", null, searchPattern, false);
                if (vdbPaths.length == 0) {
                    vdbs = Vdb.NO_VDBS;
                } else {
                    vdbs = new Vdb[vdbPaths.length];
                    int i = 0;
                    for (String path : vdbPaths) {
                        vdbs[i++] = (Vdb)wsMgr.resolve(uow, (Object)new ObjectImpl(wsMgr.getRepository(), path, 0), Vdb.class);
                    }
                    LOGGER.debug("getVdbs:found '{0}' VDBs using pattern '{1}'", new Object[]{vdbs.length, searchPattern});
                }
            }
            int start = 0;
            String qparam = (String)uriInfo.getQueryParameters().getFirst((Object)"start");
            if (qparam != null) {
                try {
                    start = Integer.parseInt(qparam);
                    if (start < 0) {
                        start = 0;
                    }
                }
                catch (Exception e) {
                    start = 0;
                }
            }
            int size = -1;
            String qparam2 = (String)uriInfo.getQueryParameters().getFirst((Object)"size");
            if (qparam2 != null) {
                try {
                    size = Integer.parseInt(qparam2);
                    if (size <= 0) {
                        size = -1;
                    }
                }
                catch (Exception e) {
                    size = -1;
                }
            }
            ArrayList<RestVdb> entities = new ArrayList<RestVdb>();
            int i = 0;
            KomodoProperties properties = new KomodoProperties();
            properties.addProperty("vdb-export-xml", (Object)false);
            for (Vdb vdb : vdbs) {
                if (start == 0 || i >= start) {
                    if (size != -1 && entities.size() >= size) break;
                    RestVdb entity = (RestVdb)this.entityFactory.create((KomodoObject)vdb, uriInfo.getBaseUri(), uow, properties);
                    entities.add(entity);
                    LOGGER.debug("getVdbs:VDB '{0}' entity was constructed", new Object[]{vdb.getName(uow)});
                }
                ++i;
            }
            return this.commit(uow, mediaTypes, entities);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.VDB_SERVICE_GET_VDBS_ERROR, new Object[0]);
        }
    }

    @GET
    @Path(value="{vdbName}")
    @Produces(value={"application/json", "application/xml"})
    @ApiOperation(value="Find vdb by name", response=RestVdb.class)
    @ApiResponses(value={@ApiResponse(code=404, message="No vdb could be found with name"), @ApiResponse(code=406, message="Only JSON or XML is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response getVdb(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the Vdb to be fetched", required=true) @PathParam(value="vdbName") String vdbName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "getVdb", true);
            Vdb vdb = this.findVdb(uow, vdbName);
            if (vdb == null) {
                return this.commitNoVdbFound(uow, mediaTypes, vdbName);
            }
            KomodoProperties properties = new KomodoProperties();
            properties.addProperty("vdb-export-xml", (Object)mediaTypes.contains(MediaType.APPLICATION_XML_TYPE));
            RestVdb restVdb = (RestVdb)this.entityFactory.create((KomodoObject)vdb, uriInfo.getBaseUri(), uow, properties);
            LOGGER.debug("getVdb:VDB '{0}' entity was constructed", new Object[]{vdb.getName(uow)});
            return this.commit(uow, mediaTypes, (KRestEntity)restVdb);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.VDB_SERVICE_GET_VDB_ERROR, new Object[]{vdbName});
        }
    }

    @GET
    @Path(value="{vdbName}/Models")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find all models belonging to the vdb", response=RestVdb.class)
    @ApiResponses(value={@ApiResponse(code=404, message="No vdb could be found with name"), @ApiResponse(code=200, message="No models could be found but an empty list is returned"), @ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response getModels(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the Vdb", required=true) @PathParam(value="vdbName") String vdbName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "getModels", true);
            Vdb vdb = this.findVdb(uow, vdbName);
            if (vdb == null) {
                return this.commitNoVdbFound(uow, mediaTypes, vdbName);
            }
            Model[] models = vdb.getModels(uow, new String[0]);
            if (models == null) {
                models = new Model[]{};
            }
            ArrayList<RestVdbModel> restModels = new ArrayList<RestVdbModel>(models.length);
            for (Model model : models) {
                RestVdbModel entity = (RestVdbModel)this.entityFactory.create((KomodoObject)model, uriInfo.getBaseUri(), uow);
                restModels.add(entity);
                LOGGER.debug("getModels:Model from VDB '{0}' entity was constructed", new Object[]{vdbName});
            }
            return this.commit(uow, mediaTypes, restModels);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.VDB_SERVICE_GET_MODELS_ERROR, new Object[]{vdbName});
        }
    }

    @GET
    @Path(value="{vdbName}/Models/{modelName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find the named model belonging to the vdb", response=RestVdbModel.class)
    @ApiResponses(value={@ApiResponse(code=404, message="No vdb could be found with name"), @ApiResponse(code=404, message="No model could be found with name"), @ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response getModel(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the Vdb", required=true) @PathParam(value="vdbName") String vdbName, @ApiParam(value="Name of the Model to be fetched", required=true) @PathParam(value="modelName") String modelName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "getModel", true);
            Vdb vdb = this.findVdb(uow, vdbName);
            if (vdb == null) {
                return this.commitNoVdbFound(uow, mediaTypes, vdbName);
            }
            Model model = this.findModel(uow, mediaTypes, modelName, vdb);
            if (model == null) {
                return this.commitNoModelFound(uow, mediaTypes, modelName, vdbName);
            }
            RestVdbModel restModel = (RestVdbModel)this.entityFactory.create((KomodoObject)model, uriInfo.getBaseUri(), uow);
            LOGGER.debug("getModel:Model '{0}' from VDB '{1}' entity was constructed", new Object[]{modelName, vdbName});
            return this.commit(uow, mediaTypes, (KRestEntity)restModel);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.VDB_SERVICE_GET_MODEL_ERROR, new Object[]{modelName, vdbName});
        }
    }

    @POST
    @Path(value="{vdbName}/Models/{modelName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a Model in a VDB")
    @ApiResponses(value={@ApiResponse(code=404, message="No vdb could be found with name"), @ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response createModel(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the Vdb", required=true) @PathParam(value="vdbName") String vdbName, @ApiParam(value="Name of the Model", required=true) @PathParam(value="modelName") String modelName, @ApiParam(value="JSON of the properties of the Model to add:<br><pre>{<br>&nbsp;keng\\_\\_id: \"name of the Model\",<br>&nbsp;keng\\_\\_dataPath: \"path of Model to create\",<br>&nbsp;<pre-cmt class=\"json-comment\">(eg keng\\_\\_dataPath: \"tko:komodo\\tko:workspace\\\\{username\\}\\\\{vdbName\\}\\\\{modelName\\}\")</pre-cmt><br>&nbsp;keng\\_\\_kType: \"Model\"<br>}</pre>", required=true) String modelJson) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        if (StringUtils.isBlank((String)vdbName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_CREATE_MISSING_VDB_NAME, new Object[0]);
        }
        if (StringUtils.isBlank((String)modelName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_CREATE_MISSING_MODEL_NAME, new Object[0]);
        }
        RestVdbModel restVdbModel = (RestVdbModel)KomodoJsonMarshaller.unmarshall((String)modelJson, RestVdbModel.class);
        String jsonModelName = restVdbModel.getId();
        if (StringUtils.isBlank((String)jsonModelName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_MISSING_JSON_MODEL_NAME, new Object[0]);
        }
        boolean namesMatch = modelName.equals(jsonModelName);
        if (!namesMatch) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_MODEL_NAME_DONT_MATCH_ERROR, new Object[]{modelName, jsonModelName});
        }
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "createModel", false);
            WorkspaceManager mgr = this.getWorkspaceManager(uow);
            KomodoObject kobject = mgr.getChild(uow, vdbName, "vdb:virtualDatabase");
            Vdb vdb = (Vdb)mgr.resolve(uow, (Object)kobject, Vdb.class);
            if (vdb == null) {
                return Response.noContent().build();
            }
            if (vdb.getModels(uow, new String[]{modelName}).length != 0) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_VDB_MODEL_ALREADY_EXISTS, new Object[]{modelName});
            }
            return this.doAddModel(uow, uriInfo.getBaseUri(), mediaTypes, vdb, restVdbModel);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.VDB_SERVICE_CREATE_VDB_MODEL_ERROR, new Object[]{vdbName});
        }
    }

    private Response doAddModel(Repository.UnitOfWork uow, URI baseUri, List<MediaType> mediaTypes, Vdb vdb, RestVdbModel restVdbModel) throws KomodoRestException {
        assert (!uow.isRollbackOnly());
        assert (uow.getState() == Repository.UnitOfWork.State.NOT_STARTED);
        assert (vdb != null);
        assert (restVdbModel != null);
        String modelName = restVdbModel.getId();
        try {
            Model newModel = vdb.addModel(uow, modelName);
            this.setProperties(uow, newModel, restVdbModel);
            RestVdbModel entity = (RestVdbModel)this.entityFactory.create((KomodoObject)newModel, baseUri, uow);
            Response response = this.commit(uow, mediaTypes, (KRestEntity)entity);
            return response;
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            throw new KomodoRestException(RelationalMessages.getString((Enum)RelationalMessages.Error.VDB_SERVICE_CREATE_VDB_MODEL_ERROR, (Object[])new Object[]{modelName}), (Throwable)e);
        }
    }

    @PUT
    @Path(value="{vdbName}/Models/{modelName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Update a Model in the VDB")
    @ApiResponses(value={@ApiResponse(code=404, message="No vdb could be found with name"), @ApiResponse(code=404, message="No model could be found with name"), @ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response updateModel(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the Vdb", required=true) @PathParam(value="vdbName") String vdbName, @ApiParam(value="Name of the Model to be updated", required=true) @PathParam(value="modelName") String modelName, @ApiParam(value="JSON of the properties of the Model to update:<br><pre>{<br>&nbsp;keng\\_\\_id: \"name of the Model\",<br>&nbsp;keng\\_\\_dataPath: \"path of Model to update\",<br>&nbsp;<pre-cmt class=\"json-comment\">(eg keng\\_\\_dataPath: \"tko:komodo\\tko:workspace\\\\{username\\}\\\\{vdbName\\}\\\\{modelName\\}\")</pre-cmt><br>&nbsp;keng\\_\\_kType: \"Model\"<br>}</pre>", required=true) String modelJson) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        if (StringUtils.isBlank((String)vdbName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_UPDATE_MISSING_VDB_NAME, new Object[0]);
        }
        if (StringUtils.isBlank((String)modelName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_UPDATE_MISSING_MODEL_NAME, new Object[0]);
        }
        RestVdbModel restVdbModel = (RestVdbModel)KomodoJsonMarshaller.unmarshall((String)modelJson, RestVdbModel.class);
        String jsonModelName = restVdbModel.getId();
        if (StringUtils.isBlank((String)jsonModelName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_MISSING_JSON_MODEL_NAME, new Object[0]);
        }
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "updateVdbModel", false);
            KomodoObject kobject = this.getWorkspaceManager(uow).getChild(uow, vdbName, "vdb:virtualDatabase");
            Vdb vdb = (Vdb)this.getWorkspaceManager(uow).resolve(uow, (Object)kobject, Vdb.class);
            if (vdb == null) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_UPDATE_VDB_DNE, new Object[0]);
            }
            Model[] models = vdb.getModels(uow, new String[]{modelName});
            if (models.length == 0) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_VDB_MODEL_ALREADY_EXISTS, new Object[]{modelName});
            }
            this.setProperties(uow, models[0], restVdbModel);
            KomodoProperties properties = new KomodoProperties();
            RestVdbModel entity = (RestVdbModel)this.entityFactory.create((KomodoObject)models[0], uriInfo.getBaseUri(), uow, properties);
            LOGGER.debug("updateVdbModel: VdbModel '{0}' entity was updated", new Object[]{models[0].getName(uow)});
            Response response = this.commit(uow, headers.getAcceptableMediaTypes(), (KRestEntity)entity);
            return response;
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.VDB_SERVICE_UPDATE_VDB_MODEL_ERROR, new Object[0]);
        }
    }

    @DELETE
    @Path(value="{vdbName}/Models/{modelName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete a Model from the VDB")
    @ApiResponses(value={@ApiResponse(code=404, message="No vdb could be found with name"), @ApiResponse(code=404, message="No model could be found with name"), @ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response deleteModel(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the Vdb", required=true) @PathParam(value="vdbName") String vdbName, @ApiParam(value="Name of the Model to remove", required=true) @PathParam(value="modelName") String modelName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        if (StringUtils.isBlank((String)vdbName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_DELETE_MISSING_VDB_NAME, new Object[0]);
        }
        if (StringUtils.isBlank((String)modelName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_DELETE_MISSING_MODEL_NAME, new Object[0]);
        }
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "removeModelFromVdb", false);
            WorkspaceManager mgr = this.getWorkspaceManager(uow);
            KomodoObject kobject = mgr.getChild(uow, vdbName, "vdb:virtualDatabase");
            Vdb vdb = (Vdb)mgr.resolve(uow, (Object)kobject, Vdb.class);
            if (vdb == null) {
                return Response.noContent().build();
            }
            Model[] models = vdb.getModels(uow, new String[]{modelName});
            if (models.length == 0) {
                return Response.noContent().build();
            }
            vdb.removeModel(uow, modelName);
            KomodoStatusObject kso = new KomodoStatusObject("Delete Status");
            kso.addAttribute(modelName, "Successfully deleted");
            return this.commit(uow, mediaTypes, (KRestEntity)kso);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.VDB_SERVICE_DELETE_VDB_MODEL_ERROR, new Object[0]);
        }
    }

    @GET
    @Path(value="{vdbName}/VdbTranslators")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find all translators belonging to the Vdb", response=RestVdbTranslator[].class)
    @ApiResponses(value={@ApiResponse(code=404, message="No vdb could be found with name"), @ApiResponse(code=200, message="No translators could be found but an empty list is returned"), @ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response getTranslators(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the VDB", required=true) @PathParam(value="vdbName") String vdbName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "getTranslators", true);
            Vdb vdb = this.findVdb(uow, vdbName);
            if (vdb == null) {
                return this.commitNoVdbFound(uow, mediaTypes, vdbName);
            }
            Translator[] translators = vdb.getTranslators(uow, new String[0]);
            if (translators == null) {
                translators = new Translator[]{};
            }
            ArrayList<RestVdbTranslator> restTranslators = new ArrayList<RestVdbTranslator>(translators.length);
            for (Translator translator : translators) {
                RestVdbTranslator entity = (RestVdbTranslator)this.entityFactory.create((KomodoObject)translator, uriInfo.getBaseUri(), uow);
                restTranslators.add(entity);
                LOGGER.debug("getTranslators:Translator from VDB '{0}' entity was constructed", new Object[]{vdbName});
            }
            return this.commit(uow, mediaTypes, restTranslators);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.VDB_SERVICE_GET_TRANSLATORS_ERROR, new Object[]{vdbName});
        }
    }

    @GET
    @Path(value="{vdbName}/VdbTranslators/{translatorName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find the named translator belonging to the vdb", response=RestVdbTranslator.class)
    @ApiResponses(value={@ApiResponse(code=404, message="No vdb could be found with name"), @ApiResponse(code=404, message="No translator could be found with name"), @ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response getTranslator(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the Vdb", required=true) @PathParam(value="vdbName") String vdbName, @ApiParam(value="Name of the translator to be fetched", required=true) @PathParam(value="translatorName") String translatorName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "getTranslator", true);
            Vdb vdb = this.findVdb(uow, vdbName);
            if (vdb == null) {
                return this.commitNoVdbFound(uow, mediaTypes, vdbName);
            }
            Translator[] translators = vdb.getTranslators(uow, new String[0]);
            if (translators == null || translators.length == 0) {
                LOGGER.debug("getTranslators:No translators found for vdb '{0}'", new Object[]{vdbName});
                String resourceName = this.uri(new String[]{vdbName, "VdbTranslators", translatorName});
                return this.commit(uow, mediaTypes, (KRestEntity)new RestBasicEntity.ResourceNotFound(resourceName, Messages.getString((Enum)Messages.General.GET_OPERATION_NAME, (Object[])new Object[0])));
            }
            Translator translator = null;
            for (Translator tr : translators) {
                if (!translatorName.equals(tr.getName(uow))) continue;
                translator = tr;
                break;
            }
            if (translator == null) {
                return this.commit(uow, mediaTypes, (KRestEntity)new RestBasicEntity.ResourceNotFound(this.uri(new String[]{vdbName, "VdbTranslators", translatorName}), Messages.getString((Enum)Messages.General.GET_OPERATION_NAME, (Object[])new Object[0])));
            }
            RestVdbTranslator restTranslator = (RestVdbTranslator)this.entityFactory.create(translator, uriInfo.getBaseUri(), uow);
            LOGGER.debug("getTranslator:Translator '{0}' from VDB '{1}' entity was constructed", new Object[]{translatorName, vdbName});
            return this.commit(uow, mediaTypes, (KRestEntity)restTranslator);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.VDB_SERVICE_GET_TRANSLATOR_ERROR, new Object[]{translatorName, vdbName});
        }
    }

    @GET
    @Path(value="{vdbName}/VdbImports")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find all imports belonging to the vdb", response=RestVdbImport[].class)
    @ApiResponses(value={@ApiResponse(code=404, message="No vdb could be found with name"), @ApiResponse(code=200, message="No imports could be found but an empty list is returned"), @ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response getImports(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the Vdb", required=true) @PathParam(value="vdbName") String vdbName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "getImports", true);
            Vdb vdb = this.findVdb(uow, vdbName);
            if (vdb == null) {
                return this.commitNoVdbFound(uow, mediaTypes, vdbName);
            }
            VdbImport[] imports = vdb.getImports(uow, new String[0]);
            if (imports == null) {
                imports = new VdbImport[]{};
            }
            ArrayList<RestVdbImport> restImports = new ArrayList<RestVdbImport>(imports.length);
            for (VdbImport vdbImport : imports) {
                RestVdbImport entity = (RestVdbImport)this.entityFactory.create((KomodoObject)vdbImport, uriInfo.getBaseUri(), uow);
                restImports.add(entity);
                LOGGER.debug("getImports:Import from VDB '{0}' entity was constructed", new Object[]{vdbName});
            }
            return this.commit(uow, mediaTypes, restImports);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.VDB_SERVICE_GET_IMPORTS_ERROR, new Object[]{vdbName});
        }
    }

    @GET
    @Path(value="{vdbName}/VdbImports/{importName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find the named vdb import belonging to the vdb", response=RestVdbImport.class)
    @ApiResponses(value={@ApiResponse(code=404, message="No vdb could be found with name"), @ApiResponse(code=404, message="No import could be found with name"), @ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response getImport(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the Vdb", required=true) @PathParam(value="vdbName") String vdbName, @ApiParam(value="Name of the Vdb import to be fetched", required=true) @PathParam(value="importName") String importName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "getImport", true);
            Vdb vdb = this.findVdb(uow, vdbName);
            if (vdb == null) {
                return this.commitNoVdbFound(uow, mediaTypes, vdbName);
            }
            VdbImport[] imports = vdb.getImports(uow, new String[0]);
            if (imports == null || imports.length == 0) {
                LOGGER.debug("getImport:No import found for vdb '{0}'", new Object[]{vdbName});
                String resourceName = this.uri(new String[]{vdbName, "VdbTranslators", importName});
                return this.commit(uow, mediaTypes, (KRestEntity)new RestBasicEntity.ResourceNotFound(resourceName, Messages.getString((Enum)Messages.General.GET_OPERATION_NAME, (Object[])new Object[0])));
            }
            VdbImport vdbImport = null;
            for (VdbImport imp : imports) {
                if (!importName.equals(imp.getName(uow))) continue;
                vdbImport = imp;
                break;
            }
            if (vdbImport == null) {
                return this.commit(uow, mediaTypes, (KRestEntity)new RestBasicEntity.ResourceNotFound(this.uri(new String[]{vdbName, "VdbImports", importName}), Messages.getString((Enum)Messages.General.GET_OPERATION_NAME, (Object[])new Object[0])));
            }
            RestVdbImport restImport = (RestVdbImport)this.entityFactory.create(vdbImport, uriInfo.getBaseUri(), uow);
            LOGGER.debug("getImport:Import '{0}' from VDB '{1}' entity was constructed", new Object[]{importName, vdbName});
            return this.commit(uow, mediaTypes, (KRestEntity)restImport);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.VDB_SERVICE_GET_IMPORT_ERROR, new Object[]{importName, vdbName});
        }
    }

    @GET
    @Path(value="{vdbName}/VdbDataRoles")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find all data roles belonging to the vdb", response=RestBasicEntity[].class)
    @ApiResponses(value={@ApiResponse(code=404, message="No vdb could be found with name"), @ApiResponse(code=200, message="No data roles could be found but an empty list is returned"), @ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response getDataRoles(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the Vdb", required=true) @PathParam(value="vdbName") String vdbName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "getDataRoles", true);
            Vdb vdb = this.findVdb(uow, vdbName);
            if (vdb == null) {
                return this.commitNoVdbFound(uow, mediaTypes, vdbName);
            }
            DataRole[] dataRoles = vdb.getDataRoles(uow, new String[0]);
            if (dataRoles == null) {
                dataRoles = new DataRole[]{};
            }
            ArrayList<RestVdbDataRole> restDataRoles = new ArrayList<RestVdbDataRole>(dataRoles.length);
            for (DataRole dataRole : dataRoles) {
                RestVdbDataRole entity = (RestVdbDataRole)this.entityFactory.create((KomodoObject)dataRole, uriInfo.getBaseUri(), uow);
                restDataRoles.add(entity);
                LOGGER.debug("getDataRoles:Data role from VDB '{0}' entity was constructed", new Object[]{vdbName});
            }
            return this.commit(uow, mediaTypes, restDataRoles);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.VDB_SERVICE_GET_DATA_ROLES_ERROR, new Object[]{vdbName});
        }
    }

    @POST
    @Path(value="{vdbName}/VdbDataRoles/{dataRoleId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a VDB data role")
    @ApiResponses(value={@ApiResponse(code=404, message="No VDB could be found with specified name"), @ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response createDataRole(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the VDB", required=true) @PathParam(value="vdbName") String vdbName, @ApiParam(value="Name of the data role", required=true) @PathParam(value="dataRoleId") String dataRoleName, @ApiParam(value="JSON of the properties of the data role to add:<br><pre>{<br>&nbsp;keng\\_\\_id: \"name of the data role\",<br>&nbsp;keng\\_\\_dataPath: \"path of the data role to create\",<br>&nbsp;<pre-cmt class=\"json-comment\">(eg keng\\_\\_dataPath: \"tko:komodo\\tko:workspace\\\\{username\\}\\\\{vdbName\\}\\vdb:dataRoles\\\\{dataRoleName\\}\")</pre-cmt><br>&nbsp;keng\\_\\_kType: \"DataRole\"<br>}</pre>", required=true) String dataRoleJson) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        if (StringUtils.isBlank((String)vdbName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_CREATE_MISSING_VDB_NAME, new Object[0]);
        }
        if (StringUtils.isBlank((String)dataRoleName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_CREATE_MISSING_DATA_ROLE_NAME, new Object[0]);
        }
        RestVdbDataRole restDataRole = (RestVdbDataRole)KomodoJsonMarshaller.unmarshall((String)dataRoleJson, RestVdbDataRole.class);
        String jsonDataRoleName = restDataRole.getId();
        if (StringUtils.isBlank((String)jsonDataRoleName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_MISSING_JSON_DATA_ROLE_NAME, new Object[0]);
        }
        boolean namesMatch = dataRoleName.equals(jsonDataRoleName);
        if (!namesMatch) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_DATA_ROLE_NAME_DONT_MATCH_ERROR, new Object[]{dataRoleName, jsonDataRoleName});
        }
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "createDataRole", false);
            WorkspaceManager mgr = this.getWorkspaceManager(uow);
            KomodoObject kobject = mgr.getChild(uow, vdbName, "vdb:virtualDatabase");
            Vdb vdb = (Vdb)mgr.resolve(uow, (Object)kobject, Vdb.class);
            if (vdb == null) {
                return Response.noContent().build();
            }
            if (vdb.getDataRoles(uow, new String[]{dataRoleName}).length != 0) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_DATA_ROLE_ALREADY_EXISTS, new Object[]{dataRoleName});
            }
            return this.doAddDataRole(uow, uriInfo.getBaseUri(), mediaTypes, vdb, restDataRole);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.VDB_SERVICE_CREATE_DATA_ROLE_ERROR, new Object[]{vdbName, dataRoleName});
        }
    }

    private Response doAddDataRole(Repository.UnitOfWork uow, URI baseUri, List<MediaType> mediaTypes, Vdb vdb, RestVdbDataRole restDataRole) throws KomodoRestException {
        assert (!uow.isRollbackOnly());
        assert (uow.getState() == Repository.UnitOfWork.State.NOT_STARTED);
        assert (vdb != null);
        assert (restDataRole != null);
        String dataRoleName = restDataRole.getId();
        try {
            DataRole newDataRole = vdb.addDataRole(uow, dataRoleName);
            this.setDataRoleState(uow, newDataRole, restDataRole);
            RestVdbDataRole entity = (RestVdbDataRole)this.entityFactory.create((KomodoObject)newDataRole, baseUri, uow);
            Response response = this.commit(uow, mediaTypes, (KRestEntity)entity);
            return response;
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            throw new KomodoRestException(RelationalMessages.getString((Enum)RelationalMessages.Error.VDB_SERVICE_CREATE_DATA_ROLE_ERROR, (Object[])new Object[]{dataRoleName}), (Throwable)e);
        }
    }

    private void setDataRoleState(Repository.UnitOfWork uow, DataRole dataRole, RestVdbDataRole restVdbDataRole) throws KException {
        RestVdbPermission[] permissions;
        String current;
        String proposed = restVdbDataRole.getDescription();
        if (!StringUtils.equals((String)proposed, (String)(current = dataRole.getDescription(uow)))) {
            dataRole.setDescription(uow, proposed);
        }
        if ((proposed = restVdbDataRole.isAllowCreateTempTables()) != (current = dataRole.isAllowCreateTempTables(uow))) {
            dataRole.setAllowCreateTempTables(uow, proposed);
        }
        if ((proposed = restVdbDataRole.isAnyAuthenticated()) != (current = dataRole.isAnyAuthenticated(uow))) {
            dataRole.setAnyAuthenticated(uow, proposed);
        }
        if ((proposed = restVdbDataRole.isGrantAll()) != (current = dataRole.isGrantAll(uow))) {
            dataRole.setGrantAll(uow, proposed);
        }
        Object[] proposed2 = restVdbDataRole.getMappedRoles();
        Arrays.sort(proposed2);
        Object[] current2 = dataRole.getMappedRoles(uow, new String[0]);
        Arrays.sort(current2);
        if (!Arrays.equals(proposed2, current2)) {
            Object role;
            int n;
            int n2;
            Object[] objectArray;
            if (current2.length != 0) {
                objectArray = current2;
                n2 = objectArray.length;
                for (n = 0; n < n2; ++n) {
                    role = objectArray[n];
                    dataRole.removeMappedRole(uow, (String)role);
                }
            }
            if (proposed2.length != 0) {
                objectArray = proposed2;
                n2 = objectArray.length;
                for (n = 0; n < n2; ++n) {
                    role = objectArray[n];
                    dataRole.addMappedRole(uow, (String)role);
                }
            }
        }
        if ((permissions = restVdbDataRole.getPermissions()).length != 0) {
            for (RestVdbPermission restPermission : permissions) {
                Permission permission = dataRole.addPermission(uow, restPermission.getName());
                permission.setAllowAlter(uow, restPermission.isAllowAlter());
                permission.setAllowCreate(uow, restPermission.isAllowCreate());
                permission.setAllowDelete(uow, restPermission.isAllowDelete());
                permission.setAllowExecute(uow, restPermission.isAllowExecute());
                permission.setAllowLanguage(uow, restPermission.isAllowLanguage());
                permission.setAllowRead(uow, restPermission.isAllowRead());
                permission.setAllowUpdate(uow, restPermission.isAllowUpdate());
            }
        }
    }

    @DELETE
    @Path(value="{vdbName}/VdbDataRoles/{dataRoleId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete a data role from the VDB")
    @ApiResponses(value={@ApiResponse(code=404, message="No VDB could be found with name"), @ApiResponse(code=404, message="No data role could be found with name"), @ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response deleteDataRole(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the VDB", required=true) @PathParam(value="vdbName") String vdbName, @ApiParam(value="Name of the data role to remove", required=true) @PathParam(value="dataRoleId") String dataRoleName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        if (StringUtils.isBlank((String)vdbName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_DELETE_MISSING_VDB_NAME, new Object[0]);
        }
        if (StringUtils.isBlank((String)dataRoleName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_DELETE_MISSING_DATA_ROLE_NAME, new Object[0]);
        }
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "deleteDataRole", false);
            WorkspaceManager mgr = this.getWorkspaceManager(uow);
            KomodoObject kobject = mgr.getChild(uow, vdbName, "vdb:virtualDatabase");
            Vdb vdb = (Vdb)mgr.resolve(uow, (Object)kobject, Vdb.class);
            if (vdb == null) {
                return Response.noContent().build();
            }
            DataRole[] dataRoles = vdb.getDataRoles(uow, new String[]{dataRoleName});
            if (dataRoles.length == 0) {
                return Response.noContent().build();
            }
            vdb.removeDataRole(uow, dataRoleName);
            KomodoStatusObject kso = new KomodoStatusObject(RelationalMessages.getString((Enum)RelationalMessages.Info.DELETE_STATUS_TITLE, (Object[])new Object[0]));
            kso.addAttribute(dataRoleName, RelationalMessages.getString((Enum)RelationalMessages.Info.DELETE_STATUS_MSG, (Object[])new Object[0]));
            return this.commit(uow, mediaTypes, (KRestEntity)kso);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.VDB_SERVICE_DELETE_DATA_ROLE_ERROR, new Object[]{dataRoleName});
        }
    }

    @GET
    @Path(value="{vdbName}/VdbDataRoles/{dataRoleId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find the named data role belonging to the vdb", response=RestVdbDataRole.class)
    @ApiResponses(value={@ApiResponse(code=404, message="No vdb could be found with name"), @ApiResponse(code=404, message="No data role could be found with name"), @ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response getDataRole(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the Vdb", required=true) @PathParam(value="vdbName") String vdbName, @ApiParam(value="Name of the Data Role to be fetched", required=true) @PathParam(value="dataRoleId") String dataRoleId) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "getDataRole", true);
            Vdb vdb = this.findVdb(uow, vdbName);
            if (vdb == null) {
                return this.commitNoVdbFound(uow, mediaTypes, vdbName);
            }
            DataRole dataRole = this.findDataRole(uow, mediaTypes, dataRoleId, vdb);
            if (dataRole == null) {
                return this.commitNoDataRoleFound(uow, mediaTypes, dataRoleId, vdbName);
            }
            RestBasicEntity restDataRole = this.entityFactory.create((KomodoObject)dataRole, uriInfo.getBaseUri(), uow);
            LOGGER.debug("getDataRole:data role '{0}' from VDB '{1}' entity was constructed", new Object[]{dataRoleId, vdbName});
            return this.commit(uow, mediaTypes, (KRestEntity)restDataRole);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.VDB_SERVICE_GET_DATA_ROLE_ERROR, new Object[]{dataRoleId, vdbName});
        }
    }

    @GET
    @Path(value="{vdbName}/Models/{modelName}/VdbModelSources")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find all ModelSources belonging to the Vdb Model", response=RestVdbModelSource[].class)
    @ApiResponses(value={@ApiResponse(code=404, message="No vdb could be found with name"), @ApiResponse(code=200, message="No sources could be found but an empty list is returned"), @ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response getModelSources(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the Vdb", required=true) @PathParam(value="vdbName") String vdbName, @ApiParam(value="Name of the Model to get its Sources", required=true) @PathParam(value="modelName") String modelName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "getSources", true);
            Vdb vdb = this.findVdb(uow, vdbName);
            if (vdb == null) {
                return this.commitNoVdbFound(uow, mediaTypes, vdbName);
            }
            Model model = this.findModel(uow, mediaTypes, modelName, vdb);
            if (model == null) {
                return this.commitNoModelFound(uow, mediaTypes, modelName, vdbName);
            }
            ModelSource[] sources = model.getSources(uow, new String[0]);
            if (sources == null) {
                sources = new ModelSource[]{};
            }
            ArrayList<RestVdbModelSource> restSources = new ArrayList<RestVdbModelSource>(sources.length);
            for (ModelSource source : sources) {
                RestVdbModelSource entity = (RestVdbModelSource)this.entityFactory.create((KomodoObject)source, uriInfo.getBaseUri(), uow);
                restSources.add(entity);
                LOGGER.debug("getSources:Source from Model '{0}' from VDB '{1}' entity was constructed", new Object[]{modelName, vdbName});
            }
            return this.commit(uow, mediaTypes, restSources);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.VDB_SERVICE_GET_SOURCES_ERROR, new Object[]{modelName, vdbName});
        }
    }

    @GET
    @Path(value="{vdbName}/Models/{modelName}/VdbModelSources/{sourceName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find the ModelSource belonging to the Vdb Model", response=RestVdbModelSource.class)
    @ApiResponses(value={@ApiResponse(code=404, message="No vdb could be found with name"), @ApiResponse(code=404, message="No model could be found with name"), @ApiResponse(code=404, message="No source could be found with name"), @ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response getModelSource(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the Vdb", required=true) @PathParam(value="vdbName") String vdbName, @ApiParam(value="Name of the Model", required=true) @PathParam(value="modelName") String modelName, @ApiParam(value="Name of the Model Source to be fetched", required=true) @PathParam(value="sourceName") String sourceName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "getSource", true);
            Vdb vdb = this.findVdb(uow, vdbName);
            if (vdb == null) {
                return this.commitNoVdbFound(uow, mediaTypes, vdbName);
            }
            Model model = this.findModel(uow, mediaTypes, modelName, vdb);
            if (model == null) {
                return this.commitNoModelFound(uow, mediaTypes, modelName, vdbName);
            }
            ModelSource[] sources = model.getSources(uow, new String[0]);
            if (sources == null || sources.length == 0) {
                LOGGER.debug("getSource:No sources found for model '{0}' in vdb '{1}'", new Object[]{modelName, vdbName});
                String resourceName = this.uri(new String[]{vdbName, "Models", modelName, "VdbModelSources"});
                return this.commit(uow, mediaTypes, (KRestEntity)new RestBasicEntity.ResourceNotFound(resourceName, Messages.getString((Enum)Messages.General.GET_OPERATION_NAME, (Object[])new Object[0])));
            }
            ModelSource source = null;
            for (ModelSource src : sources) {
                if (!sourceName.equals(src.getName(uow))) continue;
                source = src;
                break;
            }
            if (source == null) {
                return this.commit(uow, mediaTypes, (KRestEntity)new RestBasicEntity.ResourceNotFound(this.uri(new String[]{vdbName, "Models", modelName, "VdbModelSources", sourceName}), Messages.getString((Enum)Messages.General.GET_OPERATION_NAME, (Object[])new Object[0])));
            }
            RestVdbModelSource restSource = (RestVdbModelSource)this.entityFactory.create(source, uriInfo.getBaseUri(), uow);
            LOGGER.debug("getSource:Source '{0}' from Model '{1}' from VDB '{2}' entity was constructed", new Object[]{sourceName, modelName, vdbName});
            return this.commit(uow, mediaTypes, (KRestEntity)restSource);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.VDB_SERVICE_GET_SOURCE_ERROR, new Object[]{sourceName, modelName, vdbName});
        }
    }

    @POST
    @Path(value="{vdbName}/Models/{modelName}/VdbModelSources/{sourceName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a ModelSource within a Vdb Model", response=RestVdbModelSource.class)
    @ApiResponses(value={@ApiResponse(code=404, message="No vdb could be found with name"), @ApiResponse(code=404, message="No model could be found with name"), @ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response createModelSource(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the Vdb", required=true) @PathParam(value="vdbName") String vdbName, @ApiParam(value="Name of the Model", required=true) @PathParam(value="modelName") String modelName, @ApiParam(value="Name of the Model Source to be created", required=true) @PathParam(value="sourceName") String sourceName, @ApiParam(value="JSON of the properties of the Model Source to add:<br><pre>{<br>&nbsp;keng\\_\\_id: \"name of the VdbModelSource\",<br>&nbsp;keng\\_\\_dataPath: \"path of VdbModelSource to create\",<br>&nbsp;<pre-cmt class=\"json-comment\">(eg keng\\_\\_dataPath: \"tko:komodo\\tko:workspace\\\\{username\\}\\\\{vdbName\\}\\\\{modelName\\}\\vdb:sources\\\\{sourceName\\}\")</pre-cmt><br>&nbsp;keng\\_\\_kType: \"VdbModelSource\",<br>&nbsp;vdb\\_\\_sourceJndiName: \"the jndi name\",<br>&nbsp;vdb\\_\\_sourceTranslator: \"the translator name\"<br>}</pre>", required=true) String sourceJson) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        if (StringUtils.isBlank((String)vdbName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_CREATE_MISSING_VDB_NAME, new Object[0]);
        }
        if (StringUtils.isBlank((String)modelName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_CREATE_MISSING_MODEL_NAME, new Object[0]);
        }
        if (StringUtils.isBlank((String)sourceName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_CREATE_MISSING_MODEL_SOURCE_NAME, new Object[0]);
        }
        RestVdbModelSource restVdbModelSource = (RestVdbModelSource)KomodoJsonMarshaller.unmarshall((String)sourceJson, RestVdbModelSource.class);
        String jsonModelSourceName = restVdbModelSource.getId();
        if (StringUtils.isBlank((String)jsonModelSourceName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_MISSING_JSON_MODEL_SOURCE_NAME, new Object[0]);
        }
        boolean namesMatch = sourceName.equals(jsonModelSourceName);
        if (!namesMatch) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_MODEL_SOURCE_NAME_DONT_MATCH_ERROR, new Object[]{sourceName, jsonModelSourceName});
        }
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "createModelSource", false);
            WorkspaceManager mgr = this.getWorkspaceManager(uow);
            KomodoObject kobject = mgr.getChild(uow, vdbName, "vdb:virtualDatabase");
            Vdb vdb = (Vdb)mgr.resolve(uow, (Object)kobject, Vdb.class);
            if (vdb == null) {
                return Response.noContent().build();
            }
            Model[] models = vdb.getModels(uow, new String[]{modelName});
            if (models.length == 0) {
                return Response.noContent().build();
            }
            Model model = models[0];
            if (model.getSources(uow, new String[]{sourceName}).length != 0) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_VDB_MODEL_SOURCE_ALREADY_EXISTS, new Object[]{sourceName});
            }
            return this.doAddModelSource(uow, uriInfo.getBaseUri(), mediaTypes, model, restVdbModelSource);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.VDB_SERVICE_CREATE_VDB_MODEL_SOURCE_ERROR, new Object[]{vdbName});
        }
    }

    private Response doAddModelSource(Repository.UnitOfWork uow, URI baseUri, List<MediaType> mediaTypes, Model model, RestVdbModelSource restVdbModelSource) throws KomodoRestException {
        assert (!uow.isRollbackOnly());
        assert (uow.getState() == Repository.UnitOfWork.State.NOT_STARTED);
        assert (model != null);
        assert (restVdbModelSource != null);
        String sourceName = restVdbModelSource.getId();
        try {
            ModelSource newSource = model.addSource(uow, sourceName);
            this.setProperties(uow, newSource, restVdbModelSource);
            RestVdbModelSource entity = (RestVdbModelSource)this.entityFactory.create((KomodoObject)newSource, baseUri, uow);
            Response response = this.commit(uow, mediaTypes, (KRestEntity)entity);
            return response;
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            throw new KomodoRestException(RelationalMessages.getString((Enum)RelationalMessages.Error.VDB_SERVICE_CREATE_VDB_MODEL_SOURCE_ERROR, (Object[])new Object[]{sourceName}), (Throwable)e);
        }
    }

    @PUT
    @Path(value="{vdbName}/Models/{modelName}/VdbModelSources/{sourceName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Update the ModelSource belonging to the Vdb Model", response=RestVdbModelSource.class)
    @ApiResponses(value={@ApiResponse(code=404, message="No vdb could be found with name"), @ApiResponse(code=404, message="No model could be found with name"), @ApiResponse(code=404, message="No source could be found with name"), @ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response updateModelSource(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the Vdb", required=true) @PathParam(value="vdbName") String vdbName, @ApiParam(value="Name of the Model", required=true) @PathParam(value="modelName") String modelName, @ApiParam(value="Name of the Model Source to be updated", required=true) @PathParam(value="sourceName") String sourceName, @ApiParam(value="JSON of the properties of the Model Source to update:<br><pre>{<br>&nbsp;keng\\_\\_id: \"name of the VdbModelSource\",<br>&nbsp;keng\\_\\_dataPath: \"path of VdbModelSource to update\",<br>&nbsp;<pre-cmt class=\"json-comment\">(eg keng\\_\\_dataPath: \"tko:komodo\\tko:workspace\\\\{username\\}\\\\{vdbName\\}\\\\{modelName\\}\\vdb:sources\\\\{sourceName\\}\")</pre-cmt><br>&nbsp;keng\\_\\_kType: \"VdbModelSource\",<br>&nbsp;vdb\\_\\_sourceJndiName: \"the jndi name\",<br>&nbsp;vdb\\_\\_sourceTranslator: \"the translator name\"<br>}</pre>", required=true) String sourceJson) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        if (StringUtils.isBlank((String)vdbName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_UPDATE_MISSING_VDB_NAME, new Object[0]);
        }
        if (StringUtils.isBlank((String)modelName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_UPDATE_MISSING_MODEL_NAME, new Object[0]);
        }
        if (StringUtils.isBlank((String)sourceName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_UPDATE_MISSING_MODEL_SOURCE_NAME, new Object[0]);
        }
        RestVdbModelSource restVdbModelSource = (RestVdbModelSource)KomodoJsonMarshaller.unmarshall((String)sourceJson, RestVdbModelSource.class);
        String jsonModelSourceName = restVdbModelSource.getId();
        if (StringUtils.isBlank((String)jsonModelSourceName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_MISSING_JSON_MODEL_SOURCE_NAME, new Object[0]);
        }
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "updateModelSource", false);
            KomodoObject kobject = this.getWorkspaceManager(uow).getChild(uow, vdbName, "vdb:virtualDatabase");
            Vdb vdb = (Vdb)this.getWorkspaceManager(uow).resolve(uow, (Object)kobject, Vdb.class);
            if (vdb == null) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_UPDATE_VDB_DNE, new Object[0]);
            }
            Model[] models = vdb.getModels(uow, new String[]{modelName});
            if (models.length == 0) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_UPDATE_VDB_MODEL_DNE, new Object[0]);
            }
            Model model = models[0];
            ModelSource[] sources = model.getSources(uow, new String[]{sourceName});
            if (sources.length == 0) {
                return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_VDB_MODEL_SOURCE_ALREADY_EXISTS, new Object[]{modelName});
            }
            this.setProperties(uow, sources[0], restVdbModelSource);
            KomodoProperties properties = new KomodoProperties();
            RestVdbModelSource entity = (RestVdbModelSource)this.entityFactory.create((KomodoObject)sources[0], uriInfo.getBaseUri(), uow, properties);
            LOGGER.debug("updateVdbModelSource: VdbModelSource '{0}' entity was updated", new Object[]{sources[0].getName(uow)});
            Response response = this.commit(uow, headers.getAcceptableMediaTypes(), (KRestEntity)entity);
            return response;
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.VDB_SERVICE_UPDATE_VDB_MODEL_SOURCE_ERROR, new Object[0]);
        }
    }

    @DELETE
    @Path(value="{vdbName}/Models/{modelName}/VdbModelSources/{sourceName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete the ModelSource in the specified Vdb Model", response=RestVdbModelSource.class)
    @ApiResponses(value={@ApiResponse(code=404, message="No vdb could be found with name"), @ApiResponse(code=404, message="No model could be found with name"), @ApiResponse(code=404, message="No source could be found with name"), @ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response deleteModelSource(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the Vdb", required=true) @PathParam(value="vdbName") String vdbName, @ApiParam(value="Name of the Model", required=true) @PathParam(value="modelName") String modelName, @ApiParam(value="Name of the Model Source to be deleted", required=true) @PathParam(value="sourceName") String sourceName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        if (!this.isAcceptable(mediaTypes, MediaType.APPLICATION_JSON_TYPE)) {
            return this.notAcceptableMediaTypesBuilder().build();
        }
        if (StringUtils.isBlank((String)vdbName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_DELETE_MISSING_VDB_NAME, new Object[0]);
        }
        if (StringUtils.isBlank((String)modelName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_DELETE_MISSING_MODEL_NAME, new Object[0]);
        }
        if (StringUtils.isBlank((String)sourceName)) {
            return this.createErrorResponseWithForbidden(mediaTypes, RelationalMessages.Error.VDB_SERVICE_DELETE_MISSING_MODEL_SOURCE_NAME, new Object[0]);
        }
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "removeModelSourceFromModel", false);
            WorkspaceManager mgr = this.getWorkspaceManager(uow);
            KomodoObject kobject = mgr.getChild(uow, vdbName, "vdb:virtualDatabase");
            Vdb vdb = (Vdb)mgr.resolve(uow, (Object)kobject, Vdb.class);
            if (vdb == null) {
                return Response.noContent().build();
            }
            Model[] models = vdb.getModels(uow, new String[]{modelName});
            if (models.length == 0) {
                return Response.noContent().build();
            }
            Model model = models[0];
            model.removeSource(uow, sourceName);
            KomodoStatusObject kso = new KomodoStatusObject("Delete Status");
            kso.addAttribute(modelName, "Successfully deleted");
            return this.commit(uow, mediaTypes, (KRestEntity)kso);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.VDB_SERVICE_DELETE_VDB_MODEL_SOURCE_ERROR, new Object[0]);
        }
    }

    @GET
    @Path(value="{vdbName}/Models/{modelName}/Tables")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find all tables of the model belonging to the vdb", response=RestVdbModelTable[].class)
    @ApiResponses(value={@ApiResponse(code=404, message="No vdb could be found with name"), @ApiResponse(code=200, message="No tables could be found but an empty list is returned"), @ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response getModelTables(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the Vdb", required=true) @PathParam(value="vdbName") String vdbName, @ApiParam(value="Name of the Model to get its tables", required=true) @PathParam(value="modelName") String modelName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "getTables", true);
            Vdb vdb = this.findVdb(uow, vdbName);
            if (vdb == null) {
                return this.commitNoVdbFound(uow, mediaTypes, vdbName);
            }
            Model model = this.findModel(uow, mediaTypes, modelName, vdb);
            if (model == null) {
                return this.commitNoModelFound(uow, mediaTypes, modelName, vdbName);
            }
            Table[] tables = model.getTables(uow, new String[0]);
            if (tables == null) {
                tables = new Table[]{};
            }
            ArrayList<RestVdbModelTable> restTables = new ArrayList<RestVdbModelTable>(tables.length);
            for (Table table : tables) {
                RestVdbModelTable entity = (RestVdbModelTable)this.entityFactory.create((KomodoObject)table, uriInfo.getBaseUri(), uow);
                restTables.add(entity);
                LOGGER.debug("getTables:Table from Model '{0}' from VDB '{1}' entity was constructed", new Object[]{modelName, vdbName});
            }
            return this.commit(uow, mediaTypes, restTables);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.VDB_SERVICE_GET_TABLES_ERROR, new Object[]{vdbName, modelName});
        }
    }

    @GET
    @Path(value="{vdbName}/Models/{modelName}/Tables/{tableName}/Columns")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find all columns of the specified vdb model table", response=RestVdbModelTableColumn[].class)
    @ApiResponses(value={@ApiResponse(code=404, message="No vdb could be found with name"), @ApiResponse(code=200, message="No tables could be found but an empty list is returned"), @ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response getModelTableColumns(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the Vdb", required=true) @PathParam(value="vdbName") String vdbName, @ApiParam(value="Name of the Model", required=true) @PathParam(value="modelName") String modelName, @ApiParam(value="Name of the Table to get its columns", required=true) @PathParam(value="tableName") String tableName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "getTables", true);
            Vdb vdb = this.findVdb(uow, vdbName);
            if (vdb == null) {
                return this.commitNoVdbFound(uow, mediaTypes, vdbName);
            }
            Model model = this.findModel(uow, mediaTypes, modelName, vdb);
            if (model == null) {
                return this.commitNoModelFound(uow, mediaTypes, modelName, vdbName);
            }
            Table table = this.findTable(uow, mediaTypes, tableName, model);
            if (table == null) {
                return this.commitNoTableFound(uow, mediaTypes, tableName, modelName, vdbName);
            }
            Column[] columns = table.getColumns(uow, new String[0]);
            if (columns == null) {
                columns = new Column[]{};
            }
            ArrayList<RestVdbModelTableColumn> restColumns = new ArrayList<RestVdbModelTableColumn>(columns.length);
            for (Column column : columns) {
                RestVdbModelTableColumn entity = (RestVdbModelTableColumn)this.entityFactory.create((KomodoObject)column, uriInfo.getBaseUri(), uow);
                restColumns.add(entity);
                LOGGER.debug("getColumns:Column from Table '{0}' from Model '{1}' entity was constructed", new Object[]{tableName, modelName});
            }
            return this.commit(uow, mediaTypes, restColumns);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.VDB_SERVICE_GET_COLUMNS_ERROR, new Object[]{vdbName, modelName, tableName});
        }
    }

    @GET
    @Path(value="{vdbName}/VdbDataRoles/{dataRoleId}/VdbPermissions")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find all permissions belonging to the vdb data role", response=RestVdbPermission[].class)
    @ApiResponses(value={@ApiResponse(code=404, message="No vdb or data role could be found with given names"), @ApiResponse(code=200, message="No permissions could be found but an empty list is returned"), @ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response getPermissions(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the Vdb", required=true) @PathParam(value="vdbName") String vdbName, @ApiParam(value="Name of the Data Role to get its permissions", required=true) @PathParam(value="dataRoleId") String dataRoleId) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "getPermissions", true);
            Vdb vdb = this.findVdb(uow, vdbName);
            if (vdb == null) {
                return this.commitNoVdbFound(uow, mediaTypes, vdbName);
            }
            DataRole dataRole = this.findDataRole(uow, mediaTypes, dataRoleId, vdb);
            if (dataRole == null) {
                return this.commitNoDataRoleFound(uow, mediaTypes, dataRoleId, vdbName);
            }
            Permission[] permissions = dataRole.getPermissions(uow, new String[0]);
            if (permissions == null) {
                permissions = new Permission[]{};
            }
            ArrayList<RestVdbPermission> restPermissions = new ArrayList<RestVdbPermission>(permissions.length);
            for (Permission permission : permissions) {
                RestVdbPermission entity = (RestVdbPermission)this.entityFactory.create((KomodoObject)permission, uriInfo.getBaseUri(), uow);
                restPermissions.add(entity);
                LOGGER.debug("getPermissions:Permission from Data role '{0}' from VDB '{1}' entity was constructed", new Object[]{dataRoleId, vdbName});
            }
            return this.commit(uow, mediaTypes, restPermissions);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.VDB_SERVICE_GET_PERMISSIONS_ERROR, new Object[]{vdbName});
        }
    }

    @GET
    @Path(value="{vdbName}/VdbDataRoles/{dataRoleId}/VdbPermissions/{permissionId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find the named permission belonging to the data role of the vdb", response=RestVdbPermission.class)
    @ApiResponses(value={@ApiResponse(code=404, message="No vdb, data role or permission could be found with name"), @ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response getPermission(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the Vdb", required=true) @PathParam(value="vdbName") String vdbName, @ApiParam(value="Name of the Data Role", required=true) @PathParam(value="dataRoleId") String dataRoleId, @ApiParam(value="Name of the Permission to be fetched", required=true) @PathParam(value="permissionId") String permissionId) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "getPermission", true);
            Vdb vdb = this.findVdb(uow, vdbName);
            if (vdb == null) {
                return this.commitNoVdbFound(uow, mediaTypes, vdbName);
            }
            DataRole dataRole = this.findDataRole(uow, mediaTypes, dataRoleId, vdb);
            if (dataRole == null) {
                return this.commitNoDataRoleFound(uow, mediaTypes, dataRoleId, vdbName);
            }
            Permission permission = this.findPermission(uow, mediaTypes, permissionId, dataRole, vdb);
            if (permission == null) {
                return this.commitNoPermissionFound(uow, mediaTypes, permissionId, dataRoleId, vdbName);
            }
            RestVdbPermission restPermission = (RestVdbPermission)this.entityFactory.create((KomodoObject)permission, uriInfo.getBaseUri(), uow);
            LOGGER.debug("getPermission:permission '{0}' from data role '{1}' from VDB '{2}' entity was constructed", new Object[]{permissionId, dataRoleId, vdbName});
            return this.commit(uow, mediaTypes, (KRestEntity)restPermission);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.VDB_SERVICE_GET_PERMISSION_ERROR, new Object[]{permissionId, dataRoleId, vdbName});
        }
    }

    @GET
    @Path(value="{vdbName}/VdbDataRoles/{dataRoleId}/VdbPermissions/{permissionId}/VdbConditions")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find the conditions belonging to the permission of the data role of the vdb", response=RestVdbPermission.class)
    @ApiResponses(value={@ApiResponse(code=404, message="No vdb, data role or permission could be found with given names"), @ApiResponse(code=200, message="No conditions could be found but an empty list is returned"), @ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response getConditions(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the Vdb", required=true) @PathParam(value="vdbName") String vdbName, @ApiParam(value="Name of the Data Role", required=true) @PathParam(value="dataRoleId") String dataRoleId, @ApiParam(value="Name of the Permission to get its Conditions", required=true) @PathParam(value="permissionId") String permissionId) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "getConditions", true);
            Vdb vdb = this.findVdb(uow, vdbName);
            if (vdb == null) {
                return this.commitNoVdbFound(uow, mediaTypes, vdbName);
            }
            DataRole dataRole = this.findDataRole(uow, mediaTypes, dataRoleId, vdb);
            if (dataRole == null) {
                return this.commitNoDataRoleFound(uow, mediaTypes, dataRoleId, vdbName);
            }
            Permission permission = this.findPermission(uow, mediaTypes, permissionId, dataRole, vdb);
            if (permission == null) {
                return this.commitNoPermissionFound(uow, mediaTypes, permissionId, dataRoleId, vdbName);
            }
            Condition[] conditions = permission.getConditions(uow, new String[0]);
            ArrayList<RestVdbCondition> restConditions = new ArrayList<RestVdbCondition>(conditions.length);
            for (Condition condition : conditions) {
                RestVdbCondition entity = (RestVdbCondition)this.entityFactory.create((KomodoObject)condition, uriInfo.getBaseUri(), uow);
                restConditions.add(entity);
                LOGGER.debug("getConditions:Condition from Permission from Data Role '{0}' from VDB '{1}' entity was constructed", new Object[]{dataRoleId, vdbName});
            }
            return this.commit(uow, mediaTypes, restConditions);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.VDB_SERVICE_GET_CONDITIONS_ERROR, new Object[]{permissionId, dataRoleId, vdbName});
        }
    }

    @GET
    @Path(value="{vdbName}/VdbDataRoles/{dataRoleId}/VdbPermissions/{permissionId}/VdbConditions/{conditionId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find the condition belonging to the permission of the data role of the vdb", response=RestVdbPermission.class)
    @ApiResponses(value={@ApiResponse(code=404, message="No vdb, data role, permission or condition could be found with name"), @ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response getCondition(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the Vdb", required=true) @PathParam(value="vdbName") String vdbName, @ApiParam(value="Name of the Data Role", required=true) @PathParam(value="dataRoleId") String dataRoleId, @ApiParam(value="Name of the Permission", required=true) @PathParam(value="permissionId") String permissionId, @ApiParam(value="Name of the Condition to be fetched", required=true) @PathParam(value="conditionId") String conditionId) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "getCondition", true);
            Vdb vdb = this.findVdb(uow, vdbName);
            if (vdb == null) {
                return this.commitNoVdbFound(uow, mediaTypes, vdbName);
            }
            DataRole dataRole = this.findDataRole(uow, mediaTypes, dataRoleId, vdb);
            if (dataRole == null) {
                return this.commitNoDataRoleFound(uow, mediaTypes, dataRoleId, vdbName);
            }
            Permission permission = this.findPermission(uow, mediaTypes, permissionId, dataRole, vdb);
            if (permission == null) {
                return this.commitNoPermissionFound(uow, mediaTypes, permissionId, dataRoleId, vdbName);
            }
            Condition[] conditions = permission.getConditions(uow, new String[0]);
            if (conditions == null || conditions.length == 0) {
                LOGGER.debug("getConition:No conditions found for vdb '{0}'", new Object[]{vdbName});
                String resourceName = this.uri(new String[]{vdbName, "VdbDataRoles", dataRoleId, "VdbPermissions", permissionId, "VdbConditions", conditionId});
                return this.commit(uow, mediaTypes, (KRestEntity)new RestBasicEntity.ResourceNotFound(resourceName, Messages.getString((Enum)Messages.General.GET_OPERATION_NAME, (Object[])new Object[0])));
            }
            Condition condition = null;
            for (Condition con : conditions) {
                if (!conditionId.equals(con.getName(uow))) continue;
                condition = con;
                break;
            }
            if (condition == null) {
                LOGGER.debug("No condition '{0}' for permission '{1}' for data role '{2}' found for vdb '{3}'", new Object[]{conditionId, permissionId, dataRoleId, vdbName});
                return this.commit(uow, mediaTypes, (KRestEntity)new RestBasicEntity.ResourceNotFound(this.uri(new String[]{vdbName, "VdbDataRoles", dataRoleId, "VdbPermissions", permissionId, "VdbConditions", conditionId}), Messages.getString((Enum)Messages.General.GET_OPERATION_NAME, (Object[])new Object[0])));
            }
            RestVdbCondition restCondition = (RestVdbCondition)this.entityFactory.create(condition, uriInfo.getBaseUri(), uow);
            LOGGER.debug("getCondition:condition '{0}' from permission '{1}' from data role '{2}' from VDB '{3}' entity was constructed", new Object[]{permissionId, dataRoleId, vdbName});
            return this.commit(uow, mediaTypes, (KRestEntity)restCondition);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.VDB_SERVICE_GET_CONDITION_ERROR, new Object[]{conditionId, permissionId, dataRoleId, vdbName});
        }
    }

    @GET
    @Path(value="{vdbName}/VdbDataRoles/{dataRoleId}/VdbPermissions/{permissionId}/VdbMasks")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find the masks belonging to the permission of the data role of the vdb", response=RestVdbPermission.class)
    @ApiResponses(value={@ApiResponse(code=404, message="No vdb, data role or permission could be found with given names"), @ApiResponse(code=200, message="No masks could be found but an empty list is returned"), @ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response getMasks(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the Vdb", required=true) @PathParam(value="vdbName") String vdbName, @ApiParam(value="Name of the Data Role", required=true) @PathParam(value="dataRoleId") String dataRoleId, @ApiParam(value="Name of the Permission to get its Masks", required=true) @PathParam(value="permissionId") String permissionId) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "getMasks", true);
            Vdb vdb = this.findVdb(uow, vdbName);
            if (vdb == null) {
                return this.commitNoVdbFound(uow, mediaTypes, vdbName);
            }
            DataRole dataRole = this.findDataRole(uow, mediaTypes, dataRoleId, vdb);
            if (dataRole == null) {
                return this.commitNoDataRoleFound(uow, mediaTypes, dataRoleId, vdbName);
            }
            Permission permission = this.findPermission(uow, mediaTypes, permissionId, dataRole, vdb);
            if (permission == null) {
                return this.commitNoPermissionFound(uow, mediaTypes, permissionId, dataRoleId, vdbName);
            }
            Mask[] masks = permission.getMasks(uow, new String[0]);
            ArrayList<RestVdbMask> restMasks = new ArrayList<RestVdbMask>(masks.length);
            for (Mask mask : masks) {
                RestVdbMask entity = (RestVdbMask)this.entityFactory.create((KomodoObject)mask, uriInfo.getBaseUri(), uow);
                restMasks.add(entity);
                LOGGER.debug("getMasks:Mask from Permission from Data Role '{0}' from VDB '{1}' entity was constructed", new Object[]{dataRoleId, vdbName});
            }
            return this.commit(uow, mediaTypes, restMasks);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.VDB_SERVICE_GET_MASKS_ERROR, new Object[]{permissionId, dataRoleId, vdbName});
        }
    }

    @GET
    @Path(value="{vdbName}/VdbDataRoles/{dataRoleId}/VdbPermissions/{permissionId}/VdbMasks/{maskId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find the mask belonging to the permission of the data role of the vdb", response=RestVdbPermission.class)
    @ApiResponses(value={@ApiResponse(code=404, message="No vdb, data role, permission or mask could be found with name"), @ApiResponse(code=406, message="Only JSON is returned by this operation"), @ApiResponse(code=403, message="An error has occurred.")})
    public Response getMask(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="Name of the Vdb", required=true) @PathParam(value="vdbName") String vdbName, @ApiParam(value="Name of the Data Role", required=true) @PathParam(value="dataRoleId") String dataRoleId, @ApiParam(value="Name of the Permission", required=true) @PathParam(value="permissionId") String permissionId, @ApiParam(value="Name of the Mask to be fetched", required=true) @PathParam(value="maskId") String maskId) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        List mediaTypes = headers.getAcceptableMediaTypes();
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "getMask", true);
            Vdb vdb = this.findVdb(uow, vdbName);
            if (vdb == null) {
                return this.commitNoVdbFound(uow, mediaTypes, vdbName);
            }
            DataRole dataRole = this.findDataRole(uow, mediaTypes, dataRoleId, vdb);
            if (dataRole == null) {
                return this.commitNoDataRoleFound(uow, mediaTypes, dataRoleId, vdbName);
            }
            Permission permission = this.findPermission(uow, mediaTypes, permissionId, dataRole, vdb);
            if (permission == null) {
                return this.commitNoPermissionFound(uow, mediaTypes, permissionId, dataRoleId, vdbName);
            }
            Mask[] masks = permission.getMasks(uow, new String[0]);
            if (masks == null || masks.length == 0) {
                LOGGER.debug("getConition:No masks found for vdb '{0}'", new Object[]{vdbName});
                String resourceName = this.uri(new String[]{vdbName, "VdbDataRoles", dataRoleId, "VdbPermissions", permissionId, "VdbMasks", maskId});
                return this.commit(uow, mediaTypes, (KRestEntity)new RestBasicEntity.ResourceNotFound(resourceName, Messages.getString((Enum)Messages.General.GET_OPERATION_NAME, (Object[])new Object[0])));
            }
            Mask mask = null;
            for (Mask con : masks) {
                if (!maskId.equals(con.getName(uow))) continue;
                mask = con;
                break;
            }
            if (mask == null) {
                LOGGER.debug("No mask '{0}' for permission '{1}' for data role '{2}' found for vdb '{3}'", new Object[]{maskId, permissionId, dataRoleId, vdbName});
                return this.commit(uow, mediaTypes, (KRestEntity)new RestBasicEntity.ResourceNotFound(this.uri(new String[]{vdbName, "VdbDataRoles", dataRoleId, "VdbPermissions", permissionId, "VdbMasks", maskId}), Messages.getString((Enum)Messages.General.GET_OPERATION_NAME, (Object[])new Object[0])));
            }
            RestVdbMask restMask = (RestVdbMask)this.entityFactory.create(mask, uriInfo.getBaseUri(), uow);
            LOGGER.debug("getMask:mask '{0}' from permission '{1}' from data role '{2}' from VDB '{3}' entity was constructed", new Object[]{permissionId, dataRoleId, vdbName});
            return this.commit(uow, mediaTypes, (KRestEntity)restMask);
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(mediaTypes, (Throwable)e, RelationalMessages.Error.VDB_SERVICE_GET_MASK_ERROR, new Object[]{maskId, permissionId, dataRoleId, vdbName});
        }
    }

    @GET
    @Path(value="nameValidation/{vdbName}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Returns an error message if the VDB name is invalid")
    @ApiResponses(value={@ApiResponse(code=400, message="The URI cannot contain encoded slashes or backslashes."), @ApiResponse(code=403, message="An unexpected error has occurred."), @ApiResponse(code=500, message="The VDB name cannot be empty.")})
    public Response validateVdbName(@Context HttpHeaders headers, @Context UriInfo uriInfo, @ApiParam(value="The VDB name being checked", required=true) @PathParam(value="vdbName") String vdbName) throws KomodoRestException {
        KomodoService.SecurityPrincipal principal = this.checkSecurityContext(headers);
        if (principal.hasErrorResponse()) {
            return principal.getErrorResponse();
        }
        String errorMsg = VALIDATOR.checkValidName(vdbName);
        if (errorMsg != null) {
            return Response.ok().entity((Object)errorMsg).build();
        }
        Repository.UnitOfWork uow = null;
        try {
            uow = this.createTransaction(principal, "validateVdbName", true);
            Vdb vdb = this.findVdb(uow, vdbName);
            if (vdb == null) {
                Connection ds = this.findConnection(uow, vdbName);
                if (ds == null) {
                    return Response.ok().build();
                }
                return Response.ok().entity((Object)RelationalMessages.getString((Enum)RelationalMessages.Error.VDB_DATA_SOURCE_NAME_EXISTS, (Object[])new Object[0])).build();
            }
            return Response.ok().entity((Object)RelationalMessages.getString((Enum)RelationalMessages.Error.VDB_NAME_EXISTS, (Object[])new Object[0])).build();
        }
        catch (Exception e) {
            if (uow != null && uow.getState() != Repository.UnitOfWork.State.ROLLED_BACK) {
                uow.rollback();
            }
            if (e instanceof KomodoRestException) {
                throw (KomodoRestException)e;
            }
            return this.createErrorResponseWithForbidden(headers.getAcceptableMediaTypes(), (Throwable)e, RelationalMessages.Error.VDB_NAME_VALIDATION_ERROR, new Object[0]);
        }
    }
}

