/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.swagger;

import io.swagger.converter.ModelConverter;
import io.swagger.converter.ModelConverterContext;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Iterator;
import org.komodo.rest.RestLink;
import org.komodo.rest.json.JsonConstants;
import org.komodo.spi.repository.KomodoType;
import org.komodo.utils.KLog;

public abstract class RestEntityConverter<T>
implements ModelConverter,
JsonConstants {
    protected static final KLog LOGGER = KLog.getLogger();

    protected abstract Class<T> getEntityClass();

    protected abstract KomodoType getKomodoType();

    protected abstract void addProperties(ModelImpl var1, ModelConverterContext var2) throws Exception;

    public Property resolveProperty(Type type, ModelConverterContext context, Annotation[] annotations, Iterator<ModelConverter> chain) {
        if (chain.hasNext()) {
            return chain.next().resolveProperty(type, context, annotations, chain);
        }
        return null;
    }

    protected boolean isApplicable(Type type, Class<T> klazz) {
        Class cls;
        if (type == null) {
            return false;
        }
        return type instanceof Class && klazz.isAssignableFrom(cls = (Class)type);
    }

    protected Model defaultAction(Type type, ModelConverterContext context, Iterator<ModelConverter> chain) {
        if (chain.hasNext()) {
            return chain.next().resolve(type, context, chain);
        }
        return null;
    }

    protected ModelImpl generateRestEntityModel(String name, ModelConverterContext context) throws Exception {
        ModelImpl model = new ModelImpl();
        model.setName(name);
        model.property("keng__id", this.requiredProperty(String.class));
        model.property("keng__dataPath", this.requiredProperty(String.class));
        StringProperty kTypeProperty = new StringProperty();
        kTypeProperty.setRequired(true);
        kTypeProperty.readOnly();
        kTypeProperty._enum(this.getKomodoType().toString());
        model.property("keng__kType", (Property)kTypeProperty);
        model.property("keng__hasChildren", this.requiredProperty(Boolean.class));
        model.property("keng___links", context.resolveProperty(RestLink.class, null));
        context.defineModel(model.getName(), (Model)model);
        return model;
    }

    protected Property property(Class<?> typeClass) throws Exception {
        StringProperty property = null;
        if (String.class.equals(typeClass)) {
            property = new StringProperty();
        } else if (Integer.class.equals(typeClass)) {
            property = new IntegerProperty();
        } else if (Boolean.class.equals(typeClass)) {
            property = new BooleanProperty();
        } else {
            throw new Exception("Unsupported property type " + typeClass);
        }
        return property;
    }

    protected Property requiredProperty(Class<?> typeClass) throws Exception {
        Property property = this.property(typeClass);
        property.setRequired(true);
        return property;
    }

    public Model resolve(Type type, ModelConverterContext context, Iterator<ModelConverter> chain) {
        ModelImpl model;
        if (!this.isApplicable(type, this.getEntityClass())) {
            return this.defaultAction(type, context, chain);
        }
        try {
            model = this.generateRestEntityModel(this.getEntityClass().getSimpleName(), context);
            this.addProperties(model, context);
        }
        catch (Exception ex) {
            LOGGER.error("Exception occurred whilst resolving the model type " + type.toString(), new Object[0]);
            return null;
        }
        return model;
    }
}

