/*
 * Decompiled with CFR 0.152.
 */
package org.komodo.rest.swagger;

import io.swagger.converter.ModelConverter;
import io.swagger.converter.ModelConverterContext;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import java.lang.reflect.Type;
import java.util.Iterator;
import org.komodo.rest.RestProperty;
import org.komodo.rest.swagger.RestEntityConverter;
import org.komodo.spi.repository.KomodoType;

public class RestPropertyConverter
extends RestEntityConverter<RestProperty> {
    protected Class<RestProperty> getEntityClass() {
        return RestProperty.class;
    }

    protected KomodoType getKomodoType() {
        return KomodoType.UNKNOWN;
    }

    protected void addProperties(ModelImpl model, ModelConverterContext context) throws Exception {
        model.property("name", this.requiredProperty(String.class));
        model.property("value", this.property(String.class));
    }

    public Model resolve(Type type, ModelConverterContext context, Iterator<ModelConverter> chain) {
        ModelImpl model;
        if (!this.isApplicable(type, this.getEntityClass())) {
            return this.defaultAction(type, context, chain);
        }
        try {
            model = new ModelImpl();
            model.setName(this.getEntityClass().getSimpleName());
            this.addProperties(model, context);
        }
        catch (Exception ex) {
            LOGGER.error("Exception occurred whilst resolving the model type " + type.toString(), new Object[0]);
            return null;
        }
        return model;
    }
}

