/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.service;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmParameter;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ODataServerError;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriInfoResource;
import org.apache.olingo.server.core.ServiceHandler;
import org.apache.olingo.server.core.ServiceRequest;
import org.apache.olingo.server.core.requests.ActionRequest;
import org.apache.olingo.server.core.requests.DataRequest;
import org.apache.olingo.server.core.requests.FunctionRequest;
import org.apache.olingo.server.core.requests.MediaRequest;
import org.apache.olingo.server.core.requests.MetadataRequest;
import org.apache.olingo.server.core.requests.OperationRequest;
import org.apache.olingo.server.core.requests.ServiceDocumentRequest;
import org.apache.olingo.server.core.responses.CountResponse;
import org.apache.olingo.server.core.responses.EntityResponse;
import org.apache.olingo.server.core.responses.EntitySetResponse;
import org.apache.olingo.server.core.responses.ErrorResponse;
import org.apache.olingo.server.core.responses.MetadataResponse;
import org.apache.olingo.server.core.responses.NoContentResponse;
import org.apache.olingo.server.core.responses.PrimitiveValueResponse;
import org.apache.olingo.server.core.responses.PropertyResponse;
import org.apache.olingo.server.core.responses.ServiceDocumentResponse;
import org.apache.olingo.server.core.responses.ServiceResponse;
import org.apache.olingo.server.core.responses.ServiceResponseVisior;
import org.apache.olingo.server.core.responses.StreamResponse;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.TransformationException;
import org.teiid.core.types.XMLType;
import org.teiid.core.util.ReaderInputStream;
import org.teiid.logging.LogManager;
import org.teiid.odata.api.BaseResponse;
import org.teiid.odata.api.Client;
import org.teiid.odata.api.QueryResponse;
import org.teiid.odata.api.UpdateResponse;
import org.teiid.olingo.EdmComplexResponse;
import org.teiid.olingo.ODataPlugin;
import org.teiid.olingo.service.ComplexDocumentNode;
import org.teiid.olingo.service.CrossJoinNode;
import org.teiid.olingo.service.CrossJoinResult;
import org.teiid.olingo.service.EntityCollectionResponse;
import org.teiid.olingo.service.NoDocumentNode;
import org.teiid.olingo.service.ODataSQLBuilder;
import org.teiid.olingo.service.OperationResponseImpl;
import org.teiid.olingo.service.ProcedureSQLBuilder;
import org.teiid.olingo.service.ReferenceUpdateSQLBuilder;
import org.teiid.olingo.service.TeiidNotImplementedException;
import org.teiid.query.function.source.XMLSystemFunctions;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.symbol.XMLSerialize;

public class TeiidServiceHandler
implements ServiceHandler {
    private static final String PREFERENCE_APPLIED = "Preference-Applied";
    private static final String ODATA_MAXPAGESIZE = "odata.maxpagesize";
    private boolean prepared = true;
    private OData odata;
    private ServiceMetadata serviceMetadata;
    private String schemaName;
    private UniqueNameGenerator nameGenerator = new UniqueNameGenerator();
    private static ThreadLocal<Client> CLIENT = new ThreadLocal();

    public static Client getClient() {
        return CLIENT.get();
    }

    public static void setClient(Client client) {
        CLIENT.set(client);
    }

    public TeiidServiceHandler(String schemaName) {
        this.schemaName = schemaName;
    }

    public void init(OData odata, ServiceMetadata serviceMetadata) {
        this.odata = odata;
        this.serviceMetadata = serviceMetadata;
    }

    public void setPrepared(boolean flag) {
        this.prepared = flag;
    }

    public void readMetadata(MetadataRequest request, MetadataResponse response) throws ODataLibraryException, ODataApplicationException {
        response.writeMetadata();
    }

    public void readServiceDocument(ServiceDocumentRequest request, ServiceDocumentResponse response) throws ODataLibraryException, ODataApplicationException {
        response.writeServiceDocument(request.getODataRequest().getRawBaseUri());
    }

    public <T extends ServiceResponse> void read(final DataRequest request, T response) throws ODataLibraryException, ODataApplicationException {
        BaseResponse queryResponse;
        final ODataSQLBuilder visitor = new ODataSQLBuilder(this.odata, TeiidServiceHandler.getClient().getMetadataStore(), this.prepared, true, request.getODataRequest().getRawBaseUri(), this.serviceMetadata, this.nameGenerator);
        visitor.visit(request.getUriInfo());
        try {
            Query query = visitor.selectQuery();
            queryResponse = this.executeQuery((ServiceRequest)request, request.isCountRequest(), visitor, query);
        }
        catch (Throwable e) {
            throw new ODataApplicationException(e.getMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.getDefault(), e);
        }
        response.accepts(new ServiceResponseVisior(){

            public void visit(CountResponse response) throws ODataLibraryException, ODataApplicationException {
                org.teiid.odata.api.CountResponse cr = (org.teiid.odata.api.CountResponse)queryResponse;
                response.writeCount(cr.getCount());
            }

            public void visit(PrimitiveValueResponse response) throws ODataLibraryException, ODataApplicationException {
                EntityCollection entitySet = (EntityCollection)queryResponse;
                if (!entitySet.getEntities().isEmpty()) {
                    EdmProperty edmProperty;
                    Entity entity = (Entity)entitySet.getEntities().get(0);
                    Property property = entity.getProperty((edmProperty = request.getUriResourceProperty().getProperty()).getName());
                    if (property == null) {
                        response.writeNotFound(true);
                    } else if (property.getValue() == null) {
                        response.writeNoContent(true);
                    } else {
                        response.write(property.getValue());
                    }
                } else {
                    response.writeNotFound(true);
                }
            }

            public void visit(PropertyResponse response) throws ODataLibraryException, ODataApplicationException {
                EntityCollection entitySet = (EntityCollection)queryResponse;
                if (!entitySet.getEntities().isEmpty()) {
                    Entity entity = (Entity)entitySet.getEntities().get(0);
                    EdmProperty edmProperty = request.getUriResourceProperty().getProperty();
                    Property property = entity.getProperty(edmProperty.getName());
                    response.writeProperty(edmProperty.getType(), property);
                } else {
                    response.writeNotFound(true);
                }
            }

            public void visit(StreamResponse response) throws ODataLibraryException, ODataApplicationException {
                EntityCollectionResponse entitySet = (EntityCollectionResponse)queryResponse;
                EdmProperty edmProperty = request.getUriResourceProperty().getProperty();
                Object value = entitySet.getStream(edmProperty.getName());
                if (value == null) {
                    response.writeNoContent(true);
                } else {
                    try {
                        TeiidServiceHandler.this.handleLobResult(TeiidServiceHandler.getClient().getProperty("charset"), value, (ServiceResponse)response);
                    }
                    catch (SQLException e) {
                        LogManager.logDetail((String)"org.teiid.ODATA", (Object)e);
                        response.writeServerError(true);
                    }
                }
            }

            public void visit(EntityResponse response) throws ODataLibraryException, ODataApplicationException {
                EntityCollection entitySet = (EntityCollection)queryResponse;
                if (entitySet.getEntities().isEmpty()) {
                    if (visitor.hasNavigation()) {
                        response.writeNoContent(true);
                    } else {
                        response.writeNotFound(true);
                    }
                } else {
                    response.writeReadEntity(visitor.getContext().getEdmEntityType(), (Entity)entitySet.getEntities().get(0));
                }
            }

            public void visit(EntitySetResponse response) throws ODataLibraryException, ODataApplicationException {
                TeiidServiceHandler.this.sendResults(request, visitor, queryResponse, response);
            }
        });
    }

    private void sendResults(DataRequest request, ODataSQLBuilder visitor, BaseResponse queryResponse, EntitySetResponse response) throws ODataApplicationException, SerializerException {
        EntityCollectionResponse result;
        if (request.getPreference(ODATA_MAXPAGESIZE) != null) {
            response.writeHeader(PREFERENCE_APPLIED, "odata.maxpagesize=" + request.getPreference(ODATA_MAXPAGESIZE));
        }
        if ((result = (EntityCollectionResponse)queryResponse).getNextToken() != null) {
            try {
                String nextUri = request.getODataRequest().getRawBaseUri() + request.getODataRequest().getRawODataPath() + "?" + this.buildNextToken(request.getODataRequest().getRawQueryPath(), result.getNextToken());
                result.setNext(new URI(nextUri));
            }
            catch (URISyntaxException e) {
                throw new ODataApplicationException(e.getMessage(), 500, Locale.getDefault(), (Throwable)e);
            }
            catch (MalformedURLException e) {
                throw new ODataApplicationException(e.getMessage(), 500, Locale.getDefault(), (Throwable)e);
            }
        }
        response.writeReadEntitySet(visitor.getContext().getEdmEntityType(), (EntityCollection)result);
    }

    String buildNextToken(String queryPath, String nextToken) throws URISyntaxException, MalformedURLException {
        StringBuilder sb = new StringBuilder();
        if (queryPath != null) {
            String[] pairs;
            for (String pair : pairs = queryPath.split("&")) {
                int idx = pair.indexOf("=");
                String key = pair.substring(0, idx);
                if (key.equals("$skiptoken")) continue;
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(pair);
            }
        }
        if (sb.length() > 0) {
            sb.append("&$skiptoken=").append(nextToken);
        } else {
            sb.append("$skiptoken=").append(nextToken);
        }
        return sb.toString();
    }

    private void sendResults(DataRequest request, ODataSQLBuilder visitor, BaseResponse queryResponse, EdmComplexResponse response) throws ODataApplicationException, SerializerException {
        if (request.getPreference(ODATA_MAXPAGESIZE) != null) {
            response.writeHeader(PREFERENCE_APPLIED, "odata.maxpagesize=" + request.getPreference(ODATA_MAXPAGESIZE));
        }
        CrossJoinResult result = (CrossJoinResult)queryResponse;
        URI next = null;
        if (result.getNextToken() != null) {
            try {
                next = new URI(request.getODataRequest().getRawRequestUri() + (request.getODataRequest().getRawQueryPath() == null ? "?$skiptoken=" : "&$skiptoken=") + result.getNextToken());
            }
            catch (URISyntaxException e) {
                throw new ODataApplicationException(e.getMessage(), 500, Locale.getDefault(), (Throwable)e);
            }
        }
        response.writeComplexType(result, next);
    }

    private BaseResponse executeQuery(ServiceRequest request, boolean countRequest, ODataSQLBuilder visitor, Query query) throws SQLException {
        if (countRequest) {
            return TeiidServiceHandler.getClient().executeCount(query, visitor.getParameters());
        }
        String pageSize = this.getPageSize(request);
        QueryResponse result = new EntityCollectionResponse(request.getODataRequest().getRawBaseUri(), visitor.getContext());
        if (visitor.getContext() instanceof CrossJoinNode) {
            result = new CrossJoinResult(request.getODataRequest().getRawBaseUri(), (CrossJoinNode)visitor.getContext());
        } else if (visitor.getContext() instanceof ComplexDocumentNode) {
            ComplexDocumentNode cdn = (ComplexDocumentNode)visitor.getContext();
            result = new OperationResponseImpl(cdn.getProcedureReturn());
        }
        TeiidServiceHandler.getClient().executeSQL(query, visitor.getParameters(), visitor.includeTotalSize(), visitor.getSkip(), visitor.getTop(), visitor.getNextToken(), Integer.parseInt(pageSize), result);
        return result;
    }

    private String getPageSize(ServiceRequest request) {
        String pageSize = request.getPreference(ODATA_MAXPAGESIZE);
        if (pageSize == null) {
            pageSize = TeiidServiceHandler.getClient().getProperty("batch-size") == null ? String.valueOf(256) : TeiidServiceHandler.getClient().getProperty("batch-size");
        }
        return pageSize;
    }

    private void checkExpand(UriInfoResource queryInfo) {
        if (queryInfo.getExpandOption() != null && !queryInfo.getExpandOption().getExpandItems().isEmpty()) {
            throw new UnsupportedOperationException("Expand is not supported");
        }
    }

    private UpdateResponse performInsert(String rawURI, UriInfo uriInfo, EdmEntityType entityType, Entity entity) throws SQLException, TeiidException {
        ODataSQLBuilder visitor = new ODataSQLBuilder(this.odata, TeiidServiceHandler.getClient().getMetadataStore(), this.prepared, false, rawURI, this.serviceMetadata, this.nameGenerator);
        visitor.visit(uriInfo);
        Insert command = visitor.insert(entityType, entity, null, this.prepared);
        return TeiidServiceHandler.getClient().executeUpdate((Command)command, visitor.getParameters());
    }

    private int insertDepth(EdmEntityType entityType, Entity entity) throws SQLException, TeiidException {
        int depth = 1;
        int childDepth = 0;
        for (String navigationName : entityType.getNavigationPropertyNames()) {
            EdmNavigationProperty navProperty = entityType.getNavigationProperty(navigationName);
            Link navLink = entity.getNavigationLink(navigationName);
            if (navLink != null && navLink.getInlineEntity() != null) {
                childDepth = Math.max(childDepth, this.insertDepth(navProperty.getType(), navLink.getInlineEntity()));
                continue;
            }
            if (navLink == null || navLink.getInlineEntitySet() == null || navLink.getInlineEntitySet().getEntities().isEmpty()) continue;
            for (Entity inlineEntity : navLink.getInlineEntitySet().getEntities()) {
                childDepth = Math.max(childDepth, this.insertDepth(navProperty.getType(), inlineEntity));
            }
        }
        return depth + childDepth;
    }

    private UpdateResponse performDeepInsert(String rawURI, UriInfo uriInfo, EdmEntityType entityType, Entity entity, List<ExpandNode> expandNodes) throws SQLException, TeiidException {
        UpdateResponse response = this.performInsert(rawURI, uriInfo, entityType, entity);
        for (String navigationName : entityType.getNavigationPropertyNames()) {
            ExpandNode node;
            EdmNavigationProperty navProperty = entityType.getNavigationProperty(navigationName);
            Link navLink = entity.getNavigationLink(navigationName);
            if (navLink != null && navLink.getInlineEntity() != null) {
                node = new ExpandNode();
                node.navigationProperty = navProperty;
                expandNodes.add(node);
                this.performDeepInsert(rawURI, uriInfo, navProperty.getType(), navLink.getInlineEntity(), node.children);
                continue;
            }
            if (navLink == null || navLink.getInlineEntitySet() == null || navLink.getInlineEntitySet().getEntities().isEmpty()) continue;
            node = new ExpandNode();
            node.navigationProperty = navProperty;
            expandNodes.add(node);
            for (Entity inlineEntity : navLink.getInlineEntitySet().getEntities()) {
                this.performDeepInsert(rawURI, uriInfo, navProperty.getType(), inlineEntity, node.children);
            }
        }
        return response;
    }

    public void createEntity(DataRequest request, Entity entity, EntityResponse response) throws ODataLibraryException, ODataApplicationException {
        String txn;
        EdmEntityType entityType = request.getEntitySet().getEntityType();
        try {
            txn = TeiidServiceHandler.getClient().startTransaction();
        }
        catch (SQLException e) {
            throw new ODataApplicationException(e.getMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.getDefault(), (Throwable)e);
        }
        boolean success = false;
        try {
            ArrayList<ExpandNode> expands = new ArrayList<ExpandNode>();
            int insertDepth = this.insertDepth(entityType, entity);
            ODataSQLBuilder.checkExpandLevel(insertDepth - 1);
            UpdateResponse updateResponse = this.performDeepInsert(request.getODataRequest().getRawBaseUri(), request.getUriInfo(), entityType, entity, expands);
            if (updateResponse != null && updateResponse.getUpdateCount() == 1) {
                ODataSQLBuilder visitor = new ODataSQLBuilder(this.odata, TeiidServiceHandler.getClient().getMetadataStore(), true, false, request.getODataRequest().getRawBaseUri(), this.serviceMetadata, this.nameGenerator);
                Query query = visitor.selectWithEntityKey(entityType, entity, updateResponse.getGeneratedKeys(), expands);
                LogManager.logDetail((String)"org.teiid.ODATA", null, (Object[])new Object[]{"created entity = ", entityType.getName(), " with key=", query.getCriteria().toString()});
                EntityCollectionResponse result = new EntityCollectionResponse(request.getODataRequest().getRawBaseUri(), visitor.getContext());
                TeiidServiceHandler.getClient().executeSQL(query, visitor.getParameters(), false, null, null, null, 1, result);
                if (!result.getEntities().isEmpty()) {
                    entity = (Entity)result.getEntities().get(0);
                    String location = EntityResponse.buildLocation((String)request.getODataRequest().getRawBaseUri(), (Entity)entity, (String)request.getEntitySet().getName(), (EdmEntityType)entityType);
                    entity.setId(new URI(location));
                }
                response.writeCreatedEntity(request.getEntitySet(), entity);
            } else {
                response.writeNotModified();
            }
            TeiidServiceHandler.getClient().commit(txn);
            success = true;
        }
        catch (URISyntaxException | SQLException | EdmPrimitiveTypeException | TeiidException e) {
            throw new ODataApplicationException(e.getMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.getDefault(), e);
        }
        finally {
            if (!success) {
                try {
                    TeiidServiceHandler.getClient().rollback(txn);
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public void updateEntity(DataRequest request, Entity entity, boolean merge, String entityETag, EntityResponse response) throws ODataLibraryException, ODataApplicationException {
        this.checkETag(entityETag);
        UpdateResponse updateResponse = null;
        if (merge) {
            try {
                ODataSQLBuilder visitor = new ODataSQLBuilder(this.odata, TeiidServiceHandler.getClient().getMetadataStore(), this.prepared, false, request.getODataRequest().getRawBaseUri(), this.serviceMetadata, this.nameGenerator);
                visitor.visit(request.getUriInfo());
                EdmEntityType entityType = request.getEntitySet().getEntityType();
                Update update = visitor.update(entityType, entity, this.prepared);
                updateResponse = TeiidServiceHandler.getClient().executeUpdate((Command)update, visitor.getParameters());
            }
            catch (SQLException e) {
                throw new ODataApplicationException(e.getMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.getDefault(), (Throwable)e);
            }
            catch (TeiidException e) {
                throw new ODataApplicationException(e.getMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.getDefault(), (Throwable)e);
            }
        }
        String txn = this.startTransaction();
        boolean success = false;
        try {
            ODataSQLBuilder visitor = new ODataSQLBuilder(this.odata, TeiidServiceHandler.getClient().getMetadataStore(), this.prepared, false, request.getODataRequest().getRawBaseUri(), this.serviceMetadata, this.nameGenerator);
            visitor.visit(request.getUriInfo());
            EdmEntityType entityType = request.getEntitySet().getEntityType();
            List keys = request.getKeyPredicates();
            Insert command = visitor.insert(entityType, entity, keys, this.prepared);
            ODataSQLBuilder deleteVisitor = new ODataSQLBuilder(this.odata, TeiidServiceHandler.getClient().getMetadataStore(), this.prepared, false, request.getODataRequest().getRawBaseUri(), this.serviceMetadata, this.nameGenerator);
            deleteVisitor.visit(request.getUriInfo());
            Delete delete = deleteVisitor.delete();
            updateResponse = TeiidServiceHandler.getClient().executeUpdate((Command)delete, deleteVisitor.getParameters());
            updateResponse = TeiidServiceHandler.getClient().executeUpdate((Command)command, visitor.getParameters());
            this.commit(txn);
            success = true;
        }
        catch (SQLException e) {
            throw new ODataApplicationException(e.getMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.getDefault(), (Throwable)e);
        }
        catch (TeiidException e) {
            throw new ODataApplicationException(e.getMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.getDefault(), (Throwable)e);
        }
        finally {
            if (!success) {
                this.rollback(txn);
            }
        }
        if (updateResponse != null && updateResponse.getUpdateCount() > 0) {
            response.writeUpdatedEntity();
        } else {
            response.writeNotModified();
        }
    }

    private void checkETag(String entityETag) throws ODataApplicationException {
        if (entityETag != null && !entityETag.equals("*")) {
            throw new ODataApplicationException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16030, new Object[0]), HttpStatusCode.NOT_IMPLEMENTED.getStatusCode(), Locale.getDefault());
        }
    }

    public void deleteEntity(DataRequest request, String entityETag, EntityResponse response) throws ODataLibraryException, ODataApplicationException {
        this.checkETag(entityETag);
        UpdateResponse updateResponse = null;
        try {
            ODataSQLBuilder visitor = new ODataSQLBuilder(this.odata, TeiidServiceHandler.getClient().getMetadataStore(), this.prepared, false, request.getODataRequest().getRawBaseUri(), this.serviceMetadata, this.nameGenerator);
            visitor.visit(request.getUriInfo());
            Delete delete = visitor.delete();
            updateResponse = TeiidServiceHandler.getClient().executeUpdate((Command)delete, visitor.getParameters());
        }
        catch (SQLException e) {
            throw new ODataApplicationException(e.getMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.getDefault(), (Throwable)e);
        }
        if (updateResponse != null && updateResponse.getUpdateCount() > 0) {
            response.writeDeletedEntityOrReference();
        } else {
            response.writeDeletedEntityOrReference();
        }
    }

    public void updateProperty(DataRequest request, Property property, boolean rawValue, boolean merge, String entityETag, PropertyResponse response) throws ODataLibraryException, ODataApplicationException {
        this.checkETag(entityETag);
        UpdateResponse updateResponse = null;
        EdmProperty edmProperty = request.getUriResourceProperty().getProperty();
        try {
            ODataSQLBuilder visitor = new ODataSQLBuilder(this.odata, TeiidServiceHandler.getClient().getMetadataStore(), this.prepared, false, request.getODataRequest().getRawBaseUri(), this.serviceMetadata, this.nameGenerator);
            visitor.visit(request.getUriInfo());
            Update update = visitor.updateProperty(edmProperty, property, this.prepared, rawValue);
            updateResponse = TeiidServiceHandler.getClient().executeUpdate((Command)update, visitor.getParameters());
        }
        catch (SQLException e) {
            throw new ODataApplicationException(e.getMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.getDefault(), (Throwable)e);
        }
        catch (TeiidException e) {
            throw new ODataApplicationException(e.getMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.getDefault(), (Throwable)e);
        }
        if (updateResponse != null && updateResponse.getUpdateCount() > 0) {
            response.writePropertyUpdated();
        } else {
            response.writeNotModified();
        }
    }

    public void upsertStreamProperty(DataRequest request, String entityETag, InputStream streamContent, NoContentResponse response) throws ODataLibraryException, ODataApplicationException {
        UpdateResponse updateResponse = null;
        EdmProperty edmProperty = request.getUriResourceProperty().getProperty();
        try {
            ODataSQLBuilder visitor = new ODataSQLBuilder(this.odata, TeiidServiceHandler.getClient().getMetadataStore(), this.prepared, false, request.getODataRequest().getRawBaseUri(), this.serviceMetadata, this.nameGenerator);
            visitor.visit(request.getUriInfo());
            Update update = visitor.updateStreamProperty(edmProperty, streamContent);
            updateResponse = TeiidServiceHandler.getClient().executeUpdate((Command)update, visitor.getParameters());
        }
        catch (SQLException | TeiidException e) {
            throw new ODataApplicationException(e.getMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.getDefault(), e);
        }
        if (updateResponse != null && updateResponse.getUpdateCount() > 0) {
            response.writeNoContent();
        } else {
            response.writeNotModified();
        }
    }

    public <T extends ServiceResponse> void invoke(FunctionRequest request, HttpMethod method, T response) throws ODataLibraryException, ODataApplicationException {
        this.invokeOperation((OperationRequest)request, new ProcedureSQLBuilder.FunctionParameterValueProvider(request.getParameters()), response);
    }

    public <T extends ServiceResponse> void invoke(ActionRequest request, String eTag, T response) throws ODataLibraryException, ODataApplicationException {
        this.checkETag(eTag);
        this.invokeOperation((OperationRequest)request, new ProcedureSQLBuilder.ActionParameterValueProvider(request.getPayload(), request), response);
    }

    private <T extends ServiceResponse> void invokeOperation(final OperationRequest request, OperationParameterValueProvider parameters, T response) throws ODataApplicationException, ODataLibraryException {
        OperationResponseImpl queryResponse;
        this.checkExpand(request.getUriInfo().asUriInfoResource());
        ODataSQLBuilder visitor = new ODataSQLBuilder(this.odata, TeiidServiceHandler.getClient().getMetadataStore(), this.prepared, true, request.getODataRequest().getRawBaseUri(), this.serviceMetadata, this.nameGenerator);
        visitor.setOperationParameterValueProvider(parameters);
        visitor.visit(request.getUriInfo());
        try {
            if (visitor.getContext() instanceof NoDocumentNode) {
                NoDocumentNode cdn = (NoDocumentNode)visitor.getContext();
                ProcedureSQLBuilder.ProcedureReturn procReturn = cdn.getProcedureReturn();
                queryResponse = new OperationResponseImpl(procReturn);
                TeiidServiceHandler.getClient().executeCall(cdn.getQuery(), visitor.getParameters(), procReturn, queryResponse);
            } else {
                Query query = visitor.selectQuery();
                queryResponse = (OperationResponseImpl)this.executeQuery((ServiceRequest)request, request.isCountRequest(), visitor, query);
            }
        }
        catch (Throwable e) {
            throw new ODataApplicationException(e.getMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.getDefault(), e);
        }
        final OperationResponseImpl operationResult = queryResponse;
        response.accepts(new ServiceResponseVisior(){

            public void visit(PropertyResponse response) throws ODataLibraryException, ODataApplicationException {
                Property property = (Property)operationResult.getResult();
                Object value = property.getValue();
                if (value instanceof SQLXML || value instanceof Blob || value instanceof Clob) {
                    try {
                        TeiidServiceHandler.this.handleLobResult(TeiidServiceHandler.getClient().getProperty("charset"), value, (ServiceResponse)response);
                    }
                    catch (SQLException e) {
                        LogManager.logDetail((String)"org.teiid.ODATA", (Object)e);
                        response.writeServerError(true);
                    }
                } else {
                    response.writeProperty(request.getReturnType().getType(), property);
                }
            }
        });
    }

    public void readMediaStream(MediaRequest request, StreamResponse response) throws ODataLibraryException, ODataApplicationException {
        response.writeServerError(true);
    }

    public void upsertMediaStream(MediaRequest request, String entityETag, InputStream mediaContent, NoContentResponse response) throws ODataLibraryException, ODataApplicationException {
        response.writeServerError(true);
    }

    public void anyUnsupported(ODataRequest request, ODataResponse response) throws ODataLibraryException, ODataApplicationException {
        throw new ODataApplicationException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16049, new Object[0]), HttpStatusCode.NOT_IMPLEMENTED.getStatusCode(), Locale.getDefault());
    }

    public void addReference(DataRequest request, String entityETag, URI referenceId, NoContentResponse response) throws ODataLibraryException, ODataApplicationException {
        this.manageReference(request, referenceId, response, false);
    }

    public void updateReference(DataRequest request, String entityETag, URI referenceId, NoContentResponse response) throws ODataLibraryException, ODataApplicationException {
        this.manageReference(request, referenceId, response, false);
    }

    private void manageReference(DataRequest request, URI referenceId, NoContentResponse response, boolean delete) throws ODataApplicationException {
        UpdateResponse updateResponse = null;
        try {
            ReferenceUpdateSQLBuilder visitor = new ReferenceUpdateSQLBuilder(TeiidServiceHandler.getClient().getMetadataStore(), request.getODataRequest().getRawBaseUri(), this.serviceMetadata, this.odata);
            visitor.visit(request.getUriInfo());
            Update update = visitor.updateReference(referenceId, this.prepared, delete);
            updateResponse = TeiidServiceHandler.getClient().executeUpdate((Command)update, visitor.getParameters());
        }
        catch (SQLException e) {
            throw new ODataApplicationException(e.getMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.getDefault(), (Throwable)e);
        }
        if (updateResponse != null && updateResponse.getUpdateCount() > 0) {
            response.writeNoContent();
        } else {
            response.writeNotModified();
        }
    }

    public void deleteReference(DataRequest request, URI deleteId, String entityETag, NoContentResponse response) throws ODataLibraryException, ODataApplicationException {
        this.manageReference(request, deleteId, response, true);
    }

    public String startTransaction() throws ODataLibraryException, ODataApplicationException {
        try {
            return TeiidServiceHandler.getClient().startTransaction();
        }
        catch (SQLException e) {
            throw new ODataApplicationException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16039, new Object[0]), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.getDefault());
        }
    }

    public void commit(String txnId) throws ODataLibraryException, ODataApplicationException {
        try {
            TeiidServiceHandler.getClient().commit(txnId);
        }
        catch (SQLException e) {
            throw new ODataApplicationException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16039, new Object[0]), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.getDefault());
        }
    }

    public void rollback(String txnId) throws ODataLibraryException, ODataApplicationException {
        try {
            TeiidServiceHandler.getClient().rollback(txnId);
        }
        catch (SQLException e) {
            throw new ODataApplicationException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16039, new Object[0]), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.getDefault());
        }
    }

    public void crossJoin(DataRequest request, List<String> entitySetNames, ODataResponse response) throws ODataLibraryException, ODataApplicationException {
        ODataSQLBuilder visitor = new ODataSQLBuilder(this.odata, TeiidServiceHandler.getClient().getMetadataStore(), this.prepared, true, request.getODataRequest().getRawBaseUri(), this.serviceMetadata, this.nameGenerator);
        visitor.visit(request.getUriInfo());
        try {
            Query query = visitor.selectQuery();
            BaseResponse queryResponse = this.executeQuery((ServiceRequest)request, request.isCountRequest(), visitor, query);
            ContextURL.Builder builder = new ContextURL.Builder().asCollection().entitySetOrSingletonOrType("Edm.ComplexType");
            EdmComplexResponse complexResponse = EdmComplexResponse.getInstance((ServiceRequest)request, builder.build(), false, response);
            this.sendResults(request, visitor, queryResponse, complexResponse);
        }
        catch (Exception e) {
            throw new ODataApplicationException(e.getMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.getDefault(), (Throwable)e);
        }
    }

    private void handleLobResult(String charSet, Object result, ServiceResponse response) throws SQLException {
        if (result == null) {
            return;
        }
        if (result instanceof SQLXML) {
            if (charSet != null) {
                XMLSerialize serialize = new XMLSerialize();
                serialize.setTypeString("blob");
                serialize.setDeclaration(Boolean.valueOf(true));
                serialize.setEncoding(charSet);
                serialize.setDocument(Boolean.valueOf(true));
                try {
                    InputStream content = ((BlobType)XMLSystemFunctions.serialize((XMLSerialize)serialize, (XMLType)new XMLType((SQLXML)result))).getBinaryStream();
                    response.writeContent(content, 200, false);
                    response.writeOK(ContentType.APPLICATION_OCTET_STREAM);
                }
                catch (TransformationException e) {
                    throw new SQLException(e);
                }
            } else {
                InputStream content = ((SQLXML)result).getBinaryStream();
                response.writeContent(content, 200, false);
                response.writeOK(ContentType.APPLICATION_XML);
            }
        } else if (result instanceof Blob) {
            InputStream content = ((Blob)result).getBinaryStream();
            response.writeContent(content, 200, false);
            response.writeOK(ContentType.APPLICATION_OCTET_STREAM);
        } else if (result instanceof Clob) {
            ReaderInputStream content = new ReaderInputStream(((Clob)result).getCharacterStream(), charSet == null ? Charset.defaultCharset() : Charset.forName(charSet));
            response.writeContent((InputStream)content, 200, false);
            response.writeOK(ContentType.TEXT_PLAIN);
        } else {
            ByteArrayInputStream content = new ByteArrayInputStream(result.toString().getBytes(charSet == null ? Charset.defaultCharset() : Charset.forName(charSet)));
            response.writeContent((InputStream)content, 200, false);
            response.writeOK(ContentType.APPLICATION_OCTET_STREAM);
        }
    }

    public void upsertEntity(DataRequest request, Entity entity, boolean merge, String entityETag, EntityResponse response) throws ODataLibraryException, ODataApplicationException {
        EntityCollectionResponse queryResponse;
        ODataSQLBuilder visitor = new ODataSQLBuilder(this.odata, TeiidServiceHandler.getClient().getMetadataStore(), this.prepared, true, request.getODataRequest().getRawBaseUri(), this.serviceMetadata, this.nameGenerator);
        visitor.visit(request.getUriInfo());
        try {
            Query query = visitor.selectQuery();
            queryResponse = (EntityCollectionResponse)this.executeQuery((ServiceRequest)request, request.isCountRequest(), visitor, query);
        }
        catch (Exception e) {
            throw new ODataApplicationException(e.getMessage(), HttpStatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), Locale.getDefault(), (Throwable)e);
        }
        if (!queryResponse.getEntities().isEmpty()) {
            this.updateEntity(request, entity, merge, entityETag, response);
        } else {
            this.createEntity(request, entity, response);
        }
    }

    public boolean supportsDataIsolation() {
        return false;
    }

    public void processError(ODataServerError error, ErrorResponse response) {
        int logLevel = error.getStatusCode() >= 500 ? 2 : 3;
        Throwable ex = this.getRoot(error.getException());
        if (ex instanceof TeiidNotImplementedException) {
            error.setException((Exception)((Object)((TeiidNotImplementedException)((Object)ex))));
            error.setCode(((TeiidNotImplementedException)((Object)ex)).getCode());
            error.setStatusCode(501);
            logLevel = 5;
        } else if (ex instanceof TeiidProcessingException) {
            error.setException((Exception)((Object)((TeiidProcessingException)ex)));
            error.setCode(((TeiidProcessingException)ex).getCode());
            error.setStatusCode(400);
            logLevel = 3;
        } else if (ex instanceof TeiidException) {
            error.setException((Exception)((Object)((TeiidException)ex)));
            error.setCode(((TeiidException)ex).getCode());
            error.setStatusCode(500);
            logLevel = 2;
        } else if (ex instanceof TeiidRuntimeException) {
            error.setException((Exception)((Object)((TeiidRuntimeException)ex)));
            error.setCode(((TeiidRuntimeException)ex).getCode());
            error.setStatusCode(500);
            logLevel = 2;
        }
        if (ex != error.getException() && ex.getMessage() != null) {
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.ODATA", (int)5) || logLevel <= 2) {
                LogManager.log((int)logLevel, (String)"org.teiid.ODATA", (Throwable)error.getException(), (Object[])new Object[]{ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16050, new Object[]{error.getMessage(), ex.getMessage()})});
            } else {
                LogManager.log((int)logLevel, (String)"org.teiid.PROCESSOR", (Object)ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16051, new Object[]{error.getMessage(), ex.getMessage()}));
            }
        } else if (LogManager.isMessageToBeRecorded((String)"org.teiid.ODATA", (int)5) || logLevel <= 2) {
            LogManager.log((int)logLevel, (String)"org.teiid.ODATA", (Throwable)error.getException(), (Object[])new Object[]{ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16052, new Object[]{error.getMessage()})});
        } else {
            LogManager.log((int)logLevel, (String)"org.teiid.PROCESSOR", (Object)ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16053, new Object[]{error.getMessage()}));
        }
        response.writeError(error);
    }

    private Throwable getRoot(Throwable t) {
        if (t.getCause() != null && t.getCause() != t) {
            if (t.getCause() instanceof TeiidException || t.getCause() instanceof TeiidRuntimeException) {
                return t.getCause();
            }
            return this.getRoot(t.getCause());
        }
        return t;
    }

    static interface OperationParameterValueProvider {
        public Object getValue(EdmParameter var1, Class<?> var2) throws TeiidProcessingException;
    }

    class UniqueNameGenerator {
        private final AtomicInteger groupCount = new AtomicInteger(0);

        UniqueNameGenerator() {
        }

        public String getNextGroup() {
            String aliasGroup = "g" + this.groupCount.getAndIncrement();
            return aliasGroup;
        }
    }

    static class ExpandNode {
        EdmNavigationProperty navigationProperty;
        List<ExpandNode> children = new ArrayList<ExpandNode>();

        ExpandNode() {
        }
    }
}

