/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.web;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidProcessingException;
import org.teiid.olingo.ODataPlugin;
import org.teiid.olingo.web.ODataFilter;

public class CorsFilter
implements Filter {
    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpReq = (HttpServletRequest)request;
        HttpServletResponse httpResp = (HttpServletResponse)response;
        if (CorsFilter.isOptionsMethod(httpReq) && !CorsFilter.hasOriginHeader(httpReq)) {
            ODataFilter.writeError(request, new TeiidProcessingException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16056, new Object[0])), httpResp, 400);
            return;
        }
        if (this.isPreflightRequest(httpReq)) {
            httpResp.setHeader("Access-Control-Allow-Origin", httpReq.getHeader("Origin"));
            httpResp.setHeader("Access-Control-Allow-Credentials", "true");
            httpResp.setHeader("Access-Control-Max-Age", "1800");
            httpResp.setHeader("Access-Control-Allow-Methods", "GET,POST,PUT,PATCH,DELETE");
            httpResp.setHeader("Access-Control-Allow-Headers", "Content-Type,Accept,Origin,Authorization");
            httpResp.setStatus(204);
        } else {
            if (CorsFilter.hasOriginHeader(httpReq)) {
                httpResp.setHeader("Access-Control-Allow-Origin", httpReq.getHeader("Origin"));
                httpResp.setHeader("Access-Control-Allow-Credentials", "true");
            }
            chain.doFilter((ServletRequest)httpReq, (ServletResponse)httpResp);
        }
    }

    private boolean isPreflightRequest(HttpServletRequest httpReq) {
        return CorsFilter.isOptionsMethod(httpReq) && CorsFilter.hasOriginHeader(httpReq);
    }

    static boolean isOptionsMethod(HttpServletRequest httpReq) {
        return "OPTIONS".equals(httpReq.getMethod());
    }

    static boolean hasOriginHeader(HttpServletRequest httpReq) {
        String origin = httpReq.getHeader("Origin");
        return origin != null && origin.trim().length() > 0;
    }

    public void destroy() {
    }
}

