/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.server.api.ODataHttpHandler;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.util.LRUCache;
import org.teiid.deployers.CompositeVDB;
import org.teiid.deployers.VDBLifeCycleListener;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.logging.LogManager;
import org.teiid.odata.api.Client;
import org.teiid.olingo.ODataPlugin;
import org.teiid.olingo.service.LocalClient;
import org.teiid.olingo.service.OlingoBridge;
import org.teiid.olingo.web.ContextAwareHttpSerlvetRequest;
import org.teiid.olingo.web.ProxyHttpServletRequest;
import org.teiid.transport.LocalServerConnection;
import org.teiid.vdb.runtime.VDBKey;

public class ODataFilter
implements Filter,
VDBLifeCycleListener {
    protected String proxyBaseURI;
    protected Properties initProperties;
    protected Map<VDBKey, SoftReference<OlingoBridge>> contextMap = Collections.synchronizedMap(new LRUCache());
    private volatile boolean listenerRegistered = false;

    public void init(FilterConfig config) throws ServletException {
        String name;
        String proxyURI = config.getInitParameter("proxy-base-uri");
        if (proxyURI != null && proxyURI.startsWith("${") && proxyURI.endsWith("}")) {
            proxyURI = proxyURI.substring(2, proxyURI.length() - 1);
            proxyURI = System.getProperty(proxyURI);
        }
        if (proxyURI != null) {
            this.proxyBaseURI = proxyURI;
        }
        Properties props = new Properties();
        Enumeration names = config.getServletContext().getInitParameterNames();
        while (names.hasMoreElements()) {
            name = (String)names.nextElement();
            props.setProperty(name, config.getServletContext().getInitParameter(name));
        }
        names = config.getInitParameterNames();
        while (names.hasMoreElements()) {
            name = (String)names.nextElement();
            props.setProperty(name, config.getInitParameter(name));
        }
        this.initProperties = props;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            this.internalDoFilter(request, response, chain);
        }
        catch (TeiidProcessingException e) {
            LogManager.logWarning((String)"org.teiid.ODATA", (Throwable)e, (Object)ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16047, new Object[]{e.getMessage()}));
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            ODataFilter.writeError(request, e, httpResponse, 404);
        }
    }

    static void writeError(ServletRequest request, TeiidProcessingException e, HttpServletResponse httpResponse, int statusCode) throws IOException {
        String message;
        httpResponse.setStatus(statusCode);
        ContentType contentType = ContentType.parse((String)request.getContentType());
        PrintWriter writer = httpResponse.getWriter();
        String code = e.getCode() == null ? "" : e.getCode();
        String string = message = e.getMessage() == null ? "" : e.getMessage();
        if (contentType == null || contentType.isCompatible(ContentType.APPLICATION_JSON)) {
            httpResponse.setHeader("Content-Type", ContentType.APPLICATION_JSON.toContentTypeString());
            writer.write("{ \"error\": { \"code\": \"" + StringEscapeUtils.escapeJson((String)code) + "\", \"message\": \"" + StringEscapeUtils.escapeJson((String)message) + "\" } }");
        } else {
            httpResponse.setHeader("Content-Type", ContentType.APPLICATION_XML.toContentTypeString());
            writer.write("<m:error xmlns:m=\"http://docs.oasis-open.org/odata/ns/metadata\"><m:code>" + StringEscapeUtils.escapeXml10((String)code) + "</m:code><m:message>" + StringEscapeUtils.escapeXml10((String)message) + "</m:message></m:error>");
        }
        writer.close();
    }

    public void internalDoFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException, TeiidProcessingException {
        Object httpRequest = (HttpServletRequest)request;
        String proxyURI = this.proxyBaseURI;
        if (proxyURI != null) {
            httpRequest = new ProxyHttpServletRequest((HttpServletRequest)httpRequest, proxyURI);
        }
        VDBKey key = null;
        String vdbName = null;
        String version = null;
        String modelName = null;
        String uri = ((HttpServletRequest)request).getRequestURI().toString();
        String fullURL = ((HttpServletRequest)request).getRequestURL().toString();
        if (uri.startsWith("/odata4/static/") || uri.startsWith("/odata4/keycloak/")) {
            chain.doFilter((ServletRequest)httpRequest, response);
            return;
        }
        String contextPath = httpRequest.getContextPath();
        String baseURI = fullURL.substring(0, fullURL.indexOf(contextPath));
        int endIdx = uri.indexOf(47, contextPath.length() + 1);
        int beginIdx = contextPath.length() + 1;
        if (contextPath.equals("/odata4")) {
            if (endIdx == -1) {
                throw new TeiidProcessingException((BundleUtil.Event)ODataPlugin.Event.TEIID16020, ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16020, new Object[0]));
            }
            baseURI = baseURI + "/odata4";
            vdbName = uri.substring(beginIdx, endIdx);
            int modelIdx = uri.indexOf(47, endIdx + 1);
            if (modelIdx == -1) {
                modelName = uri.substring(endIdx + 1).trim();
                if (modelName.isEmpty()) {
                    throw new TeiidProcessingException((BundleUtil.Event)ODataPlugin.Event.TEIID16019, ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16019, new Object[0]));
                }
            } else {
                modelName = uri.substring(endIdx + 1, modelIdx);
            }
            contextPath = contextPath + "/" + vdbName + "/" + modelName;
            if ((vdbName = vdbName.trim()).isEmpty()) {
                throw new TeiidProcessingException((BundleUtil.Event)ODataPlugin.Event.TEIID16008, ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16008, new Object[0]));
            }
        } else {
            if (this.initProperties.getProperty("vdb-name") == null) {
                throw new TeiidProcessingException((BundleUtil.Event)ODataPlugin.Event.TEIID16018, ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16018, new Object[0]));
            }
            vdbName = this.initProperties.getProperty("vdb-name");
            version = this.initProperties.getProperty("vdb-version");
            if (endIdx == -1) {
                modelName = uri.substring(beginIdx).trim();
                if (modelName.isEmpty()) {
                    throw new TeiidProcessingException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16021, new Object[0]));
                }
            } else {
                modelName = uri.substring(beginIdx, endIdx);
            }
            contextPath = contextPath + "/" + modelName;
        }
        ContextAwareHttpSerlvetRequest contextAwareRequest = new ContextAwareHttpSerlvetRequest((HttpServletRequest)httpRequest);
        contextAwareRequest.setContextPath(contextPath);
        httpRequest = contextAwareRequest;
        key = new VDBKey(vdbName, (Object)version);
        if (key.isAtMost()) {
            if (key.getVersion() != null) {
                throw new TeiidProcessingException((BundleUtil.Event)ODataPlugin.Event.TEIID16044, ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16044, new Object[]{key}));
            }
            key = new VDBKey(vdbName, (Object)"1");
        }
        SoftReference<OlingoBridge> ref = this.contextMap.get(key);
        OlingoBridge context = null;
        if (ref != null) {
            context = ref.get();
        }
        if (context == null) {
            context = new OlingoBridge();
            ref = new SoftReference<OlingoBridge>(context);
            this.contextMap.put(key, ref);
        }
        Client client = this.buildClient(key.getName(), key.getVersion(), this.initProperties);
        try {
            Connection connection = client.open();
            this.registerVDBListener(client, connection);
            ODataHttpHandler handler = context.getHandler(baseURI, client, modelName);
            httpRequest.setAttribute(ODataHttpHandler.class.getName(), (Object)handler);
            httpRequest.setAttribute(Client.class.getName(), (Object)client);
            chain.doFilter((ServletRequest)httpRequest, response);
        }
        catch (SQLException e) {
            throw new TeiidProcessingException((Throwable)e);
        }
        finally {
            try {
                client.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerVDBListener(Client client, Connection conn) {
        if (!this.listenerRegistered) {
            ODataFilter oDataFilter = this;
            synchronized (oDataFilter) {
                if (!this.listenerRegistered && client instanceof LocalClient) {
                    try {
                        ConnectionImpl connection = (ConnectionImpl)conn;
                        LocalServerConnection lsc = (LocalServerConnection)connection.getServerConnection();
                        lsc.addListener((VDBLifeCycleListener)this);
                        this.listenerRegistered = true;
                    }
                    catch (SQLException e) {
                        LogManager.logWarning((String)"org.teiid.ODATA", (Object)ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID16014, new Object[0]));
                    }
                }
            }
        }
    }

    public Client buildClient(String vdbName, String version, Properties props) {
        return new LocalClient(vdbName, version, props);
    }

    public void destroy() {
        this.contextMap.clear();
    }

    public void removed(String name, CompositeVDB vdb) {
        this.contextMap.remove(vdb.getVDBKey());
    }

    public void finishedDeployment(String name, CompositeVDB vdb) {
        this.contextMap.remove(vdb.getVDBKey());
    }

    public void beforeRemove(String name, CompositeVDB vdb) {
    }

    public void added(String name, CompositeVDB vdb) {
    }
}

