/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.web.gzip;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.zip.GZIPInputStream;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class GzipMessageRequest
extends HttpServletRequestWrapper {
    private ServletInputStream returnedStream = null;
    private BufferedReader returnedReader = null;
    private final Charset charset;

    public GzipMessageRequest(HttpServletRequest request) {
        super(request);
        String cs = request.getCharacterEncoding();
        this.charset = cs == null || cs.isEmpty() ? Charset.defaultCharset() : Charset.forName(cs);
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.returnedReader != null) {
            throw new IllegalStateException("Method getReader() has already been called.");
        }
        if (this.returnedStream == null) {
            this.returnedStream = new GzipServletInputStream(super.getInputStream());
        }
        return this.returnedStream;
    }

    public BufferedReader getReader() throws IOException {
        if (this.returnedStream != null) {
            throw new IllegalStateException("Method getInputStream() has already been called.");
        }
        if (this.returnedReader == null) {
            this.returnedReader = new BufferedReader(new InputStreamReader((InputStream)((Object)new GzipServletInputStream(super.getInputStream())), this.charset));
        }
        return this.returnedReader;
    }

    private class GzipServletInputStream
    extends ServletInputStream {
        private final InputStream src;
        private final ServletInputStream origin;

        private GzipServletInputStream(ServletInputStream origin) throws IOException {
            this.src = new GZIPInputStream((InputStream)origin);
            this.origin = origin;
        }

        public boolean isFinished() {
            try {
                return this.src.available() == 0;
            }
            catch (IOException e) {
                return true;
            }
        }

        public boolean isReady() {
            return !this.isFinished();
        }

        public void setReadListener(ReadListener readListener) {
            this.origin.setReadListener(readListener);
        }

        public int read() throws IOException {
            return this.src.read();
        }

        public int read(byte[] b) throws IOException {
            return this.src.read(b);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.src.read(b, off, len);
        }

        public void close() throws IOException {
            this.src.close();
            super.close();
        }
    }
}

