/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.salesforce;

import com.sforce.async.AsyncApiException;
import com.sforce.async.BatchInfo;
import com.sforce.async.BatchInfoList;
import com.sforce.async.BatchRequest;
import com.sforce.async.BatchResult;
import com.sforce.async.BatchStateEnum;
import com.sforce.async.BulkConnection;
import com.sforce.async.CSVReader;
import com.sforce.async.ConcurrencyMode;
import com.sforce.async.ContentType;
import com.sforce.async.JobInfo;
import com.sforce.async.JobStateEnum;
import com.sforce.async.OperationEnum;
import com.sforce.async.QueryResultList;
import com.sforce.soap.partner.DeleteResult;
import com.sforce.soap.partner.DeletedRecord;
import com.sforce.soap.partner.DescribeGlobalResult;
import com.sforce.soap.partner.DescribeSObjectResult;
import com.sforce.soap.partner.Error;
import com.sforce.soap.partner.GetDeletedResult;
import com.sforce.soap.partner.GetUpdatedResult;
import com.sforce.soap.partner.PartnerConnection;
import com.sforce.soap.partner.QueryResult;
import com.sforce.soap.partner.SaveResult;
import com.sforce.soap.partner.UpsertResult;
import com.sforce.soap.partner.fault.InvalidFieldFault;
import com.sforce.soap.partner.fault.InvalidIdFault;
import com.sforce.soap.partner.fault.InvalidQueryLocatorFault;
import com.sforce.soap.partner.fault.InvalidSObjectFault;
import com.sforce.soap.partner.fault.MalformedQueryFault;
import com.sforce.soap.partner.fault.UnexpectedErrorFault;
import com.sforce.soap.partner.sobject.SObject;
import com.sforce.ws.ConnectionException;
import com.sforce.ws.ConnectorConfig;
import com.sforce.ws.transport.JdkHttpTransport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import javax.resource.ResourceException;
import javax.security.auth.Subject;
import org.teiid.OAuthCredential;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.logging.LogManager;
import org.teiid.resource.adapter.salesforce.SalesForceManagedConnectionFactory;
import org.teiid.resource.adapter.salesforce.TeiidPartnerConnection;
import org.teiid.resource.adapter.salesforce.transport.SalesforceCXFTransport;
import org.teiid.resource.adapter.salesforce.transport.SalesforceConnectorConfig;
import org.teiid.resource.spi.BasicConnection;
import org.teiid.resource.spi.BasicManagedConnectionFactory;
import org.teiid.resource.spi.ConnectionContext;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.salesforce.SalesforceConnection;
import org.teiid.translator.salesforce.execution.DataPayload;
import org.teiid.translator.salesforce.execution.DeletedObject;
import org.teiid.translator.salesforce.execution.DeletedResult;
import org.teiid.translator.salesforce.execution.UpdatedResult;

public class SalesforceConnectionImpl
extends BasicConnection
implements SalesforceConnection {
    private static final String ID_FIELD_NAME = "id";
    private static final String PK_CHUNKING_HEADER = "Sforce-Enable-PKChunking";
    private static final int MAX_CHUNK_SIZE = 100000;
    private BulkConnection bulkConnection;
    private PartnerConnection partnerConnection;
    private SalesforceConnectorConfig config;
    private String restEndpoint;
    private String apiVersion;
    private int pollingInterval = 500;

    public SalesforceConnectionImpl(SalesForceManagedConnectionFactory mcf) throws ResourceException {
        this.login(mcf);
    }

    SalesforceConnectionImpl(PartnerConnection partnerConnection) {
        this.partnerConnection = partnerConnection;
    }

    private void login(SalesForceManagedConnectionFactory mcf) throws ResourceException {
        this.config = new SalesforceConnectorConfig();
        String username = mcf.getUsername();
        String password = mcf.getPassword();
        boolean useCXFTransport = mcf.getConfigFile() != null;
        Subject subject = ConnectionContext.getSubject();
        if (subject != null) {
            OAuthCredential oauthCredential = (OAuthCredential)ConnectionContext.getSecurityCredential((Subject)subject, OAuthCredential.class);
            if (oauthCredential != null) {
                this.config.setCredential(OAuthCredential.class.getName(), oauthCredential);
                useCXFTransport = true;
            } else {
                username = ConnectionContext.getUserName((Subject)subject, (BasicManagedConnectionFactory)mcf, (String)username);
                password = ConnectionContext.getPassword((Subject)subject, (BasicManagedConnectionFactory)mcf, (String)username, (String)password);
            }
        }
        this.config.setCxfConfigFile(mcf.getConfigFile());
        if (useCXFTransport) {
            this.config.setTransport(SalesforceCXFTransport.class);
        }
        this.config.setCompression(true);
        this.config.setTraceMessage(false);
        String props = mcf.getConfigProperties();
        if (props != null) {
            Properties p = new Properties();
            try {
                p.load(new StringReader(props));
            }
            catch (IOException e) {
                throw new ResourceException((Throwable)e);
            }
            PropertiesUtils.setBeanProperties((Object)((Object)this.config), (Properties)p, null);
        }
        this.config.setUsername(username);
        this.config.setPassword(password);
        this.config.setAuthEndpoint(mcf.getURL());
        if (mcf.getProxyURL() != null) {
            try {
                URL proxyURL = new URL(mcf.getProxyURL());
                this.config.setProxy(proxyURL.getHost(), proxyURL.getPort());
                this.config.setProxyUsername(mcf.getProxyUsername());
                this.config.setProxyPassword(mcf.getProxyPassword());
            }
            catch (MalformedURLException e) {
                throw new ResourceException((Throwable)e);
            }
        }
        if (mcf.getConnectTimeout() != null) {
            this.config.setConnectionTimeout((int)Math.min(Integer.MAX_VALUE, mcf.getConnectTimeout()));
        }
        if (mcf.getRequestTimeout() != null) {
            this.config.setReadTimeout((int)Math.min(Integer.MAX_VALUE, mcf.getRequestTimeout()));
        }
        try {
            this.partnerConnection = new TeiidPartnerConnection(this.config);
            String endpoint = this.config.getServiceEndpoint();
            int index = endpoint.indexOf("Soap/u/");
            int endIndex = endpoint.indexOf(47, index + 7);
            this.apiVersion = endpoint.substring(index + 7, endIndex);
            String bulkEndpoint = endpoint.substring(0, endpoint.indexOf("Soap/")) + "async/" + this.apiVersion;
            this.config.setRestEndpoint(bulkEndpoint);
            this.partnerConnection.setCallOptions("RedHat/MetaMatrix/", null);
            this.bulkConnection = new BulkConnection((ConnectorConfig)this.config);
            this.partnerConnection.getUserInfo();
            this.restEndpoint = endpoint.substring(0, endpoint.indexOf("Soap/")) + "data/v30.0";
        }
        catch (AsyncApiException e) {
            throw new ResourceException((Throwable)e);
        }
        catch (ConnectionException e) {
            throw new ResourceException((Throwable)e);
        }
        LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object)"Login was successful for username", (Object)username);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long getCardinality(String sobject) throws TranslatorException {
        InputStream is = null;
        try {
            is = this.doRestHttpGet(new URL(this.restEndpoint + "/query/?explain=select+id+from+" + URLEncoder.encode(sobject, "UTF-8")));
            String s = ObjectConverterUtil.convertToString((Reader)new InputStreamReader(is, Charset.forName("UTF-8")));
            int index = s.indexOf("cardinality");
            if (index < 0) {
                Long l = null;
                return l;
            }
            if ((index = s.indexOf(":", index)) < 0) {
                Long l = null;
                return l;
            }
            int end = s.indexOf(",", index);
            if (end < 0) {
                end = s.indexOf("}", index);
            }
            if (end < 0) {
                Long l = null;
                return l;
            }
            s = s.substring(index + 1, end);
            Long l = Long.valueOf(s);
            return l;
        }
        catch (NumberFormatException e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (IOException e) {
            throw new TranslatorException((Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private InputStream doRestHttpGet(URL url) throws IOException {
        HttpURLConnection connection = JdkHttpTransport.createConnection((ConnectorConfig)this.config, (URL)url, null);
        connection.setRequestProperty("Authorization", "Bearer " + this.config.getSessionId());
        InputStream in = connection.getInputStream();
        String encoding = connection.getHeaderField("Content-Encoding");
        if ("gzip".equals(encoding)) {
            in = new GZIPInputStream(in);
        }
        return in;
    }

    public boolean isValid() {
        if (this.partnerConnection != null) {
            try {
                this.partnerConnection.getServerTimestamp();
                return true;
            }
            catch (Throwable t) {
                LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object)"Caught Throwable in isAlive", (Object)t);
            }
        }
        return false;
    }

    public QueryResult query(String queryString, int batchSize, boolean queryAll) throws TranslatorException {
        if (batchSize > 2000) {
            batchSize = 2000;
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)"reduced.batch.size");
        }
        QueryResult qr = null;
        this.partnerConnection.setQueryOptions(batchSize);
        try {
            if (queryAll) {
                qr = this.partnerConnection.queryAll(queryString);
            } else {
                this.partnerConnection.setMruHeader(false);
                qr = this.partnerConnection.query(queryString);
            }
        }
        catch (InvalidFieldFault e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (MalformedQueryFault e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (InvalidSObjectFault e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (InvalidIdFault e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (UnexpectedErrorFault e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (InvalidQueryLocatorFault e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (ConnectionException e) {
            throw new TranslatorException((Throwable)e);
        }
        finally {
            this.partnerConnection.clearMruHeader();
            this.partnerConnection.clearQueryOptions();
        }
        return qr;
    }

    public QueryResult queryMore(String queryLocator, int batchSize) throws TranslatorException {
        if (batchSize > 2000) {
            batchSize = 2000;
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)"reduced.batch.size");
        }
        this.partnerConnection.setQueryOptions(batchSize);
        try {
            QueryResult queryResult = this.partnerConnection.queryMore(queryLocator);
            return queryResult;
        }
        catch (InvalidFieldFault e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (UnexpectedErrorFault e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (InvalidQueryLocatorFault e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (ConnectionException e) {
            throw new TranslatorException((Throwable)e);
        }
        finally {
            this.partnerConnection.clearQueryOptions();
        }
    }

    public int delete(String[] ids) throws TranslatorException {
        DeleteResult[] results = null;
        try {
            results = this.partnerConnection.delete(ids);
        }
        catch (UnexpectedErrorFault e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (ConnectionException e) {
            throw new TranslatorException((Throwable)e);
        }
        boolean allGood = true;
        StringBuffer errorMessages = new StringBuffer();
        for (int i = 0; i < results.length; ++i) {
            Error[] errors;
            DeleteResult result = results[i];
            if (result.isSuccess()) continue;
            if (allGood) {
                errorMessages.append("Error(s) executing DELETE: ");
                allGood = false;
            }
            if (null == (errors = result.getErrors()) || errors.length <= 0) continue;
            for (int x = 0; x < errors.length; ++x) {
                Error error = errors[x];
                errorMessages.append(error.getMessage()).append(';');
            }
        }
        if (!allGood) {
            throw new TranslatorException(errorMessages.toString());
        }
        return results.length;
    }

    public int upsert(DataPayload data) throws TranslatorException {
        UpsertResult[] results;
        SObject toCreate = new SObject();
        toCreate.setType(data.getType());
        for (DataPayload.Field field : data.getMessageElements()) {
            toCreate.addField(field.name, field.value);
        }
        SObject[] objects = new SObject[]{toCreate};
        try {
            results = this.partnerConnection.upsert(ID_FIELD_NAME, objects);
        }
        catch (InvalidFieldFault e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (InvalidSObjectFault e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (InvalidIdFault e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (UnexpectedErrorFault e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (ConnectionException e) {
            throw new TranslatorException((Throwable)e);
        }
        for (UpsertResult result : results) {
            if (result.isSuccess()) continue;
            throw new TranslatorException(result.getErrors()[0].getMessage());
        }
        return results.length;
    }

    public int create(DataPayload data) throws TranslatorException {
        SaveResult[] result;
        SObject toCreate = new SObject();
        toCreate.setType(data.getType());
        for (DataPayload.Field field : data.getMessageElements()) {
            toCreate.addField(field.name, field.value);
        }
        SObject[] objects = new SObject[]{toCreate};
        try {
            result = this.partnerConnection.create(objects);
        }
        catch (InvalidFieldFault e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (InvalidSObjectFault e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (InvalidIdFault e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (UnexpectedErrorFault e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (ConnectionException e) {
            throw new TranslatorException((Throwable)e);
        }
        return this.analyzeResult(result);
    }

    public int update(List<DataPayload> updateDataList) throws TranslatorException {
        SaveResult[] result;
        ArrayList<SObject> params = new ArrayList<SObject>(updateDataList.size());
        for (int i = 0; i < updateDataList.size(); ++i) {
            DataPayload data = updateDataList.get(i);
            SObject toCreate = new SObject();
            toCreate.setType(data.getType());
            toCreate.setId(data.getID());
            for (DataPayload.Field field : data.getMessageElements()) {
                toCreate.addField(field.name, field.value);
            }
            params.add(i, toCreate);
        }
        try {
            result = this.partnerConnection.update(params.toArray(new SObject[params.size()]));
        }
        catch (InvalidFieldFault e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (InvalidSObjectFault e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (InvalidIdFault e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (UnexpectedErrorFault e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (ConnectionException e) {
            throw new TranslatorException((Throwable)e);
        }
        return this.analyzeResult(result);
    }

    private int analyzeResult(SaveResult[] results) throws TranslatorException {
        for (SaveResult result : results) {
            if (result.isSuccess()) continue;
            throw new TranslatorException(result.getErrors()[0].getMessage());
        }
        return results.length;
    }

    public UpdatedResult getUpdated(String objectType, Calendar startDate, Calendar endDate) throws TranslatorException {
        GetUpdatedResult updated;
        try {
            updated = this.partnerConnection.getUpdated(objectType, startDate, endDate);
        }
        catch (InvalidSObjectFault e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (UnexpectedErrorFault e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (ConnectionException e) {
            throw new TranslatorException((Throwable)e);
        }
        UpdatedResult result = new UpdatedResult();
        result.setLatestDateCovered(updated.getLatestDateCovered());
        result.setIDs(Arrays.asList(updated.getIds()));
        return result;
    }

    public DeletedResult getDeleted(String objectName, Calendar startCalendar, Calendar endCalendar) throws TranslatorException {
        GetDeletedResult deleted;
        try {
            deleted = this.partnerConnection.getDeleted(objectName, startCalendar, endCalendar);
        }
        catch (InvalidSObjectFault e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (UnexpectedErrorFault e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (ConnectionException e) {
            throw new TranslatorException((Throwable)e);
        }
        DeletedResult result = new DeletedResult();
        result.setLatestDateCovered(deleted.getLatestDateCovered());
        result.setEarliestDateAvailable(deleted.getEarliestDateAvailable());
        DeletedRecord[] records = deleted.getDeletedRecords();
        ArrayList<DeletedObject> resultRecords = new ArrayList<DeletedObject>();
        if (records != null) {
            for (DeletedRecord record : records) {
                DeletedObject object = new DeletedObject();
                object.setID(record.getId());
                object.setDeletedDate(record.getDeletedDate());
                resultRecords.add(object);
            }
        }
        result.setResultRecords(resultRecords);
        return result;
    }

    public SObject[] retrieve(String fieldList, String sObjectType, List<String> ids) throws TranslatorException {
        try {
            return this.partnerConnection.retrieve(fieldList, sObjectType, ids.toArray(new String[ids.size()]));
        }
        catch (InvalidFieldFault e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (MalformedQueryFault e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (InvalidSObjectFault e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (InvalidIdFault e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (UnexpectedErrorFault e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (ConnectionException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public DescribeGlobalResult getObjects() throws TranslatorException {
        try {
            return this.partnerConnection.describeGlobal();
        }
        catch (UnexpectedErrorFault e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (ConnectionException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public DescribeSObjectResult[] getObjectMetaData(String ... objectName) throws TranslatorException {
        try {
            return this.partnerConnection.describeSObjects(objectName);
        }
        catch (InvalidSObjectFault e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (UnexpectedErrorFault e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (ConnectionException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public void close() throws ResourceException {
    }

    public boolean isAlive() {
        return this.isValid();
    }

    public JobInfo createBulkJob(String objectName, OperationEnum operation, boolean usePkChunking) throws TranslatorException {
        try {
            JobInfo job = new JobInfo();
            job.setObject(objectName);
            job.setOperation(operation);
            job.setContentType(operation == OperationEnum.insert || operation == OperationEnum.upsert ? ContentType.XML : ContentType.CSV);
            if (operation == OperationEnum.upsert) {
                job.setExternalIdFieldName(ID_FIELD_NAME);
            }
            job.setConcurrencyMode(ConcurrencyMode.Parallel);
            if (operation == OperationEnum.query && usePkChunking) {
                this.bulkConnection.addHeader(PK_CHUNKING_HEADER, "chunkSize=100000");
            }
            JobInfo info = this.bulkConnection.createJob(job);
            if (operation == OperationEnum.query) {
                this.bulkConnection = new BulkConnection((ConnectorConfig)this.config);
            }
            return info;
        }
        catch (AsyncApiException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public String addBatch(List<com.sforce.async.SObject> payload, JobInfo job) throws TranslatorException {
        try {
            BatchRequest request = this.bulkConnection.createBatch(job);
            request.addSObjects(payload.toArray(new com.sforce.async.SObject[payload.size()]));
            return request.completeRequest().getId();
        }
        catch (AsyncApiException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public SalesforceConnection.BatchResultInfo addBatch(String query, JobInfo job) throws TranslatorException {
        try {
            BatchInfo batch = this.bulkConnection.createBatchFromStream(job, (InputStream)new ByteArrayInputStream(query.getBytes(Charset.forName("UTF-8"))));
            return new SalesforceConnection.BatchResultInfo(batch.getId());
        }
        catch (AsyncApiException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public SalesforceConnection.BulkBatchResult getBatchQueryResults(String jobId, SalesforceConnection.BatchResultInfo info) throws TranslatorException {
        if (info.getResultList() == null && info.getPkBatches() == null) {
            try {
                BatchInfo batch = this.bulkConnection.getBatchInfo(jobId, info.getBatchId());
                switch (batch.getState()) {
                    case NotProcessed: {
                        JobInfo jobStatus = this.bulkConnection.getJobStatus(jobId);
                        if (jobStatus.getState() == JobStateEnum.Aborted) {
                            throw new TranslatorException(JobStateEnum.Aborted.name());
                        }
                        BatchInfoList batchInfoList = this.bulkConnection.getBatchInfoList(jobId);
                        LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object)"Pk chunk batches", (Object)batchInfoList);
                        BatchInfo[] batchInfo = batchInfoList.getBatchInfo();
                        LinkedHashMap<String, BatchInfo> pkBactches = new LinkedHashMap<String, BatchInfo>();
                        boolean anyComplete = false;
                        for (int i = 0; i < batchInfo.length; ++i) {
                            BatchInfo batchInfoItem = batchInfo[i];
                            if (batchInfoItem.getId().equals(info.getBatchId())) continue;
                            switch (batchInfoItem.getState()) {
                                case Failed: 
                                case NotProcessed: {
                                    throw new TranslatorException(batchInfoItem.getStateMessage());
                                }
                                case Completed: {
                                    anyComplete = true;
                                }
                            }
                            pkBactches.put(batchInfoItem.getId(), batchInfoItem);
                        }
                        info.setPkBatches(pkBactches);
                        if (!anyComplete) {
                            this.throwDataNotAvailable(info);
                        }
                        break;
                    }
                    case Completed: {
                        QueryResultList list = this.bulkConnection.getQueryResultList(jobId, info.getBatchId());
                        info.setResultList(list.getResult());
                        break;
                    }
                    case InProgress: 
                    case Queued: {
                        this.throwDataNotAvailable(info);
                    }
                    default: {
                        throw new TranslatorException(batch.getStateMessage());
                    }
                }
            }
            catch (AsyncApiException e) {
                throw new TranslatorException((Throwable)e);
            }
        }
        try {
            SalesforceConnection.BulkBatchResult result = null;
            if (info.getResultList() != null) {
                result = this.nextBulkBatch(jobId, info);
            }
            if (result == null && info.getPkBatches() != null) {
                this.getNextPkChunkResultList(jobId, info);
                result = this.nextBulkBatch(jobId, info);
            }
            info.resetWaitCount();
            return result;
        }
        catch (AsyncApiException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    private void throwDataNotAvailable(SalesforceConnection.BatchResultInfo info) {
        int waitCount = info.incrementAndGetWaitCount();
        LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object)"Waiting on queued/inprogress, wait number", (Object)waitCount);
        throw new DataNotAvailableException((long)(this.pollingInterval * Math.min(8, waitCount)));
    }

    private void getNextPkChunkResultList(String jobId, SalesforceConnection.BatchResultInfo info) throws AsyncApiException, TranslatorException {
        LinkedHashMap batches = info.getPkBatches();
        if (batches.isEmpty()) {
            return;
        }
        Iterator iter = batches.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (((BatchInfo)entry.getValue()).getState() != BatchStateEnum.Completed) continue;
            iter.remove();
            QueryResultList list = this.bulkConnection.getQueryResultList(jobId, (String)entry.getKey());
            info.setResultList(list.getResult());
            return;
        }
        BatchInfoList batchInfoList = this.bulkConnection.getBatchInfoList(jobId);
        BatchInfo[] batchInfo = batchInfoList.getBatchInfo();
        String completedId = null;
        block5: for (BatchInfo bi : batchInfo) {
            if (!batches.containsKey(bi.getId())) continue;
            switch (bi.getState()) {
                case Failed: 
                case NotProcessed: {
                    throw new TranslatorException(bi.getStateMessage());
                }
                case Completed: {
                    if (completedId == null) {
                        completedId = bi.getId();
                        batches.remove(completedId);
                        continue block5;
                    }
                    batches.put(bi.getId(), bi);
                }
            }
        }
        if (completedId == null) {
            this.throwDataNotAvailable(info);
        }
        QueryResultList list = this.bulkConnection.getQueryResultList(jobId, completedId);
        info.setResultList(list.getResult());
    }

    private SalesforceConnection.BulkBatchResult nextBulkBatch(String jobId, SalesforceConnection.BatchResultInfo info) throws AsyncApiException {
        int index = info.getAndIncrementResultNum();
        if (index < info.getResultList().length) {
            String resultId = info.getResultList()[index];
            final InputStream inputStream = this.bulkConnection.getQueryResultStream(jobId, info.getBatchId(), resultId);
            final CSVReader reader = new CSVReader(inputStream);
            reader.setMaxRowsInFile(Integer.MAX_VALUE);
            reader.setMaxCharsInFile(Integer.MAX_VALUE);
            return new SalesforceConnection.BulkBatchResult(){

                public List<String> nextRecord() throws IOException {
                    return reader.nextRecord();
                }

                public void close() {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            };
        }
        return null;
    }

    public JobInfo closeJob(String jobId) throws TranslatorException {
        try {
            return this.bulkConnection.closeJob(jobId);
        }
        catch (AsyncApiException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public BatchResult[] getBulkResults(JobInfo job, List<String> ids) throws TranslatorException {
        try {
            JobInfo info = this.bulkConnection.getJobStatus(job.getId());
            if (info.getNumberBatchesTotal() != info.getNumberBatchesFailed() + info.getNumberBatchesCompleted()) {
                throw new DataNotAvailableException((long)this.pollingInterval);
            }
            BatchResult[] results = new BatchResult[ids.size()];
            for (int i = 0; i < ids.size(); ++i) {
                results[i] = this.bulkConnection.getBatchResult(job.getId(), ids.get(i));
            }
            return results;
        }
        catch (AsyncApiException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public void cancelBulkJob(JobInfo job) throws TranslatorException {
        try {
            this.bulkConnection.abortJob(job.getId());
        }
        catch (AsyncApiException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public String getVersion() {
        return this.apiVersion;
    }
}

