/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.salesforce.transport;

import com.sforce.ws.ConnectorConfig;
import com.sforce.ws.tools.VersionInfo;
import com.sforce.ws.transport.LimitingInputStream;
import com.sforce.ws.transport.LimitingOutputStream;
import com.sforce.ws.transport.Transport;
import com.sforce.ws.util.Base64;
import com.sforce.ws.util.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.teiid.resource.adapter.salesforce.transport.SalesforceConnectorConfig;

public class SalesforceCXFTransport
implements Transport {
    private ByteArrayOutputStream payload = new ByteArrayOutputStream();
    private boolean successful;
    private SalesforceConnectorConfig config;
    private WebClient client;

    public void setConfig(ConnectorConfig config) {
        this.config = (SalesforceConnectorConfig)config;
    }

    public OutputStream connect(String uri, String soapAction) throws IOException {
        if (soapAction == null) {
            soapAction = "";
        }
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("SOAPAction", "\"" + soapAction + "\"");
        header.put("Content-Type", "text/xml; charset=UTF-8");
        header.put("Accept", "text/xml");
        return this.connectLocal(uri, header);
    }

    private OutputStream connectLocal(String uri, HashMap<String, String> httpHeaders) throws IOException {
        return this.connectLocal(uri, httpHeaders, true);
    }

    private OutputStream connectLocal(String uri, HashMap<String, String> httpHeaders, boolean enableCompression) throws IOException {
        return this.wrapOutput(this.connectRaw(uri, httpHeaders, enableCompression), enableCompression);
    }

    private OutputStream wrapOutput(OutputStream output, boolean enableCompression) throws IOException {
        if (this.config.getMaxRequestSize() > 0) {
            output = new LimitingOutputStream(this.config.getMaxRequestSize(), output);
        }
        if (enableCompression && this.config.isCompression()) {
            output = new GZIPOutputStream(output);
        }
        if (this.config.isTraceMessage()) {
            output = this.config.teeOutputStream(output);
        }
        return output;
    }

    private OutputStream connectRaw(String uri, HashMap<String, String> httpHeaders, boolean enableCompression) {
        if (this.config.isTraceMessage()) {
            this.config.getTraceStream().println("WSC: Creating a new connection to " + uri + " Proxy = " + this.config.getProxy() + " username " + this.config.getProxyUsername());
        }
        this.client = this.config.getCxfConfigFile() == null ? WebClient.create((String)uri) : WebClient.create((String)uri, (String)this.config.getCxfConfigFile());
        this.client.header("User-Agent", new Object[]{VersionInfo.info()});
        if (this.config.getHeaders() != null) {
            for (Map.Entry ent : this.config.getHeaders().entrySet()) {
                this.client.header((String)ent.getKey(), new Object[]{ent.getValue()});
            }
        }
        if (enableCompression && this.config.isCompression()) {
            this.client.header("Content-Encoding", new Object[]{"gzip"});
            this.client.header("Accept-Encoding", new Object[]{"gzip"});
        }
        if (this.config.getProxyUsername() != null) {
            String token = this.config.getProxyUsername() + ":" + this.config.getProxyPassword();
            String auth = "Basic " + new String(Base64.encode((byte[])token.getBytes()));
            this.client.header("Proxy-Authorization", new Object[]{auth});
            this.client.header("Https-Proxy-Authorization", new Object[]{auth});
        }
        if (httpHeaders != null) {
            for (Map.Entry<String, String> entry : httpHeaders.entrySet()) {
                this.client.header(entry.getKey(), new Object[]{entry.getValue()});
            }
        }
        HTTPClientPolicy clientPolicy = WebClient.getConfig((Object)this.client).getHttpConduit().getClient();
        if (this.config.getReadTimeout() != 0) {
            clientPolicy.setReceiveTimeout((long)this.config.getReadTimeout());
        }
        if (this.config.getConnectionTimeout() != 0) {
            clientPolicy.setConnectionTimeout((long)this.config.getConnectionTimeout());
        }
        if (this.config.useChunkedPost()) {
            clientPolicy.setAllowChunking(true);
            clientPolicy.setChunkLength(4096);
        }
        if (this.config.getProxy() != Proxy.NO_PROXY) {
            InetSocketAddress addr = (InetSocketAddress)this.config.getProxy().address();
            clientPolicy.setProxyServer(addr.getHostName());
            clientPolicy.setProxyServerPort(Integer.valueOf(addr.getPort()));
        }
        return this.payload;
    }

    public InputStream getContent() throws IOException {
        Response response = this.client.post((Object)new ByteArrayInputStream(this.payload.toByteArray()));
        this.successful = true;
        InputStream in = (InputStream)response.getEntity();
        if (response.getStatus() != 200) {
            this.successful = false;
        }
        if (!this.successful) {
            return in;
        }
        String encoding = response.getHeaderString("Content-Encoding");
        if (this.config.getMaxResponseSize() > 0) {
            in = new LimitingInputStream(this.config.getMaxResponseSize(), in);
        }
        if ("gzip".equals(encoding)) {
            in = new GZIPInputStream(in);
        }
        if (this.config.hasMessageHandlers() || this.config.isTraceMessage()) {
            byte[] bytes = FileUtil.toBytes((InputStream)in);
            in = new ByteArrayInputStream(bytes);
            if (this.config.isTraceMessage()) {
                MultivaluedMap headers = response.getHeaders();
                for (Map.Entry header : headers.entrySet()) {
                    this.config.getTraceStream().print((String)header.getKey());
                    this.config.getTraceStream().print("=");
                    this.config.getTraceStream().println(header.getValue());
                }
                this.config.teeInputStream(bytes);
            }
        }
        return in;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public OutputStream connect(String endpoint, HashMap<String, String> headers) throws IOException {
        return this.connectLocal(endpoint, headers, true);
    }

    public OutputStream connect(String endpoint, HashMap<String, String> httpHeaders, boolean b) throws IOException {
        return this.connectLocal(endpoint, httpHeaders, b);
    }
}

