/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.cassandra;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.VersionNumber;
import java.util.List;
import java.util.Set;
import javax.resource.ResourceException;
import org.teiid.logging.LogManager;
import org.teiid.resource.adapter.cassandra.CassandraManagedConnectionFactory;
import org.teiid.resource.spi.BasicConnection;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.cassandra.CassandraConnection;

public class CassandraConnectionImpl
extends BasicConnection
implements CassandraConnection {
    private CassandraManagedConnectionFactory config;
    private Cluster cluster = null;
    private Session session = null;
    private Metadata metadata = null;
    private VersionNumber version;

    public CassandraConnectionImpl(CassandraManagedConnectionFactory config, Metadata metadata) {
        this.config = config;
        this.metadata = metadata;
    }

    public CassandraConnectionImpl(CassandraManagedConnectionFactory config) {
        this.config = config;
        Cluster.Builder builder = Cluster.builder().addContactPoint(config.getAddress());
        if (this.config.getUsername() != null) {
            builder.withCredentials(this.config.getUsername(), this.config.getPassword());
        }
        if (this.config.getPort() != null) {
            builder.withPort(this.config.getPort().intValue());
        }
        this.cluster = builder.build();
        this.metadata = this.cluster.getMetadata();
        this.session = this.cluster.connect(config.getKeyspace());
        Set allHosts = this.cluster.getMetadata().getAllHosts();
        if (!allHosts.isEmpty()) {
            Host host = (Host)allHosts.iterator().next();
            this.version = host.getCassandraVersion();
        }
    }

    public void close() throws ResourceException {
        if (this.cluster != null) {
            this.cluster.close();
        }
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)CassandraManagedConnectionFactory.UTIL.getString("shutting_down"));
    }

    public boolean isAlive() {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object)CassandraManagedConnectionFactory.UTIL.getString("alive"));
        return true;
    }

    public ResultSetFuture executeQuery(String query) {
        return this.session.executeAsync(query);
    }

    public ResultSetFuture executeBatch(List<String> updates) {
        BatchStatement bs = new BatchStatement();
        for (String update : updates) {
            bs.add((Statement)new SimpleStatement(update));
        }
        return this.session.executeAsync((Statement)bs);
    }

    public ResultSetFuture executeBatch(String update, List<Object[]> values) {
        PreparedStatement ps = this.session.prepare(update);
        BatchStatement bs = new BatchStatement();
        for (Object[] bindValues : values) {
            BoundStatement bound = ps.bind(bindValues);
            bs.add((Statement)bound);
        }
        return this.session.executeAsync((Statement)bs);
    }

    public KeyspaceMetadata keyspaceInfo() throws TranslatorException {
        String keyspace = this.config.getKeyspace();
        KeyspaceMetadata result = this.metadata.getKeyspace(keyspace);
        if (result == null && keyspace.length() > 2 && keyspace.charAt(0) == '\"' && keyspace.charAt(keyspace.length() - 1) == '\"') {
            keyspace = keyspace.substring(1, keyspace.length() - 1);
            result = this.metadata.getKeyspace(keyspace);
        }
        if (result == null) {
            throw new TranslatorException(keyspace);
        }
        return result;
    }

    public VersionNumber getVersion() {
        return this.version;
    }
}

