/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.binary;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import nux.xom.binary.ArrayCharList;
import nux.xom.binary.UnicodeUtil;

final class ArrayByteList {
    private transient byte[] elements;
    private int size;
    private transient int position = 0;
    private static final boolean DEBUG = false;

    public ArrayByteList() {
        this(64);
    }

    public ArrayByteList(int initialCapacity) {
        this.elements = new byte[initialCapacity];
        this.size = 0;
    }

    public ArrayByteList(byte[] elems) {
        this.elements = elems;
        this.size = elems.length;
    }

    public void add(byte elem) {
        if (this.size == this.elements.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.elements[this.size++] = elem;
    }

    public void add(byte[] elems, int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > elems.length) {
            throw new IndexOutOfBoundsException("offset: " + offset + ", length: " + length + ", elems.length: " + elems.length);
        }
        this.ensureCapacity(this.size + length);
        System.arraycopy(elems, offset, this.elements, this.size, length);
        this.size += length;
    }

    public byte[] asArray() {
        return this.elements;
    }

    public void clear() {
        this.size = 0;
        this.position = 0;
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity > this.elements.length) {
            int newCapacity = Math.max(minCapacity, 2 * this.elements.length + 1);
            this.elements = this.subArray(0, this.size, newCapacity);
        }
    }

    public boolean ensureRemaining(InputStream input, int need) throws IOException {
        int remaining = this.remaining();
        if ((need -= remaining) <= 0) {
            return true;
        }
        int free = this.elements.length - this.size;
        if (free < need) {
            if (free + this.position >= need) {
                System.arraycopy(this.elements, this.position, this.elements, 0, remaining);
            } else {
                int newCapacity = Math.max(2 * this.elements.length, remaining + need);
                byte[] tmp = new byte[newCapacity];
                System.arraycopy(this.elements, this.position, tmp, 0, remaining);
                this.elements = tmp;
            }
            this.size = remaining;
            this.position = 0;
        }
        return this.read(input, need) <= 0;
    }

    private int read(InputStream input, int length) throws IOException {
        int n;
        while (length > 0 && (n = input.read(this.elements, this.size, length)) >= 0) {
            this.size += n;
            length -= n;
        }
        return length;
    }

    public void write(OutputStream out) throws IOException {
        if (this.size > 0) {
            out.write(this.elements, 0, this.size);
        }
    }

    public byte get(int index) {
        return this.elements[index];
    }

    public void set(int index, byte element) {
        this.elements[index] = element;
    }

    public int size() {
        return this.size;
    }

    private byte[] subArray(int from, int length, int capacity) {
        byte[] subArray = new byte[capacity];
        System.arraycopy(this.elements, from, subArray, 0, length);
        return subArray;
    }

    public byte[] toArray() {
        return this.subArray(0, this.size, this.size);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(4 * this.size);
        buf.append("[");
        for (int i = 0; i < this.size; ++i) {
            buf.append(this.elements[i]);
            if (i >= this.size - 1) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    private void throwIndex(int index) {
        throw new IndexOutOfBoundsException("index: " + index + ", size: " + this.size);
    }

    public int position() {
        return this.position;
    }

    public void position(int position) {
        this.position = position;
    }

    public int remaining() {
        return this.size - this.position;
    }

    public byte get() {
        return this.elements[this.position++];
    }

    public int getInt() {
        byte b3 = this.elements[this.position + 0];
        byte b2 = this.elements[this.position + 1];
        byte b1 = this.elements[this.position + 2];
        byte b0 = this.elements[this.position + 3];
        this.position += 4;
        return (b3 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b1 & 0xFF) << 8 | (b0 & 0xFF) << 0;
    }

    public short getShort() {
        byte b1 = this.elements[this.position + 0];
        byte b0 = this.elements[this.position + 1];
        this.position += 2;
        return (short)(b1 << 8 | b0 & 0xFF);
    }

    public void setInt(int index, int v) {
        this.elements[index + 0] = (byte)(v >> 24);
        this.elements[index + 1] = (byte)(v >> 16);
        this.elements[index + 2] = (byte)(v >> 8);
        this.elements[index + 3] = (byte)(v >> 0);
    }

    public void addInt(int v) {
        if (this.size + 4 > this.elements.length) {
            this.ensureCapacity(this.size + 4);
        }
        this.elements[this.size + 0] = (byte)(v >> 24);
        this.elements[this.size + 1] = (byte)(v >> 16);
        this.elements[this.size + 2] = (byte)(v >> 8);
        this.elements[this.size + 3] = (byte)(v >> 0);
        this.size += 4;
    }

    public void addShort(short v) {
        if (this.size + 2 > this.elements.length) {
            this.ensureCapacity(this.size + 2);
        }
        this.elements[this.size + 0] = (byte)(v >> 8);
        this.elements[this.size + 1] = (byte)(v >> 0);
        this.size += 2;
    }

    public void remove(int from, int to) {
        this.shrinkOrExpand(from, to, 0);
    }

    private void shrinkOrExpand(int from, int to, int replacementSize) {
        this.checkRange(from, to);
        int diff = replacementSize - (to - from);
        if (diff != 0) {
            this.ensureCapacity(this.size + diff);
            if (this.size - to > 0) {
                System.arraycopy(this.elements, to, this.elements, to + diff, this.size - to);
            }
            this.size += diff;
        }
    }

    private void checkRange(int from, int to) {
        if (from < 0 || from > to || to > this.size) {
            throw new IndexOutOfBoundsException("from: " + from + ", to: " + to + ", size: " + this.size);
        }
    }

    public void swap(ArrayByteList dst) {
        byte[] e = this.elements;
        this.elements = dst.elements;
        dst.elements = e;
        int s = this.size;
        this.size = dst.size;
        dst.size = s;
        int p = this.position;
        this.position = dst.position;
        dst.position = p;
    }

    public void add(Deflater compressor, ArrayByteList src) {
        compressor.reset();
        compressor.setInput(src.asArray(), src.position(), src.remaining());
        int minBufSize = 256;
        this.ensureCapacity(this.size + Math.max(minBufSize, src.remaining() / 3));
        do {
            this.ensureCapacity(this.size + minBufSize);
            this.size += compressor.deflate(this.elements, this.size, this.elements.length - this.size);
        } while (!compressor.needsInput());
        if (!compressor.finished()) {
            compressor.finish();
            while (!compressor.finished()) {
                this.ensureCapacity(this.size + minBufSize);
                this.size += compressor.deflate(this.elements, this.size, this.elements.length - this.size);
            }
        }
        compressor.reset();
    }

    public int add(Inflater decompressor, ArrayByteList src) throws DataFormatException {
        decompressor.reset();
        decompressor.setInput(src.asArray(), src.position(), src.remaining());
        int minBufSize = 256;
        this.ensureCapacity(this.size + Math.max(minBufSize, src.remaining() * 3));
        do {
            this.ensureCapacity(this.size + minBufSize);
            this.size += decompressor.inflate(this.elements, this.size, this.elements.length - this.size);
        } while (!decompressor.finished() && !decompressor.needsDictionary());
        int remaining = decompressor.getRemaining();
        if (remaining > 0) {
            this.ensureCapacity(this.size + remaining);
            int off = src.size() - remaining;
            System.arraycopy(src.asArray(), off, this.elements, this.size, remaining);
            this.size += remaining;
        }
        decompressor.reset();
        return remaining;
    }

    private void addUTF16String(String prefix, String localName) {
        int len = localName.length();
        if (prefix.length() != 0) {
            len += prefix.length() + 1;
        }
        if (len <= 127) {
            this.add((byte)len);
        } else {
            this.add((byte)-1);
            this.addInt(len);
        }
        if (prefix.length() != 0) {
            this.addUTF16String(prefix);
            this.addUTF16String(":");
        }
        this.addUTF16String(localName);
    }

    private void addUTF16String(String str) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            this.add((byte)(c >> 8));
            this.add((byte)(c & 0xFF));
        }
    }

    private String getUTF16String(ArrayCharList buf) {
        buf.clear();
        int len = this.get();
        if (len < 0) {
            len = this.getInt();
        }
        for (int i = 0; i < len; ++i) {
            int b1 = this.get() & 0xFF;
            int b2 = this.get() & 0xFF;
            char c = (char)(b1 << 8 | b2);
            buf.add(c);
        }
        return buf.toString();
    }

    public String[] getUTF16Strings(int count) {
        String[] dst = new String[count];
        ArrayCharList buffer = new ArrayCharList(32);
        byte[] elems = this.elements;
        int off = this.position;
        for (int k = 0; k < count; ++k) {
            dst[k] = this.getUTF16String(buffer);
        }
        return dst;
    }

    public void addUTF8String(String prefix, String localName) {
        if (prefix.length() != 0) {
            this.addUTF8String(prefix);
            this.elements[this.size++] = 58;
        }
        this.addUTF8String(localName);
        this.elements[this.size++] = 0;
    }

    private void addUTF8String(String str) {
        int len = str.length();
        byte[] elems = this.elements;
        int s = this.size;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c < '\u0080') {
                elems[s++] = (byte)c;
                continue;
            }
            if (!UnicodeUtil.isSurrogate(c)) {
                if (c < '\u0800') {
                    elems[s++] = (byte)(0xC0 | c >> 6);
                    elems[s++] = (byte)(0x80 | c >> 0 & 0x3F);
                    continue;
                }
                if (c <= '\uffff') {
                    elems[s++] = (byte)(0xE0 | c >> 12);
                    elems[s++] = (byte)(0x80 | c >> 6 & 0x3F);
                    elems[s++] = (byte)(0x80 | c >> 0 & 0x3F);
                    continue;
                }
            }
            this.size = s;
            i = this.addUTFSurrogate(c, str, i);
            s = this.size;
        }
        this.size = s;
    }

    private int addUTFSurrogate(char c, String str, int i) {
        int uc = 0;
        if (UnicodeUtil.isHighSurrogate(c)) {
            char d;
            if (str.length() - i < 2) {
                ArrayByteList.charCodingException("underflow", str);
            }
            if (!UnicodeUtil.isLowSurrogate(d = str.charAt(++i))) {
                ArrayByteList.charCodingException("malformedForLength(1)", str);
            }
            uc = UnicodeUtil.toUCS4((char)c, d);
        } else {
            if (UnicodeUtil.isLowSurrogate(c)) {
                ArrayByteList.charCodingException("malformedForLength(1)", str);
            }
            uc = c;
        }
        if (uc < 0x200000) {
            this.add((byte)(0xF0 | uc >> 18));
            this.add((byte)(0x80 | uc >> 12 & 0x3F));
            this.add((byte)(0x80 | uc >> 6 & 0x3F));
            this.add((byte)(0x80 | uc >> 0 & 0x3F));
        }
        return i;
    }

    private static void charCodingException(String msg, String str) {
        throw new RuntimeException("CharacterCodingException: " + msg + " for string '" + str + "'");
    }

    private static void charCodingException(String msg, ArrayCharList str) {
        throw new RuntimeException("CharacterCodingException: " + msg + " for string '" + str + "'");
    }

    public String[] getASCIIStrings(int count) {
        String[] dst = new String[count];
        byte[] elems = this.elements;
        int off = this.position;
        for (int k = 0; k < count; ++k) {
            int start = off;
            while (elems[off] != 0) {
                ++off;
            }
            dst[k] = new String(elems, 0, start, off - start);
            ++off;
        }
        this.position = off;
        return dst;
    }

    public String[] getUTF8Strings(int count) {
        String[] dst = new String[count];
        ArrayCharList buffer = new ArrayCharList(32);
        byte[] elems = this.elements;
        int off = this.position;
        for (int k = 0; k < count; ++k) {
            byte b;
            int start = off;
            while ((b = elems[off]) > 0) {
                ++off;
            }
            if (b == 0) {
                dst[k] = new String(elems, 0, start, off - start);
            } else {
                dst[k] = this.getUTF8String(start, off, buffer);
                off = this.position;
            }
            ++off;
        }
        this.position = off;
        return dst;
    }

    private String getUTF8String(int i, int asciiEnd, ArrayCharList buffer) {
        buffer.clear();
        byte[] src = this.elements;
        while (true) {
            byte b1;
            int s = buffer.size();
            int max = i + buffer.capacity() - s - 6;
            char[] dst = buffer.asArray();
            block7: while (i < max && (b1 = src[i]) != 0) {
                switch (b1 >> 4 & 0xF) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        while (i < max && (b1 = src[i]) > 0) {
                            dst[s++] = (char)b1;
                            ++i;
                        }
                        continue block7;
                    }
                    case 12: 
                    case 13: {
                        byte b2 = src[i + 1];
                        if (ArrayByteList.isLast(b2)) {
                            ArrayByteList.charCodingException("malformedForLength(1)", buffer);
                        }
                        dst[s++] = (char)((b1 & 0x1F) << 6 | (b2 & 0x3F) << 0);
                        i += 2;
                        continue block7;
                    }
                    case 14: {
                        byte b3;
                        byte b2 = src[i + 1];
                        if (ArrayByteList.isLast(b2)) {
                            ArrayByteList.charCodingException("malformedForLength(1)", buffer);
                        }
                        if (ArrayByteList.isLast(b3 = src[i + 2])) {
                            ArrayByteList.charCodingException("malformedForLength(2)", buffer);
                        }
                        dst[s++] = (char)((b1 & 0xF) << 12 | (b2 & 0x3F) << 6 | (b3 & 0x3F) << 0);
                        i += 3;
                        continue block7;
                    }
                    case 15: {
                        buffer.setSize(s);
                        i = this.getUTF8String456(i, buffer);
                        s = buffer.size();
                        continue block7;
                    }
                }
                ArrayByteList.charCodingException("malformedForLength(1)", buffer);
            }
            buffer.setSize(s);
            if (i < max) break;
            buffer.ensureCapacity(buffer.capacity() << 1);
        }
        this.position = i;
        return buffer.toString();
    }

    private int getUTF8String456(int i, ArrayCharList buffer) {
        byte[] elems = this.elements;
        byte b1 = elems[i];
        int uc = 0;
        int n = 0;
        switch (b1 & 0xF) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                byte b4;
                byte b3;
                byte b2 = elems[i + 1];
                if (ArrayByteList.isLast(b2)) {
                    ArrayByteList.charCodingException("malformedForLength(1)", buffer);
                }
                if (ArrayByteList.isLast(b3 = elems[i + 2])) {
                    ArrayByteList.charCodingException("malformedForLength(2)", buffer);
                }
                if (ArrayByteList.isLast(b4 = elems[i + 3])) {
                    ArrayByteList.charCodingException("malformedForLength(3)", buffer);
                }
                uc = (b1 & 7) << 18 | (b2 & 0x3F) << 12 | (b3 & 0x3F) << 6 | (b4 & 0x3F) << 0;
                n = 4;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                byte b5;
                byte b4;
                byte b3;
                byte b2 = elems[i + 1];
                if (ArrayByteList.isLast(b2)) {
                    ArrayByteList.charCodingException("malformedForLength(1)", buffer);
                }
                if (ArrayByteList.isLast(b3 = elems[i + 2])) {
                    ArrayByteList.charCodingException("malformedForLength(2)", buffer);
                }
                if (ArrayByteList.isLast(b4 = elems[i + 3])) {
                    ArrayByteList.charCodingException("malformedForLength(3)", buffer);
                }
                if (ArrayByteList.isLast(b5 = elems[i + 4])) {
                    ArrayByteList.charCodingException("malformedForLength(4)", buffer);
                }
                uc = (b1 & 3) << 24 | (b2 & 0x3F) << 18 | (b3 & 0x3F) << 12 | (b4 & 0x3F) << 6 | (b5 & 0x3F) << 0;
                n = 5;
                break;
            }
            case 12: 
            case 13: {
                byte b6;
                byte b5;
                byte b4;
                byte b3;
                byte b2 = elems[i + 1];
                if (ArrayByteList.isLast(b2)) {
                    ArrayByteList.charCodingException("malformedForLength(1)", buffer);
                }
                if (ArrayByteList.isLast(b3 = elems[i + 2])) {
                    ArrayByteList.charCodingException("malformedForLength(2)", buffer);
                }
                if (ArrayByteList.isLast(b4 = elems[i + 3])) {
                    ArrayByteList.charCodingException("malformedForLength(3)", buffer);
                }
                if (ArrayByteList.isLast(b5 = elems[i + 4])) {
                    ArrayByteList.charCodingException("malformedForLength(4)", buffer);
                }
                if (ArrayByteList.isLast(b6 = elems[i + 5])) {
                    ArrayByteList.charCodingException("malformedForLength(5)", buffer);
                }
                uc = (b1 & 1) << 30 | (b2 & 0x3F) << 24 | (b3 & 0x3F) << 18 | (b4 & 0x3F) << 12 | (b5 & 0x3F) << 6 | b6 & 0x3F;
                n = 6;
                break;
            }
            default: {
                ArrayByteList.charCodingException("malformedForLength(1)", buffer);
            }
        }
        ArrayByteList.addSurrogate(uc, n, buffer);
        return i += n;
    }

    private static boolean isLast(int v) {
        return false;
    }

    private static void addSurrogate(int uc, int len, ArrayCharList dst) {
        if (uc <= 65535) {
            if (UnicodeUtil.isSurrogate(uc)) {
                ArrayByteList.charCodingException("malformedForLength(len)", dst);
            }
            dst.add((char)uc);
            return;
        }
        if (uc < 65536) {
            ArrayByteList.charCodingException("malformedForLength(len)", dst);
        }
        if (uc <= 0x10FFFF) {
            dst.add(UnicodeUtil.highSurrogate(uc));
            dst.add(UnicodeUtil.lowSurrogate(uc));
            return;
        }
        ArrayByteList.charCodingException("unmappableForLength(len)", dst);
    }
}

