/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.pool;

import java.io.IOException;
import nu.xom.Attribute;
import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.NodeFactory;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;
import nux.xom.binary.NodeBuilder;
import nux.xom.io.StreamingSerializer;

public class XOMUtil {
    private XOMUtil() {
    }

    public static NodeFactory getIgnoreWhitespaceOnlyTextNodeFactory() {
        return new NodeFactory(){
            private final Nodes NONE = new Nodes();

            public Nodes makeText(String text) {
                return Normalizer.isWhitespaceOnly(text) ? this.NONE : super.makeText(text);
            }
        };
    }

    public static NodeFactory getRedirectingNodeFactory(final StreamingSerializer serializer) {
        if (serializer == null) {
            throw new IllegalArgumentException("Streaming serializer must not be null");
        }
        return new NodeFactory(){
            private Element buffer = null;
            private final Nodes NONE = new Nodes();
            private final NodeBuilder nodeBuilder = new NodeBuilder();

            public Nodes makeAttribute(String name, String namespace, String value, Attribute.Type type) {
                this.buffer.addAttribute(this.nodeBuilder.createAttribute(name, namespace, value, type));
                return this.NONE;
            }

            public Nodes makeComment(String data) {
                this.flush();
                try {
                    serializer.write(new Comment(data));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return this.NONE;
            }

            public Nodes makeDocType(String rootElementName, String publicID, String systemID) {
                this.flush();
                try {
                    serializer.write(new DocType(rootElementName, publicID, systemID));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return this.NONE;
            }

            public Nodes makeProcessingInstruction(String target, String data) {
                this.flush();
                try {
                    serializer.write(new ProcessingInstruction(target, data));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return this.NONE;
            }

            public Nodes makeText(String text) {
                this.flush();
                try {
                    serializer.write(new Text(text));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return this.NONE;
            }

            public Element startMakingElement(String name, String namespace) {
                this.flush();
                this.buffer = this.nodeBuilder.createElement(name, namespace);
                return this.buffer;
            }

            public Nodes finishMakingElement(Element element) {
                this.flush();
                try {
                    serializer.writeEndTag();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (element.getParent() instanceof Document) {
                    return new Nodes((Node)element);
                }
                return this.NONE;
            }

            public Document startMakingDocument() {
                this.buffer = null;
                try {
                    serializer.writeXMLDeclaration();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return new Document(new Element("dummy"));
            }

            public void finishMakingDocument(Document document) {
                this.buffer = null;
                try {
                    serializer.writeEndDocument();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            private void flush() {
                if (this.buffer != null) {
                    try {
                        serializer.writeStartTag(this.buffer);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    this.buffer = null;
                }
            }
        };
    }

    public static class Normalizer {
        public static final Normalizer PRESERVE = new Normalizer();
        public static final Normalizer REPLACE = new ReplaceNormalizer();
        public static final Normalizer COLLAPSE = new CollapseNormalizer();
        public static final Normalizer TRIM = new TrimNormalizer();
        public static final Normalizer STRIP = new StripNormalizer();

        private Normalizer() {
        }

        String normalizeWhitespace(String str) {
            return str;
        }

        public final void normalize(ParentNode node) {
            int i = node.getChildCount();
            while (--i >= 0) {
                Node child = node.getChild(i);
                if (child instanceof Element) {
                    this.normalize((ParentNode)((Element)child));
                    continue;
                }
                if (!(child instanceof Text)) continue;
                int j = i;
                while (--i >= 0 && node.getChild(i) instanceof Text) {
                }
                if (j != ++i) {
                    this.merge(node, i, j);
                    continue;
                }
                String value = child.getValue();
                String norm = this.normalizeWhitespace(value);
                if (norm.length() == 0) {
                    node.removeChild(i);
                    continue;
                }
                if (norm.equals(value)) continue;
                ((Text)child).setValue(norm);
            }
        }

        private void merge(ParentNode node, int i, int j) {
            int k = i;
            StringBuffer buf = new StringBuffer(node.getChild(k++).getValue());
            while (k <= j) {
                buf.append(node.getChild(k++).getValue());
            }
            k = j;
            while (k >= i) {
                node.removeChild(k--);
            }
            String norm = this.normalizeWhitespace(buf.toString());
            if (norm.length() > 0) {
                node.insertChild((Node)new Text(norm), i);
            }
        }

        private static boolean isWhitespace(char c) {
            switch (c) {
                case '\t': {
                    return true;
                }
                case '\n': {
                    return true;
                }
                case '\r': {
                    return true;
                }
                case ' ': {
                    return true;
                }
            }
            return false;
        }

        private static boolean isWhitespaceOnly(String str) {
            int i = str.length();
            while (--i >= 0) {
                if (Normalizer.isWhitespace(str.charAt(i))) continue;
                return false;
            }
            return true;
        }

        private static String trim(String str) {
            int i;
            int j = str.length();
            for (i = 0; i < j && Normalizer.isWhitespace(str.charAt(i)); ++i) {
            }
            while (i < j && Normalizer.isWhitespace(str.charAt(j - 1))) {
                --j;
            }
            return i > 0 || j < str.length() ? str.substring(i, j) : str;
        }

        private static final class CollapseNormalizer
        extends Normalizer {
            private CollapseNormalizer() {
            }

            @Override
            String normalizeWhitespace(String str) {
                int len = str.length();
                StringBuffer buf = new StringBuffer(len);
                boolean modified = false;
                for (int i = 0; i < len; ++i) {
                    int c = str.charAt(i);
                    if (Normalizer.isWhitespace((char)c)) {
                        int j = i;
                        while (++i < len && Normalizer.isWhitespace(str.charAt(i))) {
                        }
                        if (!(modified || c == 32 && j == --i)) {
                            modified = true;
                        }
                        c = 32;
                    }
                    buf.append((char)c);
                }
                len = buf.length();
                if (len > 0 && buf.charAt(len - 1) == ' ') {
                    buf.deleteCharAt(len - 1);
                    modified = true;
                }
                if (buf.length() > 0 && buf.charAt(0) == ' ') {
                    buf.deleteCharAt(0);
                    modified = true;
                }
                return modified ? buf.toString() : str;
            }
        }

        private static final class ReplaceNormalizer
        extends Normalizer {
            private ReplaceNormalizer() {
            }

            @Override
            String normalizeWhitespace(String str) {
                int len = str.length();
                StringBuffer buf = new StringBuffer(len);
                boolean modified = false;
                for (int i = 0; i < len; ++i) {
                    int c = str.charAt(i);
                    if (c != 32 && Normalizer.isWhitespace((char)c)) {
                        c = 32;
                        modified = true;
                    }
                    buf.append((char)c);
                }
                return modified ? buf.toString() : str;
            }
        }

        private static final class StripNormalizer
        extends Normalizer {
            private StripNormalizer() {
            }

            @Override
            String normalizeWhitespace(String str) {
                return Normalizer.isWhitespaceOnly(str) ? "" : str;
            }
        }

        private static final class TrimNormalizer
        extends Normalizer {
            private TrimNormalizer() {
            }

            @Override
            String normalizeWhitespace(String str) {
                return Normalizer.trim(str);
            }
        }
    }
}

