/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.ftp;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.spi.InvalidPropertyException;
import org.apache.commons.net.ftp.FTPClient;
import org.jboss.vfs.VFS;
import org.jboss.vfs.spi.FileSystem;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.file.VirtualFile;
import org.teiid.file.VirtualFileConnection;
import org.teiid.resource.adapter.ftp.FtpFileSystem;
import org.teiid.resource.spi.BasicConnection;
import org.teiid.translator.TranslatorException;

public class FtpFileConnectionImpl
extends BasicConnection
implements VirtualFileConnection {
    public static final BundleUtil UTIL = BundleUtil.getBundleUtil(FtpFileConnectionImpl.class);
    private org.jboss.vfs.VirtualFile mountPoint;
    private Map<String, String> fileMapping;
    private Closeable closeable;
    private final FTPClient client;

    public FtpFileConnectionImpl(FTPClient client, String pathname, Map<String, String> fileMapping) throws ResourceException {
        this.client = client;
        this.fileMapping = fileMapping == null ? Collections.emptyMap() : fileMapping;
        try {
            if (this.client.cwd(pathname) != 250) {
                throw new InvalidPropertyException(UTIL.getString("parentdirectory_not_set"));
            }
            this.client.changeWorkingDirectory(pathname);
            this.mountPoint = VFS.getChild((String)pathname);
            this.closeable = VFS.mount((org.jboss.vfs.VirtualFile)this.mountPoint, (FileSystem)new FtpFileSystem(this.client));
        }
        catch (IOException e) {
            throw new ResourceException(UTIL.getString("vfs_mount_error", new Object[]{pathname}), (Throwable)e);
        }
    }

    public void close() throws ResourceException {
        try {
            this.closeable.close();
        }
        catch (IOException e) {
            throw new ResourceException((Throwable)e);
        }
    }

    public VirtualFile[] getFiles(String pattern) {
        org.jboss.vfs.VirtualFile file = this.getFile(pattern);
        if (file.exists()) {
            return new VirtualFile[]{new JBossVirtualFile(file)};
        }
        return null;
    }

    public org.jboss.vfs.VirtualFile getFile(String path) {
        if (path == null) {
            return this.mountPoint;
        }
        String altPath = this.fileMapping.get(path);
        if (altPath != null) {
            path = altPath;
        }
        return this.mountPoint.getChild(path);
    }

    public void add(InputStream in, String path) throws TranslatorException {
        try {
            this.client.storeFile(path, in);
        }
        catch (IOException e) {
            throw new TranslatorException((Throwable)e, UTIL.getString("ftp_failed_write", new Object[]{path, this.client.getReplyString()}));
        }
    }

    public boolean remove(String path) {
        return this.mountPoint.getChild(path).delete();
    }

    static class JBossVirtualFile
    implements VirtualFile {
        private org.jboss.vfs.VirtualFile file;

        public JBossVirtualFile(org.jboss.vfs.VirtualFile file) {
            this.file = file;
        }

        public String getName() {
            return this.file.getName();
        }

        public InputStreamFactory createInputStreamFactory() {
            return new InputStreamFactory(){

                public InputStream getInputStream() throws IOException {
                    return file.openStream();
                }
            };
        }

        public InputStream openInputStream(boolean lock) throws IOException {
            return this.file.openStream();
        }

        public OutputStream openOutputStream(boolean lock) throws IOException {
            throw new IOException("not supported");
        }

        public long getLastModified() {
            return this.file.getLastModified();
        }

        public long getCreationTime() {
            return this.file.getLastModified();
        }

        public long getSize() {
            return this.file.getSize();
        }
    }
}

