/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.ftp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import java.util.Map;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import javax.resource.ResourceException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.FTPSClient;
import org.apache.commons.net.util.KeyManagerUtils;
import org.apache.commons.net.util.TrustManagerUtils;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.Assertion;
import org.teiid.core.util.StringUtil;
import org.teiid.resource.adapter.ftp.FtpFileConnectionImpl;
import org.teiid.resource.spi.BasicConnectionFactory;
import org.teiid.resource.spi.BasicManagedConnectionFactory;

public class FtpManagedConnectionFactory
extends BasicManagedConnectionFactory {
    private static final long serialVersionUID = -687763504336137294L;
    public static final BundleUtil UTIL = BundleUtil.getBundleUtil(FtpManagedConnectionFactory.class);
    private String parentDirectory;
    private String fileMapping;
    protected FTPClientConfig config;
    protected String username;
    protected String host;
    protected String password;
    protected Integer port = 21;
    protected Integer bufferSize = 2048;
    protected Integer clientMode = 0;
    protected Integer fileType = 2;
    protected String controlEncoding = "ISO-8859-1";
    private Integer connectTimeout;
    private Integer defaultTimeout;
    private Integer dataTimeout;
    private Boolean isFtps = false;
    private Boolean useClientMode;
    private Boolean sessionCreation;
    private String authValue;
    private String certificate;
    private TrustManager trustManager;
    private String[] cipherSuites;
    private String[] protocols;
    private String keyPath;
    private String keyPassword;
    private KeyManager keyManager;
    private Boolean needClientAuth;
    private Boolean wantsClientAuth;
    private Boolean implicit = false;
    private String execProt = "P";
    private String protocol;

    public FTPClientConfig getConfig() {
        return this.config;
    }

    public String getParentDirectory() {
        return this.parentDirectory;
    }

    public void setParentDirectory(String parentDirectory) {
        Assertion.isNotNull((Object)parentDirectory, (String)UTIL.getString("parentdirectory_not_null"));
        this.parentDirectory = parentDirectory;
    }

    public String getFileMapping() {
        return this.fileMapping;
    }

    public void setFileMapping(String fileMapping) {
        this.fileMapping = fileMapping;
    }

    public void setConfig(FTPClientConfig config) {
        Assertion.isNotNull((Object)config, (String)UTIL.getString("ftp_client_config"));
        this.config = config;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        Assertion.isNotNull((Object)username, (String)UTIL.getString("ftp_client_username"));
        this.username = username;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        Assertion.assertTrue((host != null && host.length() > 0 ? 1 : 0) != 0, (String)UTIL.getString("ftp_client_host"));
        this.host = host;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        Assertion.isNotNull((Object)password, (String)UTIL.getString("ftp_client_password"));
        this.password = password;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        Assertion.assertTrue((port > 0 ? 1 : 0) != 0, (String)UTIL.getString("ftp_client_port"));
        this.port = port;
    }

    public Integer getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(Integer bufferSize) {
        this.bufferSize = bufferSize;
    }

    public Integer getClientMode() {
        return this.clientMode;
    }

    public void setClientMode(Integer clientMode) {
        Assertion.assertTrue((clientMode == 0 || clientMode == 2 ? 1 : 0) != 0, (String)UTIL.getString("ftp_client_clientMode", new Object[]{clientMode}));
        this.clientMode = clientMode;
    }

    public Integer getFileType() {
        return this.fileType;
    }

    public void setFileType(Integer fileType) {
        Assertion.assertTrue((fileType == 0 || fileType == 1 || fileType == 2 || fileType == 3 ? 1 : 0) != 0);
        this.fileType = fileType;
    }

    public String getControlEncoding() {
        return this.controlEncoding;
    }

    public void setControlEncoding(String controlEncoding) {
        Assertion.isNotNull((Object)controlEncoding);
        this.controlEncoding = controlEncoding;
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Integer getDefaultTimeout() {
        return this.defaultTimeout;
    }

    public void setDefaultTimeout(Integer defaultTimeout) {
        this.defaultTimeout = defaultTimeout;
    }

    public Integer getDataTimeout() {
        return this.dataTimeout;
    }

    public void setDataTimeout(Integer dataTimeout) {
        this.dataTimeout = dataTimeout;
    }

    public Boolean getIsFtps() {
        return this.isFtps;
    }

    public void setIsFtps(Boolean isFtps) {
        this.isFtps = isFtps;
    }

    public Boolean getUseClientMode() {
        return this.useClientMode;
    }

    public void setUseClientMode(Boolean useClientMode) {
        this.useClientMode = useClientMode;
    }

    public Boolean getSessionCreation() {
        return this.sessionCreation;
    }

    public void setSessionCreation(Boolean sessionCreation) {
        this.sessionCreation = sessionCreation;
    }

    public String getAuthValue() {
        return this.authValue;
    }

    public void setAuthValue(String authValue) {
        Assertion.isNotNull((Object)authValue);
        this.authValue = authValue;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public void setCertificate(String certificate) {
        this.certificate = certificate;
        if (this.certificate != null && Files.exists(Paths.get(this.certificate, new String[0]), new LinkOption[0])) {
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                InputStream in = Files.newInputStream(Paths.get(this.certificate, new String[0]), new OpenOption[0]);
                Certificate cert = certificateFactory.generateCertificate(in);
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(null);
                keyStore.setCertificateEntry("alias", cert);
                this.trustManager = TrustManagerUtils.getDefaultTrustManager((KeyStore)keyStore);
            }
            catch (IOException | GeneralSecurityException e) {
                throw new TeiidRuntimeException(UTIL.getString("ftp_certificate_path", new Object[]{certificate, e}));
            }
        }
    }

    public String getCipherSuites() {
        return this.formStringFromArray(this.cipherSuites);
    }

    private String formStringFromArray(String[] cipherSuites) {
        String result = "";
        for (String str : cipherSuites) {
            result = result + str + ",";
        }
        return result.substring(0, result.length() - 1);
    }

    public void setCipherSuites(String cipherSuites) {
        Assertion.assertTrue((cipherSuites != null && cipherSuites.length() > 0 ? 1 : 0) != 0, (String)UTIL.getString("ftp_client_invalid_array", new Object[]{cipherSuites, "cipherSuites"}));
        this.cipherSuites = cipherSuites.split(",");
    }

    public String getProtocols() {
        return this.formStringFromArray(this.protocols);
    }

    public void setProtocols(String protocols) {
        Assertion.assertTrue((protocols != null && protocols.length() > 0 ? 1 : 0) != 0, (String)UTIL.getString("ftp_client_invalid_array", new Object[]{protocols, "protocols"}));
        this.protocols = protocols.split(",");
    }

    public String getKeyPath() {
        return this.keyPath;
    }

    public void setKeyPath(String keyPath) {
        this.keyPath = keyPath;
        if (this.keyPath != null && Files.exists(Paths.get(this.keyPath, new String[0]), new LinkOption[0])) {
            if (this.keyPassword == null) {
                this.keyPassword = "";
            }
            try {
                this.keyManager = KeyManagerUtils.createClientKeyManager((File)Paths.get(this.keyPath, new String[0]).toFile(), (String)this.keyPassword);
            }
            catch (IOException | GeneralSecurityException e) {
                throw new TeiidRuntimeException(UTIL.getString("ftp_ketstore_path", new Object[]{this.keyPath, e}));
            }
        }
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public Boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public void setNeedClientAuth(Boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    public Boolean getWantsClientAuth() {
        return this.wantsClientAuth;
    }

    public void setWantsClientAuth(Boolean wantsClientAuth) {
        this.wantsClientAuth = wantsClientAuth;
    }

    public Boolean isImplicit() {
        return this.implicit;
    }

    public void setImplicit(Boolean implicit) {
        this.implicit = implicit;
    }

    public String getExecProt() {
        return this.execProt;
    }

    public void setExecProt(String execProt) {
        this.execProt = execProt;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        Assertion.assertTrue((protocol != null && protocol.length() > 0 && !protocol.contains(" ") ? 1 : 0) != 0);
        this.protocol = protocol;
    }

    public BasicConnectionFactory<FtpFileConnectionImpl> createConnectionFactory() throws ResourceException {
        final Map map = (Map)StringUtil.valueOf((String)this.fileMapping, Map.class);
        return new BasicConnectionFactory<FtpFileConnectionImpl>(){

            public FtpFileConnectionImpl getConnection() throws ResourceException {
                try {
                    return new FtpFileConnectionImpl(FtpManagedConnectionFactory.this.createClient(), FtpManagedConnectionFactory.this.parentDirectory, map);
                }
                catch (IOException e) {
                    throw new ResourceException((Throwable)e);
                }
            }
        };
    }

    protected FTPClient createClient() throws IOException, ResourceException {
        FTPClient client = this.createClientInstance();
        this.beforeConnectProcessing(client);
        client.connect(this.host, this.port.intValue());
        if (!FTPReply.isPositiveCompletion((int)client.getReplyCode())) {
            throw new ResourceException(UTIL.getString("ftp_connect_failed", new Object[]{this.host, this.port}));
        }
        if (!client.login(this.username, this.password)) {
            throw new IllegalStateException(UTIL.getString("ftp_login_failed", new Object[]{client.getReplyString()}));
        }
        this.afterConnectProcessing(client);
        return client;
    }

    private FTPClient createClientInstance() {
        if (this.isFtps.booleanValue()) {
            if (this.getProtocol() != null) {
                return new FTPSClient(this.protocol, this.implicit.booleanValue());
            }
            return new FTPSClient(this.implicit.booleanValue());
        }
        return new FTPClient();
    }

    private void beforeConnectProcessing(FTPClient client) throws IOException {
        client.configure(this.config);
        if (this.connectTimeout != null) {
            client.setConnectTimeout(this.connectTimeout.intValue());
        }
        if (this.defaultTimeout != null) {
            client.setDefaultTimeout(this.defaultTimeout.intValue());
        }
        if (this.dataTimeout != null) {
            client.setDataTimeout(this.dataTimeout.intValue());
        }
        client.setControlEncoding(this.controlEncoding);
        if (this.isFtps.booleanValue()) {
            FTPSClient ftpsClient = (FTPSClient)client;
            ftpsClient.execPBSZ(0L);
            ftpsClient.execPROT(this.execProt);
        }
    }

    private void afterConnectProcessing(FTPClient client) throws IOException {
        if (this.parentDirectory == null) {
            throw new IOException(UTIL.getString("parentdirectory_not_set"));
        }
        if (!client.changeWorkingDirectory(this.getParentDirectory())) {
            throw new IOException(UTIL.getString("ftp_dir_not_exist", new Object[]{this.getParentDirectory()}));
        }
        this.updateClientMode(client);
        client.setFileType(this.fileType.intValue());
        client.setBufferSize(this.bufferSize.intValue());
        if (this.isFtps.booleanValue()) {
            FTPSClient ftpsClient = (FTPSClient)client;
            if (this.getAuthValue() != null) {
                ftpsClient.setAuthValue(this.authValue);
            }
            if (this.trustManager != null) {
                ftpsClient.setTrustManager(this.trustManager);
            }
            if (this.cipherSuites != null) {
                ftpsClient.setEnabledCipherSuites(this.cipherSuites);
            }
            if (this.protocols != null) {
                ftpsClient.setEnabledProtocols(this.protocols);
            }
            if (this.sessionCreation != null) {
                ftpsClient.setEnabledSessionCreation(this.sessionCreation.booleanValue());
            }
            if (this.useClientMode != null) {
                ftpsClient.setUseClientMode(this.useClientMode.booleanValue());
            }
            if (this.sessionCreation != null) {
                ftpsClient.setEnabledSessionCreation(this.sessionCreation.booleanValue());
            }
            if (this.keyManager != null) {
                ftpsClient.setKeyManager(this.keyManager);
            }
            if (this.needClientAuth != null) {
                ftpsClient.setNeedClientAuth(this.needClientAuth.booleanValue());
            }
            if (this.wantsClientAuth != null) {
                ftpsClient.setWantClientAuth(this.wantsClientAuth.booleanValue());
            }
        }
    }

    private void updateClientMode(FTPClient client) {
        switch (this.clientMode) {
            case 0: {
                client.enterLocalActiveMode();
                break;
            }
            case 2: {
                client.enterLocalPassiveMode();
                break;
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.parentDirectory == null ? 0 : this.parentDirectory.hashCode());
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.controlEncoding == null ? 0 : this.controlEncoding.hashCode());
        result = 31 * result + (this.connectTimeout == null ? 0 : this.connectTimeout.hashCode());
        result = 31 * result + (this.dataTimeout == null ? 0 : this.dataTimeout.hashCode());
        result = 31 * result + (this.defaultTimeout == null ? 0 : this.defaultTimeout.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + this.fileType;
        result = 31 * result + this.clientMode;
        result = 31 * result + this.bufferSize;
        if (this.isFtps.booleanValue()) {
            result = 31 * result + (this.certificate == null ? 0 : this.certificate.hashCode());
            result = 31 * result + (this.keyPath == null ? 0 : this.keyPath.hashCode());
            result = 31 * result + (this.keyPassword == null ? 0 : this.keyPassword.hashCode());
            result = 31 * result + (this.authValue == null ? 0 : this.authValue.hashCode());
            result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
            result = 31 * result + (this.execProt == null ? 0 : this.execProt.hashCode());
            result = 31 * result + (this.useClientMode == null ? 0 : this.useClientMode.hashCode());
            result = 31 * result + (this.sessionCreation == null ? 0 : this.sessionCreation.hashCode());
            result = 31 * result + (this.needClientAuth == null ? 0 : this.needClientAuth.hashCode());
            result = 31 * result + (this.wantsClientAuth == null ? 0 : this.wantsClientAuth.hashCode());
            result = 31 * result + (this.implicit != false ? 1231 : 1237);
            result = 31 * result + (this.cipherSuites == null ? 0 : Arrays.hashCode(this.cipherSuites));
            result = 31 * result + (this.protocols == null ? 0 : Arrays.hashCode(this.protocols));
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        FtpManagedConnectionFactory other = (FtpManagedConnectionFactory)((Object)obj);
        if (!FtpManagedConnectionFactory.checkEquals((Object)this.parentDirectory, (Object)other.parentDirectory)) {
            return false;
        }
        if (!FtpManagedConnectionFactory.checkEquals((Object)this.username, (Object)other.username)) {
            return false;
        }
        if (!FtpManagedConnectionFactory.checkEquals((Object)this.password, (Object)other.password)) {
            return false;
        }
        if (!FtpManagedConnectionFactory.checkEquals((Object)this.host, (Object)other.host)) {
            return false;
        }
        if (!FtpManagedConnectionFactory.checkEquals((Object)this.controlEncoding, (Object)other.controlEncoding)) {
            return false;
        }
        if (this.connectTimeout != other.connectTimeout) {
            return false;
        }
        if (this.dataTimeout != other.dataTimeout) {
            return false;
        }
        if (this.defaultTimeout != other.defaultTimeout) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        if (this.fileType != other.fileType) {
            return false;
        }
        if (this.clientMode != other.clientMode) {
            return false;
        }
        if (this.bufferSize != other.bufferSize) {
            return false;
        }
        if (this.isFtps.booleanValue()) {
            if (!FtpManagedConnectionFactory.checkEquals((Object)this.certificate, (Object)other.certificate)) {
                return false;
            }
            if (!FtpManagedConnectionFactory.checkEquals((Object)this.keyPath, (Object)other.keyPath)) {
                return false;
            }
            if (!FtpManagedConnectionFactory.checkEquals((Object)this.keyPassword, (Object)other.keyPassword)) {
                return false;
            }
            if (!FtpManagedConnectionFactory.checkEquals((Object)this.authValue, (Object)other.authValue)) {
                return false;
            }
            if (!FtpManagedConnectionFactory.checkEquals((Object)this.protocol, (Object)other.protocol)) {
                return false;
            }
            if (!FtpManagedConnectionFactory.checkEquals((Object)this.execProt, (Object)other.execProt)) {
                return false;
            }
            if (!this.useClientMode.equals(other.useClientMode)) {
                return false;
            }
            if (!this.sessionCreation.equals(other.sessionCreation)) {
                return false;
            }
            if (!this.needClientAuth.equals(other.needClientAuth)) {
                return false;
            }
            if (!this.wantsClientAuth.equals(other.wantsClientAuth)) {
                return false;
            }
            if (this.implicit != other.implicit) {
                return false;
            }
            if (!Arrays.equals(this.cipherSuites, other.cipherSuites)) {
                return false;
            }
            if (!Arrays.equals(this.protocols, other.protocols)) {
                return false;
            }
        }
        return true;
    }
}

