/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.common;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.olingo.commons.api.edm.geo.Geospatial;
import org.apache.olingo.commons.api.edm.geo.GeospatialCollection;
import org.apache.olingo.commons.api.edm.geo.LineString;
import org.apache.olingo.commons.api.edm.geo.MultiLineString;
import org.apache.olingo.commons.api.edm.geo.MultiPolygon;
import org.apache.olingo.commons.api.edm.geo.Polygon;
import org.apache.olingo.commons.api.edm.geo.SRID;

class JTS2OlingoBridge {
    private Geospatial.Dimension dimension;
    private SRID srid;

    public JTS2OlingoBridge(Geospatial.Dimension dimension, SRID srid) {
        this.dimension = dimension;
        this.srid = srid;
    }

    public Geospatial convert(Geometry geometry) {
        if (geometry instanceof Point) {
            Point point = (Point)geometry;
            org.apache.olingo.commons.api.edm.geo.Point result = new org.apache.olingo.commons.api.edm.geo.Point(this.dimension, this.srid);
            result.setX(point.getX());
            result.setY(point.getY());
            return result;
        }
        if (geometry instanceof com.vividsolutions.jts.geom.LineString) {
            com.vividsolutions.jts.geom.LineString lineString = (com.vividsolutions.jts.geom.LineString)geometry;
            ArrayList<org.apache.olingo.commons.api.edm.geo.Point> points = this.convertLineStringToPoints(lineString.getCoordinates());
            LineString result = new LineString(this.dimension, this.srid, points);
            return result;
        }
        if (geometry instanceof com.vividsolutions.jts.geom.Polygon) {
            com.vividsolutions.jts.geom.Polygon polygon = (com.vividsolutions.jts.geom.Polygon)geometry;
            return this.convertPolygon(polygon);
        }
        if (geometry instanceof MultiPoint) {
            MultiPoint multipoint = (MultiPoint)geometry;
            ArrayList<org.apache.olingo.commons.api.edm.geo.Point> points = this.convertLineStringToPoints(multipoint.getCoordinates());
            org.apache.olingo.commons.api.edm.geo.MultiPoint result = new org.apache.olingo.commons.api.edm.geo.MultiPoint(this.dimension, this.srid, points);
            return result;
        }
        if (geometry instanceof com.vividsolutions.jts.geom.MultiLineString) {
            com.vividsolutions.jts.geom.MultiLineString multiLineString = (com.vividsolutions.jts.geom.MultiLineString)geometry;
            ArrayList<LineString> lineStrings = new ArrayList<LineString>(multiLineString.getNumGeometries());
            for (int i = 0; i < multiLineString.getNumGeometries(); ++i) {
                com.vividsolutions.jts.geom.LineString lineString = (com.vividsolutions.jts.geom.LineString)multiLineString.getGeometryN(i);
                lineStrings.add(new LineString(this.dimension, this.srid, this.convertLineStringToPoints(lineString.getCoordinates())));
            }
            MultiLineString result = new MultiLineString(this.dimension, this.srid, lineStrings);
            return result;
        }
        if (geometry instanceof com.vividsolutions.jts.geom.MultiPolygon) {
            com.vividsolutions.jts.geom.MultiPolygon multiPolygon = (com.vividsolutions.jts.geom.MultiPolygon)geometry;
            ArrayList<Polygon> polygons = new ArrayList<Polygon>(multiPolygon.getNumGeometries());
            for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
                com.vividsolutions.jts.geom.Polygon polygon = (com.vividsolutions.jts.geom.Polygon)multiPolygon.getGeometryN(i);
                polygons.add(this.convertPolygon(polygon));
            }
            MultiPolygon result = new MultiPolygon(this.dimension, this.srid, polygons);
            return result;
        }
        if (geometry instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry;
            ArrayList<Geospatial> geometries = new ArrayList<Geospatial>(geometryCollection.getNumGeometries());
            for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
                Geometry geo = geometryCollection.getGeometryN(i);
                geometries.add(this.convert(geo));
            }
            GeospatialCollection result = new GeospatialCollection(this.dimension, this.srid, geometries);
            return result;
        }
        throw new AssertionError(geometry.getClass());
    }

    private Polygon convertPolygon(com.vividsolutions.jts.geom.Polygon polygon) throws AssertionError {
        if (polygon.getNumInteriorRing() > 1) {
            throw new AssertionError((Object)"Polygons with more than 1 interior rings are not supported by olingo");
        }
        List interior = Collections.emptyList();
        if (polygon.getNumInteriorRing() == 1) {
            interior = this.convertLineStringToPoints(polygon.getInteriorRingN(1).getCoordinates());
        }
        ArrayList<org.apache.olingo.commons.api.edm.geo.Point> exterior = this.convertLineStringToPoints(polygon.getExteriorRing().getCoordinates());
        return new Polygon(this.dimension, this.srid, interior, exterior);
    }

    private ArrayList<org.apache.olingo.commons.api.edm.geo.Point> convertLineStringToPoints(Coordinate[] lineString) {
        ArrayList<org.apache.olingo.commons.api.edm.geo.Point> points = new ArrayList<org.apache.olingo.commons.api.edm.geo.Point>(lineString.length);
        for (Coordinate c : lineString) {
            org.apache.olingo.commons.api.edm.geo.Point p = new org.apache.olingo.commons.api.edm.geo.Point(this.dimension, this.srid);
            p.setX(c.x);
            p.setY(c.y);
        }
        return points;
    }
}

