/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.common;

import com.vividsolutions.jts.geom.Geometry;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.olingo.commons.api.edm.EdmParameter;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.geo.Geospatial;
import org.apache.olingo.commons.api.edm.geo.SRID;
import org.apache.olingo.commons.core.edm.primitivetype.EdmBinary;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDate;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDecimal;
import org.apache.olingo.commons.core.edm.primitivetype.EdmPrimitiveTypeFactory;
import org.apache.olingo.commons.core.edm.primitivetype.EdmStream;
import org.apache.olingo.commons.core.edm.primitivetype.EdmString;
import org.apache.olingo.commons.core.edm.primitivetype.EdmTimeOfDay;
import org.apache.olingo.commons.core.edm.primitivetype.SingletonPrimitiveType;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.AbstractGeospatialType;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.GeometryType;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.Transform;
import org.teiid.core.types.TransformationException;
import org.teiid.core.util.StringUtil;
import org.teiid.metadata.BaseColumn;
import org.teiid.olingo.common.JTS2OlingoBridge;
import org.teiid.olingo.common.ODataWKTWriter;
import org.teiid.olingo.common.Olingo2Teiid;
import org.teiid.query.function.GeometryUtils;
import org.teiid.translator.TranslatorException;

public class ODataTypeManager {
    private static HashMap<String, String> odataTypes = new HashMap();
    private static HashMap<String, String> teiidTypes = new HashMap();

    public static String teiidType(SingletonPrimitiveType odataType, boolean array) {
        String type = odataType.getFullQualifiedName().getFullQualifiedNameAsString();
        return ODataTypeManager.teiidType(type, array);
    }

    public static String teiidType(String odataType, boolean array) {
        String type = odataTypes.get(odataType);
        if (type == null) {
            type = "string";
        }
        if (array) {
            type = type + "[]";
        }
        return type;
    }

    public static EdmPrimitiveTypeKind odataType(Class<?> teiidRuntimeTypeClass) {
        String dataType = DataTypeManager.getDataTypeName(teiidRuntimeTypeClass);
        return ODataTypeManager.odataType(dataType);
    }

    public static EdmPrimitiveTypeKind odataType(BaseColumn c) {
        String runtimeType = c.getRuntimeType();
        if (c.getDatatype() != null && (c.getDatatype().getName().equalsIgnoreCase("geometry") || c.getDatatype().getName().equalsIgnoreCase("geography"))) {
            boolean geometry = c.getDatatype().getName().equalsIgnoreCase("geometry");
            String type = c.getProperty("{http://www.teiid.org/translator/spatial/2015}type", false);
            if (type != null) {
                try {
                    return (EdmPrimitiveTypeKind)StringUtil.caseInsensitiveValueOf(EdmPrimitiveTypeKind.class, (String)((geometry ? "Geometry" : "Geography") + type));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (geometry) {
                return EdmPrimitiveTypeKind.Geometry;
            }
            return EdmPrimitiveTypeKind.Geography;
        }
        return ODataTypeManager.odataType(runtimeType);
    }

    public static EdmPrimitiveTypeKind odataType(String teiidRuntimeType) {
        String type;
        if (teiidRuntimeType.endsWith("[]")) {
            teiidRuntimeType = teiidRuntimeType.substring(0, teiidRuntimeType.length() - 2);
        }
        if ((type = teiidTypes.get(teiidRuntimeType)) == null) {
            type = "Edm.String";
        }
        return EdmPrimitiveTypeKind.valueOfFQN((String)type);
    }

    public static Object convertToTeiidRuntimeType(Class<?> type, Object value, String odataType, String srid) throws TeiidException {
        Transform transform;
        if (value == null) {
            return null;
        }
        if (type.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (value instanceof UUID) {
            return value.toString();
        }
        if (type.isArray() && value instanceof List) {
            List list = (List)value;
            Class<?> expectedArrayComponentType = type.getComponentType();
            Object array = Array.newInstance(type.getComponentType(), list.size());
            for (int i = 0; i < list.size(); ++i) {
                Object arrayItem = ODataTypeManager.convertToTeiidRuntimeType(expectedArrayComponentType, list.get(i), null, srid);
                Array.set(array, i, arrayItem);
            }
            return array;
        }
        if (odataType != null && value instanceof String) {
            try {
                value = ODataTypeManager.parseLiteral(odataType, (String)value);
            }
            catch (TeiidException e) {
                throw new TranslatorException((Throwable)e);
            }
        }
        if (value instanceof Geospatial) {
            Geospatial val = (Geospatial)value;
            return Olingo2Teiid.convert(val, type, srid);
        }
        if (value instanceof Calendar) {
            Calendar calender = (Calendar)value;
            if (type.isAssignableFrom(Time.class)) {
                calender.set(1, 1970);
                calender.set(2, 0);
                calender.set(5, 1);
                calender.set(14, 0);
                return new Time(calender.getTimeInMillis());
            }
            if (type.isAssignableFrom(Date.class)) {
                calender.set(11, 0);
                calender.set(12, 0);
                calender.set(13, 0);
                calender.set(14, 0);
                return new Date(calender.getTimeInMillis());
            }
            if (type.isAssignableFrom(Timestamp.class)) {
                return new Timestamp(calender.getTimeInMillis());
            }
        }
        if ((transform = DataTypeManager.getTransform(value.getClass(), type)) != null) {
            try {
                value = transform.transform(value, type);
            }
            catch (TransformationException e) {
                throw new TeiidException((Throwable)e);
            }
        }
        return value;
    }

    public static Object convertByteArrayToTeiidRuntimeType(Class<?> type, final byte[] contents, String odataType, String srid) throws TeiidException {
        if (contents == null) {
            return null;
        }
        Object value = null;
        if (DataTypeManager.isLOB(type)) {
            InputStreamFactory isf = new InputStreamFactory(){

                public InputStream getInputStream() throws IOException {
                    return new ByteArrayInputStream(contents);
                }
            };
            if (type.isAssignableFrom(SQLXML.class)) {
                value = new SQLXMLImpl(isf);
            } else if (type.isAssignableFrom(ClobType.class)) {
                value = new ClobImpl(isf, -1L);
            } else if (type.isAssignableFrom(BlobType.class)) {
                value = new BlobImpl(isf);
            }
        } else {
            value = DataTypeManager.DefaultDataClasses.VARBINARY.equals(type) ? contents : (Object)ODataTypeManager.convertToTeiidRuntimeType(type, new String(contents), odataType, srid);
        }
        return value;
    }

    public static Object parseLiteral(EdmParameter edmParameter, Class<?> runtimeType, String value) throws TeiidProcessingException {
        EdmPrimitiveType primitiveType = EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.valueOf((String)edmParameter.getType().getFullQualifiedName().getFullQualifiedNameAsString().substring(4)));
        try {
            if (EdmString.getInstance().equals((Object)edmParameter.getType())) {
                value = EdmString.getInstance().fromUriLiteral(value);
            }
            Object converted = primitiveType.valueOfString(value, Boolean.valueOf(edmParameter.isNullable()), edmParameter.getMaxLength(), edmParameter.getPrecision(), edmParameter.getScale(), Boolean.valueOf(true), runtimeType);
            return converted;
        }
        catch (EdmPrimitiveTypeException e) {
            throw new TeiidProcessingException((Throwable)e);
        }
    }

    public static Object parseLiteral(EdmProperty edmProperty, Class<?> runtimeType, String value) throws TeiidException {
        EdmPrimitiveType primitiveType = EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.valueOf((String)edmProperty.getType().getFullQualifiedName().getFullQualifiedNameAsString().substring(4)));
        try {
            if (EdmString.getInstance().equals((Object)edmProperty.getType())) {
                value = EdmString.getInstance().fromUriLiteral(value);
            }
            Object converted = primitiveType.valueOfString(value, Boolean.valueOf(edmProperty.isNullable()), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), Boolean.valueOf(true), runtimeType);
            return converted;
        }
        catch (EdmPrimitiveTypeException e) {
            throw new TeiidException((Throwable)e);
        }
    }

    public static Object parseLiteral(String odataType, String value) throws TeiidException {
        EdmPrimitiveType primitiveType = EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)EdmPrimitiveTypeKind.valueOf((String)odataType.substring(4)));
        int maxLength = DataTypeManager.MAX_STRING_LENGTH;
        if (primitiveType instanceof EdmBinary || primitiveType instanceof EdmStream) {
            maxLength = DataTypeManager.MAX_VARBINARY_BYTES;
        }
        int precision = 4;
        int scale = 3;
        if (primitiveType instanceof EdmDecimal) {
            precision = 38;
            scale = 9;
        }
        Class expectedClass = primitiveType.getDefaultType();
        try {
            if (EdmString.getInstance().equals((Object)primitiveType)) {
                value = EdmString.getInstance().fromUriLiteral(value);
            }
            Object converted = primitiveType.valueOfString(value, Boolean.valueOf(false), Integer.valueOf(maxLength), Integer.valueOf(precision), Integer.valueOf(scale), Boolean.valueOf(true), expectedClass);
            if (primitiveType instanceof EdmTimeOfDay) {
                Calendar ts = (Calendar)converted;
                return new Time(ts.getTimeInMillis());
            }
            if (primitiveType instanceof EdmDate) {
                Calendar ts = (Calendar)converted;
                return new Date(ts.getTimeInMillis());
            }
            return converted;
        }
        catch (EdmPrimitiveTypeException e) {
            throw new TeiidException((Throwable)e);
        }
    }

    public static Object rationalizePrecision(Integer precision, Integer scale, Object value) {
        BigDecimal newBigDecimal;
        if (precision == null || !(value instanceof BigDecimal)) {
            return value;
        }
        BigDecimal bigDecimalValue = (BigDecimal)value;
        int digits = bigDecimalValue.scale() >= 0 ? Math.max(bigDecimalValue.precision(), bigDecimalValue.scale()) : bigDecimalValue.precision() - bigDecimalValue.scale();
        if ((bigDecimalValue.scale() > (scale == null ? 0 : scale) || digits > precision) && (newBigDecimal = bigDecimalValue.setScale(Math.min(digits > precision ? bigDecimalValue.scale() - digits + precision : bigDecimalValue.scale(), scale == null ? 0 : scale), RoundingMode.HALF_UP)).compareTo(bigDecimalValue) == 0) {
            bigDecimalValue = newBigDecimal;
        }
        return bigDecimalValue;
    }

    public static Geospatial convertToODataValue(InputStream wkb, boolean includesSrid) throws FunctionExecutionException {
        Geometry g = GeometryUtils.getGeometry((InputStream)wkb, null, (boolean)includesSrid);
        JTS2OlingoBridge bridge = new JTS2OlingoBridge(Geospatial.Dimension.GEOMETRY, includesSrid ? SRID.valueOf((String)String.valueOf(g.getSRID())) : null);
        return bridge.convert(g);
    }

    public static String convertToODataURIValue(Object val, String odataType) throws EdmPrimitiveTypeException {
        if (val == null) {
            return "null";
        }
        if (odataType.startsWith("Edm.")) {
            odataType = odataType.substring(4);
        }
        if (val instanceof AbstractGeospatialType) {
            Geometry g;
            try {
                g = GeometryUtils.getGeometry((AbstractGeospatialType)((AbstractGeospatialType)val));
            }
            catch (FunctionExecutionException e1) {
                throw new EdmPrimitiveTypeException(e1.getMessage(), (Exception)((Object)e1));
            }
            return ODataTypeManager.geometryToODataValueString(g, val instanceof GeometryType);
        }
        EdmPrimitiveTypeKind kind = EdmPrimitiveTypeKind.valueOf((String)odataType);
        String value = EdmPrimitiveTypeFactory.getInstance((EdmPrimitiveTypeKind)kind).valueToString(val, Boolean.valueOf(true), null, null, Integer.valueOf(Integer.MAX_VALUE), Boolean.valueOf(true));
        if (kind == EdmPrimitiveTypeKind.String) {
            return EdmString.getInstance().toUriLiteral(value);
        }
        return value;
    }

    static String geometryToODataValueString(Geometry g, boolean geometry) {
        StringWriter sw = new StringWriter();
        sw.write((geometry ? "geometry" : "geography") + "'SRID=");
        sw.write(String.valueOf(g.getSRID()));
        sw.write(";");
        ODataWKTWriter writer = new ODataWKTWriter();
        try {
            writer.write(g, sw);
        }
        catch (IOException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
        sw.write("'");
        return sw.toString();
    }

    static {
        odataTypes.put("Edm.String", "string");
        odataTypes.put("Edm.Boolean", "boolean");
        odataTypes.put("Edm.Byte", "short");
        odataTypes.put("Edm.SByte", "byte");
        odataTypes.put("Edm.Int16", "short");
        odataTypes.put("Edm.Int32", "integer");
        odataTypes.put("Edm.Int64", "long");
        odataTypes.put("Edm.Single", "float");
        odataTypes.put("Edm.Double", "double");
        odataTypes.put("Edm.Decimal", "bigdecimal");
        odataTypes.put("Edm.Date", "date");
        odataTypes.put("Edm.TimeOfDay", "time");
        odataTypes.put("Edm.DateTimeOffset", "timestamp");
        odataTypes.put("Edm.Stream", "blob");
        odataTypes.put("Edm.Guid", "string");
        odataTypes.put("Edm.Binary", "varbinary");
        odataTypes.put("Edm.Geometry", "geometry");
        odataTypes.put("Edm.GeometryPoint", "geometry");
        odataTypes.put("Edm.GeometryLineString", "geometry");
        odataTypes.put("Edm.GeometryPolygon", "geometry");
        odataTypes.put("Edm.GeometryMultiPolygon", "geometry");
        odataTypes.put("Edm.GeometryMultiPoint", "geometry");
        odataTypes.put("Edm.GeometryMultiLineString", "geometry");
        odataTypes.put("Edm.GeometryCollection", "geometry");
        odataTypes.put("Edm.Geography", "geometry");
        odataTypes.put("Edm.GeographyPoint", "geography");
        odataTypes.put("Edm.GeographyLineString", "geography");
        odataTypes.put("Edm.GeographyPolygon", "geography");
        odataTypes.put("Edm.GeographyMultiPolygon", "geography");
        odataTypes.put("Edm.GeographyMultiPoint", "geography");
        odataTypes.put("Edm.GeographyMultiLineString", "geography");
        odataTypes.put("Edm.GeographyCollection", "geography");
        teiidTypes.put("string", "Edm.String");
        teiidTypes.put("boolean", "Edm.Boolean");
        teiidTypes.put("byte", "Edm.SByte");
        teiidTypes.put("short", "Edm.Int16");
        teiidTypes.put("integer", "Edm.Int32");
        teiidTypes.put("long", "Edm.Int64");
        teiidTypes.put("float", "Edm.Single");
        teiidTypes.put("double", "Edm.Double");
        teiidTypes.put("biginteger", "Edm.Decimal");
        teiidTypes.put("bigdecimal", "Edm.Decimal");
        teiidTypes.put("date", "Edm.Date");
        teiidTypes.put("time", "Edm.TimeOfDay");
        teiidTypes.put("timestamp", "Edm.DateTimeOffset");
        teiidTypes.put("blob", "Edm.Stream");
        teiidTypes.put("clob", "Edm.Stream");
        teiidTypes.put("xml", "Edm.Stream");
        teiidTypes.put("varbinary", "Edm.Binary");
        teiidTypes.put("object", "Edm.Binary");
        teiidTypes.put("geometry", "Edm.Stream");
        teiidTypes.put("geography", "Edm.Stream");
    }
}

