/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.common;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.util.Assert;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.core.edm.primitivetype.EdmDouble;
import org.teiid.core.TeiidRuntimeException;

class ODataWKTWriter {
    private int outputDimension = 2;

    public ODataWKTWriter() {
    }

    public ODataWKTWriter(int outputDimension) {
        this.outputDimension = outputDimension;
        if (outputDimension < 2 || outputDimension > 3) {
            throw new IllegalArgumentException("Invalid output dimension (must be 2 or 3)");
        }
    }

    public String write(Geometry geometry) {
        StringWriter sw = new StringWriter();
        try {
            this.write(geometry, sw);
        }
        catch (IOException ex) {
            Assert.shouldNeverReachHere();
        }
        return ((Object)sw).toString();
    }

    public void write(Geometry geometry, Writer writer) throws IOException {
        if (geometry instanceof Point) {
            Point point = (Point)geometry;
            this.appendPointTaggedText(point.getCoordinate(), writer, point.getPrecisionModel());
        } else if (geometry instanceof LineString) {
            this.appendLineStringTaggedText((LineString)geometry, writer);
        } else if (geometry instanceof Polygon) {
            this.appendPolygonTaggedText((Polygon)geometry, writer);
        } else if (geometry instanceof MultiPoint) {
            this.appendMultiPointTaggedText((MultiPoint)geometry, writer);
        } else if (geometry instanceof MultiLineString) {
            this.appendMultiLineStringTaggedText((MultiLineString)geometry, writer);
        } else if (geometry instanceof MultiPolygon) {
            this.appendMultiPolygonTaggedText((MultiPolygon)geometry, writer);
        } else if (geometry instanceof GeometryCollection) {
            this.appendGeometryCollectionTaggedText((GeometryCollection)geometry, writer);
        } else {
            Assert.shouldNeverReachHere((String)("Unsupported Geometry implementation:" + geometry.getClass()));
        }
    }

    private void appendPointTaggedText(Coordinate coordinate, Writer writer, PrecisionModel precisionModel) throws IOException {
        writer.write("Point");
        this.appendPointText(coordinate, writer, precisionModel);
    }

    private void appendLineStringTaggedText(LineString lineString, Writer writer) throws IOException {
        writer.write("LineString");
        this.appendLineStringText(lineString, writer);
    }

    private void appendPolygonTaggedText(Polygon polygon, Writer writer) throws IOException {
        writer.write("Polygon");
        this.appendPolygonText(polygon, writer);
    }

    private void appendMultiPointTaggedText(MultiPoint multipoint, Writer writer) throws IOException {
        writer.write("MultiPoint");
        this.appendMultiPointText(multipoint, writer);
    }

    private void appendMultiLineStringTaggedText(MultiLineString multiLineString, Writer writer) throws IOException {
        writer.write("MultiLineString");
        this.appendMultiLineStringText(multiLineString, writer);
    }

    private void appendMultiPolygonTaggedText(MultiPolygon multiPolygon, Writer writer) throws IOException {
        writer.write("MultiPolygon");
        this.appendMultiPolygonText(multiPolygon, writer);
    }

    private void appendGeometryCollectionTaggedText(GeometryCollection geometryCollection, Writer writer) throws IOException {
        writer.write("Collection");
        this.appendGeometryCollectionText(geometryCollection, writer);
    }

    private void appendPointText(Coordinate coordinate, Writer writer, PrecisionModel precisionModel) throws IOException {
        writer.write("(");
        if (coordinate != null) {
            this.appendCoordinate(coordinate, writer);
        }
        writer.write(")");
    }

    private void appendCoordinate(Coordinate coordinate, Writer writer) throws IOException {
        writer.write(this.writeNumber(coordinate.x) + " " + this.writeNumber(coordinate.y));
        if (this.outputDimension >= 3 && !Double.isNaN(coordinate.z)) {
            writer.write(" ");
            writer.write(this.writeNumber(coordinate.z));
        }
    }

    private String writeNumber(double d) {
        try {
            return EdmDouble.getInstance().valueToString((Object)d, Boolean.valueOf(false), null, null, null, Boolean.valueOf(false));
        }
        catch (EdmPrimitiveTypeException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
    }

    private void appendLineStringText(LineString lineString, Writer writer) throws IOException {
        writer.write("(");
        for (int i = 0; i < lineString.getNumPoints(); ++i) {
            if (i > 0) {
                writer.write(",");
            }
            this.appendCoordinate(lineString.getCoordinateN(i), writer);
        }
        writer.write(")");
    }

    private void appendPolygonText(Polygon polygon, Writer writer) throws IOException {
        writer.write("(");
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            this.appendLineStringText(polygon.getInteriorRingN(i), writer);
            writer.write(",");
        }
        this.appendLineStringText(polygon.getExteriorRing(), writer);
        writer.write(")");
    }

    private void appendMultiPointText(MultiPoint multiPoint, Writer writer) throws IOException {
        writer.write("(");
        for (int i = 0; i < multiPoint.getNumGeometries(); ++i) {
            if (i > 0) {
                writer.write(",");
            }
            writer.write("(");
            this.appendCoordinate(((Point)multiPoint.getGeometryN(i)).getCoordinate(), writer);
            writer.write(")");
        }
        writer.write(")");
    }

    private void appendMultiLineStringText(MultiLineString multiLineString, Writer writer) throws IOException {
        writer.write("(");
        for (int i = 0; i < multiLineString.getNumGeometries(); ++i) {
            if (i > 0) {
                writer.write(",");
            }
            this.appendLineStringText((LineString)multiLineString.getGeometryN(i), writer);
        }
        writer.write(")");
    }

    private void appendMultiPolygonText(MultiPolygon multiPolygon, Writer writer) throws IOException {
        writer.write("(");
        for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
            if (i > 0) {
                writer.write(",");
            }
            this.appendPolygonText((Polygon)multiPolygon.getGeometryN(i), writer);
        }
        writer.write(")");
    }

    private void appendGeometryCollectionText(GeometryCollection geometryCollection, Writer writer) throws IOException {
        writer.write("(");
        for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
            if (i > 0) {
                writer.write(",");
            }
            this.write(geometryCollection.getGeometryN(i), writer);
        }
        writer.write(")");
    }
}

