/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.olingo.common;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Point;
import java.util.ArrayList;
import org.apache.olingo.commons.api.edm.geo.Geospatial;
import org.apache.olingo.commons.api.edm.geo.GeospatialCollection;
import org.apache.olingo.commons.api.edm.geo.LineString;
import org.apache.olingo.commons.api.edm.geo.MultiLineString;
import org.apache.olingo.commons.api.edm.geo.MultiPolygon;
import org.apache.olingo.commons.api.edm.geo.Polygon;
import org.teiid.core.types.AbstractGeospatialType;
import org.teiid.core.types.GeographyType;
import org.teiid.query.function.GeometryUtils;

class Olingo2Teiid {
    Olingo2Teiid() {
    }

    public static AbstractGeospatialType convert(Geospatial geospatial, Class<?> expectedType, String srid) {
        Geometry result = Olingo2Teiid.convertToJTS(geospatial);
        if (geospatial.getSrid() != null && geospatial.getSrid().isNotDefault()) {
            srid = geospatial.getSrid().toString();
        }
        if (srid != null) {
            try {
                result.setSRID(Integer.valueOf(geospatial.getSrid().toString()).intValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (expectedType == GeographyType.class) {
            return GeometryUtils.getGeographyType((Geometry)result);
        }
        return GeometryUtils.getGeometryType((Geometry)result);
    }

    public static Geometry convertToJTS(Geospatial geospatial) {
        if (geospatial instanceof org.apache.olingo.commons.api.edm.geo.Point) {
            org.apache.olingo.commons.api.edm.geo.Point point = (org.apache.olingo.commons.api.edm.geo.Point)geospatial;
            Point result = GeometryUtils.GEOMETRY_FACTORY.createPoint(new Coordinate(point.getX(), point.getY(), point.getZ()));
            return result;
        }
        if (geospatial instanceof LineString) {
            LineString lineString = (LineString)geospatial;
            com.vividsolutions.jts.geom.LineString result = GeometryUtils.GEOMETRY_FACTORY.createLineString(Olingo2Teiid.convertLineStringToPoints((Iterable<org.apache.olingo.commons.api.edm.geo.Point>)lineString));
            return result;
        }
        if (geospatial instanceof Polygon) {
            Polygon polygon = (Polygon)geospatial;
            return Olingo2Teiid.convertPolygon(polygon);
        }
        if (geospatial instanceof org.apache.olingo.commons.api.edm.geo.MultiPoint) {
            org.apache.olingo.commons.api.edm.geo.MultiPoint multipoint = (org.apache.olingo.commons.api.edm.geo.MultiPoint)geospatial;
            Coordinate[] coords = Olingo2Teiid.convertLineStringToPoints((Iterable<org.apache.olingo.commons.api.edm.geo.Point>)multipoint);
            MultiPoint result = GeometryUtils.GEOMETRY_FACTORY.createMultiPoint(coords);
            return result;
        }
        if (geospatial instanceof MultiLineString) {
            MultiLineString multiLineString = (MultiLineString)geospatial;
            ArrayList<com.vividsolutions.jts.geom.LineString> vals = new ArrayList<com.vividsolutions.jts.geom.LineString>();
            for (LineString lineString : multiLineString) {
                vals.add(GeometryUtils.GEOMETRY_FACTORY.createLineString(Olingo2Teiid.convertLineStringToPoints((Iterable<org.apache.olingo.commons.api.edm.geo.Point>)lineString)));
            }
            return GeometryUtils.GEOMETRY_FACTORY.createGeometryCollection((Geometry[])vals.toArray(new com.vividsolutions.jts.geom.LineString[vals.size()]));
        }
        if (geospatial instanceof MultiPolygon) {
            MultiPolygon multiPolygon = (MultiPolygon)geospatial;
            ArrayList<com.vividsolutions.jts.geom.Polygon> vals = new ArrayList<com.vividsolutions.jts.geom.Polygon>();
            for (Polygon val : multiPolygon) {
                vals.add(Olingo2Teiid.convertPolygon(val));
            }
            return GeometryUtils.GEOMETRY_FACTORY.createMultiPolygon(vals.toArray(new com.vividsolutions.jts.geom.Polygon[vals.size()]));
        }
        if (geospatial instanceof GeospatialCollection) {
            GeospatialCollection geometryCollection = (GeospatialCollection)geospatial;
            ArrayList<Geometry> vals = new ArrayList<Geometry>();
            for (Geospatial val : geometryCollection) {
                vals.add(Olingo2Teiid.convertToJTS(val));
            }
            return GeometryUtils.GEOMETRY_FACTORY.createGeometryCollection(vals.toArray(new Geometry[vals.size()]));
        }
        throw new AssertionError(geospatial.getClass());
    }

    private static com.vividsolutions.jts.geom.Polygon convertPolygon(Polygon polygon) throws AssertionError {
        Coordinate[] coords = Olingo2Teiid.convertLineStringToPoints((Iterable<org.apache.olingo.commons.api.edm.geo.Point>)polygon.getExterior());
        LinearRing shell = GeometryUtils.GEOMETRY_FACTORY.createLinearRing(coords);
        LinearRing[] holes = null;
        if (polygon.getInterior() != null && polygon.getInterior().isEmpty()) {
            holes = new LinearRing[]{GeometryUtils.GEOMETRY_FACTORY.createLinearRing(Olingo2Teiid.convertLineStringToPoints((Iterable<org.apache.olingo.commons.api.edm.geo.Point>)polygon.getExterior()))};
        }
        return GeometryUtils.GEOMETRY_FACTORY.createPolygon(shell, holes);
    }

    private static Coordinate[] convertLineStringToPoints(Iterable<org.apache.olingo.commons.api.edm.geo.Point> points) {
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>(2);
        for (org.apache.olingo.commons.api.edm.geo.Point point : points) {
            coords.add(new Coordinate(point.getX(), point.getY(), point.getZ()));
        }
        return coords.toArray(new Coordinate[coords.size()]);
    }
}

